/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.handler;

import static org.junit.Assert.*;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;

import jp.terasoluna.fw.web.struts.action.MockWebApplicationContext;
import jp.terasoluna.fw.web.struts.action.resolver.ActionResolver;
import jp.terasoluna.fw.web.struts.action.resolver.GeneralActionResolver;
import jp.terasoluna.fw.web.struts.action.resolver.GeneralConfigurationReflector;
import jp.terasoluna.fw.web.struts.action.resolver.ResolverActionMapping;
import jp.terasoluna.fw.web.struts.actions.ForwardAction;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.TargetClassAware;
import org.springframework.web.context.WebApplicationContext;

/**
 * @author bthashidumets
 */
public class DefaultDelegateActionHandlerTest {

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
    }

    /**
     * resolveAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>beanName : null</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testResolveAction001() throws Exception {
        DefaultDelegateActionHandler handler = new DefaultDelegateActionHandler();

        // p[^
        String beanName = null;
        Action action = null;
        ActionMapping mapping = null;
        ModuleConfig moduleConfig = null;
        ActionServlet servlet = null;
        WebApplicationContext wac = null;

        // eXg
        Action result = handler.resolveAction(beanName, action, mapping,
                moduleConfig, servlet, wac);

        // 
        assertNull(result);
    }

    /**
     * resolveAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>beanName : "hoge"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testResolveAction002() throws Exception {
        DefaultDelegateActionHandler handler = new DefaultDelegateActionHandler();

        // p[^
        String beanName = "hoge";
        Action action = null;
        ActionMapping mapping = null;
        ModuleConfig moduleConfig = null;
        ActionServlet servlet = null;
        WebApplicationContext wac = null;

        // eXg
        Action result = handler.resolveAction(beanName, action, mapping,
                moduleConfig, servlet, wac);

        // 
        assertNull(result);
    }

    /**
     * resolveAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>beanName : "/hogeSCR"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeansOfType(ActionResolver.class) : new
     * GeneralActionResolver(actionName : actionName, pathPattern : pathPattern), <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : new ForwardAction(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>getClass() : ForwardAction.class</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testResolveAction003() throws Exception {
        DefaultDelegateActionHandler handler = new DefaultDelegateActionHandler();

        // p[^
        String actionName = "hoge";
        String beanName = "/hogeSCR";
        String pathPattern = "/.*SCR";
        Action action = null;
        ActionMapping mapping = null;
        ModuleConfig moduleConfig = null;
        ActionServlet servlet = null;
        MockWebApplicationContext wac = new MockWebApplicationContext();
        GeneralActionResolver gar = new GeneralActionResolver();
        gar.setActionName(actionName);
        gar.setPathPattern(pathPattern);
        wac.addBeansOfTypeMap("generalActionResolver", gar);
        wac.addContainsBeanMap(actionName, Boolean.TRUE);
        wac.addBeanMap(actionName, new ForwardAction());

        // eXg
        Action result = handler.resolveAction(beanName, action, mapping,
                moduleConfig, servlet, wac);

        // 
        assertNotNull(result);
        assertEquals(ForwardAction.class, result.getClass());
    }

    /**
     * resolveAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F \bhQsALbVActionResolver邱ƁB<br>
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>beanName : "/hogeSCR"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeansOfType(ActionResolver.class) : new
     * GeneralActionResolver(actionName : actionName, pathPattern : pathPattern), <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : new ForwardAction(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>return : not null</li>
     * <li>getClass() : ForwardAction.class</li>
     * <li>getClass() : ForwardAction.class</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testResolveAction004() throws Exception {
        DefaultDelegateActionHandler handler = new DefaultDelegateActionHandler();

        // p[^
        String actionName = "hoge";
        String beanName = "/hogeSCR";
        String pathPattern = "/.*SCR";
        Action action = null;
        ActionMapping mapping = null;
        ModuleConfig moduleConfig = null;
        ActionServlet servlet = null;
        MockWebApplicationContext wac = new MockWebApplicationContext();
        GeneralActionResolver gar = new GeneralActionResolver();
        gar.setActionName(actionName);
        gar.setPathPattern(pathPattern);
        wac.addBeansOfTypeMap("generalActionResolver", gar);
        wac.addContainsBeanMap(actionName, Boolean.TRUE);
        wac.addBeanMap(actionName, new ForwardAction());

        // eXg
        Action result = handler.resolveAction(beanName, action, mapping,
                moduleConfig, servlet, wac);
        Action result2 = handler.resolveAction(beanName, action, mapping,
                moduleConfig, servlet, wac);

        // 
        assertNotNull(result);
        assertNotNull(result2);
        assertEquals(ForwardAction.class, result.getClass());
        assertEquals(ForwardAction.class, result2.getClass());
    }

    /**
     * resolveAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F ANVBean`ɐݒ肳Ăꍇ<br>
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>beanName : "/hogeSCR"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>action : new Action()</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeansOfType(ActionResolver.class) : new
     * GeneralActionResolver(actionName : actionName, pathPattern : pathPattern), <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : new ForwardAction(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>getClass() : Action.class</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testResolveAction005() throws Exception {
        DefaultDelegateActionHandler handler = new DefaultDelegateActionHandler();

        // p[^
        String actionName = "hoge";
        String beanName = "/hogeSCR";
        String pathPattern = "/.*SCR";
        Action action = new Action();
        ActionMapping mapping = null;
        ModuleConfig moduleConfig = null;
        ActionServlet servlet = null;
        MockWebApplicationContext wac = new MockWebApplicationContext();
        GeneralActionResolver gar = new GeneralActionResolver();
        gar.setActionName(actionName);
        gar.setPathPattern(pathPattern);
        wac.addBeansOfTypeMap("generalActionResolver", gar);
        wac.addContainsBeanMap(actionName, Boolean.TRUE);
        wac.addBeanMap(actionName, new ForwardAction());

        // eXg
        Action result = handler.resolveAction(beanName, action, mapping,
                moduleConfig, servlet, wac);

        // 
        assertNotNull(result);
        assertEquals(Action.class, result.getClass());
    }

    /**
     * resolveAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F ANVBean`ɐݒ肳Ăꍇ<br>
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>beanName : "/hogeSCR"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>action : new AnnotationActionStub()</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeansOfType(ActionResolver.class) : new
     * GeneralConfigurationReflector(), <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : new ForwardAction(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>getClass() : AnnotationActionStub.class</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testResolveAction006() throws Exception {
        DefaultDelegateActionHandler handler = new DefaultDelegateActionHandler();

        // p[^
        String actionName = "hoge";
        String beanName = "/hogeSCR";
        Action action = new AnnotationActionStub();
        ActionMapping mapping = new ResolverActionMapping();
        ModuleConfig moduleConfig = null;
        ActionServlet servlet = null;
        MockWebApplicationContext wac = new MockWebApplicationContext();
        GeneralConfigurationReflector gcr = new GeneralConfigurationReflector();
        wac.addBeansOfTypeMap("generalConfigurationReflector", gcr);
        wac.addContainsBeanMap(actionName, Boolean.TRUE);
        wac.addBeanMap(actionName, new ForwardAction());

        // eXg
        Action result = handler.resolveAction(beanName, action, mapping,
                moduleConfig, servlet, wac);
        Action result2 = handler.resolveAction(beanName, action, mapping,
                moduleConfig, servlet, wac);

        // 
        assertNotNull(result);
        assertNotNull(result2);
        assertEquals(AnnotationActionStub.class, result.getClass());
        assertEquals(AnnotationActionStub.class, result2.getClass());
    }

    /**
     * resolveAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F ANVBean`ɐݒ肳Ăꍇ<br>
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : -</li>
     * <li>beanName : "/hogeSCR"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>action : null</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeansOfType(ActionResolver.class) : new
     * GeneralConfigurationReflector(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * <li>getClass() : AnnotationActionStub.class</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testResolveAction007() throws Exception {
        DefaultDelegateActionHandler handler = new DefaultDelegateActionHandler();

        // p[^
        // String actionName = "hoge";
        String beanName = "/hogeSCR";
        String pathPattern = "/.*SCR";
        Action action = null;
        ActionMapping mapping = new ResolverActionMapping();
        ModuleConfig moduleConfig = null;
        ActionServlet servlet = null;
        MockWebApplicationContext wac = new MockWebApplicationContext();
        // GeneralConfigurationReflector gcr = new GeneralConfigurationReflector();
        // wac.addBeansOfTypeMap("generalConfigurationReflector", gcr);
        GeneralActionResolver gar = new GeneralActionResolver();
        gar.setPathPattern(pathPattern);
        wac.addBeansOfTypeMap("generalActionResolver", gar);
        // gar.setActionName(actionName);
        // wac.addContainsBeanMap(actionName, Boolean.TRUE);
        // wac.addBeanMap(actionName, new ForwardAction());

        handler.pathResolverMap = new ConcurrentHashMap<String, ActionResolver>();
        handler.pathResolverMap.put(beanName, gar);

        // eXg
        Action result = handler.resolveAction(beanName, action, mapping,
                moduleConfig, servlet, wac);

        // 
        assertNull(result);
    }

    /**
     * isSupportsClass\bh<br>
     * <p>
     * (n)
     * </p>
     * @throws Exception
     */
    @Test
    public void testIsSupportsClass001() throws Exception {
        DefaultDelegateActionHandler handler = new DefaultDelegateActionHandler();

        // p[^
        Class<? extends Object> targetClass = null;

        // eXg
        boolean result = handler.isSupportsClass(targetClass);

        // 
        assertFalse(result);
    }

    /**
     * getTargetClass\bh<br>
     * <p>
     * (n)
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetTargetClass001() throws Exception {
        DefaultDelegateActionHandler handler = new DefaultDelegateActionHandler();

        // p[^
        Object targetObject = null;

        // eXg
        Class<? extends Object> result = handler.getTargetClass(targetObject);

        // 
        assertNull(result);
    }

    /**
     * getTargetClass\bh<br>
     * <p>
     * (n)
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetTargetClass002() throws Exception {
        DefaultDelegateActionHandler handler = new DefaultDelegateActionHandler();

        // p[^
        Object targetObject = new Object();

        // eXg
        Class<? extends Object> result = handler.getTargetClass(targetObject);

        // 
        assertNotNull(result);
        assertEquals(Class.class, result.getClass());
    }

    /**
     * getTargetClass\bh<br>
     * <p>
     * (n)
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetTargetClass003() throws Exception {
        DefaultDelegateActionHandler handler = new DefaultDelegateActionHandler();

        // p[^
        Class<?>[] interfaces = new Class<?>[] { SpringProxy.class,
                TargetClassAware.class };
        InvocationHandler h = new InvocationHandler() {
            public Object invoke(Object proxy, Method method, Object[] args)
                                                                            throws Throwable {
                return Class.class;
            }
        };
        Object targetObject = Proxy.newProxyInstance(SpringProxy.class
                .getClassLoader(), interfaces, h);

        // eXg
        Class<? extends Object> result = handler.getTargetClass(targetObject);

        // 
        assertNotNull(result);
        assertEquals(Class.class, result.getClass());
    }
}
