/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.action;

import java.io.Serializable;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * ʉʃt[ĨR[obNɕKvȏ񋟂A{@link FlowCallbackInfo}̃ftHgNXB
 * <p>
 * ʉʃt[Ńiʉʃt[NANV\jactionvfƃW[AсAActionServlet̃T[ubg}bsO(*.do)A
 * ʉʃt[NANVɃtH[h邽߂ActionForward𐶐B<br>
 * (ʉʃt[ȊJڏ́Aʉʃt[NANVɈϏB)
 * </p>
 */
public class DefaultFlowCallbackInfo implements FlowCallbackInfo, Serializable {

    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = 8405292029083636457L;

    /**
     * ʉʃt[Ńiʉʃt[NANV́jactionvf\ANV}bsO
     */
    private ActionMapping flowInvokeActionMapping;

    /**
     * ʉʃt[Ńiʉʃt[NANV́jactionvf\ANV}bsOw肵āA
     * DefaultFlowCallbackInfõCX^X\zB
     * 
     * @param flowInvokeActionMapping
     *            ʉʃt[Ńiʉʃt[NANV́jactionvf\ANV}bsO (nullȊO)
     */
    public DefaultFlowCallbackInfo(ActionMapping flowInvokeActionMapping) {
        this.flowInvokeActionMapping = flowInvokeActionMapping;
    }

    /**
     * ʉʃt[Nʉʃt[NANVɃtH[h邽߂{@link ActionForward}擾B
     * <p>
     * ʉʃt[Ńiʉʃt[NANV\jactionvfƃW[A
     * сAActionServlet̃T[ubg}bsO(*.do)A
     * ʉʃt[NANVɃtH[h邽߂ActionForward𐶐B<br>
     * (ʉʃt[ȊJڏ́Aʉʃt[NANVɈϏB)
     * </p>
     * @param flowTerminateActionMapping
     *            ʉʃt[Íiʉʃt[IANV́jactionvf\ActionMapping
     *            (̎ł́Ä͎gpȂ)
     * @param form
     *            ANVtH[ (̎ł́Ä͎gpȂ)
     * @param request
     *            NGXg (nullȊO)
     * @param response
     *            X|X (̎ł́Ä͎gpȂ)
     * @return ʉʃt[Nʉʃt[NANVɃtH[h邽߂{@link ActionForward}
     */
    public ActionForward getActionForward(
            ActionMapping flowTerminateActionMapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) {
        String servletMapping = (String) request.getSession()
                .getServletContext().getAttribute(Globals.SERVLET_KEY);
        StringBuilder actionPathBuilder = new StringBuilder();
        if (servletMapping != null) {
            String flowInvokeActionPath = flowInvokeActionMapping.getPath();
            if (servletMapping.startsWith("*.")) {
                actionPathBuilder.append(flowInvokeActionPath);
                actionPathBuilder.append(servletMapping.substring(1));
            } else if (servletMapping.endsWith("/*")) {
                actionPathBuilder.append(servletMapping.substring(0,
                        servletMapping.length() - 2));
                actionPathBuilder.append(flowInvokeActionPath);
            } else if (servletMapping.equals("/")) {
                actionPathBuilder.append(flowInvokeActionPath);
            }
        }

        String flowInvokeActionModule = flowInvokeActionMapping
                .getModuleConfig().getPrefix();
        ActionForward forward = new ActionForward(actionPathBuilder.toString());
        forward.setModule(flowInvokeActionModule);
        return forward;
    }
}
