/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.io.BufferedReader;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * WriteTag ubN{bNXeXgB<br>
 * O<br>
 * <br>
 */
public class WriteTagTest extends TestCase {

    // eXgΏ
    WriteTag tag = null;

    // PageContextBeani[ۂ̃L[
    private static final String LOOKUP_BEAN = "lookup_bean";

    /**
     * Constructor for BodyTagTest.
     * @param arg0
     */
    public WriteTagTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (WriteTag) TagUTUtil.create(WriteTag.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoStartTag01B<br>
     * 
     * (n)<br>
     * ϓ_FA,C<br>
     * 
     * ͒l
     * ignore=true<br>
     * RequestUtils.lookup(PageContext, name, scope)=null<br>
     * value=[<br>
     * replaceNullToNbsp=[<br>
     * filter=[<br>
     * replaceSpToNbsp=[<br>
     * fillColumn=[<br>
     * replaceLTtoBR=[<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * o͓e=|<br>
     * 
     * beanvpeBɉsR[hi͕Aj܂܂ĂƂA
     * <br>ɒu鏈𖳌ɂ邽߂̑truełw肵bean
     * nullŎ擾ꍇ̃eXgP[X<br>
     */
    public void testDoStartTag01() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = null;

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "scope", "session");

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertNull(reader.readLine());

    }

    /**
     * testDoStartTag02B<br>
     * 
     * (n)<br>
     * ϓ_FA,C<br>
     * 
     * ͒l
     * ignore=true<br>
     * RequestUtils.lookup(PageContext, name, scope)=not null<br>
     * value=null<br>
     * replaceNullToNbsp=true<br>
     * filter=[<br>
     * replaceSpToNbsp=[<br>
     * fillColumn=[<br>
     * replaceLTtoBR=[<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * o͓e=u&nbsp;v<br>
     * 
     * beanvpeBɉsR[hi͕Aj܂܂ĂƂA
     * <br>ɒu鏈𖳌ɂ邽߂̑truełw肵bean
     * Ɏ擾łꍇ̃eXgP[X<br>
     */
    public void testDoStartTag02() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = new WriteTag_BeanStub01();
        bean.setValue(null);

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "property", "value");
        UTUtil.setPrivateField(tag, "scope", "session");

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.SKIP_BODY);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("&nbsp;", reader.readLine());

    }

    /**
     * testDoStartTag03B<br>
     * 
     * (n)<br>
     * ϓ_FA,C<br>
     * 
     * ͒l
     * ignore=false<br>
     * RequestUtils.lookup(PageContext, name, scope)=null<br>
     * value=null<br>
     * replaceNullToNbsp=false<br>
     * filter=[<br>
     * replaceSpToNbsp=[<br>
     * fillColumn=[<br>
     * replaceLTtoBR=[<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * o͓e=|<br>
     * 
     * beanvpeBɉsR[hi͕Aj܂܂ĂƂA
     * <br>ɒu鏈𖳌ɂ邽߂̑falsełw肵bean
     * null̏ꍇ̃eXgP[X
     * Ȃ̃eXgP[Xłnull͋󕶎&nbsp;ƒu邩ǂ
     * 肷邽߂̑falsełꍇ̃eXgP[X܂ށB<br>
     */
    public void testDoStartTag03() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = new WriteTag_BeanStub01();
        bean.setValue(null);

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "property", "value");
        UTUtil.setPrivateField(tag, "scope", "session");
        UTUtil.setPrivateField(tag, "replaceNullToNbsp", new Boolean(false));

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.SKIP_BODY);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertNull(reader.readLine());

    }

    /**
     * testDoStartTag04B<br>
     * 
     * (n)<br>
     * ϓ_FA,C<br>
     * 
     * ͒l
     * ignore=false<br>
     * RequestUtils.lookup(PageContext, name, scope)=null<br>
     * value=null<br>
     * replaceNullToNbsp=true<br>
     * filter=[<br>
     * replaceSpToNbsp=[<br>
     * fillColumn=[<br>
     * replaceLTtoBR=[<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * o͓e=|<br>
     * 
     * beanvpeBɉsR[hi͕Aj܂܂ĂƂA
     * <br>ɒu鏈𖳌ɂ邽߂̑falsełw肵bean
     * null̏ꍇ̃eXgP[X
     * Ȃ̃eXgP[Xłnull͋󕶎&nbsp;ƒu邩ǂ
     * 肷邽߂̑truełꍇ̃eXgP[X܂ށB<br>
     */
    public void testDoStartTag04() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = null;

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "scope", "session");
        UTUtil.setPrivateField(tag, "property", "value");
        UTUtil.setPrivateField(tag, "scope", "session");
        UTUtil.setPrivateField(tag, "replaceNullToNbsp", new Boolean(true));

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.SKIP_BODY);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertNull(reader.readLine());
    }

    /**
     * testDoStartTag05B<br>
     * 
     * (n)<br>
     * ϓ_FA,C<br>
     * 
     * ͒l
     * ignore=false<br>
     * RequestUtils.lookup(PageContext, name, scope)=not null<br>
     * value=""i󕶎j<br>
     * replaceNullToNbsp=false<br>
     * filter=false<br>
     * replaceSpToNbsp=false<br>
     * fillColumn=10<br>
     * replaceLTtoBR=false<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * o͓e=|<br>
     * 
     * bean擾vpeBl󕶎ŁAnull͋󕶎&nbsp;
     * ƒu邩ǂ肷邽߂̑falsȅꍇ̃eXgP[X<br>
     */
    public void testDoStartTag05() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = new WriteTag_BeanStub01();
        bean.setValue("");

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "property", "value");
        UTUtil.setPrivateField(tag, "scope", "session");
        UTUtil.setPrivateField(tag, "replaceNullToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "fillColumn", new Integer(10));
        UTUtil.setPrivateField(tag, "replaceLFtoBR", new Boolean(false));

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.SKIP_BODY);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertNull(reader.readLine());

    }

    /**
     * testDoStartTag06B<br>
     * 
     * (n)<br>
     * ϓ_FA,C<br>
     * 
     * ͒l
     * ignore=false<br>
     * RequestUtils.lookup(PageContext, name, scope)=not null<br>
     * value=""i󕶎j<br>
     * replaceNullToNbsp=true<br>
     * filter=false<br>
     * replaceSpToNbsp=false<br>
     * fillColumn=10<br>
     * replaceLTtoBR=false<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * o͓e=u&nbsp;v<br>
     * 
     * bean擾vpeBl󕶎ŁAnull͋󕶎&nbsp;
     * ƒu邩ǂ肷邽߂̑truȅꍇ̃eXgP[X<br>
     */
    public void testDoStartTag06() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = new WriteTag_BeanStub01();
        bean.setValue("");

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "property", "value");
        UTUtil.setPrivateField(tag, "scope", "session");
        UTUtil.setPrivateField(tag, "replaceNullToNbsp", new Boolean(true));
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "fillColumn", new Integer(10));
        UTUtil.setPrivateField(tag, "replaceLFtoBR", new Boolean(false));

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.SKIP_BODY);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("&nbsp;", reader.readLine());

    }

    /**
     * testDoStartTag07B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * ignore=false<br>
     * RequestUtils.lookup(PageContext, name, scope)=not null<br>
     * value="<>&"'"<br>
     * replaceNullToNbsp=false<br>
     * filter=true<br>
     * replaceSpToNbsp=false<br>
     * fillColumn=10<br>
     * replaceLTtoBR=false<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * o͓e=u&lt;&gt;&amp;&quat;&#39v<br>
     * 
     * bean擾vpeBlHTMLł̓ꕶ܂܂A
     * ꕶHTMLɑΉɒu邽߂̑
     * truȅꍇ̃eXgP[X<br>
     */
    public void testDoStartTag07() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = new WriteTag_BeanStub01();
        bean.setValue("<>&\"");

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "property", "value");
        UTUtil.setPrivateField(tag, "scope", "session");
        UTUtil.setPrivateField(tag, "replaceNullToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "fillColumn", new Integer(10));
        UTUtil.setPrivateField(tag, "replaceLFtoBR", new Boolean(false));

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.SKIP_BODY);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("&lt;&gt;&amp;&quot;", reader.readLine());

    }

    /**
     * testDoStartTag08B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * ignore=false<br>
     * RequestUtils.lookup(PageContext, name, scope)=not null<br>
     * value="a b c"<br>
     * replaceNullToNbsp=false<br>
     * filter=false<br>
     * replaceSpToNbsp=true<br>
     * fillColumn=10<br>
     * replaceLTtoBR=false<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * o͓e=ua&nbsp;b&nbsp;cv<br>
     * 
     * bean擾vpeBlɔpXy[X܂܂Aꕶ
     * HTMLɑΉɒu邽߂̑truȅꍇ̃eXgP[X<br>
     */
    public void testDoStartTag08() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = new WriteTag_BeanStub01();
        bean.setValue("a b c");

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "property", "value");
        UTUtil.setPrivateField(tag, "scope", "session");
        UTUtil.setPrivateField(tag, "replaceNullToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(true));
        UTUtil.setPrivateField(tag, "fillColumn", new Integer(10));
        UTUtil.setPrivateField(tag, "replaceLFtoBR", new Boolean(false));

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.SKIP_BODY);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("a&nbsp;b&nbsp;c", reader.readLine());

    }

    /**
     * testDoStartTag09B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * ignore=false<br>
     * RequestUtils.lookup(PageContext, name, scope)=not null<br>
     * value="1234567"<br>
     * replaceNullToNbsp=false<br>
     * filter=false<br>
     * replaceSpToNbsp=true<br>
     * fillColumn=3<br>
     * replaceLTtoBR=false<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * o͓e=u123<br>456<br>7v<br>
     * 
     * bean擾vpeBlbeanvpeB擾lA
     * 1Jɂĕ\TCY傫ꍇ̃eXgP[X<br>
     */
    public void testDoStartTag09() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = new WriteTag_BeanStub01();
        bean.setValue("1234567");

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "property", "value");
        UTUtil.setPrivateField(tag, "scope", "session");
        UTUtil.setPrivateField(tag, "replaceNullToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(true));
        UTUtil.setPrivateField(tag, "fillColumn", new Integer(3));
        UTUtil.setPrivateField(tag, "replaceLFtoBR", new Boolean(false));

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.SKIP_BODY);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("123<br>456<br>7", reader.readLine());

    }

    /**
     * testDoStartTag10B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * ignore=false<br>
     * RequestUtils.lookup(PageContext, name, scope)=not null<br>
     * value="aisR[h\njisR[h\rjb"<br>
     * replaceNullToNbsp=false<br>
     * filter=false<br>
     * replaceSpToNbsp=false<br>
     * fillColumn=10<br>
     * replaceLTtoBR=true<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * o͓e=ua<br><br>bv<br>
     * 
     * bean擾vpeBlbeanvpeB擾lɉsR[h
     * ܂܂AsR[h<br>ƒuAobt@Ɋi[ǂ肷
     * ߂̑trueꍇ̃eXgP[X<br>
     */
    public void testDoStartTag10() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = new WriteTag_BeanStub01();
        bean.setValue("a\n\rb");

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "property", "value");
        UTUtil.setPrivateField(tag, "scope", "session");
        UTUtil.setPrivateField(tag, "replaceNullToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "fillColumn", new Integer(10));
        UTUtil.setPrivateField(tag, "replaceLFtoBR", new Boolean(true));

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.SKIP_BODY);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("a<br><br>b", reader.readLine());

    }

    /**
     * testDoStartTag11B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * ignore=false<br>
     * RequestUtils.lookup(PageContext, name, scope)=not null<br>
     * value="aisR[hjb"<br>
     * replaceNullToNbsp=false<br>
     * filter=false<br>
     * replaceSpToNbsp=false<br>
     * fillColumn=10<br>
     * replaceLTtoBR=false<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * o͓e=uabv<br>
     * 
     * bean擾vpeBlbeanvpeB擾lɉsR[h
     * ܂܂AsR[h𖳎Aobt@Ɋi[邩ǂ肷邽
     * ̑trueꍇ̃eXgP[X<br>
     */
    public void testDoStartTag11() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = new WriteTag_BeanStub01();
        bean.setValue("a\nb");

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "property", "value");
        UTUtil.setPrivateField(tag, "scope", "session");
        UTUtil.setPrivateField(tag, "replaceNullToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "fillColumn", new Integer(10));
        UTUtil.setPrivateField(tag, "replaceLFtoBR", new Boolean(false));

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.SKIP_BODY);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("ab", reader.readLine());

    }
    /**
     * testDoStartTag12B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * ignore=false<br>
     * RequestUtils.lookup(PageContext, name, scope)=not null<br>
     * value="a b c"<br>
     * replaceNullToNbsp=false<br>
     * filter=false<br>
     * replaceSpToNbsp=true<br>
     * fillColumn=0<br>
     * replaceLTtoBR=false<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * o͓e=null<br>
     * 
     * 1Jɂĕ\TCY0ꍇA
     * <br>t^ȂƂmFB<br>
     */
    public void testDoStartTag12() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = new WriteTag_BeanStub01();
        bean.setValue("a b c");

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "property", "value");
        UTUtil.setPrivateField(tag, "scope", "session");
        UTUtil.setPrivateField(tag, "replaceNullToNbsp", new Boolean(true));
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(true));
        UTUtil.setPrivateField(tag, "fillColumn", new Integer(0));
        UTUtil.setPrivateField(tag, "replaceLFtoBR", new Boolean(false));

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.SKIP_BODY);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("a&nbsp;b&nbsp;c", reader.readLine());

    }
    /**
     * testDoStartTag13B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l
     * ignore=false<br>
     * bean=null<br>
     * value=[<br>
     * replaceNullToNbsp=true<br>
     * filter=[<br>
     * replaceSpToNbsp=[<br>
     * fillColumn=[<br>
     * replaceLTtoBR=[<br>
     * 
     * Ғl
     * ߂l:JspException<br>
     * o͓e=-<br>
     * 
     * w肵beannull̏ꍇAJspException邱ƂmFB<br>
     * Ȃ̃eXgP[Xłnull͋󕶎&nbsp;ƒu邩ǂ
     * 肷邽߂̑truełꍇ̃eXgP[X܂ށB<br>
     */
    public void testDoStartTag13() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = null;

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "scope", "session");
        UTUtil.setPrivateField(tag, "property", "value");

        try {
            // eXgs
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            return;
        }
    }

    /**
     * testDoStartTag14B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * ignore=false<br>
     * RequestUtils.lookup(PageContext, name, scope)=not null<br>
     * value="ab"<br>
     * replaceNullToNbsp=false<br>
     * filter=false<br>
     * replaceSpToNbsp=false<br>
     * fillColumn=10<br>
     * replaceLTtoBR=true<br>
     * addBR=true<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * o͓e=uab<br>v<br>
     * 
     * addBRtruȅꍇAvpeBl̖ɉsR[ht^邱ƁB<br>
     */
    public void testDoStartTag14() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = new WriteTag_BeanStub01();
        bean.setValue("ab");

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "property", "value");
        UTUtil.setPrivateField(tag, "scope", "session");
        UTUtil.setPrivateField(tag, "replaceNullToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "fillColumn", new Integer(10));
        UTUtil.setPrivateField(tag, "replaceLFtoBR", new Boolean(true));
        UTUtil.setPrivateField(tag, "addBR", new Boolean(true));

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.SKIP_BODY);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("ab<br>", reader.readLine());
    }
    
    /**
     * testDoStartTag15B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * ignore=false<br>
     * RequestUtils.lookup(PageContext, name, scope)=not null<br>
     * value="123456"<br>
     * replaceNullToNbsp=false<br>
     * filter=false<br>
     * replaceSpToNbsp=true<br>
     * fillColumn=3<br>
     * replaceLFtoBR=false<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * o͓e=u123<br>456v<br>
     * 
     * bean擾vpeBlbeanvpeB擾lA
     * 1Jɂĕ\TCY傫ꍇ̃eXgP[XA
     * fillColumnvalue̔{łȂꍇB<br>
     */
    public void testDoStartTag15() throws Exception {

        // JX^^ÕCX^XɊ֘AtꂽPageContext擾
        PageContext pc = TagUTUtil.getPageContext(tag);

        // PageContextɃeXgf[^ƂĊi[Bean̐ݒ
        WriteTag_BeanStub01 bean = new WriteTag_BeanStub01();
        bean.setValue("123456");

        // PageContextɃ|bvAbv\pXNvg`o͔ϐݒB
        pc.setAttribute(LOOKUP_BEAN, bean, PageContext.SESSION_SCOPE);

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", LOOKUP_BEAN);
        UTUtil.setPrivateField(tag, "property", "value");
        UTUtil.setPrivateField(tag, "scope", "session");
        UTUtil.setPrivateField(tag, "replaceNullToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(true));
        UTUtil.setPrivateField(tag, "fillColumn", new Integer(3));
        UTUtil.setPrivateField(tag, "replaceLFtoBR", new Boolean(false));

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(result, Tag.SKIP_BODY);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("123<br>456", reader.readLine());

    }
    
    /**
     * testRelease01B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * filter=false<br>
     * replaceNullToNbsp=false<br>
     * replaceSpToNbsp=false<br>
     * replaceLFtoBR=false<br>
     * ignore=true<br>
     * name="name"<br>
     * property="property"<br>
     * scope="scope"<br>
     * fillColumn=100<br>
     * 
     * Ғl
     * ߂l:void<br>
     * filter=true<br>
     * replaceNullToNbsp=true<br>
     * replaceSpToNbsp=true<br>
     * replaceLFtoBR=true<br>
     * ignore=false<br>
     * name=Null<br>
     * property=Null<br>
     * scope=Null<br>
     * fillColumn=-1<br>
     * 
     * OƂĐݒ肵elAsɊel邱ƂmF<br>
     */
    public void testRelease01() throws Exception {

        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "replaceNullToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(false));
        UTUtil.setPrivateField(tag, "replaceLFtoBR", new Boolean(false));
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));
        UTUtil.setPrivateField(tag, "name", "name");
        UTUtil.setPrivateField(tag, "property", "property");
        UTUtil.setPrivateField(tag, "scope", "scope");
        UTUtil.setPrivateField(tag, "fillColumn", new Integer(100));

        //eXgs
        tag.release();

        //eXgʊmF
        assertTrue((Boolean) UTUtil.getPrivateField(tag, "filter"));
        assertTrue((Boolean) UTUtil.getPrivateField(tag, "replaceNullToNbsp"));
        assertTrue((Boolean) UTUtil.getPrivateField(tag, "replaceSpToNbsp"));
        assertTrue((Boolean) UTUtil.getPrivateField(tag, "replaceLFtoBR"));
        assertFalse((Boolean) UTUtil.getPrivateField(tag, "ignore"));
        assertNull(UTUtil.getPrivateField(tag, "name"));
        assertNull(UTUtil.getPrivateField(tag, "property"));
        assertNull(UTUtil.getPrivateField(tag, "scope"));
        assertEquals(-1, UTUtil.getPrivateField(tag, "fillColumn"));

    }

    /**
     * testSetFilter01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l Filter="filter"<br>
     * 
     * Ғl ߂l:void<br>
     * ԕω:filter=false<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetFilter01() throws Exception {

        //eXgs
        tag.setFilter(false);

        //eXgʊmF
        assertFalse((Boolean) UTUtil.getPrivateField(tag, "filter"));

    }

    /**
     * testGetFilter01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * filter=false
     * 
     * Ғl
     * ߂l:boolean<br>
     * filter=false<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testGetFilter01() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));

        //eXgʊmF
        assertFalse(tag.getFilter());

    }

    /**
     * testSetReplaceNullToNbsp01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * replaceNullToNbsp="replaceNullToNbsp"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * ԕω:replaceNullToNbsp=false<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetReplaceNullToNbsp01() throws Exception {

        //eXgs
        tag.setReplaceNullToNbsp(false);

        //eXgʊmF
        assertFalse((Boolean) UTUtil.getPrivateField(tag, "replaceNullToNbsp"));

    }

    /**
     * testGetReplaceNullToNbsp01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * replaceNullToNbsp=false
     * 
     * Ғl
     * ߂l:boolean<br>
     * replaceNullToNbsp=false<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testGetReplaceNullToNbsp01() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "replaceNullToNbsp", new Boolean(false));

        //eXgʊmF
        assertFalse(tag.getReplaceNullToNbsp());

    }

    /**
     * testSetReplaceSpToNbsp01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * replaceSpToNbsp="replaceSpToNbsp"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * ԕω:replaceSpToNbsp=false<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetReplaceSpToNbsp01() throws Exception {

        //eXgs
        tag.setReplaceSpToNbsp(false);

        //eXgʊmF
        assertFalse((Boolean) UTUtil.getPrivateField(tag, "replaceSpToNbsp"));

    }

    /**
     * testGetReplaceSpToNbsp01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * replaceSpToNbsp=false
     * 
     * Ғl
     * ߂l:boolean<br>
     * replaceSpToNbsp=false<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testGetReplaceSpToNbsp01() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(false));

        //eXgʊmF
        assertFalse(tag.getReplaceSpToNbsp());

    }

    /**
     * testSetReplaceLFtoBR01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * replaceLFtoBR="replaceLFtoBR"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * ԕω:replaceLFtoBR=false<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetReplaceLFtoBR01() throws Exception {

        //eXgs
        tag.setReplaceLFtoBR(false);

        //eXgʊmF
        assertFalse((Boolean) UTUtil.getPrivateField(tag, "replaceLFtoBR"));

    }

    /**
     * testGetReplaceLFtoBR01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * replaceLFtoBR=false
     * 
     * Ғl
     * ߂l:boolean<br>
     * replaceLFtoBR=false<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testGetReplaceLFtoBR01() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "replaceLFtoBR", new Boolean(false));

        //eXgʊmF
        assertFalse(tag.getReplaceLFtoBR());

    }

    /**
     * testSetIgnore01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * ignore="ignore"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * ԕω:ignore=true<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetIgnore01() throws Exception {

        //eXgs
        tag.setIgnore(true);

        //eXgʊmF
        assertTrue((Boolean) UTUtil.getPrivateField(tag, "ignore"));

    }

    /**
     * testGetignore01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * ignore=true
     * 
     * Ғl
     * ߂l:boolean<br>
     * ignore=true<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testGetIgnore01() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));

        //eXgʊmF
        assertTrue(tag.getIgnore());

    }

    /**
     * testSetName01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * name="name"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * ԕω:name="name"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetName01() throws Exception {

        //eXgs
        tag.setName("name");

        //eXgʊmF
        assertEquals("name", UTUtil.getPrivateField(tag, "name"));

    }

    /**
     * testGetName01B<br>0
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * name="name"
     * 
     * Ғl
     * ߂l:String<br>
     * name="name"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testGetName01() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "name", "name");

        //eXgʊmF
        assertEquals("name", tag.getName());

    }

    /**
     * testSetProperty01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * property="property"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * ԕω:property="property"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetProperty01() throws Exception {

        //eXgs
        tag.setProperty("property");

        //eXgʊmF
        assertEquals("property", UTUtil.getPrivateField(tag, "property"));

    }

    /**
     * testGetProperty01B<br>
     * 
     * (n)<br>
     * ϓ_:A<br>
     * 
     * ͒l
     * property="property"
     * 
     * Ғl
     * ߂l:String<br>
     * property="property"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testGetProperty01() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "property", "property");

        //eXgʊmF
        assertEquals("property", tag.getProperty());

    }

    /**
     * testSetScope01B<br>
     * 
     * (n)<br>
     * ϓ_:A<br>
     * 
     * ͒l
     * scope="scope"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * ԕω:scope="scope"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetScope01() throws Exception {

        //eXgs
        tag.setScope("scope");

        //eXgʊmF
        assertEquals("scope", UTUtil.getPrivateField(tag, "scope"));

    }

    /**
     * testGetScope01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * scope="scope"
     * 
     * Ғl
     * ߂l:String<br>
     * ԕω:scope="scope"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testGetScope01() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "scope", "scope");

        //eXgʊmF
        assertEquals("scope", tag.getScope());

    }

    /**
     * testSetFillColumn01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * fillColumn="fillColumn"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * ԕω:fillColumn=100<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetFillColumn01() throws Exception {

        //eXgs
        tag.setFillColumn(100);

        //eXgʊmF
        assertEquals(100, UTUtil.getPrivateField(tag, "fillColumn"));

    }

    /**
     * testGetFillColumn01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * fillColumn=false
     * 
     * Ғl
     * ߂l:boolean<br>
     * fillColumn=100<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testGetFillColumn01() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "fillColumn", new Integer(100));

        //eXgʊmF
        assertEquals(100, tag.getFillColumn());

    }

    /**
     * testSetAddBR01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * addBR="true"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * ԕω:addBR="true"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetAddBR01() throws Exception {

        //eXgs
        tag.setAddBR(true);

        //eXgʊmF
        assertTrue((Boolean) UTUtil.getPrivateField(tag, "addBR"));

    }

    /**
     * testGetAddBR01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * addBR="true"
     * 
     * Ғl
     * ߂l:boolean<br>
     * addBR="true"<br>
     * 
     * QbglmFeXgP[X<br>
     */
    public void testGetAddBR01() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "addBR", new Boolean(true));

        //eXgʊmF
        assertTrue(tag.getAddBR());

    }
    
}
