/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.spring.SpringTestCase;

/**
 * {@link jp.terasoluna.fw.web.taglib.WriteCodeValue} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * writeCodeValue ^O̎NXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.taglib.WriteCodeValue
 */
public class WriteCodeValueTagTest extends SpringTestCase {

    /**
     * eXgΏۃCX^XB
     */
    private WriteCodeValueTag tag = null;


    @Override
    protected void doOnSetUp() throws Exception {
        this.tag = new WriteCodeValueTag();
    }

    @Override
    protected String[] getConfigLocations() {
        return new String[] { "jp/terasoluna/fw/web/taglib/WriteCodeValueTagTest.xml" };
    }

    /**
     * testDoStartTag01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() codeList:""<br>
     *
     * <br>
     * ҒlF(ԕω) out.print:ĂяoȂ<br>
     *         (ԕω) O:JspTagException<br>
     *                    bZ[WF"codeList is required."<br>
     *         (ԕω) O:OxFG[<br>
     *                    "codeList is required."<br>
     *
     * <br>
     * codeList̒l󕶎̂ƂAJspTagException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag01() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", "");
        WriteCodeValueTag_PageContext context =
            new WriteCodeValueTag_PageContext();
        WriteCodeValueTag_JspWriterStub01 out =
            new WriteCodeValueTag_JspWriterStub01(0, false);
        context.out = out;
        tag.setPageContext(context);

        // eXg{
        // 
        try {
            tag.doStartTag();
            fail();
        } catch (JspTagException e) {
            String message = "codeList is required.";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message));
            assertFalse(out.isCalled);
        }

    }

    /**
     * testDoStartTag02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() codeList:null<br>
     *
     * <br>
     * ҒlF(ԕω) out.print:ĂяoȂ<br>
     *         (ԕω) O:JspTagException<br>
     *                    bZ[WF"codeList is required."<br>
     *         (ԕω) O:OxFG[<br>
     *                    "codeList is required."<br>
     *
     * <br>
     * codeList̒lnull̂ƂAJspTagException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag02() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", null);
        WriteCodeValueTag_PageContext context =
            new WriteCodeValueTag_PageContext();
        WriteCodeValueTag_JspWriterStub01 out =
            new WriteCodeValueTag_JspWriterStub01(0, false);
        context.out = out;
        tag.setPageContext(context);

        // eXg{
        // 
        try {
            tag.doStartTag();
            fail();
        } catch (JspTagException e) {
            String message = "codeList is required.";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message));
            assertFalse(out.isCalled);
        }

    }

    /**
     * testDoStartTag03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() codeList:"hoge"<br>
     *         () key:null<br>
     *         () name:null<br>
     *
     * <br>
     * ҒlF(ԕω) out.print:ĂяoȂ<br>
     *         (ԕω) O:JspTagException<br>
     *                    bZ[WF"key and name is required."<br>
     *         (ԕω) O:OxFG[<br>
     *                    "key and name is required."<br>
     *
     * <br>
     * keyAnameƂnull̏ꍇAJspTagException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag03() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", "hoge");
        UTUtil.setPrivateField(tag, "key", null);
        UTUtil.setPrivateField(tag, "name", null);
        WriteCodeValueTag_PageContext context =
            new WriteCodeValueTag_PageContext();
        WriteCodeValueTag_JspWriterStub01 out =
            new WriteCodeValueTag_JspWriterStub01(0, false);
        context.out = out;
        tag.setPageContext(context);

        // eXg{
        // 
        try {
            tag.doStartTag();
            fail();
        } catch (JspTagException e) {
            String message = "key and name is required.";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message));
            assertFalse(out.isCalled);
        }

    }

    /**
     * testDoStartTag04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() codeList:"hoge"<br>
     *         () key:null<br>
     *         () name:"hogeBean"<br>
     *         () scope:session<br>
     *         () scopeŎw肳ꂽXR[v:sessionXR[v"hogeBean"ƂÕIuWFNg݂ȂB<br>
     *
     * <br>
     * ҒlF(ԕω) out.print:ĂяoȂ<br>
     *         (ԕω) O:JspTagException<br>
     *                    bZ[WF"bean id:hogeBean is not defined."<br>
     *         (ԕω) O:OxFG[<br>
     *                    "bean id:hogeBean is not defined."<br>
     *
     * <br>
     * nameɎw肳ꂽBean݂ȂꍇAJspTagException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag04() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", "hoge");
        UTUtil.setPrivateField(tag, "key", null);
        UTUtil.setPrivateField(tag, "name", "hogeBean");
        UTUtil.setPrivateField(tag, "scope", "session");
        WriteCodeValueTag_PageContext context =
            new WriteCodeValueTag_PageContext();
        WriteCodeValueTag_JspWriterStub01 out =
            new WriteCodeValueTag_JspWriterStub01(0, false);
        context.out = out;
        tag.setPageContext(context);

        // eXg{
        // 
        try {
            tag.doStartTag();
            fail();
        } catch (JspTagException e) {
            String message = "bean id:hogeBean is not defined.";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message));
            assertFalse(out.isCalled);
        }

    }

    /**
     * testDoStartTag05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() codeList:"hoge"<br>
     *         () key:null<br>
     *         () name:"hogeBean"<br>
     *         () property:"hogeProperty"<br>
     *         () scope:request<br>
     *         () scopeŎw肳ꂽXR[v:requestXR[v"hogeBean"݂邪AhogeBeanhogeProperty݂ȂB<br>
     *
     * <br>
     * ҒlF(ԕω) out.print:ĂяoȂ<br>
     *         (ԕω) O:JspTagException<br>
     *                    bZ[WF"Cannot get property[hogeBean.hogeProperty]."<br>
     *         (ԕω) O:OxFG[<br>
     *                    "Cannot get property[hogeBean.hogeProperty]."<br>
     *
     * <br>
     * propertyɎw肳ꂽvpeB擾łȂꍇAJspTagException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag05() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", "hoge");
        UTUtil.setPrivateField(tag, "key", null);
        UTUtil.setPrivateField(tag, "name", "hogeBean");
        UTUtil.setPrivateField(tag, "property", "hogeProperty");
        UTUtil.setPrivateField(tag, "scope", "request");
        HttpServletRequest req = new MockHttpServletRequest();
        req.setAttribute("hogeBean", "hogeBeanString");
        WriteCodeValueTag_PageContext context =
            new WriteCodeValueTag_PageContext(null, req);
        WriteCodeValueTag_JspWriterStub01 out =
            new WriteCodeValueTag_JspWriterStub01(0, false);
        context.out = out;
        tag.setPageContext(context);

        // eXg{
        // 
        try {
            tag.doStartTag();
            fail();
        } catch (JspTagException e) {
            String message = "Cannot get property[hogeBean.hogeProperty].";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message));
            assertFalse(out.isCalled);
        }

    }

    /**
     * testDoStartTag06()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() codeList:"hoge"<br>
     *         () key:null<br>
     *         () name:"hogeBean"<br>
     *         () property:"hogeProperty"<br>
     *         () scope:page<br>
     *         () scopeŎw肳ꂽXR[v:pageXR[v"hogeBean"hogeProperty̒l"001"<br>
     *         () codeListŎw肳ꂽOcodeListLoader:ApplicationContext擾łȂ<br>
     *
     * <br>
     * ҒlF(ԕω) out.print:ĂяoȂ<br>
     *         (ԕω) O:JspTagException<br>
     *                    bZ[WF"CodeListLoader:hoge is not defined."<br>
     *         (ԕω) O:OxFG[<br>
     *                    "CodeListLoader:hoge is not defined."<br>
     *
     * <br>
     * codeListLoaderCX^X擾łȂꍇAJspTagException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag06() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", "hoge");
        UTUtil.setPrivateField(tag, "key", null);
        UTUtil.setPrivateField(tag, "name", "hogeBean");
        UTUtil.setPrivateField(tag, "property", "hogeProperty");
        UTUtil.setPrivateField(tag, "scope", "page");
        WriteCodeValueTag_PageContext context =
            new WriteCodeValueTag_PageContext();
        WriteCodeValueTag_JspWriterStub01 out =
            new WriteCodeValueTag_JspWriterStub01(0, false);
        context.out = out;
        tag.setPageContext(context);
        WriteCodeValueTag_JavaBeanStub01 hogeBean =
            new WriteCodeValueTag_JavaBeanStub01();
        hogeBean.setHogeProperty("001");
        context.setAttribute("hogeBean", hogeBean);
        UTUtil.setPrivateField(context, "servletContext", servletContext);

        // eXg{
        // 
        try {
            tag.doStartTag();
            fail();
        } catch (JspTagException e) {
            String message = "CodeListLoader:hoge is not defined.";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message));
            assertFalse(out.isCalled);
        }

    }

    /**
     * testDoStartTag07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() codeList:"hoge1"<br>
     *         () key:null<br>
     *         () name:"hogeBean"<br>
     *         () property:"hogeProperty"<br>
     *         () scope:page<br>
     *         () scopeŎw肳ꂽXR[v:pageXR[v"hogeBean"hogeProperty̒l"001"<br>
     *         () codeListŎw肳ꂽOcodeListLoader:getCodeBeanšʂnull<br>
     *
     * <br>
     * ҒlF(߂l) int:1<br>
     *         (ԕω) out.print:ĂяoȂ<br>
     *         (ԕω) O:OxFx<br>
     *                    "Codebean is null. CodeListLoader(bean id:hoge1)"<br>
     *
     * <br>
     * codeListLoaderCodeBean擾łȂꍇAxOo͂ďI邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag07() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", "hoge1");
        UTUtil.setPrivateField(tag, "key", null);
        UTUtil.setPrivateField(tag, "name", "hogeBean");
        UTUtil.setPrivateField(tag, "property", "hogeProperty");
        UTUtil.setPrivateField(tag, "scope", "page");
        WriteCodeValueTag_PageContext context =
            new WriteCodeValueTag_PageContext();
        WriteCodeValueTag_JspWriterStub01 out =
            new WriteCodeValueTag_JspWriterStub01(0, false);
        context.out = out;
        tag.setPageContext(context);
        WriteCodeValueTag_JavaBeanStub01 hogeBean =
            new WriteCodeValueTag_JavaBeanStub01();
        hogeBean.setHogeProperty("001");
        context.setAttribute("hogeBean", hogeBean);
        UTUtil.setPrivateField(context, "servletContext", servletContext);

        // eXg{
        // 
        int result = tag.doStartTag();
        assertEquals(1, result);
        String message = "Codebean is null. CodeListLoader(bean id:hoge1)";
        assertTrue(LogUTUtil.checkWarn(message));
        assertFalse(out.isCalled);

    }

    /**
     * testDoStartTag08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() codeList:"hoge2"<br>
     *         () key:null<br>
     *         () name:"hogeBean"<br>
     *         () property:"hogeProperty"<br>
     *         () scope:page<br>
     *         () scopeŎw肳ꂽXR[v:pageXR[v"hogeBean"hogeProperty̒l"001"<br>
     *         () codeListŎw肳ꂽOcodeListLoader:CodeBean[] {<br>
     *                 "000"="R[h0"<br>
     *                }<br>
     *
     * <br>
     * ҒlF(߂l) int:1<br>
     *         (ԕω) out.print:ĂяoȂ<br>
     *
     * <br>
     * R[hlɈvCodeBean݂ȂꍇAo͂ɏI邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag08() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", "hoge2");
        UTUtil.setPrivateField(tag, "key", null);
        UTUtil.setPrivateField(tag, "name", "hogeBean");
        UTUtil.setPrivateField(tag, "property", "hogeProperty");
        UTUtil.setPrivateField(tag, "scope", "page");
        WriteCodeValueTag_PageContext context =
            new WriteCodeValueTag_PageContext();
        WriteCodeValueTag_JspWriterStub01 out =
            new WriteCodeValueTag_JspWriterStub01(0, false);
        context.out = out;
        tag.setPageContext(context);
        WriteCodeValueTag_JavaBeanStub01 hogeBean =
            new WriteCodeValueTag_JavaBeanStub01();
        hogeBean.setHogeProperty("001");
        context.setAttribute("hogeBean", hogeBean);
        UTUtil.setPrivateField(context, "servletContext", servletContext);

        // eXg{
        // 
        int result = tag.doStartTag();
        assertEquals(1, result);
        assertFalse(out.isCalled);

    }

    /**
     * testDoStartTag09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() codeList:"hoge3"<br>
     *         () key:"001"<br>
     *         () codeListŎw肳ꂽOcodeListLoader:CodeBean[] {<br>
     *                 "000"="R[h0",<br>
     *                 "002"="R[h2",<br>
     *                 "003"="R[h3"<br>
     *                }<br>
     *
     * <br>
     * ҒlF(߂l) int:1<br>
     *         (ԕω) out.print:ĂяoȂ<br>
     *
     * <br>
     * R[hlɈvCodeBean݂ȂꍇAo͂ɏI邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag09() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", "hoge3");
        UTUtil.setPrivateField(tag, "key", "001");
        WriteCodeValueTag_PageContext context =
            new WriteCodeValueTag_PageContext();
        WriteCodeValueTag_JspWriterStub01 out =
            new WriteCodeValueTag_JspWriterStub01(0, false);
        context.out = out;
        tag.setPageContext(context);
        UTUtil.setPrivateField(context, "servletContext", servletContext);

        // eXg{
        // 
        int result = tag.doStartTag();
        assertEquals(1, result);
        assertFalse(out.isCalled);

    }

    /**
     * testDoStartTag10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() codeList:"hoge4"<br>
     *         () key:null<br>
     *         () name:"hogeBean"<br>
     *         () property:"hogeProperty"<br>
     *         () scope:page<br>
     *         () scopeŎw肳ꂽXR[v:pageXR[v"hogeBean"hogeProperty̒l"001"<br>
     *         () codeListŎw肳ꂽOcodeListLoader:CodeBean[] {<br>
     *                 "001"="R[h1"<br>
     *                }<br>
     *
     * <br>
     * ҒlF(߂l) int:1<br>
     *         (ԕω) out.print:"R[h1"ŌĂяoB<br>
     *
     * <br>
     * R[hlɈvCodeBean݂ꍇA̒ly[Wɏo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag10() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", "hoge4");
        UTUtil.setPrivateField(tag, "key", null);
        UTUtil.setPrivateField(tag, "name", "hogeBean");
        UTUtil.setPrivateField(tag, "property", "hogeProperty");
        UTUtil.setPrivateField(tag, "scope", "page");
        WriteCodeValueTag_PageContext context =
            new WriteCodeValueTag_PageContext();
        WriteCodeValueTag_JspWriterStub01 out =
            new WriteCodeValueTag_JspWriterStub01(0, false);
        context.out = out;
        tag.setPageContext(context);
        WriteCodeValueTag_JavaBeanStub01 hogeBean =
            new WriteCodeValueTag_JavaBeanStub01();
        hogeBean.setHogeProperty("001");
        context.setAttribute("hogeBean", hogeBean);
        UTUtil.setPrivateField(context, "servletContext", servletContext);

        // eXg{
        // 
        int result = tag.doStartTag();
        assertEquals(1, result);
        assertTrue(out.isCalled);
        assertEquals("R[h1", out.result);

    }

    /**
     * testDoStartTag11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() codeList:"hoge5"<br>
     *         () key:"001"<br>
     *         () codeListŎw肳ꂽOcodeListLoader:CodeBean[] {<br>
     *                 "000"="R[h0",<br>
     *                 "001"="R[h1",<br>
     *                 "002"="R[h2"<br>
     *                }<br>
     *
     * <br>
     * ҒlF(߂l) int:1<br>
     *         (ԕω) out.print:"R[h1"ŌĂяoB<br>
     *
     * <br>
     * R[hlɈvCodeBean݂ꍇA̒ly[Wɏo͂邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag11() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", "hoge5");
        UTUtil.setPrivateField(tag, "key", "001");
        WriteCodeValueTag_PageContext context =
            new WriteCodeValueTag_PageContext();
        WriteCodeValueTag_JspWriterStub01 out =
            new WriteCodeValueTag_JspWriterStub01(0, false);
        context.out = out;
        tag.setPageContext(context);
        UTUtil.setPrivateField(context, "servletContext", servletContext);

        // eXg{
        // 
        int result = tag.doStartTag();
        assertEquals(1, result);
        assertTrue(out.isCalled);
        assertEquals("R[h1", out.result);

    }

    /**
     * testDoStartTag12()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() codeList:"hoge5"<br>
     *         () key:"001"<br>
     *         () codeListŎw肳ꂽOcodeListLoader:CodeBean[] {<br>
     *                 "000"="R[h0",<br>
     *                 "001"="R[h1",<br>
     *                 "002"="R[h2"<br>
     *                }<br>
     *         () out.print:IOException<br>
     *
     * <br>
     * ҒlF(ԕω) out.print:"R[h1"ŌĂяoB<br>
     *         (ԕω) O:JspTagException<br>
     *                    bvOFIOException<br>
     *         (ԕω) O:OxFG[<br>
     *                    ""<br>
     *                    OFIOException<br>
     *
     * <br>
     * out.printIOExceptionꍇAJspTagExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag12() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", "hoge5");
        UTUtil.setPrivateField(tag, "key", "001");
        WriteCodeValueTag_PageContext context =
            new WriteCodeValueTag_PageContext();
        WriteCodeValueTag_JspWriterStub02 out =
            new WriteCodeValueTag_JspWriterStub02(0, false);
        context.out = out;
        tag.setPageContext(context);
        UTUtil.setPrivateField(context, "servletContext", servletContext);

        // eXg{
        // 
        try {
            tag.doStartTag();
            fail();
        } catch (JspTagException e) {
            assertTrue(e.getRootCause() instanceof IOException);
            assertTrue(out.isCalled);
            assertEquals("R[h1", out.result);
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }

    }

    /**
     * testDoStartTag13()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() codeList:"hoge6"<br>
     *         () key:"001"<br>
     *         () codeListŎw肳ꂽOcodeListLoader:codeListLoaderCX^Xł͂Ȃ<br>
     *         () out.print:-<br>
     *
     * <br>
     * ҒlF(ԕω) out.print:ĂяoȂB<br>
     *         (ԕω) O:JspTagException<br>
     *                    bZ[WF"bean id:hoge6 is not instance of CodeListLoader."
     *                    bvOFClassCastException<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"bean id:hoge6 is not instance of CodeListLoader."
     *
     * <br>
     * w肳ꂽOŎ擾codeListLoaderCodeListLoaderCX^Xł͂Ȃꍇ
     * JspTagExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag13() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", "hoge6");
        UTUtil.setPrivateField(tag, "key", "001");
        WriteCodeValueTag_PageContext context =
            new WriteCodeValueTag_PageContext();
        WriteCodeValueTag_JspWriterStub02 out =
            new WriteCodeValueTag_JspWriterStub02(0, false);
        context.out = out;
        tag.setPageContext(context);
        UTUtil.setPrivateField(context, "servletContext", servletContext);

        // eXg{
        // 
        try {
            tag.doStartTag();
            fail();
        } catch (JspTagException e) {
            String message = "bean id:hoge6 is not instance of CodeListLoader.";
            assertTrue(e.getRootCause() instanceof ClassCastException);
            assertEquals(message, e.getMessage());
            assertFalse(out.isCalled);
            assertTrue(LogUTUtil.checkError(message));
        }

    }

    /**
     * testDoEndTag01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF
     * <br>
     * ҒlF(߂l) int:TagSupport.EVAL_PAGE<br>
     *
     * <br>
     * TagSupport.EVAL_PAGEԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoEndTag01() throws Exception {
        assertEquals(Tag.EVAL_PAGE, tag.doEndTag());
    }

    /**
     * testRelease01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() codeList:"codeList"<br>
     *         () key:"key"<br>
     *         () name:"name"<br>
     *         () property:"property"<br>
     *         () scope:"scope"<br>
     *
     * <br>
     * ҒlF(ԕω) codeList:null<br>
     *         (ԕω) key:null<br>
     *         (ԕω) name:null<br>
     *         (ԕω) property:null<br>
     *         (ԕω) scope:null<br>
     *
     * <br>
     * SĂ̑lnullɏ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testRelease01() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", "codeList");
        UTUtil.setPrivateField(tag, "key", "key");
        UTUtil.setPrivateField(tag, "name", "name");
        UTUtil.setPrivateField(tag, "property", "property");
        UTUtil.setPrivateField(tag, "scope", "scope");

        // eXg{
        tag.release();

        // 
        assertNull(UTUtil.getPrivateField(tag, "codeList"));
        assertNull(UTUtil.getPrivateField(tag, "key"));
        assertNull(UTUtil.getPrivateField(tag, "name"));
        assertNull(UTUtil.getPrivateField(tag, "property"));
        assertNull(UTUtil.getPrivateField(tag, "scope"));
    }

    /**
     * testSetCodeList01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() codeList:"codeList"<br>
     *         () codeList:null<br>
     *
     * <br>
     * ҒlF(ԕω) codeList:"codeList"<br>
     *
     * <br>
     * ̒lcodeListɊi[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetCodeList01() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "codeList", null);

        // eXg{
        tag.setCodeList("codeList");

        // 
        assertEquals("codeList", UTUtil.getPrivateField(tag, "codeList"));
    }

    /**
     * testSetName01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:"name"<br>
     *         () name:null<br>
     *
     * <br>
     * ҒlF(ԕω) name:"name"<br>
     *
     * <br>
     * ̒lnameɊi[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetName01() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "name", null);

        // eXg{
        tag.setName("name");

        // 
        assertEquals("name", UTUtil.getPrivateField(tag, "name"));
    }

    /**
     * testSetProperty01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"property"<br>
     *         () property:null<br>
     *
     * <br>
     * ҒlF(ԕω) property:"property"<br>
     *
     * <br>
     * ̒lpropertyɊi[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetProperty01() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "property", null);

        // eXg{
        tag.setProperty("property");

        // 
        assertEquals("property", UTUtil.getPrivateField(tag, "property"));
    }

    /**
     * testSetScope01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() scope:"scope"<br>
     *         () scope:null<br>
     *
     * <br>
     * ҒlF(ԕω) scope:"scope"<br>
     *
     * <br>
     * ̒lscopeɊi[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetScope01() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "scope", null);

        // eXg{
        tag.setScope("scope");

        // 
        assertEquals("scope", UTUtil.getPrivateField(tag, "scope"));
    }

    /**
     * testSetKey01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key"<br>
     *         () key:null<br>
     *
     * <br>
     * ҒlF(ԕω) key:"key"<br>
     *
     * <br>
     * ̒lkeyɊi[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetKey01() throws Exception {
        // O
        UTUtil.setPrivateField(tag, "key", null);

        // eXg{
        tag.setKey("key");

        // 
        assertEquals("key", UTUtil.getPrivateField(tag, "key"));
    }

}
