/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.io.BufferedReader;
import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.exception.Exception_JspWriterImpl;
import jp.terasoluna.utlib.exception.Exception_PageContextImpl;
import junit.framework.TestCase;

/**
 * StringFormatterTagBase ubN{bNXeXgB<br>
 */
public class StringFormatterTagBaseTest extends TestCase {

    // eXgΏ
    StringFormatterTagBaseImpl01 tag = null;

    /**
     * Constructor for StringFormatterTagBaseTest.
     * @param arg0
     */
    public StringFormatterTagBaseTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (StringFormatterTagBaseImpl01) TagUTUtil
                .create(StringFormatterTagBaseImpl01.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        tag = null;
    }

    /**
     * testDoStartTag01B<br>
     * (n)<br>
     * ϓ_FF<br>
     * ͒l value=Null<br>
     * ignore=true<br>
     * name=Not Null<br>
     * property=*<br>
     * scope=l<br>
     * bean=null<br>
     * valu2=*<br>
     * id=*<br>
     * filter=*<br>
     * output=*<br>
     * Ғl ߂l:int=SKIP_BODY<br>
     * pageContextid=-<br>
     * output=-<br>
     * 擾uBeanvNULL̏ꍇ̃eXgP[X<br>
     */
    public void testDoStartTag01() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));
        UTUtil.setPrivateField(tag, "name", "NoBeanKey");
        UTUtil.setPrivateField(tag, "property", "testField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        StringFormatterTagBase_BeanStub01 bean = new StringFormatterTagBase_BeanStub01();
        bean.setTestField("testtesttest");

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

    } /* testDoStartTag01 End */

    /**
     * testDoStartTag02B<br>
     * (n)<br>
     * ϓ_FF<br>
     * ͒l value=Null<br>
     * ignore=true<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=l<br>
     * bean=Not Null<br>
     * valu2=Null<br>
     * id=*<br>
     * filter=*<br>
     * output=*<br>
     * Ғl ߂l:int=SKIP_BODY<br>
     * pageContextid=-<br>
     * output=-<br>
     * 擾uvalue2vNULL̏ꍇ̃eXgP[X<br>
     */
    public void testDoStartTag02() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));
        UTUtil.setPrivateField(tag, "name", "BeanKey");
        UTUtil.setPrivateField(tag, "property", "testField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        StringFormatterTagBase_BeanStub01 bean = new StringFormatterTagBase_BeanStub01();
        bean.setTestField(null);

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

    } /* testDoStartTag02 End */

    /**
     * testDoStartTag03B<br>
     * (n)<br>
     * ϓ_FF<br>
     * ͒l value=Null<br>
     * ignore=false<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=l<br>
     * bean=Not Null<br>
     * valu2=Not Null<br>
     * id=Not Null<br>
     * filter=*<br>
     * output="testtesttest"<br>
     * Ғl ߂l:int=SKIP_BODY<br>
     * pageContextid="testtesttest"<br>
     * output=-<br>
     * StringFormatterTagBaseNXϐ́uidvL[ y[WReLXgɃtH[}bg̒lZbgꍇ̃eXgP[X<br>
     */
    public void testDoStartTag03() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", "BeanKey");
        UTUtil.setPrivateField(tag, "property", "testField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        String testValue = "testtesttest";

        StringFormatterTagBase_BeanStub01 bean = new StringFormatterTagBase_BeanStub01();
        bean.setTestField("testtesttest");

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);
        assertEquals(testValue, pc.getAttribute("id"));

    } /* testDoStartTag03 End */

    /**
     * testDoStartTag04B<br>
     * (n)<br>
     * ϓ_FF<br>
     * ͒l value=Not Null<br>
     * ignore=*<br>
     * name=*<br>
     * property=*<br>
     * scope=*<br>
     * bean=*<br>
     * valu2=*<br>
     * id=Null<br>
     * filter=true<br>
     * output="test<test>test"<br>
     * Ғl ߂l:int=SKIP_BODY<br>
     * pageContextid=-<br>
     * output="test&lt;test&gt;test"<br>
     * StringFormatterTagBaseNXϐ́uidvw肳ĂȂ߁A tH[}bg̒ltB^[Ay[WɊ֘AtꂽC^ ޏꍇ̃eXgP[X<br>
     */
    public void testDoStartTag04() throws Exception {

        // eXgf[^ݒ
        String testValue = "test<test>test";
        UTUtil.setPrivateField(tag, "value", testValue);
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        String reader = TagUTUtil.getOutputString(tag);
        assertEquals(Tag.SKIP_BODY, result);
        assertEquals("test&lt;test&gt;test", reader);

    } /* testDoStartTag04 End */

    /**
     * testDoStartTag05B<br>
     * (n)<br>
     * ϓ_FF<br>
     * ͒l value=Not Null<br>
     * ignore=*<br>
     * name=*<br>
     * property=*<br>
     * scope=*<br>
     * bean=*<br>
     * valu2=*<br>
     * id=Null<br>
     * filter=false<br>
     * output="test<test>test"<br>
     * Ғl ߂l:int=SKIP_BODY<br>
     * pageContextid=-<br>
     * output="test<test>test"<br>
     * StringFormatterTagBaseNXϐ́uidvw肳ĂȂ߁A tH[}bg̒ltB^[ɁAy[WɊ֘AtꂽC^ ޏꍇ̃eXgP[X<br>
     */
    public void testDoStartTag05() throws Exception {

        // eXgf[^ݒ
        String testValue = "test<test>test";
        UTUtil.setPrivateField(tag, "value", testValue);
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        String reader = TagUTUtil.getOutputString(tag);
        assertEquals(Tag.SKIP_BODY, result);
        assertEquals(testValue, reader);

    } /* testDoStartTag05 End */

    /**
     * testDoStartTag06B<br>
     * (ُn)<br>
     * ϓ_FG<br>
     * ͒l value=Null<br>
     * ignore=true<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=ُl<br>
     * bean=*<br>
     * valu2=*<br>
     * id=*<br>
     * filter=*<br>
     * output=*<br>
     * Ғl ߂l:int=JspException<br>
     * pageContextid=-<br>
     * output=-<br>
     * uBeanv擾JspExceptionꍇ̃eXgP[X<br>
     */
    public void testDoStartTag06() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));
        UTUtil.setPrivateField(tag, "name", "NoBeanKey");
        UTUtil.setPrivateField(tag, "property", "testField");
        UTUtil.setPrivateField(tag, "scope", "Not Scope");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        StringFormatterTagBase_BeanStub01 bean = new StringFormatterTagBase_BeanStub01();

        bean.setTestField("testtesttest");

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        // eXgs
        try {
            tag.doStartTag();
            fail();
        } catch (JspException ex) {
            // eXgʊmF
            assertEquals(JspException.class.getName(), ex.getClass().getName());
            return;
        }
    } /* testDoStartTag06 End */

    /**
     * testDoStartTag07B<br>
     * (ُn)<br>
     * ϓ_FG<br>
     * ͒l value=Null<br>
     * ignore=false<br>
     * name=Not Null<br>
     * property=z肵镶<br>
     * scope=l<br>
     * bean=*<br>
     * valu2=*<br>
     * id=*<br>
     * filter=*<br>
     * output=*<br>
     * Ғl ߂l:int=JspException<br>
     * pageContextid=-<br>
     * output=-<br>
     * uvalue2v擾JspExceptionꍇ̃eXgP[X<br>
     */
    public void testDoStartTag07() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", "BeanKey");
        UTUtil.setPrivateField(tag, "property", "NotestField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        StringFormatterTagBase_BeanStub01 bean = new StringFormatterTagBase_BeanStub01();

        bean.setTestField("testtesttest");

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        // eXgs
        try {
            tag.doStartTag();
            fail();
        } catch (JspException ex) {
            // eXgʊmF
            String mes = ex.getMessage();
            assertTrue(mes, mes.startsWith("Unknown property \'NotestField\'"));
            // assertEquals("Unknown property \'NotestField\'", ex.getMessage());
            return;
        }
    } /* testDoStartTag07 End */

    /**
     * testDoStartTag08B<br>
     * (ُn)<br>
     * ϓ_FG<br>
     * ͒l value=Not Null<br>
     * ignore=*<br>
     * name=*<br>
     * property=*<br>
     * scope=*<br>
     * bean=*<br>
     * valu2=*<br>
     * id=Null<br>
     * filter=true<br>
     * output=" output"<br>
     * Ғl ߂l:int=JspException<br>
     * pageContextid=-<br>
     * output=-<br>
     * tB^[ς݂̒ly[WɊ֘AtꂽC^ ނƂJspExceptionꍇ̃eXgP[X<br>
     */
    public void testDoStartTag08() throws Exception {

        // eXgf[^ݒ
        String testValue = "test<test>test";
        UTUtil.setPrivateField(tag, "value", testValue);
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        PageContext pc = TagUTUtil.getPageContext(tag);
        Exception_JspWriterImpl out = new Exception_JspWriterImpl();
        out.setTrue();
        out.setTiming(1);
        UTUtil.setPrivateField(pc, "jspWriter", out);

        // eXgs
        try {
            tag.doStartTag();
            fail();
        } catch (JspException ex) {
            // eXgʊmF
            assertEquals(IOException.class.getName(), ex.getRootCause()
                    .getClass().getName());
            return;
        }
    } /* testDoStartTag08 End */

    /**
     * testDoStartTag09B<br>
     * (ُn)<br>
     * ϓ_FG<br>
     * ͒l value=Not Null<br>
     * ignore=*<br>
     * name=*<br>
     * property=*<br>
     * scope=*<br>
     * bean=*<br>
     * valu2=*<br>
     * id=Null<br>
     * filter=false<br>
     * output=" output"<br>
     * Ғl ߂l:int=JspException<br>
     * pageContextid=-<br>
     * output=-<br>
     * ly[WɊ֘AtꂽC^ɏނƂ JspExceptionꍇ̃eXgP[X<br>
     */
    public void testDoStartTag09() throws Exception {

        // eXgf[^ݒ
        String testValue = "test<test>test";
        UTUtil.setPrivateField(tag, "value", testValue);
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));

        PageContext pc = TagUTUtil.getPageContext(tag);
        Exception_JspWriterImpl out = new Exception_JspWriterImpl();
        out.setTrue();
        out.setTiming(1);
        UTUtil.setPrivateField(pc, "jspWriter", out);

        // eXgs
        try {
            tag.doStartTag();
            fail();
        } catch (JspException ex) {
            // eXgʊmF
            assertEquals(IOException.class.getName(), ex.getRootCause()
                    .getClass().getName());
            return;
        }
    } /* testDoStartTag09 End */

    /**
     * testDoStartTag10B<br>
     * (ُn)<br>
     * ϓ_FG<br>
     * ͒l value=Null<br>
     * ignore=false<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=l<br>
     * bean=*<br>
     * valu2=Not Null<br>
     * id=Not Null<br>
     * filter=*<br>
     * output="output"<br>
     * Ғl ߂l:int=NullPointerException<br>
     * pageContextid=-<br>
     * output=-<br>
     * y[WReLXgɃZbg鎞 NullPointerExceptionꍇ<br>
     */
    public void testDoStartTag10() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", "value");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        PageContext pc = TagUTUtil.getPageContext(tag);
        Exception_PageContextImpl pc2 = new Exception_PageContextImpl(pc
                .getServletConfig(), pc.getRequest(), pc.getResponse());
        pc2.setNullPointerEx();
        pc2.setTiming(1);
        tag.setPageContext(pc2);

        // eXgs
        try {
            tag.doStartTag();
            fail();
        } catch (NullPointerException ex) {

            // eXgʊmF
            assertEquals(NullPointerException.class.getName(), ex.getClass()
                    .getName());
            return;
        }
    } /* testDoStartTag10 End */

    /**
     * testDoStartTag11B<br>
     * (ُn)<br>
     * ϓ_FG<br>
     * ͒l value=Null<br>
     * ignore=false<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=l<br>
     * bean=*<br>
     * valu2=Not Null<br>
     * id=Not Null<br>
     * filter=*<br>
     * output="output"<br>
     * Ғl ߂l:int=IllegalArgumentException<br>
     * pageContextid=-<br>
     * output=-<br>
     * y[WReLXgɃZbg鎞 IllegalArgumentExceptionꍇ<br>
     */
    public void testDoStartTag11() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", "value");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        PageContext pc = TagUTUtil.getPageContext(tag);
        Exception_PageContextImpl pc2 = new Exception_PageContextImpl(pc
                .getServletConfig(), pc.getRequest(), pc.getResponse());
        pc2.setIllegalArgumentEx();
        pc2.setTiming(1);
        tag.setPageContext(pc2);

        // eXgs
        try {
            tag.doStartTag();
            fail();
        } catch (IllegalArgumentException ex) {

            // eXgʊmF
            assertEquals(IllegalArgumentException.class.getName(), ex
                    .getClass().getName());
            return;
        }
    } /* testDoStartTag11 End */

    /**
     * testDoStartTag12B<br>
     * (n)<br>
     * ϓ_FF<br>
     * ͒l value=Null<br>
     * ignore=false<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=l<br>
     * bean=Not Null<br>
     * valu2=Not Null<br>
     * id=Null<br>
     * filter=*<br>
     * output="test  TEST"(pXy[X~2)<br>
     * replaceSpToNbsp=true<br>
     * Ғl ߂l:int=SKIP_BODY<br>
     * pageContextid="test&nbsp;&nbsp;TEST"<br>
     * output=-<br>
     * pXy[X܂ޕŁAStringFormatterTagBaseNXϐ́uidvL[ y[WReLXgɃtH[}bg̒lZbgꍇ̃eXgP[X
     * (replaceSpToNbsptrueȂ̂ŔpXy[XuĂ)<br>
     */
    public void testDoStartTag12() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", "BeanKey");
        UTUtil.setPrivateField(tag, "property", "testField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(true));

        String testValue = "test  TEST";

        StringFormatterTagBase_BeanStub01 bean = new StringFormatterTagBase_BeanStub01();

        bean.setTestField(testValue);

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);
        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);
        String reader = TagUTUtil.getOutputString(tag);
        assertEquals("test&nbsp;&nbsp;TEST", reader);

    } /* testDoStartTag12 End */

    /**
     * testDoStartTag13B<br>
     * (n)<br>
     * ϓ_FF<br>
     * ͒l value=Null<br>
     * ignore=false<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=l<br>
     * bean=Not Null<br>
     * valu2=Not Null<br>
     * id=Null<br>
     * filter=*<br>
     * output="test@@TEST"(SpXy[X~2)<br>
     * replaceSpToNbsp=true<br>
     * Ғl ߂l:int=SKIP_BODY<br>
     * pageContextid="testTEST"<br>
     * output=-<br>
     * SpXy[X܂ޕŁAStringFormatterTagBaseNXϐ́uidvL[ y[WReLXgɃtH[}bg̒lZbgꍇ̃eXgP[X
     * (replaceSpToNbsptrueSpXy[XȂ̂ŒuĂȂ)<br>
     */
    public void testDoStartTag13() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", "BeanKey");
        UTUtil.setPrivateField(tag, "property", "testField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(true));

        String testValue = "test@@TEST";

        StringFormatterTagBase_BeanStub01 bean = new StringFormatterTagBase_BeanStub01();

        bean.setTestField(testValue);

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals(testValue, reader.readLine());

    } /* testDoStartTag13 End */

    /**
     * testDoStartTag14B<br>
     * (n)<br>
     * ϓ_FF<br>
     * ͒l value=Null<br>
     * ignore=false<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=l<br>
     * bean=Not Null<br>
     * valu2=Not Null<br>
     * id=Null<br>
     * filter=*<br>
     * output="test  TEST"(pXy[X~2)<br>
     * replaceSpToNbsp=false<br>
     * Ғl ߂l:int=SKIP_BODY<br>
     * pageContextid="testTEST"<br>
     * output=-<br>
     * pXy[X܂ޕŁAStringFormatterTagBaseNXϐ́uidvL[ y[WReLXgɃtH[}bg̒lZbgꍇ̃eXgP[X
     * (replaceSpToNbspfalseȂ̂ŔpXy[XuĂȂ)<br>
     */
    public void testDoStartTag14() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", "BeanKey");
        UTUtil.setPrivateField(tag, "property", "testField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(false));

        String testValue = "test  TEST";

        StringFormatterTagBase_BeanStub01 bean = new StringFormatterTagBase_BeanStub01();

        bean.setTestField(testValue);

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals(testValue, reader.readLine());

    } /* testDoStartTag14 End */

    /**
     * testDoStartTag15B<br>
     * (n)<br>
     * ϓ_FF<br>
     * ͒l value=Null<br>
     * ignore=false<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=l<br>
     * bean=Not Null<br>
     * valu2=Not Null<br>
     * id=Not Null<br>
     * filter=*<br>
     * output="test  TEST"(pXy[X~2)<br>
     * replaceSpToNbsp=true<br>
     * Ғl ߂l:int=SKIP_BODY<br>
     * pageContextid="testTEST"<br>
     * output=-<br>
     * pXy[X܂ޕŁAStringFormatterTagBaseNXϐ́uidvL[ y[WReLXgɃtH[}bg̒lZbgꍇ̃eXgP[X (replaceSpToNbsp͖)<br>
     */
    public void testDoStartTag15() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", "BeanKey");
        UTUtil.setPrivateField(tag, "property", "testField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(true));

        String testValue = "test  TEST";

        StringFormatterTagBase_BeanStub01 bean = new StringFormatterTagBase_BeanStub01();

        bean.setTestField(testValue);

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);
        assertEquals(testValue, pc.getAttribute("id"));

    } /* testDoStartTag15 End */

    /**
     * testRelease01B<br>
     * (n)<br>
     * ϓ_FC<br>
     * ͒l id=*<br>
     * filter=false<br>
     * ignore=true<br>
     * name="name"<br>
     * property="property"<br>
     * scope="scope"<br>
     * value="value"<br>
     * replaceSpToNbsp=false<br>
     * Ғl ߂l:void<br>
     * id=Null<br>
     * filter=true<br>
     * ignore=false<br>
     * name=Null<br>
     * property=Null<br>
     * scope=Null<br>
     * value=Null<br>
     * replaceSpToNbsp=true<br>
     * OƂĐݒ肵elAsɊel邱ƂmF<br>
     */
    public void testRelease01() throws Exception {
        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));
        UTUtil.setPrivateField(tag, "name", "name");
        UTUtil.setPrivateField(tag, "property", "property");
        UTUtil.setPrivateField(tag, "scope", "scope");
        UTUtil.setPrivateField(tag, "value", "value");
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(false));

        // eXgs
        tag.release();

        // eXgʊmF
        assertNull(UTUtil.getPrivateField(tag, "id"));
        assertTrue((Boolean) UTUtil.getPrivateField(tag, "filter"));
        assertFalse((Boolean) UTUtil.getPrivateField(tag, "ignore"));
        assertNull(UTUtil.getPrivateField(tag, "name"));
        assertNull(UTUtil.getPrivateField(tag, "property"));
        assertNull(UTUtil.getPrivateField(tag, "scope"));
        assertNull(UTUtil.getPrivateField(tag, "value"));
        assertTrue((Boolean) UTUtil.getPrivateField(tag, "replaceSpToNbsp"));

    } /* testRelease01 End */

    /**
     * testSetId01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l id="id"<br>
     * Ғl ߂l:void<br>
     * id="id"<br>
     * ZbglmFeXgP[X<br>
     */
    public void testSetId01() throws Exception {
        // eXgs
        tag.setId("id");

        // eXgʊmF
        assertEquals("id", UTUtil.getPrivateField(tag, "id"));

    } /* testSetId01 End */

    /**
     * testSetFilter01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l filter=false<br>
     * Ғl ߂l:void<br>
     * filter=false<br>
     * ZbglmFeXgP[X<br>
     */
    public void testSetFilter01() throws Exception {
        // eXgs
        tag.setFilter(false);

        // eXgʊmF
        assertFalse((Boolean) UTUtil.getPrivateField(tag, "filter"));

    } /* testSetFilter01 End */

    /**
     * testSetIgnore01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l ignore=true<br>
     * Ғl ߂l:void<br>
     * ignore=true<br>
     * ZbglmFeXgP[X<br>
     */
    public void testSetIgnore01() throws Exception {
        // eXgs
        tag.setIgnore(true);

        // eXgʊmF
        assertTrue((Boolean) UTUtil.getPrivateField(tag, "ignore"));

    } /* testSetIgnore01 End */

    /**
     * testSetName01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l name="name"<br>
     * Ғl ߂l:void<br>
     * name="name"<br>
     * ZbglmFeXgP[X<br>
     */
    public void testSetName01() throws Exception {
        // eXgs
        tag.setName("name");

        // eXgʊmF
        assertEquals("name", UTUtil.getPrivateField(tag, "name"));

    } /* testSetNam01 End */

    /**
     * testSetProperty01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l property="property"<br>
     * Ғl ߂l:void<br>
     * property="property"<br>
     * ZbglmFeXgP[X<br>
     */
    public void testSetProperty01() throws Exception {
        // eXgs
        tag.setProperty("property");

        // eXgʊmF
        assertEquals("property", UTUtil.getPrivateField(tag, "property"));

    } /* testSetProperty01 End */

    /**
     * testSetScope01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l scope="scope"<br>
     * Ғl ߂l:void<br>
     * scope="scope"<br>
     * ZbglmFeXgP[X<br>
     */
    public void testSetScope01() throws Exception {
        // eXgs
        tag.setScope("scope");

        // eXgʊmF
        assertEquals("scope", UTUtil.getPrivateField(tag, "scope"));

    } /* testSetScope01 End */

    /**
     * testSetValue01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l value="value"<br>
     * Ғl ߂l:void<br>
     * value="value"<br>
     * ZbglmFeXgP[X<br>
     */
    public void testSetValue01() throws Exception {
        // eXgs
        tag.setValue("value");

        // eXgʊmF
        assertEquals("value", UTUtil.getPrivateField(tag, "value"));

    } /* testSetValue01 End */

    /**
     * testSetReplaceSpToNbsp01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l value=false<br>
     * Ғl ߂l:void<br>
     * value=false<br>
     * ZbglmFeXgP[X<br>
     */
    public void testSetReplaceSpToNbsp01() throws Exception {
        // eXgs
        tag.setReplaceSpToNbsp(false);

        assertFalse((Boolean) UTUtil.getPrivateField(tag, "replaceSpToNbsp"));
    } /* testSetReplaceSpToNbsp01 End */

    /**
     * testGetId01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l id="id"<br>
     * Ғl ߂l:String="id"<br>
     * QbglmFeXgP[X<br>
     */
    public void testGetId01() throws Exception {
        // eXgݒ
        String value = "id";
        UTUtil.setPrivateField(tag, "id", value);

        // eXgs
        String result = tag.getId();

        // eXgʊmF
        assertEquals(value, result);

    } /* testGetId01 End */

    /**
     * testGetFilter01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l filter=false<br>
     * Ғl ߂l:Boolean=false<br>
     * QbglmFeXgP[X<br>
     */
    public void testGetFilter01() throws Exception {
        // eXgݒ
        boolean value = false;
        UTUtil.setPrivateField(tag, "filter", new Boolean(value));

        // eXgs
        boolean result = tag.getFilter();

        // eXgʊmF
        assertFalse(result);

    } /* testGetFilter01 End */

    /**
     * testGetIgnore01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l ignore=true<br>
     * Ғl ߂l:Boolean=true<br>
     * QbglmFeXgP[X<br>
     */
    public void testGetIgnore01() throws Exception {
        // eXgݒ
        boolean value = true;
        UTUtil.setPrivateField(tag, "ignore", new Boolean(value));

        // eXgs
        boolean result = tag.getIgnore();

        // eXgʊmF
        assertTrue(result);

    } /* testGetIgnore01 End */

    /**
     * testGetName01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l name="name"<br>
     * Ғl ߂l:String="name"<br>
     * QbglmFeXgP[X<br>
     */
    public void testGetName01() throws Exception {
        // eXgݒ
        String value = "name";
        UTUtil.setPrivateField(tag, "name", value);

        // eXgs
        String result = tag.getName();

        // eXgʊmF
        assertEquals(value, result);

    } /* testGetName01 End */

    /**
     * testGetProperty01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l property="property"<br>
     * Ғl ߂l:String="property"<br>
     * QbglmFeXgP[X<br>
     */
    public void testGetProperty01() throws Exception {
        // eXgݒ
        String value = "property";
        UTUtil.setPrivateField(tag, "property", value);

        // eXgs
        String result = tag.getProperty();

        // eXgʊmF
        assertEquals(value, result);

    } /* testGetProperty01 End */

    /**
     * testGetScope01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l scope="scope"<br>
     * Ғl ߂l:String="scope"<br>
     * QbglmFeXgP[X<br>
     */
    public void testGetScope01() throws Exception {
        // eXgݒ
        String value = "scope";
        UTUtil.setPrivateField(tag, "scope", value);

        // eXgs
        String result = tag.getScope();

        // eXgʊmF
        assertEquals(value, result);

    } /* testGetScope01 End */

    /**
     * testGetValue01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l value="value"<br>
     * Ғl ߂l:String="value"<br>
     * QbglmFeXgP[X<br>
     */
    public void testGetValue01() throws Exception {
        // eXgݒ
        String value = "value";
        UTUtil.setPrivateField(tag, "value", value);

        // eXgs
        String result = tag.getValue();

        // eXgʊmF
        assertEquals(value, result);

    } /* testGetValue01 End */

    /**
     * testGetReplaceSpToNbsp01B<br>
     * (n)<br>
     * ϓ_FA<br>
     * ͒l value="(false);"<br>
     * Ғl ߂l:String="(false);"<br>
     * QbglmFeXgP[X<br>
     */
    public void testGetReplaceSpToNbsp01() throws Exception {
        // eXgݒ
        UTUtil.setPrivateField(tag, "replaceSpToNbsp", new Boolean(false));

        // eXgs
        boolean result = tag.getReplaceSpToNbsp();

        // eXgʊmF
        assertFalse(result);

    } /* testGetReplaceSpToNbsp01 End */

} /* StringFormatterTagBaseTest Class End */
