/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.web.codelist.ReloadableCodeListLoader;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.struts.action.ActionForward;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.ReloadCodeListAction}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * T[ubgReLXgɃLbVꂽR[hXgׂă[hB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.actions.ReloadCodeListAction
 */
@SuppressWarnings("unused")
public class ReloadCodeListActionTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ReloadCodeListActionTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testGetCodeListLoader01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() codeListLoader:ReloadCodeListActionIuWFNg<br>
     *
     * <br>
     * ҒlF(߂l) ReloadableCodeListLoader:OƓ
     * ReloadCodeListActionIuWFNg<br>
     *
     * <br>
     * ReloadCodeListActionɊi[ĂcodeListLoader𐳏Ɏ擾邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetCodeListLoader01() throws Exception {
        // O
        // ݒ
        ReloadableCodeListLoader loader = new ReloadableCodeListLoaderImpl01();

        ReloadCodeListAction action = new ReloadCodeListAction();
        UTUtil.setPrivateField(action, "codeListLoader", loader);

        // eXg{
        // 
        assertSame(loader, action.getCodeListLoader());
    }

    /**
     * testSetCodeListLoader01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() codeListLoader:ReloadableCodeListLoaderIuWFNg<br>
     *         () codeListLoader:null<br>
     *
     * <br>
     * ҒlF(ԕω) codeListLoader:Ɠ
     * ReloadableCodeListLoaderIuWFNg<br>
     *
     * <br>
     * Ɏw肵lcodeListLoaderɐɊi[邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetCodeListLoader01() throws Exception {
        // O
        // ݒ
        ReloadableCodeListLoader loader = new ReloadableCodeListLoaderImpl01();

        ReloadCodeListAction action = new ReloadCodeListAction();

        // eXg{
        action.setCodeListLoader(loader);

        // 
        assertSame(loader, UTUtil.getPrivateField(action, "codeListLoader"));
    }

    /**
     * testDoExecute01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () codeListLoader:null<br>
     *         () path:null<br>
     *
     * <br>
     * ҒlF(߂l) actionForward:null<br>
     *         (ԕω) res.sendError():ďo<br>
     *
     * <br>
     * codeListLoadernull<br>
     * mappingp[^̎擾ʂnull̏ꍇA
     * HttpServletResponse.sendError()ďoꂽnullԂƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute01() throws Exception {
        // O
        ReloadableCodeListLoader loader = null;
        ReloadCodeListAction action = new ReloadCodeListAction();
        UTUtil.setPrivateField(action, "codeListLoader", loader);

        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();

        // path : null
        String path = null;
        mapping.setParameter(path);

        ReloadCodeList_ActionFormStub01 form =
            new ReloadCodeList_ActionFormStub01();

        MockHttpServletRequest req = new MockHttpServletRequest();

        // sendErrořĂяomFp
        ReloadCodeListAction_HttpServletResponseStub01 res =
            new ReloadCodeListAction_HttpServletResponseStub01();

        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        assertNull(forward);
        assertTrue(res.isSendError);
    }

    /**
     * testDoExecute02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () codeListLoader:null<br>
     *         () path:null<br>
     *         () res.sendError():IOException<br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"error.forward.errorpage"<br>
     *                    bvOFIOException<br>
     *         (ԕω) O:O<br>
     *                    G[OF"Error page(404) forwarding failed."<br>
     *
     * <br>
     * codeListLoadernull<br>
     * mappingp[^̎擾ʂnull̏ꍇ
     * HttpServletResponse.sendError()ďoŗOꍇA
     * w肵pXɃZbVfBNgꂽmFB
     * ܂SystemException邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute02() throws Exception {
        // O
        ReloadableCodeListLoader loader = null;
        ReloadCodeListAction action = new ReloadCodeListAction();
        UTUtil.setPrivateField(action, "codeListLoader", loader);

        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();

        // path : null
        String path = null;
        mapping.setParameter(path);

        ReloadCodeList_ActionFormStub01 form =
            new ReloadCodeList_ActionFormStub01();

        MockHttpServletRequest req = new MockHttpServletRequest();

        // sendErrořĂяomFp
        ReloadCodeListAction_HttpServletResponseStub02 res =
            new ReloadCodeListAction_HttpServletResponseStub02();

        ActionForward forward = null;

        // eXg{
        try {
            forward = action.doExecute(mapping, form, req, res);
            fail();
        } catch (SystemException e) {
            // 
            // IOExceptionbv
            assertTrue(e.getCause() instanceof IOException);
            // G[OmF
            assertTrue(LogUTUtil.checkError(
                    "Error page(404) forwarding failed."));
            assertEquals("error.forward.errorpage", e.getErrorCode());
        }
    }

    /**
     * testDoExecute03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () codeListLoader:ReloadableCodeListLoaderCX^X<br>
     *         () path:"abc"<br>
     *
     * <br>
     * ҒlF(߂l) actionForward:ActionForward.getPath()F"abc"<br>
     *         (ԕω) codeListLoader.reload():ĂяomF<br>
     *
     * <br>
     * codeListLoaderReloadableCodeListLoader̃CX^Xmapping
     * p[^̎擾ʂnot null̏ꍇAcodeListLoader.reload()
     * ĂяoꂽƂƁAʑJڏ邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute03() throws Exception {
        // O
        // ݒ
        ReloadableCodeListLoaderImpl01 loader =
            new ReloadableCodeListLoaderImpl01();

        ReloadCodeListAction action = new ReloadCodeListAction();
        UTUtil.setPrivateField(action, "codeListLoader", loader);

        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();

        // path : null
        String path = "abc";
        mapping.setParameter(path);

        ReloadCodeList_ActionFormStub01 form =
            new ReloadCodeList_ActionFormStub01();

        MockHttpServletRequest req = new MockHttpServletRequest();

        // sendErrořĂяomFp
        MockHttpServletResponse res = new MockHttpServletResponse();

        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        assertEquals("abc", forward.getPath());
        ReloadableCodeListLoaderImpl01 result = (ReloadableCodeListLoaderImpl01)
        UTUtil.getPrivateField(action, "codeListLoader");
        assertTrue(result.isReload);
    }
}
