/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import jp.terasoluna.fw.exception.SystemException;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.DownloadInputStream}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * t@C_E[hf[^Ƃ邽߂̃NXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.actions.DownloadInputStream
 */
public class DownloadInputStreamTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DownloadInputStreamTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name
     *            ̃eXgP[X̖OB
     */
    public DownloadInputStreamTest(String name) {
        super(name);
    }

    /**
     * testDownloadInputStream01() <br>
     * <br>
     * 
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() name:null<br>
     * () stream:null<br>
     * 
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     * bZ[WL[F<br>
     * "errors.no.download.content"<br>
     * bvOF<br>
     * IllegalArgumentException<br>
     * 
     * <br>
     * streamnull̏ꍇAOX[邱ƂmFeXgB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadInputStream01() throws Exception {
        // O

        // eXg{
        try {
            @SuppressWarnings("unused")
            DownloadInputStream downloadInputStream = new DownloadInputStream(
                    null, null);
            fail("SystemException܂łB");
        } catch (SystemException e) {
            // 
            assertEquals("errors.no.download.content", e.getErrorCode());
            assertEquals(IllegalArgumentException.class, e.getCause()
                    .getClass());
        }
    }

    /**
     * testDownloadInputStream02() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() name:null<br>
     * () stream:ByteArrayInputStream<br>
     * 
     * <br>
     * ҒlF(ԕω) name:null<br>
     * (ԕω) stream:ByteArrayInputStream<br>
     * (ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     * (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     * 
     * <br>
     * contentType, charsetɃftHglݒ肳邱ƂmFeXgB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadInputStream02() throws Exception {
        // O
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(
                new byte[0]);

        // eXg{
        DownloadInputStream downloadInputStream = new DownloadInputStream(null,
                byteArrayInputStream);

        // 
        assertNull(downloadInputStream.name);
        assertEquals(byteArrayInputStream, downloadInputStream.stream);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE,
                downloadInputStream.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET,
                downloadInputStream.charset);

    }

    /**
     * testDownloadInputStream03() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() name:" "i󔒁j<br>
     * () stream:ByteArrayInputStream<br>
     * 
     * <br>
     * ҒlF(ԕω) name:" "i󔒁j<br>
     * (ԕω) stream:ByteArrayInputStream<br>
     * (ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     * (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     * 
     * <br>
     * ϐ󔒂̏ꍇÂ܂ܐݒ肳邱ƂmFeXg <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadInputStream03() throws Exception {
        // O
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(
                new byte[0]);

        // eXg{
        DownloadInputStream downloadInputStream = new DownloadInputStream("  ",
                byteArrayInputStream);

        // 
        assertEquals("  ", downloadInputStream.name);
        assertEquals(byteArrayInputStream, downloadInputStream.stream);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE,
                downloadInputStream.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET,
                downloadInputStream.charset);
    }

    /**
     * testDownloadInputStream04() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() name:""i󕶎j<br>
     * () stream:ByteArrayInputStream<br>
     * 
     * <br>
     * ҒlF(ԕω) name:""i󕶎j<br>
     * (ԕω) stream:ByteArrayInputStream<br>
     * (ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     * (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     * 
     * <br>
     * ϐ󕶎̏ꍇÂ܂ܐݒ肳邱ƂmFeXg <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadInputStream04() throws Exception {
        // O
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(
                new byte[0]);

        // eXg{
        DownloadInputStream downloadInputStream = new DownloadInputStream("",
                byteArrayInputStream);

        // 
        assertEquals("", downloadInputStream.name);
        assertEquals(byteArrayInputStream, downloadInputStream.stream);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE,
                downloadInputStream.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET,
                downloadInputStream.charset);
    }

    /**
     * testDownloadInputStream05() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() name:"abc"<br>
     * () stream:ByteArrayInputStream<br>
     * 
     * <br>
     * ҒlF(ԕω) name:"abc"<br>
     * (ԕω) stream:ByteArrayInputStream<br>
     * (ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     * (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     * 
     * <br>
     * ϐ̏ꍇÂ܂ܐݒ肳邱ƂmFeXg <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadInputStream05() throws Exception {
        // O
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(
                new byte[0]);

        // eXg{
        DownloadInputStream downloadInputStream = new DownloadInputStream(
                "abc", byteArrayInputStream);

        // 
        assertEquals("abc", downloadInputStream.name);
        assertEquals(byteArrayInputStream, downloadInputStream.stream);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE,
                downloadInputStream.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET,
                downloadInputStream.charset);
    }

    /**
     * testGetLengthOfData01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() stream:ByteArrayInputStream<br>
     * 
     * <br>
     * ҒlF(߂l) int:-1<br>
     * 
     * <br>
     * filẽTCYԋp邱ƂmFeXgB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetLengthOfData01() throws Exception {
        // O
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(
                new byte[0]);

        DownloadInputStream downloadInputStream = new DownloadInputStream(null,
                byteArrayInputStream);

        // eXg{
        int size = downloadInputStream.getLengthOfData();

        // 
        assertEquals(-1, size);
    }

    /**
     * testGetStreamInternal01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() file:ByteArrayInputStream<br>
     * 
     * <br>
     * ҒlF(߂l) InputStream:ByteArrayInputStream<br>
     * 
     * <br>
     * streamԋp邱ƂmFeXgB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetStreamInternal01() throws Exception {
        // O
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(
                new byte[0]);

        DownloadInputStream downloadInputStream = new DownloadInputStream(null,
                byteArrayInputStream);

        // eXg{
        InputStream inputStream = downloadInputStream.getStreamInternal();

        // 
        assertNotNull(inputStream);
        assertEquals(ByteArrayInputStream.class, inputStream.getClass());
    }

}
