/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.BLogicAction} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * t[[NŃrWlXWbNsWANVNX
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.actions.BLogicAction
 */
@SuppressWarnings("unchecked")
public class BLogicActionTest extends TestCase {
    
    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public BLogicActionTest(String name) {
        super(name);
    }

    /**
     * testSetBusinessLogic01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() businessLogic:BlogicIuWFNg<br>
     *         () businessLogic:null<br>
     *         
     * <br>
     * ҒlF(ԕω) businessLogic:ƓBlogicIuWFNg<br>
     *         
     * <br>
     * Ɏw肵lbusinessLogicɐɊi[邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetBusinessLogic01() throws Exception {
        // O
        BLogicAction action = new BLogicAction();
        UTUtil.setPrivateField(action, "businessLogic", null);
        BLogicImpl01 blogic = new BLogicImpl01();

        // eXg{
        action.setBusinessLogic(blogic);

        // 
        assertSame(blogic, UTUtil.getPrivateField(action, "businessLogic"));
    }

    /**
     * testGetBusinessLogic01()B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒l :Ȃ<br>
     *         () businessLogic:blogic<br>
     * Ғl :businessLogic:blogic<br>
     *
     * businessLogic̒l擾ł邱ƂmFB<br>
     *
     */
    public void testGetBusinessLogic01() throws Exception {
        // O
        BLogicAction action = new BLogicAction();
        BLogicImpl01 blogic = new BLogicImpl01();        
        UTUtil.setPrivateField(action, "businessLogic", blogic);

        // eXg{
        BLogic businessLogic = action.getBusinessLogic();

        // 
        assertSame(blogic, businessLogic);
    }

    /**
     * testDoExecuteBLogic01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() param:null<br>
     *         () businessLogic:not null<br>
     *         () businessLogic.execute():"businessLogic"<br>
     *         
     * <br>
     * ҒlF(߂l) BLogicResult:"businessLogic"<br>
     *         
     * <br>
     * paramnullłAbusinessLogicnot null̏ꍇA
     * businessLogic.execute\bh̎sʂԂƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecuteBLogic01() throws Exception {
        // O
        BLogicAction action = new BLogicAction();
        // execute() : "businessLogic"
        BLogicImpl02 blogic = new BLogicImpl02();
        UTUtil.setPrivateField(action, "businessLogic", blogic);
        Map param = null;

        // eXg{
        BLogicResult result = action.doExecuteBLogic(param);

        // 
        assertEquals("businessLogic", result.getResultString());
    }

    /**
     * testDoExecuteBLogic02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() param:not null<br>
     *         () businessLogic:null<br>
     *         
     * <br>
     * ҒlF(߂l) BLogicResult:null<br>
     *         
     * <br>
     * tB[hbusinessLogicnullꍇAnullԂƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecuteBLogic02() throws Exception {
        // O
        BLogicAction action = new BLogicAction();
        
        // businessLogic : null
        UTUtil.setPrivateField(action, "businessLogic", null);
        Map param = new HashMap();

        // eXg{
        BLogicResult result = action.doExecuteBLogic(param);

        // 
        assertNull(result);
    }

    /**
     * testDoExecuteBLogic03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() param:not null<br>
     *         () businessLogic:not null<br>
     *         () businessLogic.execute():null<br>
     *         
     * <br>
     * ҒlF(߂l) BLogicResult:null<br>
     *         
     * <br>
     * businessLogic.execute()̌ʂnullꍇA
     * ߂lnullł邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecuteBLogic03() throws Exception {
        // O
        BLogicAction action = new BLogicAction();
        // execute() : null
        BLogicImpl01 blogic = new BLogicImpl01();
        UTUtil.setPrivateField(action, "businessLogic", blogic);
        Map param = new HashMap();

        // eXg{
        BLogicResult result = action.doExecuteBLogic(param);

        // 
        assertNull(result);
    }

    /**
     * testDoExecuteBLogic04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() param:not null<br>
     *         () businessLogic:not null<br>
     *         () businessLogic.execute():"businessLogic"<br>
     *         
     * <br>
     * ҒlF(߂l) BLogicResult:"businessLogic"<br>
     *         
     * <br>
     * paramnot nullłAbusinessLogicnot null̏ꍇA
     * businessLogic.execute\bh̎sʂԂƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecuteBLogic04() throws Exception {
        // O
        BLogicAction action = new BLogicAction();
        // execute() : "businessLogic"
        BLogicImpl02 blogic = new BLogicImpl02();
        UTUtil.setPrivateField(action, "businessLogic", blogic);
        Map param = new HashMap();

        // eXg{
        BLogicResult result = action.doExecuteBLogic(param);

        // 
        assertEquals("businessLogic", result.getResultString());
    }
}
