/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;

/**
 * {@link jp.terasoluna.fw.web.struts.action.GlobalMessageResources} 
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ƖʁAVXẽbZ[W\[X𐶐NXB
 * privateȃRXgN^Ȃ߁AeXgΏۃX^X̐getInstance()pĂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.action.GlobalMessageResources
 */
@SuppressWarnings("unchecked")
public class GlobalMessageResourcesTest extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(GlobalMessageResourcesTest.class);
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public GlobalMessageResourcesTest(String name) {
        super(name);
    }

    /**
     * testGetInstance01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() globalMessageResources:null<br>
     *         
     * <br>
     * ҒlF(߂l) GlobalMessageResources:not null<br>
     *         (ԕω) globalMessageResources:ԂꂽlƓ̃CX^X<br>
     *         
     * <br>
     * \bhĂяoƂŃtB[hɖ߂lƓl
     * ݒ肳Ă邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetInstance01() throws Exception {
        // O
        // VOgCX^Xnullݒ
        UTUtil.setPrivateField(GlobalMessageResources.class,
                               "globalMessageResources", null);
            
        // eXg{
        Object result = 
            GlobalMessageResources.getInstance();
        
        // 
        assertEquals(GlobalMessageResources.class.getName(),
                     result.getClass().getName());
        assertSame(result, UTUtil.getPrivateField(GlobalMessageResources.class,
            "globalMessageResources"));
    }

    /**
     * testGetInstance02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() globalMessageResources:not null<br>
     *         
     * <br>
     * ҒlF(߂l) GlobalMessageResources:OƓ̃CX^X<br>
     *         (ԕω) globalMessageResources:OƓ̃CX^X<br>
     *         
     * <br>
     * tB[hɐݒ肳ĂCX^XƓ̃CX^X
     * Ԃ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetInstance02() throws Exception {
        // O
        Object prepare = GlobalMessageResources.getInstance();
        UTUtil.setPrivateField(GlobalMessageResources.class,
                "globalMessageResources", prepare);

        // eXg{
        Object result = 
            GlobalMessageResources.getInstance();

        // 
        assertSame(prepare, result);
    }

    /**
     * testGlobalInit01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:"aaaaa"<br>
     *                i݂Ȃt@Cj<br>
     *         () fwMessages:["key"->"value"]<br>
     *         
     * <br>
     * ҒlF(ԕω) fwMessages:Map<br>
     *         
     * <br>
     * vpeBɎ擾łȂꍇAVXẽbZ[W
     * NAAɂȂĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGlobalInit01() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();
        UTUtil.setPrivateField(resources, "config", "aaaaa");
        
        Map fwMap = new HashMap();
        fwMap.put("key", "value");
        UTUtil.setPrivateField(resources, "fwMessages", fwMap);
        
        // eXg{
        UTUtil.invokePrivate(resources, "globalInit");
        
        // 
        Map resultMap = (Map) UTUtil.getPrivateField(resources, "fwMessages");
        assertTrue(resultMap.isEmpty());
    }

    /**
     * testGlobalInit02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:"GlobalMessageResources_system-messages01"<br>
     *                ĩt@Cj<br>
     *         () fwMessages:Map<br>
     *         
     * <br>
     * ҒlF(ԕω) fwMessages:Map<br>
     *         
     * <br>
     * vpeBt@CŐݒ肳ꂽvpeB0̎A
     * VXẽbZ[Wł邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGlobalInit02() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();
        // config0vpeBt@Cݒ
        UTUtil.setPrivateField(resources, "config",
                GlobalMessageResources.class.getPackage().getName().replace(
                        '.', '/')
                        + "/GlobalMessageResources_system-messages01");
        UTUtil.setPrivateField(resources, "fwMessages", new HashMap());
        
        // eXg{
        UTUtil.invokePrivate(resources, "globalInit");
        
        // 
        // VXebZ[W0ł邱ƁB
        Map resultMap = (Map) UTUtil.getPrivateField(resources, "fwMessages");
        assertTrue(resultMap.isEmpty());
    }

    /**
     * testGlobalInit03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:"GlobalMessageResources_system-messages02"<br>
     *                yt@C̓ez<br>
     *                test.fw.message.01=eveXgbZ[WOP<br>
     *         () fwMessages:Map<br>
     *         
     * <br>
     * ҒlF(ԕω) fwMessages:["test.fw.messages.01"->"eveXgbZ[WOP"]<br>
     *         
     * <br>
     * vpeBt@CŐݒ肳ꂽvpeB1̎A
     * VXẽbZ[Wݒ肳Ă邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGlobalInit03() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();
        // config1vpeBt@Cݒ
        UTUtil.setPrivateField(resources, "config",
                GlobalMessageResources.class.getPackage().getName().replace(
                        '.', '/')
                        + "/GlobalMessageResources_system-messages02");
        UTUtil.setPrivateField(resources, "fwMessages", new HashMap());
        
        // eXg{
        UTUtil.invokePrivate(resources, "globalInit");
        
        // 
        // VXebZ[W1ł邱ƁB
        Map resultMap = (Map) UTUtil.getPrivateField(resources, "fwMessages");
        assertEquals(1, resultMap.size());
        assertEquals("eveXgbZ[WOP",
                     resultMap.get("test.fw.message.01"));
    }

    /**
     * testGlobalInit04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:"GlobalMessageResources_system-messages03"<br>
     *                yt@C̓ez<br>
     *                test.fw.message.01=eveXgbZ[WOP<br>
     *                test.fw.message.02=eveXgbZ[WOQ<br>
     *                test.fw.message.03=eveXgbZ[WOR<br>
     *         () fwMessages:Map<br>
     *         
     * <br>
     * ҒlF(ԕω) fwMessages:["test.fw.messages.01"->"eveXgbZ[WOP"]<br>
     *                    ["test.fw.messages.02"->"eveXgbZ[WOQ"]<br>
     *                    ["test.fw.messages.03"->"eveXgbZ[WOR"]<br>
     *         
     * <br>
     * vpeBt@CŐݒ肳ꂽvpeB3̎A
     * VXẽbZ[Wݒ肳Ă邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGlobalInit04() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();
        // config3vpeBt@Cݒ
        UTUtil.setPrivateField(resources, "config",
                GlobalMessageResources.class.getPackage().getName().replace(
                        '.', '/')
                        + "/GlobalMessageResources_system-messages03");
        UTUtil.setPrivateField(resources, "fwMessages", new HashMap());
        
        // eXg{
        UTUtil.invokePrivate(resources, "globalInit");
        
        // 
        // VXebZ[W3ł邱ƁB
        Map resultMap = (Map) UTUtil.getPrivateField(resources, "fwMessages");
        assertEquals(3, resultMap.size());

        assertEquals("eveXgbZ[WOP", resultMap.get("test.fw.message.01"));
        assertEquals("eveXgbZ[WOQ", resultMap.get("test.fw.message.02"));
        assertEquals("eveXgbZ[WOR", resultMap.get("test.fw.message.03"));
    }

    /**
     * testApplicationInit01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() PropertyUtil.getProperty("application.messages"):null<br>
     *         () ƖʃbZ[W\[X`t@Ciapplication-messages.propertiesj:test.gb.message.01=faeXgbZ[WOP<br>
     *         () globalMessages:Map<br>
     *         
     * <br>
     * ҒlF(ԕω) globalMessages:["test.gb.message.01"->"faeXgbZ[WOP"]<br>
     *         
     * <br>
     * PropertyUtil.getProperty("application.messages")null̎A
     * application-messages.properties[hA[g̋ƖʃbZ[WƂĐݒ肳邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testApplicationInit01() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();
        deleteProperty("application.messages");
        UTUtil.setPrivateField(resources, "globalMessages", new HashMap());
        
        // eXg{
        UTUtil.invokePrivate(resources, "applicationInit");

        // 
        // application-resources.properties[hA
        // app.resource=\[X 擾ł邱ƁB
        Map appMap = (Map) UTUtil.getPrivateField(resources, "globalMessages");
        assertEquals("faeXgbZ[WOP", appMap.get("test.gb.message.01"));
    }

    /**
     * testApplicationInit02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() PropertyUtil.getProperty("application.messages"):"GlobalMessageResources_application-messages01"<br>
     *         () ƖʃbZ[W\[X`t@Ciapplication-messages.propertiesj:test.gb.message.01=faeXgbZ[WOP<br>
     *                test.gb.message.02=faeXgbZ[WOQ<br>
     *                test.gb.message.03=faeXgbZ[WOR<br>
     *         () globalMessages:Map<br>
     *         
     * <br>
     * ҒlF(ԕω) globalMessages:["test.gb.message.01"->"faeXgbZ[WOP"]<br>
     *                    ["test.gb.message.02"->"faeXgbZ[WOQ"]<br>
     *                    ["test.gb.message.03"->"faeXgbZ[WOR"]<br>
     *         
     * <br>
     * application.messagesL["GlobalMessageResources_application-messages01"
     * ̎Aapplication-messages01.properties[hA
     * ƖʃbZ[WƂĐݒ肳邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testApplicationInit02() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();

        // vpeBB
        deleteProperty("application.messages");
        addProperty("application.messages", 
                    "jp/terasoluna/fw/web/struts/action/GlobalMessageResources_application-messages01");
        UTUtil.setPrivateField(resources, "globalMessages", new HashMap());
        
        // eXg{
        UTUtil.invokePrivate(resources, "applicationInit");

        // 
        Map appMap = (Map) UTUtil
            .getPrivateField(resources, "globalMessages");
        assertEquals("faeXgbZ[WOP", appMap.get("test.gb.message.01"));
        assertEquals("faeXgbZ[WOQ", appMap.get("test.gb.message.02"));
        assertEquals("faeXgbZ[WOR", appMap.get("test.gb.message.03"));
    }

    /**
     * testApplicationInit03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() PropertyUtil.getProperty("application.messages"):"aaaaa"<br>
     *         () globalMessages:["test.gb.message.01"->"̂faeXgbZ[WOP"]<br>
     *                ["test.gb.message.02"->"̂faeXgbZ[WOQ"]<br>
     *                ["test.gb.message.03"->"̂faeXgbZ[WOR"]<br>
     *         
     * <br>
     * ҒlF(ԕω) globalMessages:["test.gb.message.01"->"̂faeXgbZ[WOP"]<br>
     *                    ["test.gb.message.02"->"̂faeXgbZ[WOQ"]<br>
     *                    ["test.gb.message.03"->"̂faeXgbZ[WOR"]<br>
     *         
     * <br>
     * application.messagesL[œo^Ăl݂Ȃt@C̎A
     * ƖʃbZ[W͓o^ꂸA܂ANAȂƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testApplicationInit03() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();

        // vpeBB
        deleteProperty("application.messages");
        addProperty("application.messages", "jp/terasoluna/fw/web/struts/action/aaaaa");
        
        // ̋ƖʃbZ[Wݒ
        Map defaultMap = new HashMap();
        defaultMap.put("test.gb.message.01", "̂faeXgbZ[WOP");
        defaultMap.put("test.gb.message.02", "̂faeXgbZ[WOQ");
        defaultMap.put("test.gb.message.03", "̂faeXgbZ[WOR");
        
        UTUtil.setPrivateField(resources, "globalMessages", defaultMap);
        
        // eXg{
        UTUtil.invokePrivate(resources, "applicationInit");

        // 
        Map appMap = (Map) UTUtil
            .getPrivateField(resources, "globalMessages");
        assertSame(defaultMap, appMap);
        assertEquals(3, appMap.size());
        assertEquals("̂faeXgbZ[WOP", appMap.get("test.gb.message.01"));
        assertEquals("̂faeXgbZ[WOQ", appMap.get("test.gb.message.02"));
        assertEquals("̂faeXgbZ[WOR", appMap.get("test.gb.message.03"));
    }

    /**
     * testApplicationInit04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() PropertyUtil.getProperty("application.messages"):"GlobalMessageResources_application-messages02"<br>
     *         () ƖʃbZ[W\[X`t@Ciapplication-messages.propertiesj:̃t@C<br>
     *         () globalMessages:["test.gb.message.01"->"̂faeXgbZ[WOP"]<br>
     *                ["test.gb.message.02"->"̂faeXgbZ[WOQ"]<br>
     *                ["test.gb.message.03"->"̂faeXgbZ[WOR"]<br>
     *         
     * <br>
     * ҒlF(ԕω) globalMessages:Map<br>
     *         
     * <br>
     * 0̃bZ[Wi[ꂽvpeBt@Cw肵A
     * ̃bZ[ẂA0̃bZ[Wŏ㏑邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testApplicationInit04() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();

        // vpeBB
        deleteProperty("application.messages");
        addProperty("application.messages", 
                    "jp/terasoluna/fw/web/struts/action/GlobalMessageResources_application-messages02");
        
        // ̋ƖʃbZ[Wݒ
        Map defaultMap = new HashMap();
        defaultMap.put("test.gb.message.01", "̂faeXgbZ[WOP");
        defaultMap.put("test.gb.message.02", "̂faeXgbZ[WOQ");
        defaultMap.put("test.gb.message.03", "̂faeXgbZ[WOR");
        UTUtil.setPrivateField(resources, "globalMessages", defaultMap);
        
        // eXg{
        UTUtil.invokePrivate(resources, "applicationInit");

        // 
        Map appMap = (Map) UTUtil.getPrivateField(resources, "globalMessages");
        assertTrue(appMap.isEmpty());
    }

    /**
     * testApplicationInit05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() PropertyUtil.getProperty("application.messages"):"GlobalMessageResources_application-messages01"<br>
     *         () ƖʃbZ[W\[X`t@Ciapplication-messages.propertiesj:test.gb.message.01=faeXgbZ[WOP<br>
     *                test.gb.message.02=faeXgbZ[WOQ<br>
     *                test.gb.message.03=faeXgbZ[WOR<br>
     *         () globalMessages:["test.gb.message.01"->"̂faeXgbZ[WOP"]<br>
     *         
     * <br>
     * ҒlF(ԕω) globalMessages:["test.gb.message.01"->"faeXgbZ[WOP"]<br>
     *                    ["test.gb.message.02"->"faeXgbZ[WOQ"]<br>
     *                    ["test.gb.message.03"->"faeXgbZ[WOR"]<br>
     *         
     * <br>
     * 3̃bZ[Wi[ꂽvpeBt@Cw肵A
     * ̃bZ[ẂA3̃bZ[Wŏ㏑邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testApplicationInit05() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();

        // vpeBB
        deleteProperty("application.messages");
        addProperty("application.messages", 
                    "jp/terasoluna/fw/web/struts/action/GlobalMessageResources_application-messages01");
        
        // ̋ƖʃbZ[Wݒ
        Map defaultMap = new HashMap();
        defaultMap.put("test.gb.message.01", "̂faeXgbZ[WOP");
        UTUtil.setPrivateField(resources, "globalMessages", defaultMap);
        
        // eXg{
        UTUtil.invokePrivate(resources, "applicationInit");

        // 
        Map appMap = (Map) UTUtil
            .getPrivateField(resources, "globalMessages");
        assertEquals(3, appMap.size());
        
        assertEquals("faeXgbZ[WOP", appMap.get("test.gb.message.01"));
        assertEquals("faeXgbZ[WOQ", appMap.get("test.gb.message.02"));
        assertEquals("faeXgbZ[WOR", appMap.get("test.gb.message.03"));
    }

    /**
     * testApplicationInit06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() PropertyUtil.getProperty("application.messages"):"GlobalMessageResources_application-messages04"<br>
     *         () ƖʃbZ[W\[X`t@Ciapplication-messages.propertiesj:test.gb.message.01=faeXgbZ[WOP<br>
     *                add.message.file.1=GlobalMessageResources_application-messages04_add<br>
     *         () ǉp̋ƖʃbZ[W\[X`t@C:test.gb.message.addition=ǉpfaeXgbZ[WOP<br>
     *         () globalMessages:["test.gb.message.01"->"̂faeXgbZ[WOP"]<br>
     *         
     * <br>
     * ҒlF(ԕω) globalMessages:["test.gb.message.01"->"faeXgbZ[WOP"]<br>
     *                    ["test.gb.message.addition"->"ǉpfaeXgbZ[WOP"]<br>
     *         
     * <br>
     * Ɩʂ̃[gvpeBt@CA1̃bZ[Wt@C
     * ĂяoĂAL[Փ˂ĂȂꍇ́A
     * 2̃bZ[Wo^邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testApplicationInit06() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();

        // vpeBB
        deleteProperty("application.messages");
        addProperty("application.messages", 
                    "jp/terasoluna/fw/web/struts/action/GlobalMessageResources_application-messages04");
        
        // ̋ƖʃbZ[Wݒ
        Map defaultMap = new HashMap();
        defaultMap.put("test.gb.message.01", "̂faeXgbZ[WOP");
        UTUtil.setPrivateField(resources, "globalMessages", defaultMap);
        
        // eXg{
        UTUtil.invokePrivate(resources, "applicationInit");

        // 
        Map appMap = (Map) UTUtil
            .getPrivateField(resources, "globalMessages");
        assertEquals(2, appMap.size());
        
        assertEquals("faeXgbZ[WOP", appMap.get("test.gb.message.01"));
        assertEquals("ǉpfaeXgbZ[WOP", appMap.get("test.gb.message.addition"));
    }

    /**
     * testApplicationInit07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() PropertyUtil.getProperty("application.messages"):"GlobalMessageResources_application-messages05"<br>
     *         () ƖʃbZ[W\[X`t@Ciapplication-messages.propertiesj:test.gb.message.01=faeXgbZ[WOP<br>
     *                add.message.file.1=GlobalMessageResources_application-messages05_add<br>
     *         () ǉp̋ƖʃbZ[W\[X`t@C:test.gb.message.01=ǉpfaeXgbZ[WOP<br>
     *         () globalMessages:["test.gb.message.01"->"̂faeXgbZ[WOP"]<br>
     *         
     * <br>
     * ҒlF(ԕω) globalMessages:["test.gb.message.01"->"faeXgbZ[WOP"]<br>
     *         
     * <br>
     * Ɩʂ̃[gvpeBt@CA1̃bZ[Wt@C
     * ĂяoĂAL[Փ˂Ăꍇ́A[g̃bZ[W
     * ̗p邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testApplicationInit07() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();

        // vpeBB
        deleteProperty("application.messages");
        addProperty("application.messages", 
                    "jp/terasoluna/fw/web/struts/action/GlobalMessageResources_application-messages05");
        
        // ̋ƖʃbZ[Wݒ
        Map defaultMap = new HashMap();
        defaultMap.put("test.gb.message.01", "̂faeXgbZ[WOP");
        UTUtil.setPrivateField(resources, "globalMessages", defaultMap);
        
        // eXg{
        UTUtil.invokePrivate(resources, "applicationInit");

        // 
        // 1̃vpeBŊ̋ƖʃbZ[W\[XXV邱ƁB
        Map appMap = (Map) UTUtil
            .getPrivateField(resources, "globalMessages");
        assertEquals(1, appMap.size());
        assertEquals("faeXgbZ[WOP", 
                     appMap.get("test.gb.message.01"));
    }

    /**
     * testApplicationInit08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() PropertyUtil.getProperty("application.messages"):"GlobalMessageResources_application-messages06"<br>
     *         () ƖʃbZ[W\[X`t@Ciapplication-messages.propertiesj:test.gb.message.01=faeXgbZ[WOP<br>
     *                add.message.file.1=GlobalMessageResources_application-messages06<br>
     *         () ǉp̋ƖʃbZ[W\[X`t@C:Ɠ̃t@Ĉߏȗ<br>
     *         () globalMessages:["test.gb.message.01"->"̂faeXgbZ[WOP"]<br>
     *         
     * <br>
     * ҒlF(ԕω) globalMessages:["test.gb.message.01"->"faeXgbZ[WOP"]<br>
     *         
     * <br>
     * Ɩʂ̃[gvpeBt@CA[gvpeBt@Cg
     * ĂяoĂꍇ́Aǂݔ΂邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testApplicationInit08() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();

        // vpeBB
        deleteProperty("application.messages");
        addProperty("application.messages", 
                    "jp/terasoluna/fw/web/struts/action/GlobalMessageResources_application-messages06");

        // ̋ƖʃbZ[Wݒ
        Map defaultMap = new HashMap();
        defaultMap.put("test.gb.message.01", "̂faeXgbZ[WOP");
        UTUtil.setPrivateField(resources, "globalMessages", defaultMap);
        
        // eXg{
        UTUtil.invokePrivate(resources, "applicationInit");

        // 
        Map appMap = (Map) UTUtil
            .getPrivateField(resources, "globalMessages");
        assertEquals(1, appMap.size());
        assertEquals("faeXgbZ[WOP", 
                     appMap.get("test.gb.message.01"));
    }

    /**
     * testApplicationInit09()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() PropertyUtil.getProperty("application.messages"):"GlobalMessageResources_application-messages07"<br>
     *         () ƖʃbZ[W\[X`t@Ciapplication-messages.propertiesj:test.gb.message.01=faeXgbZ[WOP<br>
     *                test.gb.message.02=faeXgbZ[WOQ<br>
     *                test.gb.message.03=faeXgbZ[WOR<br>
     *                add.message.file.1=GlobalMessageResources_application-messages07_add1<br>
     *                add.message.file.2=GlobalMessageResources_application-messages07_add2<br>
     *                add.message.file.3=GlobalMessageResources_application-messages07_add3<br>
     *         () ǉp̋ƖʃbZ[W\[X`t@C:yGlobalMessageResources_application-messages07_add1z<br>
     *                test.gb.message.addition.01=ǉpfaeXgbZ[WOP<br>
     *                yGlobalMessageResources_application-messages07_add2z<br>
     *                test.gb.message.addition.02=ǉpfaeXgbZ[WOQ<br>
     *                yGlobalMessageResources_application-messages07_add3z<br>
     *                test.gb.message.addition.03=ǉpfaeXgbZ[WOR<br>
     *                test.gb.message.addition.04=ǉpfaeXgbZ[WOS<br>
     *         () globalMessages:["test.gb.message.01"->"̂faeXgbZ[WOP"]<br>
     *         
     * <br>
     * ҒlF(ԕω) globalMessages:test.gb.message.01=faeXgbZ[WOP<br>
     *                    test.gb.message.02=faeXgbZ[WOQ<br>
     *                    test.gb.message.03=faeXgbZ[WOR<br>
     *                    test.gb.message.addition.01=ǉpfaeXgbZ[WOP<br>
     *                    test.gb.message.addition.02=ǉpfaeXgbZ[WOQ<br>
     *                    test.gb.message.addition.03=ǉpfaeXgbZ[WOR<br>
     *                    test.gb.message.addition.04=ǉpfaeXgbZ[WOS<br>
     *         
     * <br>
     * ̊Ot@CÃ[gbZ[Wv7擾邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testApplicationInit09() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();

        // vpeBB
        deleteProperty("application.messages");
        addProperty("application.messages", 
                    "jp/terasoluna/fw/web/struts/action/GlobalMessageResources_application-messages07");

        // ̋ƖʃbZ[Wݒ
        Map defaultMap = new HashMap();
        defaultMap.put("test.gb.message.01", "̂faeXgbZ[WOP");
        UTUtil.setPrivateField(resources, "globalMessages", defaultMap);
        
        // eXg{
        UTUtil.invokePrivate(resources, "applicationInit");

        // 
        Map appMap = (Map) UTUtil.getPrivateField(resources, "globalMessages");
        assertEquals(7, appMap.size());

        assertEquals("faeXgbZ[WOP", appMap.get("test.gb.message.01"));
        assertEquals("faeXgbZ[WOQ", appMap.get("test.gb.message.02"));
        assertEquals("faeXgbZ[WOR", appMap.get("test.gb.message.03"));
        assertEquals("ǉpfaeXgbZ[WOP", appMap.get("test.gb.message.addition.01"));
        assertEquals("ǉpfaeXgbZ[WOQ", appMap.get("test.gb.message.addition.02"));
        assertEquals("ǉpfaeXgbZ[WOR", appMap.get("test.gb.message.addition.03"));
        assertEquals("ǉpfaeXgbZ[WOS", appMap.get("test.gb.message.addition.04"));
    }

    /**
     * testApplicationInit10()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() PropertyUtil.getProperty("application.messages"):"GlobalMessageResources_application-messages03"<br>
     *         () ƖʃbZ[W\[X`t@Ciapplication-messages.propertiesj:test.gb.message.01=faeXgbZ[WOP<br>
     *                add.message.file.1=aaaaa<br>
     *         () ǉp̋ƖʃbZ[W\[X`t@C:݂Ȃ<br>
     *         () globalMessages:["test.gb.message.01"->"̂faeXgbZ[WOP"]<br>
     *         
     * <br>
     * ҒlF(ԕω) globalMessages:["test.gb.message.01"="faeXgbZ[WOP"]<br>
     *         (ԕω) O:yxOz<br>
     *                    bZ[W<br>
     *                    "aaaaa" is illegal."<br>
     *         
     * <br>
     * ǉp̃t@CsꍇAxOoA
     * ̂ق̋ƖʃbZ[W\[X`t@C
     * iapplication-messages.propertiesjɐݒ肳Ă郁bZ[W\[X
     * ɐݒ肳Ă邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testApplicationInit10() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();

        // vpeBB
        deleteProperty("application.messages");
        addProperty("application.messages", 
                    "jp/terasoluna/fw/web/struts/action/GlobalMessageResources_application-messages03");

        // ̋ƖʃbZ[Wݒ
        Map defaultMap = new HashMap();
        defaultMap.put("test.gb.message.01", "̂faeXgbZ[WOP");
        UTUtil.setPrivateField(resources, "globalMessages", defaultMap);
        
        // eXg{
        UTUtil.invokePrivate(resources, "applicationInit");

        // 
        Map appMap = (Map) UTUtil.getPrivateField(resources, "globalMessages");
        assertEquals(1, appMap.size());
        assertEquals("faeXgbZ[WOP", appMap.get("test.gb.message.01"));
        assertTrue(LogUTUtil.checkWarn("\"aaaaa\" is illegal."));
    }

    /**
     * testGetMessage01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() key:"message"<br>
     *         () fwMessages:Map<br>
     *         () globalMessages:Map<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         
     * <br>
     * VXẽbZ[WAƖʃbZ[WɋMap̎A
     * nullԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage01() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();
        // VXebZ[Wݒ
        UTUtil.setPrivateField(resources, "fwMessages", new HashMap());
        // ƖʃbZ[Wݒ
        UTUtil.setPrivateField(resources, "globalMessages", new HashMap());

        // eXg{
        // 
        Locale locale = null;
        assertNull(resources.getMessage(locale, "message"));
    }

    /**
     * testGetMessage02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"message.fw"<br>
     *         () fwMessages:["message.fw"->"evbZ[W"]<br>
     *         () globalMessages:["message.gb"->"ƖbZ[W"]<br>
     *         
     * <br>
     * ҒlF(߂l) String:"evbZ[W"<br>
     *         
     * <br>
     * VXebZ[WɊY郁bZ[W݂鎞A
     * bZ[Wԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage02() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();
        // VXebZ[Wݒ
        Map fwMessagesMap = new HashMap();
        fwMessagesMap.put("message.fw", "evbZ[W");
        UTUtil.setPrivateField(resources, "fwMessages", fwMessagesMap);

        // ƖʃbZ[Wݒ
        Map globalMessageMap = new HashMap();
        fwMessagesMap.put("message.gb", "ƖbZ[W");
        UTUtil.setPrivateField(resources, "globalMessages", globalMessageMap);

        // eXg{
        String result = resources.getMessage(Locale.getDefault(), "message.fw");

        // 
        // VXebZ[W擾Ă邱
        assertEquals("evbZ[W", result);
    }

    /**
     * testGetMessage03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"message.gb"<br>
     *         () fwMessages:["message.fw"->"evbZ[W"]<br>
     *         () globalMessages:["message.gb"->"ƖbZ[W"]<br>
     *         
     * <br>
     * ҒlF(߂l) String:"ƖbZ[W"<br>
     *         
     * <br>
     * ƖbZ[WɊY郁bZ[W݂鎞A
     * bZ[Wԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage03() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();
        // VXebZ[Wݒ
        Map fwMessagesMap = new HashMap();
        fwMessagesMap.put("message.fw", "evbZ[W");
        UTUtil.setPrivateField(resources, "fwMessages", fwMessagesMap);

        // ƖʃbZ[Wݒ
        Map globalMessageMap = new HashMap();
        globalMessageMap.put("message.gb", "ƖbZ[W");
        UTUtil.setPrivateField(resources, "globalMessages", globalMessageMap);

        // eXg{
        Locale locale = null;
        String result = resources.getMessage(locale, "message.gb");

        // 
        // ƖbZ[W擾Ă邱
        assertEquals("ƖbZ[W", result);
    }

    /**
     * testGetMessage04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"message"<br>
     *         () fwMessages:["message"->"evbZ[W"]<br>
     *         () globalMessages:["message"->"ƖbZ[W"]<br>
     *         
     * <br>
     * ҒlF(߂l) String:"ƖbZ[W"<br>
     *         
     * <br>
     * w肳ꂽbZ[WL[AVXeƋƖʂ̑oɑ݂鎞A
     * ƖbZ[Wԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage04() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();
        // VXebZ[Wݒ
        Map fwMessagesMap = new HashMap();
        fwMessagesMap.put("message", "evbZ[W");
        UTUtil.setPrivateField(resources, "fwMessages", fwMessagesMap);

        // ƖʃbZ[Wݒ
        Map globalMessageMap = new HashMap();
        fwMessagesMap.put("message", "ƖbZ[W");
        UTUtil.setPrivateField(resources, "globalMessages", globalMessageMap);

        // eXg{
        Locale locale = null;
        String result = resources.getMessage(locale, "message");

        // 
        // ƖbZ[W擾Ă邱
        assertEquals("ƖbZ[W", result);
    }

    /**
     * testGetMessage05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() key:null<br>
     *         () fwMessages:["message.fw"->"evbZ[W"]<br>
     *         () globalMessages:["message.gb"->"ƖbZ[W"]<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         
     * <br>
     * w肳ꂽbZ[WL[null̎Anullԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage05() throws Exception {
        // O
        GlobalMessageResources resources = GlobalMessageResources.getInstance();
        // VXebZ[Wݒ
        Map fwMessagesMap = new HashMap();
        fwMessagesMap.put("message.fw", "evbZ[W");
        UTUtil.setPrivateField(resources, "fwMessages", fwMessagesMap);

        // ƖʃbZ[Wݒ
        Map globalMessageMap = new HashMap();
        globalMessageMap.put("message.gb", "ƖbZ[W");
        UTUtil.setPrivateField(resources, "globalMessages", globalMessageMap);

        // eXg{
        // 
        Locale locale = null;
        assertNull(resources.getMessage(locale, null));
    }

    /**
     * VOgCX^XԂɂB
     * 
     */
    @Override
    protected void setUpData() throws Exception {

        UTUtil.setPrivateField(GlobalMessageResources.class,
                               "globalMessageResources",
                               null);
        
    }

    /**
     * VOgCX^XԂɖ߂B
     */
    @Override
    protected void cleanUpData() throws Exception {

        UTUtil.setPrivateField(GlobalMessageResources.class,
                "globalMessageResources",
                null);
        
    }

}
