/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.codelist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.codelist.MappedCodeListLoader} NX
 * ̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * R[hXg̏MapōsA
 * jp.terasoluna.fw.web.codelist.CodeListLoaderNXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.codelist.MappedCodeListLoader
 */
public class MappedCodeListLoaderTest extends TestCase {

    /**
     * eXgΏہB
     */
    private MappedCodeListLoader test = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(MappedCodeListLoaderTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        test = new MappedCodeListLoader();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public MappedCodeListLoaderTest(String name) {
        super(name);
    }

    /**
     * testGetCodeListMap01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() codeListMap:not null<br>
     *
     * <br>
     * ҒlF(߂l) Map:CX^XϐcodeListMap<br>
     *
     * <br>
     * CX^XϐcodeListMap擾ł邱ƂmFB<br>
     * n1̂݊mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetCodeListMap01() throws Exception {
        // O
        Map map = new HashMap();
        UTUtil.setPrivateField(test, "codeListMap", map);

        // eXg{
        Object result = test.getCodeListMap();

        // 
        assertSame(map, result);
    }

    /**
     * testSetCodeListMap01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() codeListMap:not null<br>
     *         () codeListMap:null<br>
     *
     * <br>
     * ҒlF(ԕω) codeListMap:not nulliɎw肵Mapj<br>
     *
     * <br>
     * Ɏw肵MapCX^XϐcodeListMapɐݒ肳邱ƂmFB<br>
     * n1̂݊mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetCodeListMap01() throws Exception {
        // O
        UTUtil.setPrivateField(test, "codeListMap", null);

        // eXg{
        Map<String, String> map = new HashMap<String, String>();
        test.setCodeListMap(map);

        // 
        Object result = UTUtil.getPrivateField(test, "codeListMap");
        assertSame(map, result);
    }

    /**
     * testLoad01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() codeLists:not null<br>
     *
     * <br>
     * ҒlF(ԕω) codeLists:ωȂ<br>
     *
     * <br>
     * CX^XϐcodeListsnot null̏ꍇAsꂸI邱ƂmFBcodeListsϐɕωȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLoad01() throws Exception {
        // O
        CodeBean cb = new CodeBean();
        cb.setId("id");
        cb.setName("name");
        List<CodeBean> list = new ArrayList<CodeBean>();
        list.add(cb);
        UTUtil.setPrivateField(test, "codeLists", list);

        // eXg{
        test.load();

        // 
        List codeLists = (List) UTUtil.getPrivateField(test, "codeLists");
        assertSame(list, codeLists);
        assertEquals(1, codeLists.size());
        CodeBean codebean = (CodeBean) codeLists.get(0);
        assertEquals("id", codebean.getId());
        assertEquals("name", codebean.getName());
    }

    /**
     * testLoad02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () codeListMap:null<br>
     *
     * <br>
     * ҒlF(ԕω) codeLists:vf0List<br>
     *
     * <br>
     * codeListMapnull̏ꍇAcodeListsvf0ListƂĐݒ肳邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLoad02() throws Exception {
        // O
        UTUtil.setPrivateField(test, "codeLists", null);
        UTUtil.setPrivateField(test, "codeListMap", null);

        // eXg{
        test.load();

        // 
        List result = (List) UTUtil.getPrivateField(test, "codeLists");
        assertTrue(result.isEmpty());
    }

    /**
     * testLoad03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () codeListMap:vf0Map<br>
     *
     * <br>
     * ҒlF(ԕω) codeLists:vf0List<br>
     *
     * <br>
     * codeListMap̗vf̏ꍇAcodeListsvf0ListƂĐݒ肳邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLoad03() throws Exception {
        // O
        UTUtil.setPrivateField(test, "codeLists", null);
        Map<String, String> map = new HashMap<String, String>();
        UTUtil.setPrivateField(test, "codeListMap", map);

        // eXg{
        test.load();

        // 
        List result = (List) UTUtil.getPrivateField(test, "codeLists");
        assertTrue(result.isEmpty());
    }

    /**
     * testLoad04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () codeListMap:vf1Map<br>
     *                {"id","name"}<br>
     *
     * <br>
     * ҒlF(ԕω) codeLists:vf1List<br>
     *                    CodeBean{"id","name"}<br>
     *
     * <br>
     * codeListMap1̗vfꍇAMap̓ecodeLists邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLoad04() throws Exception {
        // O
        UTUtil.setPrivateField(test, "codeLists", null);
        Map<String, String> map = new HashMap<String, String>();
        map.put("id", "name");
        UTUtil.setPrivateField(test, "codeListMap", map);

        // eXg{
        test.load();

        // 
        List result = (List) UTUtil.getPrivateField(test, "codeLists");
        assertEquals(1, result.size());
        CodeBean codebean = (CodeBean) result.get(0);
        assertEquals("id", codebean.getId());
        assertEquals("name", codebean.getName());
    }

    /**
     * testLoad05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() codeLists:null<br>
     *         () codeListMap:vf3Map<br>
     *                {"id1","name1"},<br>
     *                {"id2","name2"},<br>
     *                {"id3","name3"}<br>
     *
     * <br>
     * ҒlF(ԕω) codeLists:vf1List<br>
     *                    CodeBean{"id1","name1"},<br>
     *                    CodeBean{"id2","name2"},<br>
     *                    CodeBean{"id3","name3"},<br>
     *
     * <br>
     * codeListMapɕ̗vfꍇAMap̓ecodeLists邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLoad05() throws Exception {
        // O
        UTUtil.setPrivateField(test, "codeLists", null);
        Map<String, String> map = new TreeMap<String, String>();
        map.put("id1", "name1");
        map.put("id2", "name2");
        map.put("id3", "name3");
        UTUtil.setPrivateField(test, "codeListMap", map);

        // eXg{
        test.load();

        // 
        List result = (List) UTUtil.getPrivateField(test, "codeLists");
        assertEquals(3, result.size());

        // 1
        CodeBean codebean = (CodeBean) result.get(0);
        assertEquals("id1", codebean.getId());
        assertEquals("name1", codebean.getName());

        // 2
        codebean = (CodeBean) result.get(1);
        assertEquals("id2", codebean.getId());
        assertEquals("name2", codebean.getName());

        // 3
        codebean = (CodeBean) result.get(2);
        assertEquals("id3", codebean.getId());
        assertEquals("name3", codebean.getName());
    }

    /**
     * testGetCodeBeans01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() codeLists:null<br>
     *
     * <br>
     * ҒlF(߂l) CodeBean[]:vf0CodeBean[]<br>
     *
     * <br>
     * CX^XϐcodeListsnull̏ꍇA0CodeBeanz񂪎擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetCodeBeans01() throws Exception {
        // O
        UTUtil.setPrivateField(test, "codeLists", null);

        // eXg{
        CodeBean[] result = test.getCodeBeans();

        // 
        assertEquals(0, result.length);
    }

    /**
     * testGetCodeBeans02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() codeLists:vf0List<br>
     *
     * <br>
     * ҒlF(߂l) CodeBean[]:vf0CodeBean[]<br>
     *
     * <br>
     * CX^XϐcodeLists0List̏ꍇA0CodeBeanz񂪎擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetCodeBeans02() throws Exception {
        // O
        List<CodeBean> list = new ArrayList<CodeBean>();
        UTUtil.setPrivateField(test, "codeLists", list);

        // eXg{
        CodeBean[] result = test.getCodeBeans();

        // 
        assertEquals(0, result.length);
    }

    /**
     * testGetCodeBeans03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() codeLists:vf1<br>
     *                CodeBean{"id","name"}<br>
     *
     * <br>
     * ҒlF(߂l) CodeBean[]:vf1CodeBean[]<br>
     *                  CodeBean{"id","name"}<br>
     *
     * <br>
     * CX^XϐcodeLists1List̏ꍇA̗vfCodeBeanz񂪎擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetCodeBeans03() throws Exception {
        // O
        List<CodeBean> list = new ArrayList<CodeBean>();
        CodeBean cb = new CodeBean();
        cb.setId("id");
        cb.setName("name");
        list.add(cb);
        UTUtil.setPrivateField(test, "codeLists", list);

        // eXg{
        CodeBean[] result = test.getCodeBeans();

        // 
        assertEquals(1, result.length);
        assertEquals("id", result[0].getId());
        assertEquals("name", result[0].getName());
    }

    /**
     * testGetCodeBeans04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() codeLists:vf3<br>
     *                CodeBean{"id1","name1"},<br>
     *                CodeBean{"id2","name2"},<br>
     *                CodeBean{"id3","name3"}<br>
     *
     * <br>
     * ҒlF(߂l) CodeBean[]:vf3CodeBean[]<br>
     *                  CodeBean{"id1","name1"},<br>
     *                  CodeBean{"id2","name2"},<br>
     *                  CodeBean{"id3","name3"}<br>
     *
     * <br>
     * CX^XϐcodeLists̗vfꍇA̗vfCodeBeanz񂪎擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetCodeBeans04() throws Exception {
        // O
        List<CodeBean> list = new ArrayList<CodeBean>();
        CodeBean cb = new CodeBean();
        cb.setId("id1");
        cb.setName("name1");
        list.add(cb);
        cb = new CodeBean();
        cb.setId("id2");
        cb.setName("name2");
        list.add(cb);
        cb = new CodeBean();
        cb.setId("id3");
        cb.setName("name3");
        list.add(cb);
        UTUtil.setPrivateField(test, "codeLists", list);

        // eXg{
        CodeBean[] result = test.getCodeBeans();

        // 
        assertEquals(3, result.length);

        //1
        assertEquals("id1", result[0].getId());
        assertEquals("name1", result[0].getName());

        //2
        assertEquals("id2", result[1].getId());
        assertEquals("name2", result[1].getName());

        //3
        assertEquals("id3", result[2].getId());
        assertEquals("name3", result[2].getName());
    }

}
