/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.codelist;

import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import jp.terasoluna.utlib.MockDataSource;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.JdbcTemplate;

import com.mockrunner.mock.jdbc.MockResultSet;

/**
 * {@link jp.terasoluna.fw.web.codelist.DBCodeListQuery} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * f[^x[XR[hXg擾s RDBMSIy[VNXB<br>
 * ̃NXjp.terasoluna.fw.web.codelist.DBCodeListLoaderł̂ݗpB<br>
 * EO<br>
 * mapRow\bh̓X[p[NXĂяoArsnullAvfȂԂ݂͑ȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.codelist.DBCodeListQuery
 */
@SuppressWarnings("unused")
public class DBCodeListQueryTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DBCodeListQueryTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DBCodeListQueryTest(String name) {
        super(name);
    }

    /**
     * testDBCodeListQuery01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() dataSource:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:udataSource is requiredvƌbZ[WInvalidDataAccessApiUsageException<br>
     *         
     * <br>
     * dataSourcenull̏ꍇudataSource is requiredvƌbZ[WInvalidDataAccessApiUsageException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBCodeListQuery01() throws Exception {

        try {
            // eXg{
            DBCodeListQuery query = new DBCodeListQuery(null, "abc");
        } catch (InvalidDataAccessApiUsageException e) {
            // 
            assertEquals("dataSource is required", e.getMessage());
        }
    }

    /**
     * testDBCodeListQuery02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() dataSource:not null<br>
     *         () sql:null<br>
     *         
     * <br>
     * ҒlF(ԕω) jdbcTemplatedataSource<br>
     *                    ieNXRdbmsOperatioñtB[hj:not null<br>
     *         (ԕω) sql<br>
     *                    ieNXRdbmsOperatioñtB[hj:null<br>
     *         
     * <br>
     * dataSourcetnot nullAsqlnull̏ꍇꂼAnot nullAnulltB[hɃZbg邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBCodeListQuery02() throws Exception {
        // O
        DataSource ds = new MockDataSource();

        // eXg{
        DBCodeListQuery query = new DBCodeListQuery(ds, null);

        // 
        JdbcTemplate template = (JdbcTemplate) UTUtil.getPrivateField(query,
                "jdbcTemplate");
        assertSame(ds, template.getDataSource());
        assertNull(UTUtil.getPrivateField(query, "sql"));

    }

    /**
     * testDBCodeListQuery03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() dataSource:not null<br>
     *         () sql:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) jdbcTemplatedataSource<br>
     *                    ieNXRdbmsOperatioñtB[hj:not null<br>
     *         (ԕω) sql<br>
     *                    ieNXRdbmsOperatioñtB[hj:not null<br>
     *         
     * <br>
     * dataSourcetAsqlnot null̏ꍇZbg邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBCodeListQuery03() throws Exception {
        // O
        DataSource ds = new MockDataSource();

        // eXg{
        DBCodeListQuery query = new DBCodeListQuery(ds, "abc");

        // 
        JdbcTemplate template = (JdbcTemplate) UTUtil.getPrivateField(query,
                "jdbcTemplate");
        assertSame(ds, template.getDataSource());
        assertEquals("abc", UTUtil.getPrivateField(query, "sql"));
    }

    /**
     * testMapRow01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() ResultSet rs:not null<br>
     *         () 1J:not null<br>
     *         () 2J:݂Ȃ<br>
     *         () 3J:݂Ȃ<br>
     *         
     * <br>
     * ҒlF(߂l) CodeBean:id1Jڂ̒lAnameɋ󕶎<br>
     *         
     * <br>
     * rs̃J1̏ꍇid1Jڂ̒lAname󕶎CodeBeanԂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testMapRow01() throws Exception {
        // O
        DataSource ds = new MockDataSource();
        DBCodeListQuery query = new DBCodeListQuery(ds, null);
        
        // eXgΏۂ̃RXgN^gpĂ邽߁Aēxݒ肷
        JdbcTemplate template = (JdbcTemplate) UTUtil.getPrivateField(query,
                "jdbcTemplate");
        template.setDataSource(ds);
        UTUtil.setPrivateField(query, "sql", null);

        // [ResultSet̐ݒ
        MockResultSet rs = new MockResultSet("testid");
        List<String> list = new ArrayList<String>();
        list.add("value1");
        rs.addColumn("column1", list);
        rs.first();
        
        // eXg{
        CodeBean result = (CodeBean) query.mapRow(rs, 0);

        // 
        assertEquals("value1", result.getId());
        assertEquals("", result.getName());
    }

    /**
     * testMapRow02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() ResultSet rs:not null<br>
     *         () 1J:not null<br>
     *         () 2J:not null<br>
     *         () 3J:݂Ȃ<br>
     *         
     * <br>
     * ҒlF(߂l) CodeBean:id1Jڂ̒lAname2Jڂ̒l<br>
     *         
     * <br>
     * rs̃J2̏ꍇid1Jڂ̒lAname2Jڂ̒lCodeBeanԂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testMapRow02() throws Exception {
        // O
        DataSource ds = new MockDataSource();
        DBCodeListQuery query = new DBCodeListQuery(ds, null);
        
        // eXgΏۂ̃RXgN^gpĂ邽߁Aēxݒ肷
        JdbcTemplate template = (JdbcTemplate) UTUtil.getPrivateField(query,
                "jdbcTemplate");
        template.setDataSource(ds);
        UTUtil.setPrivateField(query, "sql", null);

        // [ResultSet̐ݒ
        MockResultSet rs = new MockResultSet("testid");
        List<String> list = new ArrayList<String>();
        list.add("value1");
        rs.addColumn("column1", list);
        List<String> list2 = new ArrayList<String>();
        list2.add("value2");
        rs.addColumn("column2", list2);
        rs.first();
        
        // eXg{
        CodeBean result = (CodeBean) query.mapRow(rs, 0);

        // 
        assertEquals("value1", result.getId());
        assertEquals("value2", result.getName());
    }

    /**
     * testMapRow03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() ResultSet rs:not null<br>
     *         () 1J:not null<br>
     *         () 2J:not null<br>
     *         () 3J:not null<br>
     *         
     * <br>
     * ҒlF(߂l) CodeBean:id1Jڂ̒lAname2Jڂ̒l<br>
     *         
     * <br>
     * rs̃J3̏ꍇid1Jڂ̒lAname2Jڂ̒lCodeBeanԂ3Jڂ͖邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testMapRow03() throws Exception {
        // O
        DataSource ds = new MockDataSource();
        DBCodeListQuery query = new DBCodeListQuery(ds, null);
        
        // eXgΏۂ̃RXgN^gpĂ邽߁Aēxݒ肷
        JdbcTemplate template = (JdbcTemplate) UTUtil.getPrivateField(query,
                "jdbcTemplate");
        template.setDataSource(ds);
        UTUtil.setPrivateField(query, "sql", null);

        // [ResultSet̐ݒ
        MockResultSet rs = new MockResultSet("testid");
        List<String> list = new ArrayList<String>();
        list.add("value1");
        rs.addColumn("column1", list);
        List<String> list2 = new ArrayList<String>();
        list2.add("value2");
        rs.addColumn("column2", list2);
        List<String> list3 = new ArrayList<String>();
        list3.add("value3");
        rs.addColumn("column3", list3);
        rs.first();
        
        // eXg{
        CodeBean result = (CodeBean) query.mapRow(rs, 0);

        // 
        assertEquals("value1", result.getId());
        assertEquals("value2", result.getName());
    }

    /**
     * testMapRow04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FCD
     * <br><br>
     * ͒lF() ResultSet rs:not null<br>
     *         () 1J:null<br>
     *         () 2J:null<br>
     *         () 3J:݂Ȃ<br>
     *         
     * <br>
     * ҒlF(߂l) CodeBean:id󕶎Aname󕶎<br>
     *         
     * <br>
     * rs̃J2̏ꍇ1JځA2Jڂnull̏ꍇidɋ󕶎Anameɋ󕶎̒lCodeBeanԂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testMapRow04() throws Exception {
        // O
        DataSource ds = new MockDataSource();
        DBCodeListQuery query = new DBCodeListQuery(ds, null);
        
        // eXgΏۂ̃RXgN^gpĂ邽߁Aēxݒ肷
        JdbcTemplate template = (JdbcTemplate) UTUtil.getPrivateField(query,
                "jdbcTemplate");
        template.setDataSource(ds);
        UTUtil.setPrivateField(query, "sql", null);

        // [ResultSet̐ݒ
        MockResultSet rs = new MockResultSet("testid");
        rs.addColumn("column1");
        rs.addColumn("column2");
        
        // eXg{
        CodeBean result = (CodeBean) query.mapRow(rs, 0);

        // 
        assertEquals("", result.getId());
        assertEquals("", result.getName());
    }

}
