/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.testcase;

import static jp.terasoluna.fw.ex.unit.common.DefaultProperties.getValue;
import static jp.terasoluna.fw.ex.unit.common.PropertyKeys.APPLICATIONCONTEXT_FILE;
import static jp.terasoluna.fw.ex.unit.common.PropertyKeys.MOCKDAOBEANS_FILE;
import static jp.terasoluna.fw.ex.unit.common.PropertyKeys.MODULECONTEXT_FILE;
import static jp.terasoluna.fw.ex.unit.common.PropertyKeys.WEBINF_DIR;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import jp.terasoluna.fw.ex.unit.util.ClassLoaderUtils;

public class TestCaseUtils {
    /**
     * {@link DaoTestCase}ɂftHg̐ݒt@Cǉݒt@C̃Xgԋp܂B
     * 
     * <pre>
     * {@link DaoTestCase}ɂftHgŒǉ̐ݒt@C
     * 
     * EWEB-INF/applicationContext.xml
     * EWEB-INF/moduleContext.xml
     * 
     * łB
     * ㏑ꍇ́A
     * terasoluna-unit-override.properties
     * ɐݒ肵܂B
     * 
     * ꂼ
     * WEB-INF -> webinf.dir
     * applicationContext.xml -> applicationcontext.file
     * moduleContext.xml -> modulecontext.file
     * ̃L[ɑ΂ĐݒlLqĂB
     * </pre>
     * 
     * @param configLocations
     *            ̐ݒt@CpXz
     * @return ǉ̐ݒt@CpXXg
     */
    public static List<String> getConfigLocationsForDaoTestCase(
            String[] configLocations) {
        // WEB-INF/applicationContext.xml,WEB-INF/moduleContext.xmlǉ܂B
        List<String> addFiles = Arrays.asList(getValue(WEBINF_DIR) + "/"
                + getValue(APPLICATIONCONTEXT_FILE), getValue(WEBINF_DIR) + "/"
                + getValue(MODULECONTEXT_FILE));
        return getDefaultAddedConfigLocations(configLocations, addFiles);
    }

    /**
     * {@link MockDaoInjectedTestCase}ɂftHg̐ݒt@Cǉݒt@C̃Xgԋp܂B
     * 
     * <pre>
     * {@link MockDaoInjectedTestCase}ɂftHgŒǉ̐ݒt@C
     * 
     * EWEB-INF/applicationContext.xml
     * EmockDaoBeans.xml
     * 
     * łB
     * ㏑ꍇ́A
     * terasoluna-unit-override.properties
     * ɐݒ肵܂B
     * 
     * ꂼ
     * WEB-INF -> webinf.dir
     * applicationContext.xml -> applicationcontext.file
     * mockDaoBeans.xml -> mockdaobeans.file
     * ̃L[ɑ΂ĐݒlLqĂB
     * </pre>
     * 
     * @param configLocations
     *            ̐ݒt@CpXz
     * @return ǉ̐ݒt@CpXXg
     */
    public static List<String> getConfigLocationsForMockDaoInjectedTestCase(
            String[] configLocations) {
        // WEB-INF/moduleContext.xml,mockDaoBeans.xmlǉ܂B
        List<String> addFiles = Arrays.asList(getValue(WEBINF_DIR) + "/"
                + getValue(MODULECONTEXT_FILE), getValue(MOCKDAOBEANS_FILE));
        return getDefaultAddedConfigLocations(configLocations, addFiles);
    }

    /**
     * ftHgŒǉݒt@C̃Xgԋp܂B
     * 
     * @param configLocations
     *            ̐ݒt@CpXz
     * @param addFiles
     *            ǉݒt@CpXXg
     * @return ǉ̐ݒt@CpXXg
     */
    public static List<String> getDefaultAddedConfigLocations(
            String[] configLocations, List<String> addFiles) {
        List<String> result = new ArrayList<String>();

        if (configLocations != null) {
            Collections.addAll(result, configLocations);
        }

        // ftHgŒǉt@CɊւĂ͑݃`FbN܂
        ClassLoaderUtils.addPathIfExists(result, addFiles);

        return result;
    }
}
