/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter.mockrunner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.mockrunner.BinaryExpression;
import org.activemq.filter.mockrunner.Expression;
import org.activemq.filter.mockrunner.UnaryExpression;

public class MultiExpressionEvaluator {
    HashMap rootExpressions = new HashMap();
    HashMap cachedExpressions = new HashMap();
    int view = 0;

    public void addExpressionListner(Expression expression, ExpressionListener expressionListener) {
        ExpressionListenerSet expressionListenerSet = (ExpressionListenerSet)this.rootExpressions.get(expression.toString());
        if (expressionListenerSet == null) {
            expressionListenerSet = new ExpressionListenerSet();
            expressionListenerSet.expression = this.addToCache(expression);
            this.rootExpressions.put(expression.toString(), expressionListenerSet);
        }
        expressionListenerSet.listeners.add(expressionListener);
    }

    public boolean removeEventListner(String string, ExpressionListener expressionListener) {
        String string2 = string;
        ExpressionListenerSet expressionListenerSet = (ExpressionListenerSet)this.rootExpressions.get(string2);
        if (expressionListenerSet == null) {
            return false;
        }
        if (!expressionListenerSet.listeners.remove(expressionListener)) {
            return false;
        }
        if (expressionListenerSet.listeners.size() == 0) {
            this.removeFromCache((CacheExpression)expressionListenerSet.expression);
            this.rootExpressions.remove(string2);
        }
        return true;
    }

    private CacheExpression addToCache(Expression expression) {
        CacheExpression cacheExpression = (CacheExpression)this.cachedExpressions.get(expression);
        if (cacheExpression == null) {
            cacheExpression = new CacheExpression(expression);
            this.cachedExpressions.put(expression, cacheExpression);
            if (expression instanceof UnaryExpression) {
                UnaryExpression unaryExpression = (UnaryExpression)expression;
                unaryExpression.setRight(this.addToCache(unaryExpression.getRight()));
            } else if (expression instanceof BinaryExpression) {
                BinaryExpression binaryExpression = (BinaryExpression)expression;
                binaryExpression.setRight(this.addToCache(binaryExpression.getRight()));
                binaryExpression.setLeft(this.addToCache(binaryExpression.getLeft()));
            }
        }
        cacheExpression.refCount = (short)(cacheExpression.refCount + 1);
        return cacheExpression;
    }

    private void removeFromCache(CacheExpression cacheExpression) {
        Expression expression;
        cacheExpression.refCount = (short)(cacheExpression.refCount - 1);
        Expression expression2 = cacheExpression.getRight();
        if (cacheExpression.refCount == 0) {
            this.cachedExpressions.remove(expression2);
        }
        if (expression2 instanceof UnaryExpression) {
            expression = (UnaryExpression)expression2;
            this.removeFromCache((CacheExpression)((UnaryExpression)expression).getRight());
        }
        if (expression2 instanceof BinaryExpression) {
            expression = (BinaryExpression)expression2;
            this.removeFromCache((CacheExpression)((BinaryExpression)expression).getRight());
        }
    }

    public void evaluate(Message message) {
        Collection collection = this.rootExpressions.values();
        for (ExpressionListenerSet expressionListenerSet : collection) {
            try {
                Object object = expressionListenerSet.expression.evaluate(message);
                for (ExpressionListener expressionListener : expressionListenerSet.listeners) {
                    expressionListener.evaluateResultEvent(expressionListenerSet.expression, message, object);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    static interface ExpressionListener {
        public void evaluateResultEvent(Expression var1, Message var2, Object var3);
    }

    static class ExpressionListenerSet {
        Expression expression;
        ArrayList listeners = new ArrayList();

        ExpressionListenerSet() {
        }
    }

    public class CacheExpression
    extends UnaryExpression {
        short refCount;
        int cview;
        Object cachedValue;
        int cachedHashCode;

        public CacheExpression(Expression expression) {
            super(expression);
            this.refCount = 0;
            this.cview = MultiExpressionEvaluator.this.view - 1;
            this.cachedHashCode = expression.hashCode();
        }

        public Object evaluate(Message message) throws JMSException {
            if (MultiExpressionEvaluator.this.view == this.cview) {
                return this.cachedValue;
            }
            this.cachedValue = this.right.evaluate(message);
            this.cview = MultiExpressionEvaluator.this.view;
            return this.cachedValue;
        }

        public int hashCode() {
            return this.cachedHashCode;
        }

        public boolean equals(Object object) {
            return ((CacheExpression)object).right.equals(this.right);
        }

        public String getExpressionSymbol() {
            return null;
        }

        public String toString() {
            return this.right.toString();
        }
    }
}

