/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.base.NestedApplicationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class MockFilterChain
implements FilterChain {
    private List filters = new ArrayList();
    private Servlet servlet;
    private Iterator iterator;
    private List requestList = new ArrayList();
    private List responseList = new ArrayList();

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        this.requestList.add(servletRequest);
        this.responseList.add(servletResponse);
        if (null == this.iterator) {
            this.iterator = this.filters.iterator();
        }
        if (this.iterator.hasNext()) {
            Filter filter = (Filter)this.iterator.next();
            filter.doFilter(servletRequest, servletResponse, (FilterChain)this);
        } else {
            this.reset();
            if (null == this.servlet) {
                return;
            }
            this.servlet.service(servletRequest, servletResponse);
        }
    }

    public void reset() {
        this.iterator = null;
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void addFilter(Class clazz) {
        if (!Filter.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("filterClass must be an instance of javax.servlet.Filter");
        }
        try {
            this.filters.add(clazz.newInstance());
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public void release() {
        this.filters.clear();
        this.setServlet(null);
        this.reset();
    }

    public List getRequestList() {
        return Collections.unmodifiableList(this.requestList);
    }

    public List getResponseList() {
        return Collections.unmodifiableList(this.responseList);
    }

    public ServletRequest getLastRequest() {
        if (this.requestList.isEmpty()) {
            return null;
        }
        return (ServletRequest)this.requestList.get(this.requestList.size() - 1);
    }

    public ServletResponse getLastResponse() {
        if (this.responseList.isEmpty()) {
            return null;
        }
        return (ServletResponse)this.responseList.get(this.responseList.size() - 1);
    }
}

