/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import jp.terasoluna.fw.ex.unit.exception.PopulationFailedException;
import jp.terasoluna.fw.ex.unit.util.DateConvertUtils;
import jp.terasoluna.fw.ex.unit.util.Populator;
import jp.terasoluna.fw.ex.unit.util.ReflectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPopulator<T>
implements Populator<T> {
    private String dateFormat = null;
    private static final List<String> defaultDateFormatList = Arrays.asList("yyyy-MM-dd", "yyyy/MM/dd", "HH:mm:ss");
    private boolean ignoreParseException = true;

    public void setIgnoreParseException(boolean ignoreParseException) {
        this.ignoreParseException = ignoreParseException;
    }

    @Override
    public T populate(Class<T> clazz, String[] propertyNames, Object ... values) {
        Assert.notEmpty((Object[])values);
        Assert.notEmpty((Object[])propertyNames);
        Assert.isTrue((values.length == propertyNames.length ? 1 : 0) != 0, (String)("The length of propertyNames and values  must be same! " + propertyNames.length + " != " + values.length));
        try {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(clazz);
            for (int i = 0; i < values.length; ++i) {
                Object value = null;
                String propertyName = propertyNames[i];
                Class propertyType = beanWrapper.getPropertyType(propertyName);
                if (propertyType != null) {
                    value = this.convertPropertyValue(values[i], propertyType);
                    beanWrapper.setPropertyValue(propertyName, value);
                    continue;
                }
                if (!StringUtils.contains((String)propertyName, (char)'.')) continue;
                String[] names = StringUtils.split((String)propertyName, (char)'.');
                StringBuilder prop = new StringBuilder(names[0]);
                for (int j = 0; j < names.length; ++j) {
                    String parentName;
                    Class parentType;
                    if (j > 0) {
                        prop.append('.');
                        prop.append(names[j]);
                    }
                    if ((parentType = beanWrapper.getPropertyType(parentName = prop.toString())) == null) break;
                    this.populateParent((BeanWrapper)beanWrapper, parentType, parentName);
                }
                if ((propertyType = beanWrapper.getPropertyType(propertyName)) == null) continue;
                value = this.convertPropertyValue(values[i], propertyType);
                beanWrapper.setPropertyValue(propertyName, value);
            }
            return (T)beanWrapper.getWrappedInstance();
        }
        catch (Exception e) {
            throw new PopulationFailedException(e);
        }
    }

    private void populateParent(BeanWrapper beanWrapper, Class<?> parentType, String parentName) {
        Object parent = beanWrapper.getPropertyValue(parentName);
        if (parent == null) {
            Object o = ReflectionUtils.newInstance(parentType);
            beanWrapper.setPropertyValue(parentName, o);
        }
    }

    private Object convertPropertyValue(Object value, Class<?> propertyType) {
        Object result = null;
        if (Date.class.isAssignableFrom(propertyType) && value != null) {
            Date d = this.parseDate(value.toString());
            result = DateConvertUtils.convertDateValue(d, propertyType);
        } else {
            result = value;
        }
        return result;
    }

    private Date parseDate(String value) throws IllegalArgumentException {
        Date date = null;
        if (this.dateFormat != null) {
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
            try {
                date = format.parse(value);
                return date;
            }
            catch (ParseException ignore) {
                // empty catch block
            }
        }
        try {
            date = Timestamp.valueOf(value);
            return date;
        }
        catch (IllegalArgumentException ignore) {
            for (String fmt : defaultDateFormatList) {
                SimpleDateFormat format = new SimpleDateFormat(fmt);
                try {
                    date = format.parse(value);
                }
                catch (ParseException ignore2) {}
            }
            if (date == null && !this.ignoreParseException) {
                throw new IllegalArgumentException("Cannot parse " + value + ". Please set dateFormat.");
            }
            return date;
        }
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }
}

