/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockMessage;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;

public class MockTextMessage
extends MockMessage
implements TextMessage {
    private String text;

    public MockTextMessage() {
        this(null);
    }

    public MockTextMessage(String string) {
        this.text = string;
    }

    public void setText(String string) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.text = string;
    }

    public String getText() throws JMSException {
        return this.text;
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName() + ": " + this.getText());
            return stringBuffer.toString();
        }
        catch (JMSException jMSException) {
            return jMSException.getMessage();
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.text = null;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!(object instanceof MockTextMessage)) {
            return false;
        }
        MockTextMessage mockTextMessage = (MockTextMessage)object;
        if (null == this.text && null == mockTextMessage.text) {
            return true;
        }
        return this.text.equals(mockTextMessage.text);
    }

    public int hashCode() {
        if (null == this.text) {
            return 0;
        }
        return this.text.hashCode();
    }

    public Object clone() {
        return super.clone();
    }
}

