/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.action;

import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.ex.exception.ValidationException;

import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ExceptionConfig;

/**
 * ValidationExceptionp̗OnhNXłB
 * 
 * @version 1.0.0
 */
public class ValidationExceptionHandler extends BLogicExceptionHandler {

    /**
     * Jڐ\ActionForwardCX^X擾܂B 
     * ȉ̏őJڐ肵܂B
     * <ol>
     * <li>sactionvfinput</li>
     * <li>exceptionvfpath</li>
     * <li>擾łȂꍇnull</li>
     * </ol>
     * 
     * @param ex O
     * @param ae ExceptionConfig
     * @param mapping ANV}bsO
     * @param request NGXg
     * @return Jڐ\ActionFowardCX^X
     */
    @Override
    protected ActionForward getActionForward(Exception ex, ExceptionConfig ae,
            ActionMapping mapping, HttpServletRequest request) {
        if (ex instanceof ValidationException) {
            ActionForward forward = mapping.getInputForward();
            if (forward != null && forward.getPath() != null) {
                return forward;
            }
        }
        return super.getActionForward(ex, ae, mapping, request);
    }
}
