/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.database.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.thin.functionsample.database.bean.AddressTableVO;
import jp.terasoluna.fw.dao.QueryDAO;

/**
 * Z^ڂ擾T[rXiArrayListŁj
 *
 */
public class ArrayListAddressServiceImpl implements ArrayListAddressService {

    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private QueryDAO queryDAO = null;

    /**
     * f[^x[XZ^Xg擾
     *
     * @return Z^ꗗ
     */
    public Map<String, List<AddressTableVO>> getListAddress() {
        Map<String, List<AddressTableVO>> retMap = new HashMap<String, List<AddressTableVO>>();
        
        // Z^̃Xg擾B
        List<AddressTableVO> addressVO = 
                    queryDAO.executeForObjectList("database.selectListAddress",
                                                   null);
        retMap.put("listAddress", addressVO);
        return retMap;
    }

    /**
     * queryDAO擾B
     * @return queryDAO
     */
    public QueryDAO getQueryDAO() {
        return queryDAO;
    }

    /**
     * queryDAOݒ肷B
     * @param queryDAO queryDAOB
     */
    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }

    /* ( Javadoc)
     * @see jp.terasoluna.thin.functionsample.database.service.ArrayListAddressService#searchListAddress(java.lang.String)
     */
    public Map<String, List<AddressTableVO>> searchListAddress(String name) {
        Map<String, List<AddressTableVO>> retMap = new HashMap<String, List<AddressTableVO>>();
        
        // Z^̃Xg擾B
        List<AddressTableVO> addressVO = 
                    queryDAO.executeForObjectList("database.searchListAddress",
                                                   name);
        retMap.put("listAddress", addressVO);
        return retMap;
    }
}