/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.common.web;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @\ԗTvAPɂāANGXgp[^̃GR[fBOݒsB
 * <p>
 * <code>web.xml</code> ŏlݒ肷鎖ɂAȉ̐䂪\łB
 * </p>
 * <p>
 * <table border="1" frame='box'>
 * <tr>
 * <td>p[^</td>
 * <td>ftHgl</td>
 * <td>Tv</td>
 * </tr>
 * <tr>
 * <td><code>encoding</code></td>
 * <td><code>null</code></td>
 * <td>GR[fBOB <br>
 * ݒ肵Ȃꍇ́AsȂȂB</td>
 * </tr>
 * <tr>
 * <td><code>ignore</code></td>
 * <td><code>false</code></td>
 * <td>̒l <code>true</code> łꍇAGR[fBOsȂȂB</td>
 * </tr>
 * <tr>
 * <td>more</td>
 * <td>false</td>
 * <td>tB^̕񏈗tOB <br>
 * ̒l <code>false</code> łꍇ́A
 * xNGXgIuWFNg͏ΏۊOƂB</td>
 * </tr>
 * </table>
 * </p>
 * <p>
 * ServletAPIo[W2.4ȏɂėLBL̂悤web.xmlɐݒ肷B
 * </p>
 * &lt;filter&gt; <br>
 * &lt;filter-name&gt;Set Character Encoding&lt;/filter-name&gt; <br>
 * &lt;filter-class&gt; <br>
 * jp.terasoluna.thin.functionsample.common.web.SetCharacterEncodingFilter <br>
 * &lt;/filter-class&gt; <br>
 * &lt;init-param&gt; <br>
 * &lt;param-name&gt;encoding&lt;/param-name&gt; <br>
 * &lt;param-value&gt;Windows31-J&lt;/param-value&gt; <br>
 * &lt;/init-param&gt; <br>
 * &lt;init-param&gt; <br>
 * &lt;param-name&gt;more&lt;/param-name&gt; <br>
 * &lt;param-value&gt;false&lt;/param-value&gt; <br>
 * &lt;/init-param&gt; <br>
 * &lt;/filter&gt; <br>
 * &lt;filter-mapping&gt; <br>
 * &lt;filter-name&gt;Set Character Encoding&lt;/filter-name&gt; <br>
 * &lt;url-pattern&gt;/&lt;/url-pattern&gt; <br>
 * &lt;/filter-mapping&gt; <br>
 * 
 */
public class SetCharacterEncodingFilter implements Filter {

    /**
     * ONXB
     */
    private static Log log
         = LogFactory.getLog(SetCharacterEncodingFilter.class);

    /**
     * tB^ς݃tOB
     */
    private static final String THRU_FILTER_KEY = "THRU_FILTER_ENCODING";

    /**
     * tB^̕񏈗tOB
     */
    private boolean moreFlag = false;

    /**
     * ftHg̃GR[fBOB
     */
    private String encoding = null;

    /**
     * tB^[RtBOB
     */
    @SuppressWarnings("unused")
    private FilterConfig filterConfig = null;

    /**
     * NCAgŎw肳ꂽGR[fBO𖳎邩ǂ̃tOB
     */
    private boolean ignoreFlag = false;

    /**
     * B
     * 
     * @param filterConfig
     *            tB^[ݒ
     * 
     * @exception ServletException
     *                O
     */
    public void init(FilterConfig filterConfig) throws ServletException {

        // Log
        if (log.isDebugEnabled()) {
            log.debug("init() called.");
        }

        this.filterConfig = filterConfig;
        this.encoding = filterConfig.getInitParameter("encoding");

        if (log.isDebugEnabled()) {
            log.debug("this.encoding = " + this.encoding);
        }

        String ignoreValue = filterConfig.getInitParameter("ignore");
        if (ignoreValue != null) {
            this.ignoreFlag = this.createFlag(ignoreValue);
        }

        String moreValue = filterConfig.getInitParameter("more");
        if (moreValue != null) {
            this.moreFlag = this.createFlag(moreValue);
        }
    }

    /**
     * tB^[B
     * 
     * <p>
     * NGXgp[^w肳ꂽGR[fBOɐݒ肷B
     * </p>
     * 
     * @param request
     *            NGXg
     * @param response
     *            X|X
     * @param chain
     *            tB^[`F[
     * 
     * @exception IOException
     *                O
     * @exception ServletException
     *                O
     */
    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, ServletException {
    
        if (!this.moreFlag && request.getAttribute(THRU_FILTER_KEY) != null) {
            chain.doFilter(request, response);
            return;
        }
    
        if (!ignoreFlag && encoding != null) {
            // Log
            if (log.isDebugEnabled()) {
                log.debug("set encoding(" + encoding + ") to request.");
            }
            request.setCharacterEncoding(encoding);
        }
    
    
        // σtOi[
        request.setAttribute(THRU_FILTER_KEY, THRU_FILTER_KEY);
    
        chain.doFilter(request, response);
    }

    /**
     * IB
     */
    public void destroy() {
        this.encoding = null;
        this.filterConfig = null;
    }

    /**
     * AtO𐶐B
     * 
     * @param value
     *            ΏەB
     * @return ꂽtOB
     */
    private boolean createFlag(String value) {
    
        if (value == null) {
            return false;
        } else if ("true".equalsIgnoreCase(value)) {
            return true;
        } else if ("yes".equalsIgnoreCase(value)) {
            return true;
        }
        return false;
    }
}