/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.mock;

import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.dao.QueryDAO;

/**
 * {@link QueryDAO}̃bNNXłB
 * 
 */
public class MockQueryDao extends AbstractMockDao implements QueryDAO {

    public Map<String, Object> executeForMap(String sqlId, Object bindParams) {
        addParam(new DaoParam(sqlId, bindParams));
        return pollMap();
    }

    public Map<String, Object>[] executeForMapArray(String sqlId,
            Object bindParams) {
        addParam(new DaoParam(sqlId, bindParams));
        return pollMapArray();
    }

    public Map<String, Object>[] executeForMapArray(String sqlId,
            Object bindParams, int beginIndex, int maxCount) {
        addParam(new DaoParam(sqlId, bindParams, beginIndex, maxCount));
        return pollMapArray();
    }

    public List<Map<String, Object>> executeForMapList(String sqlId,
            Object bindParams) {
        addParam(new DaoParam(sqlId, bindParams));
        return pollMapList();
    }

    public List<Map<String, Object>> executeForMapList(String sqlId,
            Object bindParams, int beginIndex, int maxCount) {
        addParam(new DaoParam(sqlId, bindParams, beginIndex, maxCount));
        return pollMapList();
    }

    @SuppressWarnings("unchecked")
    public <E> E executeForObject(String sqlId, Object bindParams,
            @SuppressWarnings("rawtypes") Class clazz) {
        addParam(new DaoParam(sqlId, bindParams, clazz));
        return (E) poll();
    }

    @SuppressWarnings("unchecked")
    public <E> E[] executeForObjectArray(String sqlId, Object bindParams,
            @SuppressWarnings("rawtypes") Class clazz) {
        addParam(new DaoParam(sqlId, bindParams, clazz));

        return (E[]) pollArray();
    }

    @SuppressWarnings("unchecked")
    public <E> E[] executeForObjectArray(String sqlId, Object bindParams,
            @SuppressWarnings("rawtypes") Class clazz, int beginIndex,
            int maxCount) {
        addParam(new DaoParam(sqlId, bindParams, clazz, beginIndex, maxCount));
        return (E[]) pollArray();
    }

    @SuppressWarnings("unchecked")
    public <E> List<E> executeForObjectList(String sqlId, Object bindParams) {
        addParam(new DaoParam(sqlId, bindParams));
        return (List<E>) pollList();
    }

    @SuppressWarnings("unchecked")
    public <E> List<E> executeForObjectList(String sqlId, Object bindParams,
            int beginIndex, int maxCount) {
        addParam(new DaoParam(sqlId, bindParams, beginIndex, maxCount));
        return (List<E>) pollList();
    }

}
