/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;


/**
 *  JUnit ł̒P̃eXgT|[g郆[eBeBNXB
 * <BR><BR>
 * f[^x[Xnуt@Cñ\bh𗘗pꍇ́A<BR>
 * ݒt@Cuutlib.confvt@CJUnits̃NXpX<BR>
 * uĂKvB
 * <BR><BR>
 * LqLɎB
 * <BR><BR>
 * 
 * <pre>
 * [utlib.confLq]
 * ------------------------------------------------------------
 * ## JDBCڑ̃[U
 * unittest.jdbc.user=scott
 * 
 * ## JDBCڑ̃pX[h
 * unittest.jdbc.password=tiger
 * 
 * ## JDBCڑURL
 * unittest.jdbc.url=jdbc:oracle:thin:@192.168.0.1:1521:ORCL
 * 
 * ## JDBCڑ̃hCoNX
 * unittest.jdbc.driver=oracle.jdbc.driver.OracleDriver
 * 
 * ## JDBCڑR~bgۂ(on/off)
 * unittest.jdbc.autocommit=off
 * 
 * ## UTUtil̊eDB상\bh(setData)DBR~bg邩ۂ(on/off)
 * unittest.dbmethods.commit=off  
 * 
 * ## eXgf[^̊i[tH_(΃pX or ΃pX)
 * unittest.folder.testdata=data
 * ------------------------------------------------------------
 * </pre>
 * 
 * 
 */
public class UTUtil {

    /**
     * f[^x[X̃RlNV擾B<BR><BR>
     * ConnectionIuWFNgrWlXWbNɈn߂ɗpB
     * <BR><BR>
     * ̃\bh𗘗pꍇAڑf[^x[X̏<BR>
     * uutlib.confvt@CɋLqĂKvB
     * <BR><BR>
     * 
     * <pre>
     * [gp]
     * public void testSomething() throws Exception {
     *     Connection conn = UTUtil.getConnection();
     *     ...
     *     MyBlogic logic = new MyBlogic();
     *     logic.execute(ivo, ovo, svo, conn);
     *     ...
     * }
     * </pre>
     * 
     * mQln<BR>
     * ConnectionIuWFNǵAclose()\bhĂяoĂ<BR>
     * ɂ͐ڑN[YȂB<BR>
     * ́AEJBConnectionpꍇ̓G~[g邽߂<BR>
     * dlłBAEJBȊOł̃eXgł̎gpłpȂ̂ŁA<BR>
     * prCɂpĂ悢B
     * 
     * @return ڑIuWFNg
     * @throws SQLException
     */
    public static Connection getConnection() throws SQLException {
        return DBConnectionWrapper.getInstance();
    }

    /**
     * w肳ꂽe[ůf[^Sč폜B
     * <BR><BR>
     * ̃\bh𗘗pꍇAڑf[^x[X̏<BR>
     * uutlib.confvt@CɋLqĂKvB
     * <BR><BR>
     * XVR~bg邩ǂ́Auunittest.jdbc.autocommitv<BR>
     * uunittest.dbmethods.commitv̎wlɂB
     * 
     * <PRE>
     * [gp]
     * UTUtil.deleteAll("CUSTOMER");
     * </PRE>
     * 
     * @param tableName DBe[u
     * @throws SQLException
     */
    public static void deleteAll(String tableName) throws SQLException {
        DBAccessUtil.deleteAll(tableName);
    }

    /**
     * w肳ꂽ̃e[ůf[^Sč폜B
     * <BR><BR>
     * ̃\bh𗘗pꍇAڑf[^x[X̏<BR>
     * uutlib.confvt@CɋLqĂKvB
     * <BR><BR>
     * XVR~bg邩ǂ́Auunittest.jdbc.autocommitv<BR>
     * uunittest.dbmethods.commitv̎wlɂB
     * 
     * <PRE>
     * [gp]
     * String[] tableNames = new String[]{"CUSTOMER","PRODUCTS"};
     * UTUtil.deleteAll(tableNames);
     * </PRE>
     * 
     * @param tableName DBe[u
     * @throws SQLException
     */
    public static void deleteAll(String tableNames[]) throws SQLException {
        for(int i = 0; i < tableNames.length; i++ ){
            DBAccessUtil.deleteAll(tableNames[i]);    
        }
    }
    
    /**
     * w肳ꂽe[uɏf[^C|[gB
     * <BR><BR>
     * ̃\bhsƁAYe[ů̃f[^ׂ͂<BR>
     * 폜ꂽŃf[^C|[gB
     * <BR><BR>
     * C|[gf[^ƂȂ񎟌ẑPs(data[0])ɂ́A<BR>
     * J̔zw肷BāAQsڈȍ~(data[1`n])ɁA<BR>
     * C|[glLqB
     * <BR><BR>
     * l͕Ŏw肷BNULLlݒ肵ꍇnullw肷B<BR>
     * DATE^ɂẮAȉ̂ꂩ̃tH[}bgŋLqB
     * <BR><BR>
     * E"yyyy-MM-dd" iF "2003-05-20"j<BR>
     * E"HH:mm:ss" iF "12:05:20"j<BR>
     * E"yyyy-MM-dd HH:mm:ss" iF "2003-05-20 12:05:20"j
     * <BR><BR>
     * L[ƂȂJ͕Kw肵Ȃ΂ȂȂB<BR>
     * iw肵ȂƗOBj<BR>
     * L[ȊÕJ͏ȗ\Bȗꍇ̓k̃JNULLɁA<BR>
     * ks̃J͓KȒlݒ肳B
     * <BR><BR>
     * ̃\bh𗘗pꍇAڑf[^x[X̏<BR>
     * uutlib.confvt@CɋLqĂKvB
     * <BR><BR>
     * XVR~bg邩ǂ́Auunittest.jdbc.autocommitv<BR>
     * uunittest.dbmethods.commitv̎wlɂB
     * 
     * <pre>
     * [gp]
     * String[][] data = {
     *     { "C_ID", "C_NAME", "C_REGIST_DATE" },
     *     { "1", "cY", "2001-08-15 13:00:00" },
     *     { "2", "ؓY", "2002-03-14 16:30:15" },
     *     { "3", null, null }
     * }
     * UTUtil.setData("CUSTOMER", data);
     * </pre>
     * 
     * @param tableName e[u
     * @param data C|[gf[^
     * @throws SQLException
     */
    public static void setData(String tableName, String[][] data)
            throws SQLException {

        DBAccessUtil.deleteAll(tableName);
        DBAccessUtil.insertData(tableName, data);
    }

    /**
     * f[^x[XR~bgB
     * <BR><BR>
     * 
     * @throws SQLException
     */
    public static void commit() throws SQLException {
        getConnection().commit();
    }

    /**
     * f[^x[X[obNB
     * <BR><BR>
     * 
     * @throws SQLException
     */
    public static void rollback() throws SQLException {
        getConnection().rollback();
    }

    /**
     * w肳ꂽe[ȗSĂ̍sf[^擾B
     * <BR><BR>
     * ߂ĺAsMapIuWFNg̔z񂪕ԂB<BR>
     * MapIuWFNg̒ɂ́AJƃJl̃Zbgi[B
     * <BR><BR>
     * Jlׂ͂String^Ŋi[Bt⎞̒ĺA<BR>
     * "yyyy-mm-dd hh:mm:ss.fffffffff"̃tH[}bg̕Ŋi[B<BR>
     * (java.sql.Timestamp^toString()̃tH[}bgƓB<BR>
     * Ⴆ΁A"2003-01-01 12:00:00.123456789"ȂǂƂȂB)<BR>
     * <BR><BR>
     * ̃\bh𗘗pꍇAڑf[^x[X̏<BR>
     * uutlib.confvt@CɋLqĂKvB
     * 
     * <pre>
     * [gp]
     * Map[] rows = UTUtil.select("CUSTOMER");
     * assertEquals(2, rows.length); // ʂ2sł邱ƂmF
     * 
     * // Psڂ̃f[^
     * assertEquals("cY", rows[0].get("C_NAME"));
     * assertEquals("detat@terasoluna.jp", rows[0].get("C_EMAIL"));
     * UTUtil.assertEqualsDate("2003-01-01", rows[0].get("C_REGIST_DATE"));
     * 
     * // Qsڂ̃f[^
     * assertEquals("ؓY", rows[1].get("C_NAME"));
     * assertEquals("detaj@terasoluna.jp", rows[1].get("C_EMAIL"));
     * UTUtil.assertEqualsDate("2003-05-20", rows[1].get("C_REGIST_DATE"));
     * </pre>
     * 
     * @param tableName e[u
     * @return sf[^̃Xg
     * @throws SQLException
     */
    public static Map[] select(String tableName) throws SQLException {
        return select(tableName, null, null);
    }

    /**
     * w肳ꂽe[usf[^擾B
     * <BR><BR>
     * WHEREȍ~ɋLq̂AconditionɎw肷B
     * <BR><BR>
     * ߂ĺAsMapIuWFNg̔z񂪕ԂB<BR>
     * MapIuWFNg̒ɂ́AJƃJl̃Zbgi[B
     * <BR><BR>
     * Jlׂ͂String^Ŋi[Bt⎞̒ĺA<BR>
     * "yyyy-mm-dd hh:mm:ss.fffffffff"̃tH[}bg̕Ŋi[B<BR>
     * (java.sql.Timestamp^toString()̃tH[}bgƓB<BR>
     * Ⴆ΁A"2003-01-01 12:00:00.123456789"ȂǂƂȂB)<BR>
     * <BR><BR>
     * ̃\bh𗘗pꍇAڑf[^x[X̏<BR>
     * uutlib.confvt@CɋLqĂKvB
     * 
     * <pre>
     * [gp]
     * Map[] rows = UTUtil.select("CUSTOMER", "C_ID=1");
     * assertEquals(1, rows.length); // ʂ1sł邱ƂmF
     * 
     * assertEquals("cY", rows[0].get("C_NAME"));
     * assertEquals("detat@terasoluna.jp", rows[0].get("C_EMAIL"));
     * UTUtil.assertEqualsDate("2003-01-01", rows[0].get("C_REGIST_DATE"));
     * </pre>
     * 
     * @param tableName e[u
     * @param condition (WHERE)
     * @return sf[^̃Xg
     * @throws SQLException
     */
    public static Map[] select(String tableName, String condition)
            throws SQLException {

        return select(tableName, condition, null);
    }

    /**
     * w肳ꂽe[usf[^擾B
     * <BR><BR>
     * WHEREȍ~ɋLq̂AconditionɎw肷B<BR>
     * ܂AORDER BYȍ~ɋLq̂orderɎw肷B
     * <BR><BR>
     * ߂ĺAsMapIuWFNg̔z񂪕ԂB<BR>
     * MapIuWFNg̒ɂ́AJƃJl̃Zbgi[B
     * <BR><BR>
     * Jlׂ͂String^Ŋi[Bt⎞̒ĺA<BR>
     * "yyyy-mm-dd hh:mm:ss.fffffffff"̃tH[}bg̕Ŋi[B<BR>
     * (java.sql.Timestamp^toString()̃tH[}bgƓB<BR>
     * Ⴆ΁A"2003-01-01 12:00:00.123456789"ȂǂƂȂB)<BR>
     * <BR><BR>
     * ̃\bh𗘗pꍇAڑf[^x[X̏<BR>
     * uutlib.confvt@CɋLqĂKvB
     * 
     * <pre>
     * [gp]
     * Map[] rows = UTUtil.select("CUSTOMER", null, "C_ID");
     * assertEquals(2, rows.length); // ʂ2sł邱ƂmF
     * 
     * assertEquals("cY", rows[0].get("C_NAME"));
     * assertEquals("detat@terasoluna.jp", rows[0].get("C_EMAIL"));
     * UTUtil.assertEqualsDate("2003-01-01", rows[0].get("C_REGIST_DATE"));
     * 
     * assertEquals("ؓY", rows[1].get("C_NAME"));
     * assertEquals("detaj@terasoluna.jp", rows[1].get("C_EMAIL"));
     * UTUtil.assertEqualsDate("2003-05-20", rows[1].get("C_REGIST_DATE"));
     * </pre>
     * 
     * @param tableName e[u
     * @param condition (WHERE)
     * @param order (ORDER BY)
     * @return sf[^̃Xg
     * @throws SQLException
     */
    public static Map[] select(String tableName, String condition,
            String order) throws SQLException {

        return DBAccessUtil.select(tableName, condition, order);
    }

    /**
     * w肳ꂽSQLsB
     * <BR><BR>
     * ̃\bh𗘗pꍇAڑf[^x[X̏<BR>
     * uutlib.confvt@CɋLqĂKvB
     * <BR><BR>
     * XVR~bg邩ǂ́Auunittest.jdbc.autocommitv<BR>
     * uunittest.dbmethods.commitv̎wlɂB
     * 
     * <pre>
     * [gp]
     * UTUtil.executeSQL("DELETE FROM CUSTOMER WHERE C_ID > 50");
     * </pre>
     * 
     * @param sql SQL
     * @throws SQLException
     */
    public static void executeSQL(String sql) throws SQLException {
        DBAccessUtil.executeSQL(sql);
    }



    /*--------------------------------------------------------------------*/


    /**
     * t⎞r邽߂assert[eBeB\bhB
     * <BR><BR>
     * select()́At^̒l"yyyy-mm-dd hh:mm:ss.fffffffff"`<BR>
     * ԋp悤ɂȂĂ邽߁Â܂܂ł͒l̔rÂ炢B<BR>
     * ̂߁Atpassert[eBeB\bhpӂĂB
     * <BR><BR>
     * ut̂݁vAû݁vAut{vAut{{imbvA<BR>
     * ̂ꂩ̃p^[Ŕr邱ƂłB
     * <BR><BR>
     * 
     * <pre>
     * [gp]
     * Map[] rows = UTUtil.select("CUSTOMER", "C_ID=1");
     * UTUtil.assertEqualsTimestamp(
     *     "2004-01-01", rows[0].get("C_REGIST_DATE")); 
     * UTUtil.assertEqualsTimestamp(
     *     "12:00:00", rows[0].get("C_REGIST_DATE")); 
     * UTUtil.assertEqualsTimestamp(
     *     "2004-01-01 12:00:00", rows[0].get("C_REGIST_DATE")); 
     * UTUtil.assertEqualsTimestamp(
     *     "2004-01-01 12:00:00.123456789", rows[0].get("C_REGIST_DATE")); 
     * </pre>
     * 
     * @param expected Ғl
     * @param actual ۂ̒l
     */
    public static void assertEqualsTimestamp(Object expected, Object actual) {        
        AssertUtil.assertEqualsTimestamp(expected, actual);
    }

    /**
     * ݓtƔr邽߂assert[eBeB\bhB
     * <BR><BR>
     * 
     * <pre>
     * [gp]
     * Map[] rows = UTUtil.select("CUSTOMER", "C_ID=1");
     * UTUtil.assertEqualsToday(rows[0].get("C_UPDATE_DATE")); 
     * </pre>
     * 
     * @param actual ۂ̒l
     */
    public static void assertEqualsToday(Object actual) {
        AssertUtil.assertEqualsToday(actual);
    }

    /**
     * t@C̒goCirB
     * 
     * <pre>
     * [gp]
     * class SampleTest extends TestCase {
     *     public void testDoSomething() throws Excepton {
     *         // Ȃ炩̏sʂ̃t@C߂B
     *         File actual = Sample.doSomething();
     * 
     *         // r邽߂̊Ғlf[^̃t@C擾B
     *         // t@Cutlib,confŎw肵tH_ɒuĂB
     *         File expected = UTUtil.getFile("expected.txt");
     * 
     *         // t@C̔rB
     *         UTUtil.assertEqualsFile(expected, actual);
     *     }
     * }
     * </pre>
     * 
     * @param expected Ғl̃t@C
     * @param actual ۂ̒l̃t@C
     */
    public static void assertEqualsFile(File expected, File actual) {
        AssertUtil.assertEqualsFile(expected, actual);
    }

    /**
     * Xgr邽߂assert[eBeB\bhB
     * <BR><BR>
     * XgɃXgA}bvȊÕIuWFNgꍇÃIuWFNg<BR>
     * equals()\bhȂ΁Aʂ𓾂ȂB
     * 
     * <pre>
     * [gp]
     * List aList = new ArrayList();
     * aList.add("this is a test");
     * Lib  bList = new ArrayList();
     * bList.add("this is a test");
     * UTUtil.assertEqualsList(aList,bList);
     * </pre>
     * 
     * @param expected Ғl
     * @param actual ۂ̒l
     */
    public static void assertEqualsList(Object expected,Object actual){
        AssertUtil.assertEqualsList(expected,actual);
    }

    /*--------------------------------------------------------------------*/



    /**
     * eXgf[^Ƃėpt@CFileIuWFNg擾B
     * <BR><BR>
     * t@Ćuutlib.confvt@Ćuunittest.folder.testdatav<BR>
     * w肵tH_ȉɒuĂKvB
     * 
     * @param fileName t@C
     * @return w肳ꂽt@CFileIuWFNgB
     */
    public static File getFile(String fileName) {
        return FileAccessUtil.getFile(fileName);
    }

    /**
     * w肳ꂽCX^Xclasst@CƓtH_ɒuĂ<BR>
     * t@CFileIuWFNg擾B
     * 
     * @param instance NX̃CX^X
     * @param fileName t@C
     * @return w肳ꂽt@CFileIuWFNgB
     * t@C݂ȂꍇnullԂB
     */
    public static File getFile(Object instance, String fileName) {
        return FileAccessUtil.getResourceFile(instance, fileName);
    }


    /*--------------------------------------------------------------------*/




    /**
     * private\bhistaticłȂ́jĂяoB<BR>
     * p[^0`2̃\bhɂ͐p̃\bhpӂĂ̂ŁA<BR>
     * 𗘗pVvɋLqłB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private int calcAdd(int val1, int val2, int val3) {
     *         return val1 + val2 + val3;
     *     }
     * }
     * 
     * class SampleTest {
     *     public void testCalcAdd() {
     *         Sample sample = new Sample();
     *         Integer result = (Integer) UTUtil.invokePrivate(
     *             sample,
     *             "calcAdd",
     *             new Class[] { int.class, int.class, int.class },
     *             new Object[] { new Integer(1), new Integer(2), 
     *                            new Integer(3) }
     *         );
     *         assertEquals(6, result.intValue());
     *     }
     * }
     * </pre>
     * 
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @param argTypes ̌^̔z
     * @param args ̒l̔zBint, boolean̊{f[^^́A<BR>
     * @@Integer, Booleañbp[NXɊi[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB<BR>
     * int, boolean̊{f[^^́AInteger, Booleañbp[NX<BR>
     * Ɋi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Object target, String methodName,
            Class[] argTypes, Object[] args)
            throws Exception {

        return PrivateAccessUtil.invokePrivate(target, methodName, argTypes,
            args);
    }

    /**
     * private\bhistaticłȂ́jĂяoip[^0pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private int getString() {
     *         return "success";
     *     }
     * }
     * 
     * class SampleTest {
     *     public void testGetString() {
     *         Sample sample = new Sample();
     *         String result = 
     *             (String) UTUtil.invokePrivate(sample, "getString"):
     *         assertEquals("success", result);
     *     }
     * }
     * </pre>
     * 
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @return \bh̖߂lBĂяoŃ_ELXgKvB<BR>
     * int, boolean̊{f[^^́AInteger, Booleañbp[NX<BR>
     * Ɋi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Object target, String methodName)
            throws Exception {

        return invokePrivate(target, methodName, new Class[] {},
            new Object[] {});
    }

    /**
     * private\bhistaticłȂ́jĂяoip[^1pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private long square(long val) {
     *         return val ^ 2;
     *     }
     * }
     * 
     * class SampleTest {
     *     public void testSquare() {
     *         Sample sample = new Sample();
     *         Long result = (Long) UTUtil.invokePrivate(
     *             sample, "square", long.class, new Long(2L)):
     *         assertEquals(4, result.longValue());
     *     }
     * }
     * </pre>
     * 
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @param argType ̌^
     * @param arg ̒lBint, boolean̊{f[^^́A<BR>
     * @@Integer, Booleañbp[NXɊi[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB<BR>
     * int, boolean̊{f[^^́AInteger, Booleañbp[NX<BR>
     * Ɋi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Object target, String methodName,
            Class argType, Object arg)
            throws Exception {

        return invokePrivate(target, methodName, new Class[] { argType },
            new Object[] { arg });
    }

    /**
     * private\bhistaticłȂ́jĂяoip[^2pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static int calcAdd(int val1, int val2) {
     *         return val1 + val2;
     *     }
     * }
     * 
     * class SampleTest {
     *     public void testCalcAdd() {
     *         Sample sample = new Sample();
     *         Integer result = (Integer) UTUtil.invokePrivate(
     *             sample,
     *             "calcAdd",
     *             int.class,
     *             int.class,
     *             new Integer(1),
     *             new Integer(2)
     *         );
     *         assertEquals(3, result.intValue());
     *     }
     * }
     * </pre>
     * 
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @param argType1 ̌^
     * @param argType2 ̌^
     * @param arg1 ̒lBint, boolean̊{f[^^́A<BR>
     * @@Integer, Booleañbp[NXɊi[ĒlnKvB
     * @param arg2 ̒lB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB<BR>
     * int, boolean̊{f[^^́AInteger, Booleañbp[NX<BR>
     * Ɋi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Object target, String methodName,
            Class argType1, Class argType2, Object arg1, Object arg2)
            throws Exception {

        return invokePrivate(target, methodName,
            new Class[] { argType1, argType2 }, new Object[] { arg1, arg2 });
    }

    /**
     * staticprivate\bhĂяoB
     * <BR><BR>
     * p[^0`2̃\bhɂ͐p̃\bhpӂĂ̂ŁA<BR>
     * 𗘗pVvɋLqłB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static int calcAdd(int val1, int val2, int val3) {
     *         return val1 + val2 + val3;
     *     }
     * }
     * 
     * class SampleTest {
     *     public void testCalcAdd() {
     *         Integer result = (Integer) UTUtil.invokePrivate(
     *             Sample.class,
     *             "calcAdd",
     *             new Class[] { int.class, int.class, int.class },
     *             new Object[] { new Integer(1), new Integer(2), 
     *                            new Integer(3) }
     *         );
     *         assertEquals(6, result.intValue());
     *     }
     * }
     * </pre>
     * 
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @param argTypes ̌^̔z
     * @param args ̒lBint, boolean̊{f[^^́A<BR>
     * @@Integer, Booleañbp[NXɊi[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB<BR>
     * int, boolean̊{f[^^́AInteger, Booleañbp[NX<BR>
     * Ɋi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Class target, String methodName,
            Class[] argTypes, Object[] args)
            throws Exception {

        return PrivateAccessUtil.invokePrivate(target, methodName, argTypes,
            args);
    }

    /**
     * staticprivate\bhĂяoip[^0pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static int getString() {
     *         return "success";
     *     }
     * }
     * 
     * class SampleTest {
     *     public void testGetString() {
     *         String result = (String) UTUtil.invokePrivate(
     *             Sample.class, "getString"):
     *         assertEquals("success", result);
     *     }
     * }
     * </pre>
     * 
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @return \bh̖߂lBĂяoŃ_ELXgKvB<BR>
     * int, boolean̊{f[^^́AInteger, Booleañbp[NX<BR>
     * Ɋi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Class target, String methodName)
            throws Exception {

        return invokePrivate(target, methodName, new Class[] {}, 
            new Object[] {});
    }

    /**
     * staticprivate\bhĂяoip[^1pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static long square(long val) {
     *         return val ^ 2;
     *     }
     * }
     * 
     * class SampleTest {
     *     public void testSquare() {
     *         Long result = (Long) UTUtil.invokePrivate(
     *             Sample.class, "square", long.class, new Long(2L)):
     *         assertEquals(4, result.longValue());
     *     }
     * }
     * </pre>
     * 
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @param argType ̌^
     * @param arg ̒lBint, boolean̊{f[^^́A<BR>
     * @@Integer, Booleañbp[NXɊi[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB<BR>
     * int, boolean̊{f[^^́AInteger, Booleañbp[NX<BR>
     * Ɋi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Class target, String methodName,
            Class argType, Object arg)
            throws Exception {

        return invokePrivate(target, methodName, new Class[] { argType },
            new Object[] { arg });
    }

    /**
     * staticprivate\bhĂяoip[^2pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static int calcAdd(int val1, int val2) {
     *         return val1 + val2;
     *     }
     * }
     * 
     * class SampleTest {
     *     public void testCalcAdd() {
     *         Integer result = (Integer) UTUtil.invokePrivate(
     *             Sample.class,
     *             "calcAdd",
     *             int.class,
     *             int.class,
     *             new Integer(1),
     *             new Integer(2)
     *         );
     *         assertEquals(3, result.intValue());
     *     }
     * }
     * </pre>
     * 
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @param argType1 ̌^
     * @param argType2 ̌^
     * @param arg1 ̒lBint, boolean̊{f[^^́A<BR>
     * @@Integer, Booleañbp[NXɊi[ĒlnKvB
     * @param arg2 ̒lB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB<BR>
     * int, boolean̊{f[^^́AInteger, Booleañbp[NX<BR>
     * Ɋi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Class target, String methodName,
            Class argType1, Class argType2, Object arg1, Object arg2)
            throws Exception {

        return invokePrivate(target, methodName,
            new Class[] { argType1, argType2 }, new Object[] { arg1, arg2 });
    }

    /**
     * w肵IuWFNgprivatetB[h̒lԂB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private int value = 15;
     * }
     * 
     * class SampleTest {
     *     public void test() {
     *         Sample sample = new Sample();
     *         Integer result = 
     *             (Integer) UTUtil.getPrivateField(sample, "value");
     *         assertEquals(15, result.intValue());
     *     }
     * }
     * </pre>
     *
     * @param target Ώۂ̃IuWFNg
     * @param fieldName l擾privatetB[h̖O
     * @return privatetB[h̒l
     * @exception NoSuchFieldException
     */
    public static Object getPrivateField(Object target, String fieldName)
            throws NoSuchFieldException {
        return PrivateAccessUtil.getField(target, fieldName);
    }

    /**
     * w肵NXstaticprivatetB[h̒lԂB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static int value = 15;
     * }
     * 
     * class SampleTest {
     *     public void test() {
     *         Integer result = 
     *             (Integer) UTUtil.getPrivateField(Sample.class, "value");
     *         assertEquals(15, result.intValue());
     *     }
     * }
     * </pre>
     *
     * @param target Ώۂ̃NX
     * @param fieldName l擾privatetB[h̖O
     * @return privatetB[h̒l
     * @exception NoSuchFieldException
     */
    public static Object getPrivateField(Class target, String fieldName)
            throws NoSuchFieldException {
        return PrivateAccessUtil.getField(target, fieldName);
    }

    /**
     * w肵IuWFNgprivatetB[hɒlݒ肷B
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private int value = 15;
     * }
     * 
     * class SampleTest {
     *     public void test() {
     *         Sample sample = new Sample();
     *         Integer val = new Integer(20);
     *         UTUtil.setPrivateField(sample, "value", val);
     *     }
     * }
     * </pre>
     * 
     * @param target Ώۂ̃IuWFNg
     * @param fieldName lݒ肷privatetB[h̖O
     * @param value ݒ肷lBint,boolean̊{f[^^́A<BR>
     * @@Integer, Booleañbp[NXɊi[ĒlnKvB
     * @exception NoSuchFieldException
     */
    public static void setPrivateField(Object target, String fieldName,
            Object value) 
            throws NoSuchFieldException {
        PrivateAccessUtil.setField(target, fieldName, value);
    }

    /**
     * w肵NXstaticprivatetB[hɒlݒ肷B
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private int value = 15;
     * }
     * 
     * class SampleTest {
     *     public void test() {
     *         Integer val = new Integer(20);
     *         UTUtil.setPrivateField(Sample.class, "value", val);
     *     }
     * }
     * </pre>
     * 
     * @param target Ώۂ̃NX
     * @param fieldName lݒ肷privatetB[h̖O
     * @param value ݒ肷lBint,boolean̊{f[^^́A<BR>
     * @@Integer, Booleañbp[NXɊi[ĒlnKvB
     * @exception NoSuchFieldException
     */
    public static void setPrivateField(Class target, String fieldName,
            Object value) 
            throws NoSuchFieldException {
        PrivateAccessUtil.setField(target, fieldName, value);
    }

    /**
     * w肵VPX̌ݒl擾B
     * <BR><BR>
     * ̃\bh𗘗pꍇAC^tF[XDBSequence̎NX̏<BR>
     * uutlib.confvt@CɋLqĂKvB
     * <BR><BR>
     * [Lq]<BR>
     * unittest.dbsequence.class = jp.terasoluna.utlib.PostgresDBSequence
     * <BR><BR>
     * <b>ӁFDB֐ڑɁAgetSequenceValueĂяoOɁAsetSequenceValue<br>
     * Ă΂ȂƁASQLExceptionB̓VPXIuWFNg̐ɂ̂łB</b>
     * 
     * @param sequenceName VPX
     * @return@VPX̌ݒl
     * 
     * @throws SQLException@DBANZXɗOꍇ
     */
    public static int getSequenceValue(String sequenceName) throws SQLException{
        
        return DBAccessUtil.getSequenceValue(sequenceName);
    }

    /**
     * w肵VPXɒlݒ肷B
     * <BR><BR>
     * ̃\bh𗘗pꍇAC^tF[XDBSequence̎NX̏<BR>
     * uutlib.confvt@CɋLqĂKvB
     * <BR><BR>
     * [Lq]<BR>
     * unittest.dbsequence.class = jp.terasoluna.utlib.PostgresDBSequence
     * 
     * @param sequenceName@VPX
     * @param value@VPXɐݒ肷l
     * 
     * @throws SQLException@DBANZXɗOꍇ
     */
    public static void setSequenceValue(String sequenceName,int value) throws SQLException{
        
        DBAccessUtil.setSequenceValue(sequenceName, value);    
    }
    
    /**
     * privateȃRXgN^B
     */
    private UTUtil() {
    }

}
