/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;

/**
 * {@link jp.terasoluna.fw.validation.ValidationUtil} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ؃WbÑ[eBeBNXB
 * <p>
 *
 * @see jp.terasoluna.fw.validation.ValidationUtil
 */
public class ValidationUtilTest03 extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ValidationUtilTest03.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        UTUtil.setPrivateField(ValidationUtil.class, "hankakuKanaList",
            "¯֬ܦް");
        UTUtil.setPrivateField(ValidationUtil.class, "zenkakuKanaList",
            "ACEGI@BDFHJLNPRKMOQSTVXZ\" +
            "UWY[]^`ceg_adfhijklmnqtwz" +
            "orux{psvy|}~" +
            "b[");
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public ValidationUtilTest03(String name) {
        super(name);
    }

    /**
     * testCheckNumberFigures01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() length:3<br>
     *         () checkLength:0<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * lengthcheckLength傫ꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testCheckNumberFigures01() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.checkNumberFigures(3, 0, false));
    }

    /**
     * testCheckNumberFigures02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() length:0<br>
     *         () checkLength:3<br>
     *         () isAccorded:false<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * isAccordedfalsȅꍇAlengthcheckLengthȉł΁Atrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testCheckNumberFigures02() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.checkNumberFigures(0, 3, false));
    }

    /**
     * testCheckNumberFigures03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() length:3<br>
     *         () checkLength:3<br>
     *         () isAccorded:false<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * isAccordedfalsȅꍇAlengthcheckLengthȉł΁Atrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testCheckNumberFigures03() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.checkNumberFigures(3, 3, false));
    }

    /**
     * testCheckNumberFigures04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() length:3<br>
     *         () checkLength:3<br>
     *         () isAccorded:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * isAccordedtruȅꍇAlengthcheckLengthƓ΁Atrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testCheckNumberFigures04() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.checkNumberFigures(3, 3, true));
    }

    /**
     * testCheckNumberFigures05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() length:0<br>
     *         () checkLength:3<br>
     *         () isAccorded:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * isAccordedtruȅꍇAlengthcheckLengthƓȂ΁Afalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testCheckNumberFigures05() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.checkNumberFigures(0, 3, true));
    }

    /**
     * testIsHankakuKanaString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuenull̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuKanaString01() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isHankakuKanaString(null));
    }

    /**
     * testIsHankakuKanaString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:""<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * value󕶎̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuKanaString02() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isHankakuKanaString(""));
    }

    /**
     * testIsHankakuKanaString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"A"<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valuepJiłȂꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuKanaString03() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isHankakuKanaString("A"));
    }

    /**
     * testIsHankakuKanaString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:""<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuepJȉꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuKanaString04() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isHankakuKanaString(""));
    }

    /**
     * testIsHankakuKanaString05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"A"<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valueŔpJiȊO܂܂ꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuKanaString05() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isHankakuKanaString("A"));
    }

    /**
     * testIsHankakuKanaString06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:""<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valueŔpJî݂ō\ĂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuKanaString06() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isHankakuKanaString(""));
    }

    /**
     * testIsHankakuString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuenull̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuString01() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isHankakuString(null));
    }

    /**
     * testIsHankakuString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:""<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * value󕶎̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuString02() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isHankakuString(""));
    }

    /**
     * testIsHankakuString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:""<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valuepłȂꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuString03() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isHankakuString(""));
    }

    /**
     * testIsHankakuString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"a"<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuep̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuString04() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isHankakuString("a"));
    }

    /**
     * testIsHankakuString05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"ab"<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valueŔpȊO܂܂ꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuString05() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isHankakuString("ab"));
    }

    /**
     * testIsHankakuString06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"1a"<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valueŔp݂̂ō\ĂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuString06() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isHankakuString("1a"));
    }

    /**
     * testIsZenkakuString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuenull̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuString01() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isZenkakuString(null));
    }

    /**
     * testIsZenkakuString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:""<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * value󕶎̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuString02() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isZenkakuString(""));
    }

    /**
     * testIsZenkakuString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"a"<br>
     *         () zenkakuKanaList:ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valueSpłȂꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuString03() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isZenkakuString("a"));
    }

    /**
     * testIsZenkakuString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:""<br>
     *         () zenkakuKanaList:ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valueSp̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuString04() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isZenkakuString(""));
    }

    /**
     * testIsZenkakuString05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"`"<br>
     *         () zenkakuKanaList:ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valueőSpȊO܂܂ꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuString05() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isZenkakuString("`"));
    }

    /**
     * testIsZenkakuString06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"`Sp"<br>
     *         () zenkakuKanaList:ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valueőSp݂̂ō\ĂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuString06() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isZenkakuString("`Sp"));
    }

    /**
     * testIsZenkakuKanaString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuenull̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuKanaString01() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isZenkakuKanaString(null));
    }

    /**
     * testIsZenkakuKanaString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:""<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * value󕶎̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuKanaString02() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isZenkakuKanaString(""));
    }

    /**
     * testIsZenkakuKanaString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"A"<br>
     *         () isZenkakuKanaChar(char):ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valueSpJiłȂꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuKanaString03() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isZenkakuKanaString("A"));
    }

    /**
     * testIsZenkakuKanaString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"A"<br>
     *         () isZenkakuKanaChar(char):ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valueSpJȉꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuKanaString04() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isZenkakuKanaString("A"));
    }

    /**
     * testIsZenkakuKanaString05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"AC"<br>
     *         () isZenkakuKanaChar(char):ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valueőSpJiȊO܂܂ꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuKanaString05() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isZenkakuKanaString("AC"));
    }

    /**
     * testIsZenkakuKanaString06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"ACE"<br>
     *         () isZenkakuKanaChar(char):ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valueőSpJî݂ō\ĂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuKanaString06() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isZenkakuKanaString("ACE"));
    }

}
