/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * L[啶ʂɈ߂̃}bvIuWFNgB
 * 
 */
public class IgnoreCaseMap implements Map {

    private Map<Object, Object> delegateMap;
    
    /**
     * RXgN^ 
     */
    public IgnoreCaseMap() {
        delegateMap = new HashMap<Object, Object>();
    }
    
    /**
     * RXgN^ 2
     * 
     * @param map }bvIuWFNg
     */
    public IgnoreCaseMap(Map<Object, Object> map) {
        delegateMap = map;
    }

    /**
     * }bṽL[ƒl̃}bsO̐ԂB
     * 
     * @return int }bvIuWFNg̒
     */
    public int size() {
        return delegateMap.size();
    }

    /**
     *  }bv}bsOׂč폜B
     */
    public void clear() {
        delegateMap.clear();
    }

    /**
     * }bvL[ƒl̃}bsOێȂꍇ<code>true</code>ԂB
     * 
     * @return boolean
     */
    public boolean isEmpty() {
        return delegateMap.isEmpty();
    }
    
    /**
     * w肳ꂽL[̃}bsO}bvɊ܂܂Ăꍇ<code>true</code>Ԃ
     * 
     * @return boolean
     */
    public boolean containsKey(Object key) {
        if (delegateMap.containsKey(((String) key).toLowerCase())) {
            return true;
        }
        return delegateMap.containsKey(((String) key).toUpperCase());
    }

    /**
     * }bvAw肳ꂽl 1 ȏ̃L[}bsOĂꍇ true ԂB
     * 
     * @return boolean
     */
    public boolean containsValue(Object value) {
        return delegateMap.containsValue(value);
    }

    /**
     * }bvɊi[Ăl̃RNVr[ԂB
     * 
     * @return Collection
     */
    public Collection values() {
        return delegateMap.values();
    }

    /**
     * w肳ꂽ}bvׂ̂Ẵ}bsÕ}bvɃRs[B
     */
    @SuppressWarnings("unchecked")
    public void putAll(Map t) {
        delegateMap.putAll(t);
    }

    /**
     * }bvɊ܂܂Ă}bsÕZbgr[ԂB
     * 
     * @return Set
     */
    public Set entrySet() {
        return delegateMap.entrySet();
    }

    /**
     * }bvɊi[ĂL[̃Zbgr[ԂB
     * 
     * @return Set
     */
    public Set keySet() {
        return delegateMap.keySet();
    }

    /**
     * }bvw肳ꂽL[}bvlԂ܂B
     * 
     * @return Object
     */
    public Object get(Object key) {
        if (delegateMap.containsKey(((String) key).toLowerCase())) {
            return delegateMap.get(((String) key).toLowerCase());
        }
        return delegateMap.get(((String) key).toUpperCase());
    }

    /**
     * ̃L[Ƀ}bsOꍇɁÃ}bsO}bv폜B
     * 
     * @return Object
     */
    public Object remove(Object key) {
        if (delegateMap.containsKey(((String) key).toLowerCase())) {
            return delegateMap.remove(((String) key).toLowerCase());
        }
        return delegateMap.remove(((String) key).toUpperCase());
    }

    /**
     * w肳ꂽlƎw肳ꂽL[̃}bvɊ֘AtB
     * 
     * @return Object
     */
    public Object put(Object key, Object value) {
        return delegateMap.put(key, value);
    }
}
