/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.io;

/**
 * f[^rʂێNXłB
 * 
 */
public class Comparison {
    /**
     * rʂ̗񋓌^łB
     * 
     * @author maki
     * 
     */
    public static enum Result {
        /**
         * rʂƂ\܂B
         */
        EQUAL,
        /**
         * rʂȂƂ\܂B
         */
        NOT_EQUAL
    };

    /**
     * rʂȂꍇ̃bZ[W
     */
    private String message;
    /**
     * r
     */
    private final Result result;

    /**
     * RXgN^
     * 
     * @param result
     *            r
     */
    public Comparison(Result result) {
        this.result = result;
    }

    /**
     * RXgN^
     * 
     * @param result
     *            r
     * @param message
     *            rʂȂꍇ̃bZ[W
     */
    public Comparison(Result result, String message) {
        this.message = message;
        this.result = result;
    }

    /**
     * rʂȂꍇ̃bZ[Wԋp܂B
     * 
     * @return rʂȂꍇ̃bZ[W
     */
    public String getMessage() {
        return message;
    }

    /**
     * rʂԋp܂B
     * 
     * @return r
     */
    public Result getResult() {
        return result;
    }

    /**
     * rʂƂCX^X𐶐܂B
     * 
     * @return rʂƂCX^X
     */
    public static Comparison equal() {
        return new Comparison(Result.EQUAL);
    }

    /**
     * rʂȂƂCX^X𐶐܂B
     * 
     * @return rʂȂƂCX^X
     */
    public static Comparison notEqual() {
        return new Comparison(Result.NOT_EQUAL);
    }

    /**
     * rʂȂƂCX^X𐶐܂B
     * 
     * @param message
     *            rʂȂꍇ̃bZ[W
     * @return rʂȂƂCX^X
     */
    public static Comparison notEqual(String message) {
        return new Comparison(Result.NOT_EQUAL, message);
    }

    @Override
    public String toString() {
        return "Comparison [message=" + message + ", result=" + result + "]";
    }
}
