package jp.terasoluna.fw.collector;

import static org.junit.Assert.*;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

import jp.terasoluna.fw.collector.validate.ValidateErrorStatus;
import jp.terasoluna.fw.collector.validate.ValidationErrorException;
import jp.terasoluna.fw.collector.vo.DataValueObject;
import jp.terasoluna.fw.exception.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AbstractCollectorTest {

    /**
     * Log.
     */
    private static Log logger = LogFactory.getLog(AbstractCollectorTest.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        AbstractCollector.setVerbose(true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractCollector.setVerbose(false);
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    /**
     * 
     */
    @Test
    public void testExecute001() {
        logger.info("testExecute001:Start");
        AbstractCollectorStubHasNext1<AbstractCollectorTestBean> col = new AbstractCollectorStubHasNext1<AbstractCollectorTestBean>();

        // eXg
        try {
            col.execute();
        } catch (SystemException e) {
            assertNotNull(e);
            assertEquals(SystemException.class, e.getClass());
            logger.info("testExecute001:End");
            return;
        }

        fail();
        return;
    }

    /**
     * 
     */
    @Test
    public void testExecute002() {
        logger.info("testExecute002:Start");
        AbstractCollectorStub7<AbstractCollectorTestBean> col = new AbstractCollectorStub7<AbstractCollectorTestBean>();

        // eXg
        try {
            col.execute();
        } catch (SystemException e) {
            assertNotNull(e);
            assertEquals(SystemException.class, e.getClass());
            logger.info("testExecute002:End");
            return;
        }

        fail();
        return;
    }

    /**
     * 
     */
    @Test
    public void testHasNext001() {
        logger.info("testHasNext001:Start");
        AbstractCollectorStubHasNext2<AbstractCollectorTestBean> col = new AbstractCollectorStubHasNext2<AbstractCollectorTestBean>();

        // eXg
        boolean result = col.hasNext();

        assertFalse(result);
        logger.info("testHasNext001:End");
    }

    /**
     * 
     */
    @Test
    public void testHasNext002() {
        logger.info("testHasNext002:Start");
        AbstractCollectorStub3<AbstractCollectorTestBean> col = new AbstractCollectorStub3<AbstractCollectorTestBean>();

        // eXg
        boolean result = col.hasNext();

        assertFalse(result);
        logger.info("testHasNext002:End");
    }

    @Test
    public void testNext001() {
        logger.info("testNext001:Start");
        AbstractCollectorStubNext1<AbstractCollectorTestBean> col = new AbstractCollectorStubNext1<AbstractCollectorTestBean>();

        AbstractCollectorTestBean result = col.next();

        assertNull(result);
        logger.info("testNext001:End");
    }

    @Test
    public void testNext002() {
        logger.info("testNext002:Start");
        AbstractCollectorStubNext2<AbstractCollectorTestBean> col = new AbstractCollectorStubNext2<AbstractCollectorTestBean>();

        @SuppressWarnings("unused")
        AbstractCollectorTestBean result = null;
        try {
            result = col.next();
        } catch (Exception e) {
            assertNotNull(e);
            assertEquals(SystemException.class, e.getClass());
            assertEquals(Exception.class, e.getCause().getClass());
            assertEquals(null, e.getCause().getMessage());
            logger.info("testNext002:End");
            return;
        }

        fail();
    }

    @Test
    public void testNext003() {
        logger.info("testNext003:Start");
        AbstractCollectorStubNext3<AbstractCollectorTestBean> col = new AbstractCollectorStubNext3<AbstractCollectorTestBean>();

        @SuppressWarnings("unused")
        AbstractCollectorTestBean result = null;
        try {
            result = col.next();
        } catch (Exception e) {
            assertNotNull(e);
            assertEquals(SystemException.class, e.getClass());
            assertEquals(Exception.class, e.getCause().getClass());
            assertEquals("hoge", e.getCause().getMessage());
            logger.info("testNext003:End");
            return;
        }

        fail();
    }

    @Test
    public void testNext004() {
        logger.info("testNext004:Start");
        AbstractCollectorStub8<AbstractCollectorTestBean> col = new AbstractCollectorStub8<AbstractCollectorTestBean>();

        AbstractCollectorTestBean result = null;
        result = col.next();

        assertEquals(null, result);
        logger.info("testNext004:End");
        return;
    }

    @Test
    public void testNext005() {
        logger.info("testNext005:Start");
        AbstractCollectorStub9<AbstractCollectorTestBean> col = new AbstractCollectorStub9<AbstractCollectorTestBean>();

        @SuppressWarnings("unused")
        AbstractCollectorTestBean result = null;
        try {
            result = col.next();
        } catch (Exception e) {
            assertNotNull(e);
            assertEquals(SystemException.class, e.getClass());
            assertEquals(Exception.class, e.getCause().getClass());
            assertEquals(null, e.getCause().getMessage());
            logger.info("testNext005:End");
            return;
        }

        fail();
    }

    @Test
    public void testNext006() {
        logger.info("testNext006:Start");
        AbstractCollectorStub10<AbstractCollectorTestBean> col = new AbstractCollectorStub10<AbstractCollectorTestBean>();

        AbstractCollectorTestBean result = null;
        result = col.next();

        assertEquals(null, result);
        logger.info("testNext006:End");
        return;
    }

    @Test
    public void testGetNext001() {
        logger.info("testGetNext001:Start");
        AbstractCollectorStub11<AbstractCollectorTestBean> col = new AbstractCollectorStub11<AbstractCollectorTestBean>();

        AbstractCollectorTestBean result = null;
        result = col.getNext();

        assertEquals(null, result);
        logger.info("testGetNext001:End");
        return;
    }

    @Test
    public void testGetPrevious001() {
        logger.info("testGetPrevious001:Start");
        AbstractCollectorStub15<AbstractCollectorTestBean> col = new AbstractCollectorStub15<AbstractCollectorTestBean>();

        AbstractCollectorTestBean result = null;
        result = col.getPrevious();

        assertEquals(null, result);
        logger.info("testGetPrevious001:End");
        return;
    }

    @Test
    public void testGetCurrent001() {
        logger.info("testGetCurrent001:Start");
        AbstractCollectorStub12<AbstractCollectorTestBean> col = new AbstractCollectorStub12<AbstractCollectorTestBean>();

        AbstractCollectorTestBean result = null;
        result = col.getCurrent();

        assertEquals(null, result);
        logger.info("testGetCurrent001:End");
        return;
    }

    @Test
    public void testRemove001() {
        logger.info("testRemove001:Start");
        AbstractCollectorStub13<AbstractCollectorTestBean> col = new AbstractCollectorStub13<AbstractCollectorTestBean>();

        col.remove();

        assertNotNull(col.queue);
        logger.info("testRemove001:End");
        return;
    }

    @Test
    public void addQueue001() throws InterruptedException {
        logger.info("addQueue001:Start");
        AbstractCollectorStub16<AbstractCollectorTestBean> col = new AbstractCollectorStub16<AbstractCollectorTestBean>();

        col.execute();
        col.addQueue(null);

        assertNotNull(col.getQueue());
        DataValueObject dvo = ((BlockingQueue<DataValueObject>) col.getQueue())
                .poll(1, TimeUnit.MILLISECONDS);
        assertNotNull(dvo);
        assertEquals(ValidationErrorException.class, dvo.getThrowable()
                .getClass());
        logger.info("addQueue001:End");
        return;
    }

    @Test
    public void addQueue002() throws InterruptedException {
        logger.info("addQueue002:Start");
        AbstractCollectorStub17<AbstractCollectorTestBean> col = new AbstractCollectorStub17<AbstractCollectorTestBean>();

        col.execute();
        col.addQueue(null);

        assertNotNull(col.getQueue());
        DataValueObject dvo = ((ConcurrentLinkedQueue<DataValueObject>) col
                .getQueue()).poll();
        assertNotNull(dvo);
        assertEquals(ValidationErrorException.class, dvo.getThrowable()
                .getClass());
        logger.info("addQueue002:End");
        return;
    }

    @Test
    public void addQueue003() throws InterruptedException {
        logger.info("addQueue003:Start");
        AbstractCollectorStub18<AbstractCollectorTestBean> col = new AbstractCollectorStub18<AbstractCollectorTestBean>();
        DataValueObject dvo = new DataValueObject("hoge");

        col.execute();
        col.addQueue(dvo);

        assertNotNull(col.getQueue());
        DataValueObject dvo2 = ((ConcurrentLinkedQueue<DataValueObject>) col
                .getQueue()).poll();
        assertNotNull(dvo2);
        assertEquals("hoge", dvo.getValue());
        logger.info("addQueue003:End");
        return;
    }

    @Test
    public void addQueue004() throws InterruptedException {
        logger.info("addQueue004:Start");
        AbstractCollectorStub19<AbstractCollectorTestBean> col = new AbstractCollectorStub19<AbstractCollectorTestBean>();
        DataValueObject dvo = new DataValueObject("hoge");

        col.execute();
        col.addQueue(dvo);

        assertNotNull(col.getQueue());
        DataValueObject dvo2 = ((ConcurrentLinkedQueue<DataValueObject>) col
                .getQueue()).poll();
        assertNotNull(dvo2);
        assertEquals(ValidateErrorStatus.END, dvo2.getValidateStatus());
        logger.info("addQueue004:End");
        return;
    }

    @Test
    public void testHandleValidationError001() {
        logger.info("testHandleValidationError001:Start");
        AbstractCollectorStub14<AbstractCollectorTestBean> col = new AbstractCollectorStub14<AbstractCollectorTestBean>();

        assertEquals(ValidateErrorStatus.SKIP, col.handleValidationError(null,
                null));
        logger.info("testHandleValidationError001:End");
        return;
    }

    @Test
    public void testGetQueue001() {
        logger.info("testGetQueue001:Start");
        AbstractCollectorStub13<AbstractCollectorTestBean> col = new AbstractCollectorStub13<AbstractCollectorTestBean>();

        assertNull(col.getQueue());
        col.execute();
        assertNotNull(col.getQueue());
        assertEquals(0, col.getQueue().size());
        logger.info("testGetQueue001:End");
        return;
    }

    @Test
    public void testGetSleepWait001() {
        logger.info("testGetSleepWait001:Start");
        AbstractCollectorStub13<AbstractCollectorTestBean> col = new AbstractCollectorStub13<AbstractCollectorTestBean>();

        assertNotNull(col.getSleepWait());
        assertEquals(1, col.getSleepWait());
        logger.info("testGetSleepWait001:End");
        return;
    }

    @Test
    public void testSetSleepWait001() {
        logger.info("testSetSleepWait001:Start");
        AbstractCollectorStub13<AbstractCollectorTestBean> col = new AbstractCollectorStub13<AbstractCollectorTestBean>();

        col.setSleepWait(10);
        assertEquals(10, col.getSleepWait());
        logger.info("testSetSleepWait001:End");
        return;

    }

    // @Test
    // public void testIterator() {
    // fail("܂Ă܂");
    // }
    //
    // @Test
    // public void testSetQueueSize() {
    // // fail("܂Ă܂");
    // }

}
