/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.collector.db;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

import jp.terasoluna.fw.collector.LogId;
import jp.terasoluna.fw.collector.vo.DataValueObject;
import jp.terasoluna.fw.logger.TLogger;

/**
 * QueueingDataRowHandler̎NX<br>
 */
public class QueueingDataRowHandlerImpl implements QueueingDataRowHandler {

    /**
     * Log.
     */
    private static final TLogger LOGGER = TLogger
            .getLogger(QueueingDataRowHandlerImpl.class);

    /** 璷Oo̓tO. */
    protected static AtomicBoolean verboseLog = new AtomicBoolean(false);

    /** 荞݃tO. */
    protected boolean interrupted = false;

    /**
     * OhandleRow\bhɓnꂽIuWFNg
     */
    protected Object prevRow = null;

    /** DBCollector */
    protected DBCollector<?> dbCollector = null;

    /** f[^JEg */
    protected AtomicLong dataCount = new AtomicLong(0);

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.dao.event.DataRowHandler#handleRow(java.lang.Object)
     */
    public void handleRow(Object valueObject) {
        if (!interrupted) {
            delayCollect();
            this.prevRow = valueObject;
        } else {
            // 荞݂L[XLbv
            if (verboseLog.get()) {
                LOGGER.trace(LogId.TAL041003);
            }
        }
    }

    /**
     * OhandleRow\bhɓnꂽ<code>Row</code>f[^L[Ɋi[B
     */
    public void delayCollect() {
        if (this.prevRow != null) {
            if (!interrupted) {
                long dtcnt = this.dataCount.incrementAndGet();
                try {
                    if (this.dbCollector != null) {
                        // 擾IuWFNg1L[ɂ߂
                        this.dbCollector.addQueue(new DataValueObject(
                                this.prevRow, dtcnt));
                    }
                } catch (InterruptedException e) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(LogId.TAL041002, Thread.currentThread().getName());
                    }
                    interrupted = true;
                }
            } else {
                // 荞݂L[XLbv
                if (verboseLog.get()) {
                    LOGGER.trace(LogId.TAL041003);
                }
            }
        }
    }

    /**
     * DBCollectorݒ肷B<br>
     * @param dbCollector DBCollector&lt;?&gt;
     */
    public void setDbCollector(DBCollector<?> dbCollector) {
        this.dbCollector = dbCollector;
    }

    /**
     * 璷Oo̓tOݒ肷B
     * @param verbose 璷Oo̓tO
     */
    public static void setVerbose(boolean verbose) {
        verboseLog.set(verbose);
    }
}
