/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.message;

import org.springframework.context.ApplicationContext;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import jp.terasoluna.fw.batch.message.MessageAccessor;
import jp.terasoluna.fw.batch.util.MessageUtil;
import jp.terasoluna.fw.util.PropertyUtil;
import junit.framework.TestCase;

/**
 * O<br>
 * <br>
 * 
 * Esrc/test/resourcestH_zAppricationResources.properties݂邱ƁB<br>
 * <br>
 * 
 * EvpeBMessageAccessor.default̒lݒ肳Ă邱ƁB<br>
 * <fieldset><legend>batch.propertiesݒ</legend> #bZ[W\[XANZTBean<br>
 * MessageAccessor.default=msgAcc
 * 
 * </fieldset> <br>
 * EBean`t@CɃvpeBŐݒ肳ꂽ̒lBeanݒ肳Ă邱ƁB<br>
 * <fieldset><legend>AdminContext.xmlݒ</legend>
 * 
 * &lt;!-- bZ[WANZT --&gt;<br>
 * &lt;bean id=&quot;msgAcc&quot;
 * class=&quot;jp.terasoluna.fw.batch.message.MessageAccessorImpl&quot;
 * /&gt;
 * 
 * </fieldset> <br>
 * Emessages.propertiest@C݂邱<br>
 * 
 */
public class MessageAccessorImplTest extends TestCase {

	/**
	 * vpeBl擾l
	 */
	private String value = null;

	/**
	 * Reip̃tB[h
	 */
	private ApplicationContext context;

	/**
	 * MessageAccessorNX̃tB[h
	 */
	private MessageAccessor messageAccessor;

	@Override
	protected void setUp() throws Exception {

		// bZ[W\[XANZTBean擾
		context = new ClassPathXmlApplicationContext(
				"beansDef/AdminContext.xml");
		value = PropertyUtil.getProperty("messageAccessor.default");
		messageAccessor = (MessageAccessor) context.getBean(value,
				MessageAccessor.class);
	}

	/**
	 * testGetMessage01()<br>
	 * <br>
	 * OԁFerrors.alphaNumericStringݒ肳Ă邱<br>
	 * <br>
	 * eXgTvFp[^1bZ[WL[ɊY郁bZ[W𐳏Ɏ擾邱Ƃł邱ƂmF<br>
	 * <br>
	 * mFځFvpeBɐݒ肵bZ[W擾Ă邱ƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testGetMessage01() throws Exception {

		String[] args = { "test1" };

		String result = messageAccessor.getMessage("errors.alphaNumericString",
				args);

		assertEquals("test1ɂ͔ppœ͂Ă.", result);
	}

	/**
	 * testGetMessage02()<br>
	 * <br>
	 * OԁFerrors.alphaNumericStringݒ肳Ă邱<br>
	 * <br>
	 * eXgTvFp[^nullݒ肵A
	 * bZ[WL[ɊY郁bZ[W擾Ƃp[^ϊꂸɃbZ[Wԋp邱ƂmF<br>
	 * <br>
	 * mFځFvpeBɐݒ肵bZ[W擾Ă邱ƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testGetMessage02() throws Exception {

		String[] args = { "test1" };

		String result = messageAccessor.getMessage("errors.alphaNumericString",
				null);

		assertEquals("{0}ɂ͔ppœ͂Ă.", result);
	}

	/**
	 * testGetMessage03()<br>
	 * <br>
	 * eXgTvF݂ȂbZ[WL[̏ꍇANoSuchMessageExceptionX[邱ƂmF<br>
	 * <br>
	 * mFځFNoSuchMessageExceptionX[Ă邱ƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testGetMessage03() throws Exception {

		try {
			String result = messageAccessor.getMessage("test", null);
			fail();
		} catch (NoSuchMessageException e) {
			// Ȃ
		}

	}

	/**
	 * testGetMessage03()<br>
	 * <br>
	 * eXgTvFbZ[WL[ɋ󕶎ݒ肵ꍇANoSuchMessageExceptionX[邱ƂmF<br>
	 * <br>
	 * mFځFNoSuchMessageExceptionX[Ă邱ƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testGetMessage04() throws Exception {

		try {
			String result = messageAccessor.getMessage("", null);
			fail();
		} catch (NoSuchMessageException e) {
			// Ȃ
		}
	}

	/**
	 * testGetMessage03()<br>
	 * <br>
	 * eXgTvFbZ[WL[nullݒ肵ꍇANoSuchMessageExceptionX[邱ƂmF<br>
	 * <br>
	 * mFځFNoSuchMessageExceptionX[Ă邱ƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testGetMessage05() throws Exception {

		try {
			String result = messageAccessor.getMessage(null, null);
			fail();
		} catch (NoSuchMessageException e) {
			// Ȃ
		}
	}

}
