package jp.terasoluna.batch.functionsample.b003;

import java.sql.Timestamp;

import jp.terasoluna.fw.dao.UpdateDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * WuǗe[uɂPsǉ鏈
 * 
 */
public class BatchEntryServiceImpl implements BatchEntryService {

	/**
	 * O
	 */
	private static Log log = LogFactory.getLog(BatchEntryServiceImpl.class);

	/**
	 * XVnDAO
	 */
	protected UpdateDAO updateDAO = null;

	/**
	 * XVnDAOݒ肷B
	 * 
	 * @param updateDAO
	 */
	public void setUpdateDAO(UpdateDAO updateDAO) {
		this.updateDAO = updateDAO;
	}

	
	private CommonBean commonBean;

	/**
	 * @param commonBean the commonBean to set
	 */
	public void setCommonBean(CommonBean commonBean) {
		this.commonBean = commonBean;
	}

	/**
	 * WuǗe[uo^
	 * 
	 * @param param
	 *            o^p[^
	 * @return BatchEntryResult o^
	 */
	public BatchEntryResult writeJobTable(BatchEntryParam param) {

		if (log.isDebugEnabled()) {
			log.debug(param.toString());
		}

		// ԋpIuWFNg
		BatchEntryResult result = new BatchEntryResult();

		// Xe[^XiWȕԁj ݒ
		param.setCurAppStatus("0");

		// WuVXeR[h̔
		String jobSysCd = this.commonBean.executeGetSysCodeVariablePrecision(
				"JOB_CONTROL", 10);

		if (jobSysCd != null) {
			// WuVXeR[hݒ
			param.setJobSysCd(jobSysCd);

			// VXe擾
			Timestamp currentTime = this.commonBean.executeGetCurrentTime();

			param.setAddDateTime(currentTime);
			param.setUpdDateTime(currentTime);

			int updateCnt = 0;

			// XVSQLs
			updateCnt = executeUpdateSql("B003002.insertJobTable",
					param);

			if (updateCnt == 1) {
				// I
				result.setEndCode(BATCH_ENTRY_END_CODE_NORMAL);
			} else {
				// ُI
				result.setEndCode(BATCH_ENTRY_END_CODE_ABNORMAL);
			}

			// WuVXeR[hݒ
			result.setJobSysCd(jobSysCd);
		} else {
			// ُI
			result.setEndCode(BATCH_ENTRY_END_CODE_ABNORMAL);
		}

		if (log.isDebugEnabled()) {
			log.debug(result.toString());
		}

		return result;
	}

	/**
	 * XVSQLs.<br>
	 * 
	 * @param sqlId
	 *            SQL-ID
	 * @param param
	 *            p[^IuWFNg
	 * @return 
	 */
	protected int executeUpdateSql(String sqlId, Object param) {
		return this.updateDAO.execute(sqlId, param);
	}

}
