/*
 * Copyright (c) 2011 NTT DATA Corporation
 */

package jp.terasoluna.batch.functionsample.b005;

import java.util.List;


import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * DAO̎sOEs Oo͂邽߂̃C^Zv^B
 * 
 * <p>
 * Oo͂̎́AOperationLoggersB
 * </p>
 * 
 * <p>
 * ̃C^Zv^̓KpύXꍇ́A beanvf"daoLoggingAutoProxy"ҏW邱ƁB
 * </p>
 * 
 */
public class DAOLoggingInterceptor extends LoggingInterceptor {
    /**
     * LogB
     */
    private static Log logger = LogFactory.getLog(DAOLoggingInterceptor.class);

    /**
     * Ώۃ\bhXg.
     */
    private List<String> methodNames = null;

    /**
     * Ώۃ\bhXg.<br>
     * ݒ̏ꍇ͑S\bhΏہB
     * 
     * @param methodNames
     *            the methodNames to set
     */
    public void setMethodNames(List<String> methodNames) {
        this.methodNames = methodNames;
    }

    /**
     * ONX擾AOo͂̔sB
     * 
     * @param invocation
     *            {Ăяo郁\bh
     * @return {Ăяo郁\bȟ
     * @throws Throwable
     *             O
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        OperationLogger operationLogger = getOperationLogger();

        // methodNamesݒ肳Ăꍇ́AΏۂǂB
        if (this.methodNames != null && this.methodNames.size() > 0) {
            String methodName = invocation.getMethod().getName();
            if (!this.methodNames.contains(methodName)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Skip to logging:"
                            + getInvocationDescription(invocation));
                }
                return invocation.proceed();
            }
        }

        // JnȌo
        if (logger.isTraceEnabled()) {
            logger.trace("Start:" + getInvocationDescription(invocation));
        }

        // 샍O(Jn)̏o
        if (operationLogger != null) {
            try {
                operationLogger.logStartDAO(invocation.getThis().getClass(),
                        invocation.getMethod(), invocation.getArguments());
            } catch (Throwable logEx) {
                // čOosɌxOo͂B
                logger.warn("Logging start DAO failed.", logEx);
            }
        }

        try {
            // {Ăяo郁\bhĂяo
            Object rval = invocation.proceed();

            // IȌo
            if (logger.isTraceEnabled()) {
                logger.trace("End:" + getInvocationDescription(invocation));
            }

            // 샍O(I)̏o
            if (operationLogger != null) {
                try {
                    operationLogger.logEndDAO(invocation.getThis().getClass(),
                            invocation.getMethod(), invocation.getArguments(),
                            rval);
                } catch (Throwable logEx) {
                    // čOosɌxOo͂B
                    logger.warn("Logging end DAO failed.", logEx);
                }
            }

            // ʂ̕ԋp
            return rval;

        } catch (Throwable ex) {
            // Oۂ̃Oo
            if (logger.isTraceEnabled()) {
                logger.trace("Exception thrown in:"
                        + getInvocationDescription(invocation), ex);
            }

            // 샍O(O)̏o
            if (operationLogger != null) {
                try {
                    operationLogger.logExceptionDAO(invocation.getThis()
                            .getClass(), invocation.getMethod(), invocation
                            .getArguments(), ex);
                } catch (Throwable logEx) {
                    // čOosɌxOo͂B
                    logger.warn("Logging exception DAO failed.", logEx);
                }
            }

            throw ex;
        }
    }

}
