/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.util;

import jp.terasoluna.fw.batch.message.MessageAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageUtil {
    private static Log log = LogFactory.getLog(MessageUtil.class);
    private static final ThreadLocal<MessageAccessor> messageAccessorLocal = new ThreadLocal();

    public static void setMessageAccessor(MessageAccessor messageAccessor) {
        messageAccessorLocal.set(messageAccessor);
    }

    public static String getMessage(String code) {
        return MessageUtil.getMessage(code, null);
    }

    public static String getMessage(String code, Object[] args) {
        StringBuilder sb;
        String mes = null;
        MessageAccessor ma = messageAccessorLocal.get();
        if (ma != null) {
            try {
                mes = ma.getMessage(code, args);
            }
            catch (Throwable throwable) {}
        } else if (log.isDebugEnabled()) {
            sb = new StringBuilder();
            sb.append("MessageAccessor is not found.");
            log.debug((Object)sb.toString());
        }
        if (mes == null) {
            sb = new StringBuilder();
            sb.append("Message not found. CODE:[");
            sb.append(code);
            sb.append("]");
            return sb.toString();
        }
        return mes;
    }
}

