/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.terasoluna.fw.dao.IllegalClassTypeException;
import jp.terasoluna.fw.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchUtil {
    public static String cat(Object ... args) {
        StringBuilder str = new StringBuilder();
        if (args == null) {
            return null;
        }
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null) {
                str.append(o);
            }
            ++n2;
        }
        return str.toString();
    }

    public static String getInfoLogStartMsg(String jobCd) {
        return BatchUtil.cat("[", jobCd, "] ", "\u51e6\u7406\u958b\u59cb");
    }

    public static String getInfoLogEndMsg(String jobCd) {
        return BatchUtil.cat("[", jobCd, "] ", "\u51e6\u7406\u7d42\u4e86");
    }

    public static TransactionDefinition getTransactionDefinition() {
        return new DefaultTransactionDefinition();
    }

    public static TransactionStatus startTransaction(PlatformTransactionManager tran) {
        return BatchUtil.startTransaction(tran, BatchUtil.getTransactionDefinition(), null);
    }

    public static TransactionStatus startTransaction(PlatformTransactionManager tran, Log log) {
        return BatchUtil.startTransaction(tran, BatchUtil.getTransactionDefinition(), log);
    }

    public static TransactionStatus startTransaction(PlatformTransactionManager tran, TransactionDefinition def) {
        return BatchUtil.startTransaction(tran, def, null);
    }

    public static TransactionStatus startTransaction(PlatformTransactionManager tran, TransactionDefinition def, Log log) {
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)BatchUtil.cat("startTransaction:", tran));
        }
        TransactionStatus stat = null;
        if (tran != null) {
            stat = tran.getTransaction(def);
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)("CurrentConnection(start):" + stat));
        }
        return stat;
    }

    public static Map<String, TransactionStatus> startTransactions(TransactionDefinition tranDef, Map<?, ?> tranMap) {
        return BatchUtil.startTransactions(tranDef, tranMap, null);
    }

    public static Map<String, TransactionStatus> startTransactions(TransactionDefinition tranDef, Map<?, ?> tranMap, Log log) {
        int count = 0;
        HashMap<String, TransactionStatus> statMap = new HashMap<String, TransactionStatus>();
        Set<Map.Entry<?, ?>> entrySet = tranMap.entrySet();
        if (entrySet != null) {
            for (Map.Entry<?, ?> entObj : entrySet) {
                Map.Entry<?, ?> ent;
                String key = null;
                PlatformTransactionManager ptm = null;
                if (entObj instanceof Map.Entry && (ent = entObj) != null) {
                    if (ent.getKey() instanceof String) {
                        key = (String)ent.getKey();
                    }
                    if (ent.getValue() instanceof PlatformTransactionManager) {
                        ptm = (PlatformTransactionManager)ent.getValue();
                    }
                }
                if (ptm == null) continue;
                if (log != null && log.isDebugEnabled()) {
                    log.debug((Object)BatchUtil.cat("startTransaction:", count));
                }
                TransactionStatus trnStat = ptm.getTransaction(tranDef);
                if (statMap != null) {
                    statMap.put(key, trnStat);
                }
                if (log == null || !log.isDebugEnabled()) continue;
                log.debug((Object)BatchUtil.cat("CurrentConnection(start):", trnStat, ",", count));
                ++count;
            }
        }
        return statMap;
    }

    public static void commitTransaction(PlatformTransactionManager tran, TransactionStatus stat) {
        BatchUtil.commitTransaction(tran, stat, null);
    }

    public static void commitTransaction(PlatformTransactionManager tran, TransactionStatus stat, Log log) {
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)BatchUtil.cat("commitTransaction:", stat));
        }
        if (tran != null && stat != null) {
            tran.commit(stat);
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)("CurrentConnection(commit):" + stat));
        }
    }

    public static void commitTransactions(Map<?, ?> tranMap, Map<String, TransactionStatus> statMap) {
        BatchUtil.commitTransactions(tranMap, statMap, null);
    }

    public static void commitTransactions(Map<?, ?> tranMap, Map<String, TransactionStatus> statMap, Log log) {
        int count = 0;
        Set<Map.Entry<?, ?>> entrySet = tranMap.entrySet();
        if (entrySet != null) {
            for (Map.Entry<?, ?> entObj : entrySet) {
                Map.Entry<?, ?> ent;
                String key = null;
                PlatformTransactionManager ptm = null;
                if (entObj instanceof Map.Entry && (ent = entObj) != null) {
                    if (ent.getKey() instanceof String) {
                        key = (String)ent.getKey();
                    }
                    if (ent.getValue() instanceof PlatformTransactionManager) {
                        ptm = (PlatformTransactionManager)ent.getValue();
                    }
                }
                if (ptm == null) continue;
                TransactionStatus trnStat = null;
                if (statMap != null) {
                    trnStat = statMap.get(key);
                }
                if (trnStat == null) continue;
                if (log != null && log.isDebugEnabled()) {
                    log.debug((Object)BatchUtil.cat("commitTransaction:", count, ",", trnStat));
                    log.debug((Object)("CurrentConnection(commit):" + trnStat));
                    ++count;
                }
                ptm.commit(trnStat);
            }
        }
    }

    public static void endTransaction(PlatformTransactionManager tran, TransactionStatus stat) {
        BatchUtil.endTransaction(tran, stat, null);
    }

    public static void endTransaction(PlatformTransactionManager tran, TransactionStatus stat, Log log) {
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)BatchUtil.cat("endTransaction:", stat));
        }
        if (tran != null && stat != null && !stat.isCompleted()) {
            tran.rollback(stat);
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)("CurrentConnection(release):" + stat));
        }
    }

    public static boolean endTransactions(Map<?, ?> tranMap, Map<String, TransactionStatus> statMap) {
        return BatchUtil.endTransactions(tranMap, statMap, null);
    }

    public static boolean endTransactions(Map<?, ?> tranMap, Map<String, TransactionStatus> statMap, Log log) {
        boolean isNormal = true;
        int count = 0;
        Set<Map.Entry<?, ?>> entrySet = tranMap.entrySet();
        if (entrySet != null) {
            for (Map.Entry<?, ?> entObj : entrySet) {
                Map.Entry<?, ?> ent;
                String key = null;
                PlatformTransactionManager ptm = null;
                if (entObj instanceof Map.Entry && (ent = entObj) != null) {
                    if (ent.getKey() instanceof String) {
                        key = (String)ent.getKey();
                    }
                    if (ent.getValue() instanceof PlatformTransactionManager) {
                        ptm = (PlatformTransactionManager)ent.getValue();
                    }
                }
                if (ptm == null) continue;
                TransactionStatus trnStat = null;
                if (statMap != null) {
                    trnStat = statMap.get(key);
                }
                if (trnStat == null || trnStat.isCompleted()) continue;
                if (log != null && log.isDebugEnabled()) {
                    log.debug((Object)BatchUtil.cat("endTransaction:", count, ",", trnStat));
                    log.debug((Object)("CurrentConnection(end):" + trnStat));
                }
                try {
                    ptm.rollback(trnStat);
                }
                catch (TransactionException e) {
                    if (log != null && log.isErrorEnabled()) {
                        log.error((Object)("CurrentConnection(end):" + Integer.toString(count)), (Throwable)e);
                    }
                    isNormal = false;
                }
                if (log != null && log.isDebugEnabled()) {
                    log.debug((Object)("CurrentConnection(release):" + trnStat));
                }
                ++count;
            }
        }
        return isNormal;
    }

    public static Object setSavepoint(TransactionStatus stat) {
        return BatchUtil.setSavepoint(stat, null);
    }

    public static Object setSavepoint(TransactionStatus stat, Log log) {
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)BatchUtil.cat("setSavepoint:", stat));
        }
        Object savepoint = stat.createSavepoint();
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)("CurrentConnection(setSavepoint):" + stat));
        }
        return savepoint;
    }

    public static void releaseSavepoint(TransactionStatus stat, Object savepoint) {
        BatchUtil.releaseSavepoint(stat, savepoint, null);
    }

    public static void releaseSavepoint(TransactionStatus stat, Object savepoint, Log log) {
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)BatchUtil.cat("releaseSavepoint:", stat));
        }
        stat.releaseSavepoint(savepoint);
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)("CurrentConnection(releaseSavepoint):" + savepoint));
        }
    }

    public static void rollbackSavepoint(TransactionStatus stat, Object savepoint) {
        BatchUtil.rollbackSavepoint(stat, savepoint, null);
    }

    public static void rollbackSavepoint(TransactionStatus stat, Object savepoint, Log log) {
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)BatchUtil.cat("rollbackSavepoint:", stat));
        }
        stat.rollbackToSavepoint(savepoint);
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)("CurrentConnection(rollback(savepoint)):" + stat));
        }
    }

    public static void rollbackTransaction(PlatformTransactionManager tran, TransactionStatus stat) {
        BatchUtil.rollbackTransaction(tran, stat, null);
    }

    public static void rollbackTransaction(PlatformTransactionManager tran, TransactionStatus stat, Log log) {
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)BatchUtil.cat("rollback:", stat));
        }
        if (tran != null && stat != null && !stat.isCompleted()) {
            tran.rollback(stat);
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug((Object)("CurrentConnection(rollback):" + stat));
        }
    }

    public static <E> E[] changeListToArray(List<E> list, Class clazz) {
        if (clazz == null) {
            throw new IllegalClassTypeException();
        }
        List<E> castedList = list;
        Object[] retArray = (Object[])Array.newInstance(clazz, castedList.size());
        try {
            castedList.toArray(retArray);
        }
        catch (ArrayStoreException e) {
            throw new IllegalClassTypeException((Throwable)e);
        }
        return retArray;
    }

    public static List<String> getProperties(String propertyName, String grpKey) {
        Properties properties = PropertyUtil.loadProperties((String)propertyName);
        Enumeration propNames = PropertyUtil.getPropertyNames((Properties)properties, (String)grpKey);
        ArrayList<String> propNamesList = Collections.list(propNames);
        Collections.sort(propNamesList);
        ArrayList<String> resultList = new ArrayList<String>();
        for (String key : propNamesList) {
            resultList.add(PropertyUtil.getProperty((String)key));
        }
        return resultList;
    }
}

