/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.executor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.terasoluna.fw.batch.executor.AbstractBatchExecutor;
import jp.terasoluna.fw.batch.executor.vo.BLogicResult;
import jp.terasoluna.fw.batch.executor.vo.BatchJobData;
import jp.terasoluna.fw.batch.util.JobUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SyncBatchExecutor
extends AbstractBatchExecutor {
    private static Log logging = LogFactory.getLog(SyncBatchExecutor.class);
    private static final String JOB_ARG_PARAM_BASE = "JobArgNm";

    protected SyncBatchExecutor() {
    }

    public static void main(String[] args) {
        BLogicResult result = new BLogicResult();
        String jobAppCd = null;
        if (logging.isInfoEnabled()) {
            logging.info((Object)"SyncBatchExecutor START");
        }
        BatchJobData jobRecord = new BatchJobData();
        if (args.length > 0) {
            jobAppCd = args[0];
        }
        int i = 1;
        while (i < args.length && i <= 20) {
            String arg = args[i];
            if (arg != null && arg.length() != 0) {
                SyncBatchExecutor.setParam(jobRecord, JOB_ARG_PARAM_BASE, i, arg);
            }
            ++i;
        }
        if (jobAppCd == null || jobAppCd.length() == 0) {
            jobAppCd = JobUtil.getenv("JOB_APP_CD");
        }
        jobRecord.setJobAppCd(jobAppCd);
        StringBuilder envName = new StringBuilder();
        int i2 = 1;
        while (i2 <= 20) {
            String param = SyncBatchExecutor.getParam(jobRecord, JOB_ARG_PARAM_BASE, i2);
            if (param == null || param.length() == 0) {
                envName.setLength(0);
                envName.append("JOB_ARG_NM");
                envName.append(i2);
                param = JobUtil.getenv(envName.toString());
                if (param != null && param.length() != 0) {
                    SyncBatchExecutor.setParam(jobRecord, JOB_ARG_PARAM_BASE, i2, param);
                }
            }
            ++i2;
        }
        jobRecord.setJobSequenceId(JobUtil.getenv("JOB_SEQ_ID"));
        jobRecord.setErrAppStatus(JobUtil.getenv("BLOGIC_APP_STATUS"));
        jobRecord.setCurAppStatus(JobUtil.getenv("CUR_APP_STATUS"));
        SyncBatchExecutor executor = new SyncBatchExecutor();
        result = executor.executeBatch(jobRecord);
        if (logging.isInfoEnabled()) {
            StringBuilder logSb = new StringBuilder();
            logSb.append("SyncBatchExecutor END");
            logSb.append(" blogicStatus:[");
            logSb.append(result.getBlogicStatus());
            logSb.append("]");
            logging.info((Object)logSb.toString());
        }
        System.exit(result.getBlogicStatus());
    }

    private static String getParam(Object obj, String paramName, int i) {
        String result = null;
        if (obj != null) {
            Method method = null;
            StringBuilder methodName = new StringBuilder();
            methodName.append("get");
            methodName.append(paramName);
            methodName.append(i);
            try {
                method = obj.getClass().getMethod(methodName.toString(), new Class[0]);
            }
            catch (SecurityException e) {
                logging.error((Object)"SecurityException", (Throwable)e);
                return null;
            }
            catch (NoSuchMethodException e) {
                logging.error((Object)"NoSuchMethodException", (Throwable)e);
                return null;
            }
            if (method != null) {
                Object resultObj = null;
                try {
                    resultObj = method.invoke(obj, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    logging.error((Object)"IllegalArgumentException", (Throwable)e);
                    return null;
                }
                catch (IllegalAccessException e) {
                    logging.error((Object)"IllegalAccessException", (Throwable)e);
                    return null;
                }
                catch (InvocationTargetException e) {
                    logging.error((Object)"InvocationTargetException", (Throwable)e);
                    return null;
                }
                if (resultObj instanceof String) {
                    result = (String)resultObj;
                }
            }
        }
        return result;
    }

    private static void setParam(Object obj, String paramName, int i, String value) {
        if (obj != null) {
            Method method = null;
            StringBuilder methodName = new StringBuilder();
            methodName.append("set");
            methodName.append(paramName);
            methodName.append(i);
            try {
                method = obj.getClass().getMethod(methodName.toString(), String.class);
            }
            catch (SecurityException e) {
                logging.error((Object)"SecurityException", (Throwable)e);
                return;
            }
            catch (NoSuchMethodException e) {
                logging.error((Object)"NoSuchMethodException", (Throwable)e);
                return;
            }
            if (method != null) {
                try {
                    method.invoke(obj, value);
                }
                catch (IllegalArgumentException e) {
                    logging.error((Object)"IllegalArgumentException", (Throwable)e);
                    return;
                }
                catch (IllegalAccessException e) {
                    logging.error((Object)"IllegalAccessException", (Throwable)e);
                    return;
                }
                catch (InvocationTargetException e) {
                    logging.error((Object)"InvocationTargetException", (Throwable)e);
                    return;
                }
            }
        }
    }
}

