/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.executor;

import jp.terasoluna.fw.batch.executor.AbstractBatchExecutor;
import jp.terasoluna.fw.batch.executor.vo.BLogicResult;
import jp.terasoluna.fw.batch.executor.vo.BatchJobData;
import jp.terasoluna.fw.batch.util.JobUtil;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public abstract class AbstractJobBatchExecutor
extends AbstractBatchExecutor {
    private static Log log = LogFactory.getLog(AbstractJobBatchExecutor.class);
    protected static final String JOB_INTERVAL_TIME = "polling.interval";
    protected static final String EXECUTOR_END_MONITORING_FILE = "executor.endMonitoringFile";
    protected static final String EXECUTOR_JOB_TERMINATE_WAIT_INTERVAL_TIME = "executor.jobTerminateWaitInterval";
    protected static final long DEFAULT_JOB_INTERVAL_TIME = 1000L;
    protected static final boolean DEFAULT_JOB_AFTER_GC = true;
    protected static final long DEFAULT_EXECUTOR_LOOP_INTERVAL_TIME = 1000L;
    protected static final String DEFAULT_EXECUTOR_END_MONITORING_FILE = null;
    protected static final long DEFAULT_EXECUTOR_QUEUE_CHECK_INTERVAL_TIME = 1000L;
    protected static final long DEFAULT_EXECUTOR_JOB_TERMINATE_WAIT_INTERVAL_TIME = 5000L;
    protected long jobIntervalTime = 1000L;
    protected String executorEndMonitoringFile = DEFAULT_EXECUTOR_END_MONITORING_FILE;
    protected long executorJobTerminateWaitIntervalTime = 5000L;
    protected boolean changeStartStatus = false;

    protected AbstractJobBatchExecutor() {
        this.initParameter();
    }

    protected void initDefaultAppContext() {
        String defaultAppContextName = AbstractJobBatchExecutor.getDefaultBeanFileName();
        if (defaultAppContextName == null || "".equals(defaultAppContextName)) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Bean definition default file name is undefined.");
            }
            return;
        }
        String dataSourceAppContextName = AbstractJobBatchExecutor.getDataSourceBeanFileName();
        if (dataSourceAppContextName == null || "".equals(dataSourceAppContextName)) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Bean definition default file name is undefined.");
            }
            return;
        }
        this.defaultApplicationContext = AbstractJobBatchExecutor.getApplicationContext(defaultAppContextName, dataSourceAppContextName);
        if (this.defaultApplicationContext == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Default application context not found. defaultAppContextName:[");
            sb.append(defaultAppContextName);
            sb.append("],dataSourceAppContextName:[");
            sb.append(dataSourceAppContextName);
            sb.append("]");
            if (log.isErrorEnabled()) {
                log.error((Object)sb.toString());
            }
            return;
        }
    }

    protected void initSystemDatasourceDao() {
        block15: {
            StringBuilder sb;
            String transactionManagerKey;
            block14: {
                String updateDaoKey;
                block13: {
                    if (this.defaultApplicationContext == null) {
                        return;
                    }
                    String queryDaoKey = PropertyUtil.getProperty((String)"systemDataSource.queryDAO");
                    updateDaoKey = PropertyUtil.getProperty((String)"systemDataSource.updateDAO");
                    transactionManagerKey = PropertyUtil.getProperty((String)"systemDataSource.transactionManager");
                    if (queryDaoKey != null && queryDaoKey.length() != 0 && this.defaultApplicationContext.containsBean(queryDaoKey)) {
                        try {
                            this.sysQueryDAO = (QueryDAO)this.defaultApplicationContext.getBean(queryDaoKey, QueryDAO.class);
                        }
                        catch (Throwable e) {
                            if (!log.isErrorEnabled()) break block13;
                            sb = new StringBuilder();
                            sb.append("QueryDAO bean not found. beanName:[");
                            sb.append(queryDaoKey);
                            sb.append("]");
                            log.error((Object)sb.toString(), e);
                        }
                    }
                }
                if (updateDaoKey != null && updateDaoKey.length() != 0 && this.defaultApplicationContext.containsBean(updateDaoKey)) {
                    try {
                        this.sysUpdateDAO = (UpdateDAO)this.defaultApplicationContext.getBean(updateDaoKey, UpdateDAO.class);
                    }
                    catch (Throwable e) {
                        if (!log.isErrorEnabled()) break block14;
                        sb = new StringBuilder();
                        sb.append("UpdateDAO bean not found. beanName:[");
                        sb.append(updateDaoKey);
                        sb.append("]");
                        log.error((Object)sb.toString(), e);
                    }
                }
            }
            if (transactionManagerKey != null && transactionManagerKey.length() != 0 && this.defaultApplicationContext.containsBean(transactionManagerKey)) {
                try {
                    this.sysTransactionManager = (PlatformTransactionManager)this.defaultApplicationContext.getBean(transactionManagerKey, PlatformTransactionManager.class);
                }
                catch (Throwable e) {
                    if (!log.isErrorEnabled()) break block15;
                    sb = new StringBuilder();
                    sb.append("TransactionManager bean not found.");
                    sb.append(" beanName:[");
                    sb.append(transactionManagerKey);
                    sb.append("]");
                    log.error((Object)sb.toString(), e);
                }
            }
        }
        if (this.sysQueryDAO == null && log.isErrorEnabled()) {
            log.error((Object)"queryDAO is null.");
        }
        if (this.sysUpdateDAO == null && log.isErrorEnabled()) {
            log.error((Object)"updateDAO is null.");
        }
        if (this.sysTransactionManager == null && log.isErrorEnabled()) {
            log.error((Object)"transactionManager is null.");
        }
    }

    protected void initParameter() {
        String executorEndMonitoringFileStr;
        String jobIntervalTimeStr = PropertyUtil.getProperty((String)JOB_INTERVAL_TIME);
        if (jobIntervalTimeStr != null && jobIntervalTimeStr.length() != 0) {
            try {
                this.jobIntervalTime = Long.parseLong(jobIntervalTimeStr);
            }
            catch (NumberFormatException e) {
                this.jobIntervalTime = 1000L;
            }
        } else {
            this.jobIntervalTime = 1000L;
        }
        this.executorEndMonitoringFile = (executorEndMonitoringFileStr = PropertyUtil.getProperty((String)EXECUTOR_END_MONITORING_FILE)) != null && executorEndMonitoringFileStr.length() != 0 ? executorEndMonitoringFileStr : DEFAULT_EXECUTOR_END_MONITORING_FILE;
        String executorJobTerminateWaitIntervalTimeStr = PropertyUtil.getProperty((String)EXECUTOR_JOB_TERMINATE_WAIT_INTERVAL_TIME);
        if (executorJobTerminateWaitIntervalTimeStr != null && executorJobTerminateWaitIntervalTimeStr.length() != 0) {
            try {
                this.executorJobTerminateWaitIntervalTime = Long.parseLong(executorJobTerminateWaitIntervalTimeStr);
            }
            catch (NumberFormatException e) {
                this.executorJobTerminateWaitIntervalTime = 5000L;
            }
        } else {
            this.executorJobTerminateWaitIntervalTime = 5000L;
        }
    }

    public BLogicResult executeBatch(String jobSequenceId) {
        BLogicResult result = new BLogicResult();
        boolean st = false;
        if (log.isInfoEnabled()) {
            log.info((Object)("BATCH START jobSequenceId:[" + jobSequenceId + "]"));
        }
        try {
            if (this.sysQueryDAO == null || this.sysUpdateDAO == null || this.sysTransactionManager == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("System sqlMapClient is null.(JOB_SEQ_CD:" + jobSequenceId + ")"));
                }
                BLogicResult bLogicResult = result;
                return bLogicResult;
            }
            BatchJobData jobRecord = JobUtil.selectJob(jobSequenceId, false, this.sysQueryDAO);
            if (jobRecord == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Job Record Not Found.(JOB_SEQ_CD:" + jobSequenceId + ")"));
                }
                BLogicResult bLogicResult = result;
                return bLogicResult;
            }
            if (this.changeStartStatus && !(st = this.startBatchStatus(jobSequenceId, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager))) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Job status update error.(JOB_SEQ_CD:" + jobSequenceId + ")" + " blogicStatus:[" + result.getBlogicStatus() + "]"));
                }
                BLogicResult bLogicResult = result;
                return bLogicResult;
            }
            if (jobRecord.getJobAppCd() != null) {
                jobRecord.setJobAppCd(jobRecord.getJobAppCd().trim());
            }
            result = this.executeBatch(jobRecord);
            if (log.isDebugEnabled()) {
                log.debug((Object)("batchStatus:" + result.getBlogicStatus()));
            }
        }
        finally {
            st = this.endBatchStatus(jobSequenceId, result, this.sysQueryDAO, this.sysUpdateDAO, this.sysTransactionManager);
            if (!st) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Job status update error.(JOB_APP_CD:" + jobSequenceId + ")" + " blogicStatus:[" + result.getBlogicStatus() + "]"));
                }
                return result;
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("BATCH END jobSequenceId:[" + jobSequenceId + "]" + " blogicStatus:[" + result.getBlogicStatus() + "]"));
        }
        return result;
    }

    protected boolean startBatchStatus(String jobSequenceId, QueryDAO queryDAO, UpdateDAO updateDAO, PlatformTransactionManager transactionManager) {
        return this.updateBatchStatus(jobSequenceId, "0", null, queryDAO, updateDAO, transactionManager);
    }

    protected boolean endBatchStatus(String jobSequenceId, BLogicResult result, QueryDAO queryDAO, UpdateDAO updateDAO, PlatformTransactionManager transactionManager) {
        String blogicStatus = null;
        if (result != null) {
            blogicStatus = Integer.toString(result.getBlogicStatus());
        }
        return this.updateBatchStatus(jobSequenceId, "1", blogicStatus, queryDAO, updateDAO, transactionManager);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean updateBatchStatus(String jobSequenceId, String eventCode, String blogicStatus, QueryDAO queryDAO, UpdateDAO updateDAO, PlatformTransactionManager transactionManager) {
        BatchJobData job;
        TransactionStatus tranStatus = null;
        try {
            DefaultTransactionDefinition tranDef = new DefaultTransactionDefinition();
            tranStatus = transactionManager.getTransaction((TransactionDefinition)tranDef);
            if (log.isDebugEnabled()) {
                log.debug((Object)"startTransaction");
            }
            if ((job = JobUtil.selectJob(jobSequenceId, true, queryDAO)) == null) {
                StringBuilder errStr = new StringBuilder();
                errStr.append("Job record Not Found. jobSequenceId:");
                errStr.append(jobSequenceId);
                if (!log.isErrorEnabled()) return false;
                log.error((Object)errStr.toString());
                return false;
            }
        }
        catch (Exception e) {
            if (!log.isErrorEnabled()) return false;
            log.error((Object)"updateBatchStatus Error.", (Throwable)e);
            return false;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            String changeStatus = this.judgmentStatus(job, jobSequenceId, eventCode, blogicStatus);
            if (changeStatus == null) {
                return false;
            }
            if (log.isDebugEnabled()) {
                StringBuilder debugStr = new StringBuilder();
                debugStr.append("\u30b9\u30c6\u30fc\u30bf\u30b9\u66f4\u65b0 jobSequenceId:");
                debugStr.append(jobSequenceId);
                debugStr.append(" changeStatus:");
                debugStr.append(changeStatus);
                log.debug((Object)debugStr.toString());
            }
            JobUtil.updateJobStatus(job.getJobSequenceId(), changeStatus, null, blogicStatus, queryDAO, updateDAO);
            transactionManager.commit(tranStatus);
            if (!log.isDebugEnabled()) return true;
            log.debug((Object)"commitTransaction");
            return true;
        }
    }

    protected String judgmentStatus(BatchJobData job, String jobSequenceId, String eventCode, String blogicStatus) {
        String judge = null;
        judge = "0".equals(eventCode) ? ("0".equals(job.getCurAppStatus()) ? "1" : null) : ("1".equals(job.getCurAppStatus()) ? "2" : null);
        if (judge == null) {
            if (log.isInfoEnabled()) {
                StringBuilder errStr = new StringBuilder();
                errStr.append("\u30b9\u30c6\u30fc\u30bf\u30b9\u304c\u5224\u5b9a\u57fa\u6e96\u5916");
                errStr.append("(\u30b8\u30e7\u30d6\u30b7\u30fc\u30b1\u30f3\u30b9\u30b3\u30fc\u30c9:");
                errStr.append(jobSequenceId);
                errStr.append(" blogic\u306e\u623b\u308a\u5024:");
                errStr.append(blogicStatus);
                errStr.append(" \u30a4\u30d9\u30f3\u30c8:");
                errStr.append(eventCode);
                errStr.append(" \u30b8\u30e7\u30d6\u30ec\u30b3\u30fc\u30c9\u306e\u30b9\u30c6\u30fc\u30bf\u30b9\u5024:");
                errStr.append(job.getCurAppStatus());
                errStr.append(" \u5224\u5b9a:");
                errStr.append(judge);
                errStr.append(")");
                log.info((Object)errStr.toString());
            }
            return null;
        }
        return judge.toString();
    }

    public long getJobIntervalTime() {
        return this.jobIntervalTime;
    }

    public String getExecutorEndMonitoringFile() {
        return this.executorEndMonitoringFile;
    }

    public long getExecutorJobTerminateWaitIntervalTime() {
        return this.executorJobTerminateWaitIntervalTime;
    }

    public void setChangeStartStatus(boolean changeStartStatus) {
        this.changeStartStatus = changeStartStatus;
    }
}

