/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.executor;

import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.terasoluna.fw.batch.blogic.BLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.batch.exception.handler.ExceptionHandler;
import jp.terasoluna.fw.batch.executor.AbstractJobBatchExecutor;
import jp.terasoluna.fw.batch.executor.BatchExecutor;
import jp.terasoluna.fw.batch.executor.vo.BLogicResult;
import jp.terasoluna.fw.batch.executor.vo.BatchJobData;
import jp.terasoluna.fw.batch.message.MessageAccessor;
import jp.terasoluna.fw.batch.util.MessageUtil;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractBatchExecutor
implements BatchExecutor {
    private static Log log = LogFactory.getLog(AbstractJobBatchExecutor.class);
    protected static final String ENV_JOB_SEQ_ID = "JOB_SEQ_ID";
    protected static final String ENV_JOB_APP_CD = "JOB_APP_CD";
    protected static final String ENV_JOB_BEAN_DEFINITION_PATH = "JOB_BEAN_DEFINITION_PATH";
    protected static final int ENV_JOB_ARG_MAX = 20;
    protected static final String ENV_JOB_ARG_NM = "JOB_ARG_NM";
    protected static final String ENV_JOB_ARG_NM1 = "JOB_ARG_NM1";
    protected static final String ENV_JOB_ARG_NM2 = "JOB_ARG_NM2";
    protected static final String ENV_JOB_ARG_NM3 = "JOB_ARG_NM3";
    protected static final String ENV_JOB_ARG_NM4 = "JOB_ARG_NM4";
    protected static final String ENV_JOB_ARG_NM5 = "JOB_ARG_NM5";
    protected static final String ENV_JOB_ARG_NM6 = "JOB_ARG_NM6";
    protected static final String ENV_JOB_ARG_NM7 = "JOB_ARG_NM7";
    protected static final String ENV_JOB_ARG_NM8 = "JOB_ARG_NM8";
    protected static final String ENV_JOB_ARG_NM9 = "JOB_ARG_NM9";
    protected static final String ENV_JOB_ARG_NM10 = "JOB_ARG_NM10";
    protected static final String ENV_JOB_ARG_NM11 = "JOB_ARG_NM11";
    protected static final String ENV_JOB_ARG_NM12 = "JOB_ARG_NM12";
    protected static final String ENV_JOB_ARG_NM13 = "JOB_ARG_NM13";
    protected static final String ENV_JOB_ARG_NM14 = "JOB_ARG_NM14";
    protected static final String ENV_JOB_ARG_NM15 = "JOB_ARG_NM15";
    protected static final String ENV_JOB_ARG_NM16 = "JOB_ARG_NM16";
    protected static final String ENV_JOB_ARG_NM17 = "JOB_ARG_NM17";
    protected static final String ENV_JOB_ARG_NM18 = "JOB_ARG_NM18";
    protected static final String ENV_JOB_ARG_NM19 = "JOB_ARG_NM19";
    protected static final String ENV_JOB_ARG_NM20 = "JOB_ARG_NM20";
    protected static final String ENV_BLOGIC_APP_STATUS = "BLOGIC_APP_STATUS";
    protected static final String ENV_CUR_APP_STATUS = "CUR_APP_STATUS";
    protected static final String SYSTEM_DATASOURCE_QUERY_DAO = "systemDataSource.queryDAO";
    protected static final String SYSTEM_DATASOURCE_UPDATE_DAO = "systemDataSource.updateDAO";
    protected static final String SYSTEM_DATASOURCE_TRANSACTION_MANAGER = "systemDataSource.transactionManager";
    protected static final String BEAN_DEFINITION_ADMIN_CLASSPATH_KEY = "beanDefinition.admin.classpath";
    protected static final String BEAN_DEFINITION_DEFAULT = "beanDefinition.admin.default";
    protected static final String BEAN_DEFINITION_DATASOURCE = "beanDefinition.admin.dataSource";
    protected static final String BEAN_DEFINITION_BUSINESS_CLASSPATH_KEY = "beanDefinition.business.classpath";
    protected static final String PROPERTY_BEAN_FILENAME_SUFFIX = ".xml";
    protected static final String BEAN_MESSAGE_ACCESSOR_DEFAULT = "messageAccessor.default";
    protected static final String DEFAULT_BLOGIC_BEAN_NAME_SUFFIX = "BLogic";
    protected static final String DEFAULT_BLOGIC_EXCEPTION_HANDLER_BEAN_NAME_SUFFIX = "ExceptionHandler";
    protected static final String DEFAULT_BLOGIC_EXCEPTION_HANDLER_BEAN_NAME = "defaultExceptionHandler";
    protected static final String APPLICATION_CONTEXT = "org.springframework.context.support.ClassPathXmlApplicationContext";
    protected static final int ARGUMENT_COUNT = 20;
    protected static ClassLoader cl = null;
    protected QueryDAO sysQueryDAO = null;
    protected UpdateDAO sysUpdateDAO = null;
    protected PlatformTransactionManager sysTransactionManager = null;
    protected ApplicationContext defaultApplicationContext = null;

    static {
        cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            log.error((Object)"Classloader cannot be taken.");
        }
    }

    protected AbstractBatchExecutor() {
        this.init();
    }

    protected void init() {
        this.initDefaultAppContext();
        this.initSystemDatasourceDao();
        this.initDefaultErrorMessage();
    }

    protected void initDefaultAppContext() {
        String defaultAppContextName = AbstractBatchExecutor.getDefaultBeanFileName();
        if (defaultAppContextName == null || "".equals(defaultAppContextName)) {
            log.error((Object)"Bean definition default file name is undefined.");
            return;
        }
        this.defaultApplicationContext = AbstractBatchExecutor.getApplicationContext(defaultAppContextName);
        if (this.defaultApplicationContext == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Default application context not found. defaultAppContextName:[");
            sb.append(defaultAppContextName);
            sb.append("]");
            log.error((Object)sb.toString());
            return;
        }
    }

    protected void initSystemDatasourceDao() {
    }

    protected void initDefaultErrorMessage() {
        if (this.defaultApplicationContext == null) {
            return;
        }
        String value = PropertyUtil.getProperty((String)BEAN_MESSAGE_ACCESSOR_DEFAULT);
        if (value == null) {
            if (log.isWarnEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("MessageAccessor bean not found. beanName:[");
                sb.append(value);
                sb.append("]");
                sb.append(" [");
                sb.append(Thread.currentThread().getName());
                sb.append("]");
                log.warn((Object)sb.toString());
            }
            return;
        }
        if (this.defaultApplicationContext.containsBean(value)) {
            MessageAccessor messageAccessor;
            block12: {
                messageAccessor = null;
                try {
                    messageAccessor = (MessageAccessor)this.defaultApplicationContext.getBean(value, MessageAccessor.class);
                }
                catch (Throwable e) {
                    if (!log.isWarnEnabled()) break block12;
                    StringBuilder sb = new StringBuilder();
                    sb.append("MessageAccessor bean not found. beanName:[");
                    sb.append(value);
                    sb.append("]");
                    log.warn((Object)sb.toString(), e);
                }
            }
            if (messageAccessor != null) {
                MessageUtil.setMessageAccessor(messageAccessor);
                if (log.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("MessageAccessor was found. [");
                    sb.append(Thread.currentThread().getName());
                    sb.append("]");
                    log.debug((Object)sb.toString());
                }
            } else if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("MessageAccessor not found. [");
                sb.append(Thread.currentThread().getName());
                sb.append("]");
                log.debug((Object)sb.toString());
            }
        } else if (log.isWarnEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("MessageAccessor bean not found. beanName:[");
            sb.append(value);
            sb.append("]");
            sb.append(" [");
            sb.append(Thread.currentThread().getName());
            sb.append("]");
            log.warn((Object)sb.toString());
        }
    }

    protected ApplicationContext initJobAppContext(String jobAppCd) {
        ApplicationContext context = null;
        String beanFileName = null;
        beanFileName = this.getBeanFileName(jobAppCd);
        if (log.isDebugEnabled()) {
            log.debug((Object)("ApplicationContext:[" + beanFileName + "]"));
        }
        if (beanFileName != null && beanFileName.length() > 0) {
            context = AbstractBatchExecutor.getApplicationContext(beanFileName);
            if (context == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("ApplicationContext is null. batchBeanFileName:[");
                sb.append(beanFileName);
                sb.append("]");
                log.error((Object)sb.toString());
            }
            if (log.isDebugEnabled() && context != null) {
                log.debug((Object)"ApplicationContext is not null.");
            }
        }
        return context;
    }

    protected void closeApplicationContext(ApplicationContext context) {
        if (context instanceof AbstractApplicationContext) {
            AbstractApplicationContext aac = (AbstractApplicationContext)context;
            aac.close();
            aac.destroy();
        }
    }

    public BLogicResult executeBatch(BatchJobData jobRecord) {
        String jobAppCd;
        String blogicBeanName;
        BLogicResult result = new BLogicResult();
        BLogicParam param = this.convertBLogicParam(jobRecord);
        if (param == null) {
            return result;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)param.toString());
        }
        if ((blogicBeanName = this.getBlogicBeanName(jobAppCd = jobRecord.getJobAppCd())) == null || blogicBeanName.length() == 0) {
            log.error((Object)("Unregistered batch.(JOB_APP_CD:[" + jobRecord.getJobAppCd() + "])"));
            return result;
        }
        String exceptionHandlerBeanName = this.getExceptionHandlerBeanName(jobAppCd);
        if (exceptionHandlerBeanName == null || exceptionHandlerBeanName.length() == 0) {
            log.error((Object)("Unregistered batch.(JOB_APP_CD:[" + jobRecord.getJobAppCd() + "])"));
            return result;
        }
        ApplicationContext context = this.initJobAppContext(jobAppCd);
        try {
            if (blogicBeanName != null && blogicBeanName.length() > 0) {
                result = this.executeBatchClass(blogicBeanName, exceptionHandlerBeanName, param, context);
            }
        }
        finally {
            this.closeApplicationContext(context);
        }
        return result;
    }

    protected BLogicParam convertBLogicParam(BatchJobData jobRecord) {
        BLogicParam param = new BLogicParam();
        param.setJobSequenceId(jobRecord.getJobSequenceId());
        param.setJobAppCd(jobRecord.getJobAppCd());
        boolean ret = this.argumentCopy(jobRecord, param, "JobArgNm");
        if (!ret) {
            return null;
        }
        return param;
    }

    protected static String getDefaultBeanFileName() {
        StringBuilder str = new StringBuilder();
        String classpath = PropertyUtil.getProperty((String)BEAN_DEFINITION_ADMIN_CLASSPATH_KEY);
        String beanFileName = PropertyUtil.getProperty((String)BEAN_DEFINITION_DEFAULT);
        str.append(classpath == null ? "" : classpath);
        str.append(beanFileName == null ? "" : beanFileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Default bean file:" + str.toString()));
        }
        return str.toString();
    }

    protected static String getDataSourceBeanFileName() {
        StringBuilder str = new StringBuilder();
        String classpath = PropertyUtil.getProperty((String)BEAN_DEFINITION_ADMIN_CLASSPATH_KEY);
        String beanFileName = PropertyUtil.getProperty((String)BEAN_DEFINITION_DATASOURCE);
        str.append(classpath == null ? "" : classpath);
        str.append(beanFileName == null ? "" : beanFileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Default bean file:" + str.toString()));
        }
        return str.toString();
    }

    protected BLogicResult executeBatchClass(String blogicBeanName, String exceptionHandlerBeanName, BLogicParam param, ApplicationContext context) {
        BLogicResult result;
        block21: {
            ExceptionHandler exceptionHandler;
            BLogic blogic;
            block20: {
                StringBuilder sb;
                block19: {
                    result = new BLogicResult();
                    blogic = null;
                    exceptionHandler = null;
                    if (context == null) {
                        StringBuilder sb2 = new StringBuilder();
                        sb2.append("ApplicationContext is null.");
                        log.error((Object)sb2.toString());
                        return result;
                    }
                    String findBlogicBeanName = null;
                    if (context.containsBean(blogicBeanName)) {
                        findBlogicBeanName = blogicBeanName;
                    } else if (context.containsBean(Introspector.decapitalize(blogicBeanName))) {
                        findBlogicBeanName = Introspector.decapitalize(blogicBeanName);
                    }
                    if (findBlogicBeanName != null) {
                        try {
                            blogic = (BLogic)context.getBean(findBlogicBeanName, BLogic.class);
                        }
                        catch (Throwable e) {
                            StringBuilder sb3 = new StringBuilder();
                            sb3.append("BLogic bean not found. beanName:[");
                            sb3.append(blogicBeanName);
                            sb3.append("]");
                            log.error((Object)sb3.toString(), e);
                            return result;
                        }
                    }
                    if (blogic == null) {
                        StringBuilder sb4 = new StringBuilder();
                        sb4.append("BLogic bean not found. beanName:[");
                        sb4.append(blogicBeanName);
                        sb4.append("]");
                        log.error((Object)sb4.toString());
                        return result;
                    }
                    String findExceptionHandlerBeanName = null;
                    if (context.containsBean(exceptionHandlerBeanName)) {
                        findExceptionHandlerBeanName = exceptionHandlerBeanName;
                    } else if (context.containsBean(Introspector.decapitalize(exceptionHandlerBeanName))) {
                        findExceptionHandlerBeanName = Introspector.decapitalize(exceptionHandlerBeanName);
                    }
                    if (findExceptionHandlerBeanName != null) {
                        try {
                            exceptionHandler = (ExceptionHandler)context.getBean(findExceptionHandlerBeanName, ExceptionHandler.class);
                        }
                        catch (Throwable e) {
                            if (!log.isTraceEnabled()) break block19;
                            sb = new StringBuilder();
                            sb.append("ExceptionHandler bean not found. beanName:[");
                            sb.append(exceptionHandlerBeanName);
                            sb.append("]");
                            log.trace((Object)sb.toString(), e);
                        }
                    }
                }
                if (exceptionHandler == null && context.containsBean(this.getDefaultExceptionHandlerBeanName())) {
                    try {
                        exceptionHandler = (ExceptionHandler)context.getBean(this.getDefaultExceptionHandlerBeanName(), ExceptionHandler.class);
                    }
                    catch (Throwable e) {
                        if (!log.isTraceEnabled()) break block20;
                        sb = new StringBuilder();
                        sb.append("ExceptionHandler bean not found. beanName:[");
                        sb.append(this.getDefaultExceptionHandlerBeanName());
                        sb.append("]");
                        log.trace((Object)sb.toString(), e);
                    }
                }
            }
            try {
                int blogicStatus = blogic.execute(param);
                result.setBlogicStatus(blogicStatus);
            }
            catch (Throwable e) {
                if (exceptionHandler == null) break block21;
                result.setBlogicStatus(exceptionHandler.handleThrowableException(e));
            }
        }
        return result;
    }

    protected boolean argumentCopy(Object from, Object to, String field) {
        int i = 1;
        while (i <= 20) {
            StringBuilder getterName = new StringBuilder();
            getterName.append("get");
            getterName.append(field);
            getterName.append(i);
            String argument = (String)this.getMethod(from, getterName.toString());
            if (argument != null) {
                StringBuilder setterName = new StringBuilder();
                setterName.append("set");
                setterName.append(field);
                setterName.append(i);
                boolean ret = this.setMethod(to, setterName.toString(), argument);
                if (!ret) {
                    return ret;
                }
            }
            ++i;
        }
        return true;
    }

    protected boolean setMethod(Object obj, String methodName, String argument) {
        if (obj == null) {
            log.error((Object)"Object is null.");
            return false;
        }
        try {
            Method method = obj.getClass().getMethod(methodName, String.class);
            method.invoke(obj, argument);
        }
        catch (SecurityException e) {
            log.error((Object)"setMethod Error.", (Throwable)e);
            return false;
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"setMethod Error.", (Throwable)e);
            return false;
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"setMethod Error.", (Throwable)e);
            return false;
        }
        catch (InvocationTargetException e) {
            log.error((Object)"setMethod Error.", (Throwable)e);
            return false;
        }
        catch (IllegalAccessException e) {
            log.error((Object)"setMethod Error.", (Throwable)e);
            return false;
        }
        return true;
    }

    protected Object getMethod(Object obj, String methodName) {
        Method method = null;
        Object result = null;
        if (obj == null) {
            log.error((Object)"Object is null.");
            return null;
        }
        try {
            method = obj.getClass().getMethod(methodName, new Class[0]);
            result = method.invoke(obj, new Object[0]);
        }
        catch (SecurityException e) {
            log.error((Object)"getMethod Error.", (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"getMethod Error.", (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"getMethod Error.", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            log.error((Object)"getMethod Error.", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            log.error((Object)"getMethod Error.", (Throwable)e);
            return null;
        }
        return result;
    }

    protected static ApplicationContext getApplicationContext(String ... batchBeanFileName) {
        ApplicationContext ctx = null;
        Class<?> clazz = null;
        Constructor<?> constructor = null;
        try {
            clazz = cl.loadClass(APPLICATION_CONTEXT);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"ClassNotFoundException", (Throwable)e);
            return null;
        }
        try {
            Class[] arrClass = new Class[]{String[].class};
            constructor = clazz.getConstructor(arrClass);
        }
        catch (SecurityException e) {
            log.error((Object)"SecurityException", (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"NoSuchMethodException", (Throwable)e);
            return null;
        }
        try {
            Object[] array = new Object[]{batchBeanFileName};
            ctx = (ApplicationContext)constructor.newInstance(array);
            return ctx;
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)"bean definition load error.", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.warn((Object)"bean definition load error.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)"bean definition load error.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.warn((Object)"bean definition load error.", (Throwable)e);
        }
        catch (RuntimeException e) {
            log.warn((Object)"bean definition load error.", (Throwable)e);
        }
        return ctx;
    }

    protected String getBeanFileName(String jobAppCd) {
        StringBuilder str = new StringBuilder();
        String classpath = PropertyUtil.getProperty((String)BEAN_DEFINITION_BUSINESS_CLASSPATH_KEY);
        str.append(classpath == null ? "" : classpath);
        str.append(jobAppCd == null ? "" : jobAppCd);
        str.append(PROPERTY_BEAN_FILENAME_SUFFIX);
        return str.toString();
    }

    protected String getBlogicBeanName(String jobAppCd) {
        StringBuilder str = new StringBuilder();
        if (jobAppCd != null && jobAppCd.length() != 0) {
            str.append(jobAppCd);
            str.append(DEFAULT_BLOGIC_BEAN_NAME_SUFFIX);
        }
        return str.toString();
    }

    protected String getExceptionHandlerBeanName(String jobAppCd) {
        StringBuilder str = new StringBuilder();
        if (jobAppCd != null && jobAppCd.length() != 0) {
            str.append(jobAppCd);
            str.append(DEFAULT_BLOGIC_EXCEPTION_HANDLER_BEAN_NAME_SUFFIX);
        }
        return str.toString();
    }

    protected String getDefaultExceptionHandlerBeanName() {
        return DEFAULT_BLOGIC_EXCEPTION_HANDLER_BEAN_NAME;
    }

    protected ApplicationContext getDefaultApplicationContext() {
        return this.defaultApplicationContext;
    }

    public QueryDAO getSysQueryDAO() {
        return this.sysQueryDAO;
    }

    public UpdateDAO getSysUpdateDAO() {
        return this.sysUpdateDAO;
    }

    public PlatformTransactionManager getSysTransactionManager() {
        return this.sysTransactionManager;
    }
}

