/*
 * Copyright (c) 2011 NTT DATA Corporation
 */

package jp.terasoluna.batch.functionsample.b005;

import java.lang.reflect.Method;
import java.util.Map;

import jp.terasoluna.fw.batch.exception.BatchException;
import jp.terasoluna.fw.exception.SystemException;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ob`̑샍OL^B
 * 
 */
public class OperationLoggerImpl implements OperationLogger {

    /**
     * LogB
     */
    private static Log log = LogFactory.getLog(OperationLoggerImpl.class);

    /**
     * JnO.
     */
    private static int STATUS_START_LOG = 0;

    /**
     * IO.
     */
    private static int STATUS_END_LOG = 1;

    /**
     * OO.
     */
    private static int STATUS_EXCEPTION_LOG = 2;

    /**
     * Ox:fatal
     */
    private static String LOG_LEVEL_FATAL = "fatal";

    /**
     * Ox:error
     */
    private static String LOG_LEVEL_ERROR = "error";

    /**
     * Ox:warn
     */
    private static String LOG_LEVEL_WARN = "warn";

    /**
     * Ox:info
     */
    private static String LOG_LEVEL_INFO = "info";

    /**
     * Ox:debug
     */
    private static String LOG_LEVEL_DEBUG = "debug";

    /**
     * Ox:trace
     */
    private static String LOG_LEVEL_TRACE = "trace";

    /**
     * Ox:none iOo͂Ȃj
     */
    private static String LOG_LEVEL_NONE = "none";

    /**
     * ftHgOx
     */
    private static String DEFAULT_LOG_LEVEL = LOG_LEVEL_INFO;

    /**
     * VXeOG[R[h.
     */
    private static final String SYSTEM_ERROR_MESSAGE_ID = "errors.8004C999";

    /**
     * JnOOx
     */
    private String startLogLevel = DEFAULT_LOG_LEVEL;

    /**
     * IOOx
     */
    private String endLogLevel = DEFAULT_LOG_LEVEL;

    /**
     * OOOxiftHgj
     */
    private String exceptionLogLevel = DEFAULT_LOG_LEVEL;

    /**
     * OOOxiOƂɎwj
     * key : ONX̊SC
     * value : Ox
     */
    private Map<String, String> exceptionLogLevelMap = null;

    /**
     * JnÕOx
     * 
     * @param startLogLevel the startLogLevel to set
     */
    public void setStartLogLevel(String startLogLevel) {
        this.startLogLevel = startLogLevel;
    }

    /**
     * IÕOx
     * 
     * @param endLogLevel the endLogLevel to set
     */
    public void setEndLogLevel(String endLogLevel) {
        this.endLogLevel = endLogLevel;
    }

    /**
     * OÕOxiftHgj
     * 
     * @param exceptionLogLevel the exceptionLogLevel to set
     */
    public void setExceptionLogLevel(String exceptionLogLevel) {
        this.exceptionLogLevel = exceptionLogLevel;
    }

    /**
     * OÕOxiOƂɎwj
     * 
     * @param exceptionLogLevelMap the exceptionLogLevelMap to set
     */
    public void setExceptionLogLevelMap(Map<String, String> exceptionLogLevelMap) {
        this.exceptionLogLevelMap = exceptionLogLevelMap;
    }

    /**
     * DAO̊JnOɃOo͂B
     * 
     * @param clazz
     *            DAÕNX
     * @param method
     *            DAÕ\bh
     * @param argument
     *            DAÖ̔z
     */
    public void logStartDAO(Class<?> clazz, Method method, Object[] argument) {
        outputLog(STATUS_START_LOG, clazz, method, argument, null, null,
                "DAO Start.");
    }

    /**
     * DAO̐IɃOo͂B
     * 
     * @param clazz
     *            DAÕNX
     * @param method
     *            DAÕ\bh
     * @param argument
     *            DAÖ̔z
     * @param ret
     *            DAO̖߂l
     */
    public void logEndDAO(Class<?> clazz, Method method, Object[] argument,
            Object ret) {
        outputLog(STATUS_END_LOG, clazz, method, argument, ret, null,
                "DAO End.");
    }

    /**
     * DAO̗OLb`ɃOo͂B
     * 
     * @param clazz
     *            DAÕNX
     * @param method
     *            DAÕ\bh
     * @param argument
     *            DAÖ̔z
     * @param exception
     *            DAOX[ꂽO
     */
    public void logExceptionDAO(Class<?> clazz, Method method,
            Object[] argument, Throwable exception) {
        outputLog(STATUS_EXCEPTION_LOG, clazz, method, argument, null,
                exception, "DAO Exception.");
    }

    /**
     * BLogic̊JnOɃOo͂B
     * 
     * @param clazz
     *            BLogic̃NX
     * @param method
     *            BLogic̃\bh
     * @param argument
     *            BLogic̈̔z
     */
    public void logStartBLogic(Class<?> clazz, Method method, Object[] argument) {
        outputLog(STATUS_START_LOG, clazz, method, argument, null, null,
                "BLogic Start.");
    }

    /**
     * BLogic̐IɃOo͂B
     * 
     * @param clazz
     *            BLogic̃NX
     * @param method
     *            BLogic̃\bh
     * @param argument
     *            BLogic̈̔z
     * @param ret
     *            BLogic̖߂l
     */
    public void logEndBLogic(Class<?> clazz, Method method, Object[] argument,
            Object ret) {
        outputLog(STATUS_END_LOG, clazz, method, argument, ret, null,
                "BLogic End.");
    }

    /**
     * BLogic̗OLb`ɃOo͂B
     * 
     * @param clazz
     *            BLogic̃NX
     * @param method
     *            BLogic̃\bh
     * @param argument
     *            BLogic̈̔z
     * @param exception
     *            BLogicX[ꂽO
     */
    public void logExceptionBLogic(Class<?> clazz, Method method,
            Object[] argument, Throwable exception) {
        outputLog(STATUS_EXCEPTION_LOG, clazz, method, argument, null,
                exception, "BLogic Exception.");
    }

    /**
     * BLogic̊ւ郍Oo͂B
     * @param logStat 
     * 
     * @param clazz
     *            BLogic̃NX
     * @param method
     *            BLogic̃\bh
     * @param argument
     *            BLogic̈̔z
     * @param ret
     *            BLogic̖߂l̔z(Ĩ^C~OŌĂяoꂽꍇ̂)
     * @param exception
     *            BLogicX[ꂽO(ُĨ^C~OŌĂяoꂽꍇ̂)
     * @param message
     *            bZ[W
     */
    protected void outputLog(int logStat, Class<?> clazz, Method method,
            Object[] argument, Object ret, Throwable exception, String message) {

        if (log.isTraceEnabled()) {
            log.trace("샍Oo͏Jn");
            log.trace("clazzF" + clazz);
            log.trace("methodF" + method);
            log.trace("argumentF" + argument);
            log.trace("retF" + ret);
            log.trace("exceptionF" + exception);
            log.trace("messageF" + message);
        }

        // Ox
        String logLevel = DEFAULT_LOG_LEVEL;
        if (logStat == STATUS_START_LOG) {
            logLevel = startLogLevel;
        } else if (logStat == STATUS_END_LOG) {
            logLevel = endLogLevel;
        } else if (logStat == STATUS_EXCEPTION_LOG) {
            logLevel = exceptionLogLevel;

            // OƂ̃Oxw肳Ăꍇ͎擾
            if (exceptionLogLevelMap != null && exception != null) {
                String className = exception.getClass().getName();
                if (exceptionLogLevelMap.containsKey(className)) {
                    logLevel = exceptionLogLevelMap.get(className);
                }
            }
        }

        // Oo͂邩
        if (isLogEnabled(logLevel)) {

            StringBuilder logData = new StringBuilder(message);
            logData.append(" [");

            // JnO̓p[^o
            if (logStat == STATUS_START_LOG && argument != null) {
                outputStartLogData(logData, argument);
            }

            // IO͌ʃIuWFNgo
            if (logStat == STATUS_END_LOG && ret != null) {
                outputOutputLogData(logData, ret);
            }

            // OO͗Oo
            if (logStat == STATUS_EXCEPTION_LOG && exception != null) {
                // Log4Jo
                outputExceptionLogData(logData, exception);
            }
            logData.append("]");

            // Oo
            outputLog(logLevel, logData, exception);
        }

        if (log.isTraceEnabled()) {
            log.trace("샍Oo͏I");
        }

    }

    /**
     * Oo͂邩
     * 
     * @param logLevel
     * @return
     */
    protected boolean isLogEnabled(String logLevel) {
        if (LOG_LEVEL_TRACE.equalsIgnoreCase(logLevel)) {
            if (log.isTraceEnabled()) {
                return true;
            }
        } else if (LOG_LEVEL_DEBUG.equalsIgnoreCase(logLevel)) {
            if (log.isDebugEnabled()) {
                return true;
            }
        } else if (LOG_LEVEL_INFO.equalsIgnoreCase(logLevel)) {
            if (log.isInfoEnabled()) {
                return true;
            }
        } else if (LOG_LEVEL_WARN.equalsIgnoreCase(logLevel)) {
            if (log.isWarnEnabled()) {
                return true;
            }
        } else if (LOG_LEVEL_ERROR.equalsIgnoreCase(logLevel)) {
            if (log.isErrorEnabled()) {
                return true;
            }
        } else if (LOG_LEVEL_FATAL.equalsIgnoreCase(logLevel)) {
            if (log.isFatalEnabled()) {
                return true;
            }
        } else if (LOG_LEVEL_NONE.equalsIgnoreCase(logLevel)) {
            return false;
        }
        return false;
    }

    /**
     * Oo
     * 
     * @param logLevel
     * @param logData
     * @param exception
     */
    protected void outputLog(String logLevel, StringBuilder logData,
            Throwable exception) {
        if (LOG_LEVEL_TRACE.equalsIgnoreCase(logLevel)) {
            if (log.isTraceEnabled()) {
                if (exception == null) {
                    log.trace(logData.toString());
                } else {
                    log.trace(logData.toString(), exception);
                }
            }
        } else if (LOG_LEVEL_DEBUG.equalsIgnoreCase(logLevel)) {
            if (log.isDebugEnabled()) {
                if (exception == null) {
                    log.debug(logData.toString());
                } else {
                    log.debug(logData.toString(), exception);
                }
            }
        } else if (LOG_LEVEL_INFO.equalsIgnoreCase(logLevel)) {
            if (log.isInfoEnabled()) {
                if (exception == null) {
                    log.info(logData.toString());
                } else {
                    log.info(logData.toString(), exception);
                }
            }
        } else if (LOG_LEVEL_WARN.equalsIgnoreCase(logLevel)) {
            if (log.isWarnEnabled()) {
                if (exception == null) {
                    log.warn(logData.toString());
                } else {
                    log.warn(logData.toString(), exception);
                }
            }
        } else if (LOG_LEVEL_ERROR.equalsIgnoreCase(logLevel)) {
            if (log.isErrorEnabled()) {
                if (exception == null) {
                    log.error(logData.toString());
                } else {
                    log.error(logData.toString(), exception);
                }
            }
        } else if (LOG_LEVEL_FATAL.equalsIgnoreCase(logLevel)) {
            if (log.isFatalEnabled()) {
                if (exception == null) {
                    log.fatal(logData.toString());
                } else {
                    log.fatal(logData.toString(), exception);
                }
            }
        } else if (LOG_LEVEL_NONE.equalsIgnoreCase(logLevel)) {
            // Oo͂Ȃ
        }
    }

    /**
     * JnOo͗pf[^쐬
     * 
     * @param logData
     * @param argument
     */
    protected void outputStartLogData(StringBuilder logData, Object[] argument) {
        // ̎擾
        for (int i = 0; i < argument.length; i++) {
            if (i != 0) {
                logData.append(",");
            }

            if (argument[i] != null) {
                // ̏ꍇ
                if (argument[i] instanceof String) {
                    logData.append((String) argument[i]);
                }
                // v~eBȕꍇ
                else if (argument[i].getClass().isPrimitive()) {
                    logData.append(argument[i]);
                }
                // LȊȌꍇ
                else {
                    Method toStringMethod = null;
                    try {
                        // toString\bh擾
                        toStringMethod = argument[i].getClass().getMethod(
                                "toString");
                    } catch (Throwable e) {
                        // O͖
                    }
                    Class<?> decClass = null;
                    if (toStringMethod != null) {
                        // toString\bh̎NX擾
                        decClass = toStringMethod.getDeclaringClass();
                    }
                    // toString\bhgĂtoString\bh𗘗p
                    if (!Object.class.equals(decClass)) {
                        logData.append(argument[i].toString());
                    } else {
                        // toString\bhȂ̂ŁAToStringBuilder𗘗p
                        try {
                            String str = ToStringBuilder.reflectionToString(
                                    argument[i],
                                    ToStringStyle.SHORT_PREFIX_STYLE);
                            logData.append(str);
                        } catch (Throwable e) {
                            // OȂƂ肠toString
                            logData.append(argument[i].toString());
                        }
                    }
                }
            }
        }
    }

    /**
     * IOo͗pf[^쐬
     * 
     * @param logData
     * @param ret
     */
    protected void outputOutputLogData(StringBuilder logData, Object ret) {
        Method toStringMethod = null;
        try {
            // toString\bh擾
            toStringMethod = ret.getClass().getMethod("toString");
        } catch (Throwable e) {
            // O͖
        }
        Class<?> decClass = null;
        if (toStringMethod != null) {
            // toString\bh̎NX擾
            decClass = toStringMethod.getDeclaringClass();
        }
        // toString\bhgĂtoString\bh𗘗p
        if (!Object.class.equals(decClass)) {
            logData.append(ret.toString());
        } else {
            // toString\bhȂ̂ŁAToStringBuilder𗘗p
            try {
                String str = ToStringBuilder.reflectionToString(ret,
                        ToStringStyle.SHORT_PREFIX_STYLE);
                logData.append(str);
            } catch (Throwable e) {
                // OȂƂ肠toString
                logData.append(ret.toString());
            }
        }
    }

    /**
     * OOo͗pf[^쐬
     * 
     * @param logData 
     * @param exception
     *            ƖEVXeEʗO
     */
    protected void outputExceptionLogData(StringBuilder logData,
            Throwable exception) {
        String message = null;
        String msgcd = SYSTEM_ERROR_MESSAGE_ID;
        String options[] = null;

        if (exception instanceof SystemException) {
            SystemException e = (SystemException) exception;
            msgcd = e.getErrorCode();
            options = e.getOptions();
        } else if (exception instanceof BatchException) {
            BatchException e = (BatchException) exception;
            msgcd = e.getMessageId();
            message = e.getLogMessage();
        } else {
            message = exception.getMessage();
        }

        logData.append(getLogMsg(msgcd, message, options));
    }

    /**
     * ObZ[W擾
     * 
     * @param msgId
     *            bZ[WID
     * @param message
     *            bZ[W
     * @param options 
     * @return String o̓bZ[W
     */
    private static String getLogMsg(String msgId, String message,
            String[] options) {
        StringBuilder sb = new StringBuilder();
        sb.append(msgId);
        sb.append(":");
        sb.append(message);
        if (options != null) {
            sb.append("(");
            for (int i = 0; i < options.length; i++) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(options[i]);
            }
            sb.append("(");
        }
        return sb.toString();
    }
}
