package jp.terasoluna.batch.functionsample.b002;

import jp.terasoluna.fw.batch.blogic.AbstractTransactionBLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.dao.FileQueryDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * t@C-DB֘AWũTv<br>
 * <br>
 * 
 * OFC:\tmpzinput.csvt@Czu邱<br><br>
 * TveFt@Cǂݍ݁ADBɍXVTvB
 * 
 */
public class B002001BLogic extends AbstractTransactionBLogic {

	private Log log = LogFactory.getLog(B002001BLogic.class);

	private static final int BATCH_NORMAL_END = 0;

	@Autowired
	@Qualifier("csvFileQueryDAO")
	private FileQueryDAO csvFileQueryDAO = null;

	@Autowired
	@Qualifier("updateDAO")
	private UpdateDAO updateDAO = null;

	@Override
	public int doMain(BLogicParam arg0) {
		
		//EMPLOYEEe[ȕ
		updateDAO.execute("B002001.deleteEmployees", null);
		
		
		FileLineIterator<CsvRecord> recordIterator = csvFileQueryDAO.execute(
				"C:\\tmp\\input.csv", CsvRecord.class);

		try {

			while (recordIterator.hasNext()) {
				CsvRecord record = recordIterator.next();
				log.info("ID:" + record.getId() + " FIMILYNAME:"
						+ record.getFamilyName() + " FIRSTNAME:"
						+ record.getFamilyName() + " AGE:" + record.getAge());

				updateDAO.execute("B002001.insertEmployees", record);

			}
		} finally {
			// t@C̃N[Y
			recordIterator.closeFile();
		}

		// I
		return BATCH_NORMAL_END;
	}

}
