package jp.terasoluna.batch.functionsample.b004;

import jp.terasoluna.fw.batch.exception.handler.ExceptionHandler;
import jp.terasoluna.fw.batch.util.MessageUtil;
import jp.terasoluna.fw.file.dao.FileException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;

/**
 *  Ǝ̗OnhNXB<br>
 */
public class B004002ExceptionHandler implements ExceptionHandler {

	private Log log = LogFactory.getLog(B004002ExceptionHandler.class);

	public int handleThrowableException(Throwable e) {

		if (e instanceof FileException) {

			log.error(MessageUtil.getMessage("errors.fileexception"));

			log.error("An exception occurred.",e);
			
			
			return 100;

		} else if (e instanceof DataAccessException) {

			log.error(MessageUtil.getMessage("errors.dataaccessexception"));
			log.error("An exception occurred.",e);

			return 200;

		} else {

			log.error(MessageUtil.getMessage("errors.runtimeexception"));
			log.error("An exception occurred.",e);
			return 255;
		}

	}
}
