/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.springsupport.init;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.init.JobRequestInfo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p>WuNpNXB</p>
 * 
 * <p>̃NX <code>main()</code> \bhŃWuN邱ƂłB</p>
 * 
 * <p>̃NXŃWuNۂɂ́AȉŎw肷B</p>
 *
 * <ul>
 * <li>PFWu<code>ID</code>iK{j</li>
 *   <p>sΏۃWuӂɎʂWuIDw肷B</p>
 * <li>QFWuBean`t@C̑΃pXiK{j</li>
 *   <p>sΏۃWȕ񂪐ݒ肳ĂWu<code>Bean</code>
 *   `t@C̑΃pXB</p>
 *   <p>WuBean`t@C̓NX[_œǂݍ܂邽߁ANXpXƂ
 *   w肷B
 *   <p>Ƃ΁AubatchappsvƂtH_zɃWuBean`t@Cu
 *   ĂāAubatchappsv̑΃pXw肷B</p>
 *   <p>w̃WuBean`t@C݂Ȃꍇ̓G[ƂďIB</p>
 * <li>Rȍ~Fp[^l<td>iCӁj</li>
 *   <p>w肳ꂽl̓Wuݒ莞Ɏw肵WuReLXgɊi[B</p>
 *   <p>̑OɁu-pvw肷邱ƂŋNWũWuvZXIDw肷
 *   ƂłB</p>
 * <li>VMFȕIR[hiCӁj</li>
 *   <p>Av̏IR[h'1'̏ꍇA-DIvV𗘗p
 *   jp.terasoluan.fw.batch.jobExitCode1=(Cӂ̏IR[h)ݒ肷邱Ƃ
 *   Cӂ̏IR[hɒu邱ƂłBݒ肳ĂȂꍇ͒uꂸ
 *   IR[h'1'̂܂ܕԋpB
 *   </p>
 * </ul>
 * 
 * <p>N</p>
 * <code>java -Djp.terasoluna.fw.batch.jobExitCode1=0 jp.terasoluna....JobStarter 
 * JOB0001 UD001/JOB0001.xml PARAM01 PARAM02 PARAM03 PARAM04 -p PS0001</code>
 *
 * <p>WuReLXg<p>
 * <pre><code>public class SampleJobParameter extends JobContext {
 *     private String company = null;
 *     private Date startDay = null;
 *     private Date endDay = null;
 *     private String fileName = null;
 *     private List&lt;String&gt; fileData = null;
 *     public void setParameter(String[] arg) {
 *         company = arg[0];
 *         startDay = DateFormat.getTimeInstance().parse(arg[1]);
 *         endDay = DateFormat.getTimeInstance().parse(arg[2]);
 *         Properties p = new Properties();
 *         fileName = arg[3];
 *         FileInputStream fis = new FileInputStream(fileName);
 *         p.load(fis);
 *     }
 *     
 *     public String getCompany(){
 *         return company;
 *     }
 *     public Date getStartDay(){
 *            return startDay;
 *     }
 *     public Date getEndDay(){
 *         return endDay;
 *     }
 *     public List&lt;String&gt; getFileData(){
 *         return fileData;
 *     }
 *     public String getFileName() {
 *         return fileName;
 *     }
 *     
 *}</code></pre>
 * </ul>
 *
 */
public class JobStarter {

    /**
     * OCX^XB
     */
    private static final Log log = LogFactory.getLog(JobStarter.class);

    /**
     * VXevpeBŎw肳ꂽIR[hL[
     */
    private static final String EXITCODE_KEY = "jp.terasoluna.fw.batch.jobExitCode1";

    /**
     * uΏۏIR[h
     */
    private static final int REPLACEMENT_EXIT_CODE = 1;

    /**
     * WuNpMain\bhB
     *
     * @param args 
     *            N̈<BR>
     *            PFWuID<BR>
     *            QFWuBean`t@C̑΃pX<BR>
     *            Rȍ~FWuReLXgi[p<BR>
     *            -pȍ~̈̓WuvZXID<BR>
     * @throws Throwable Throwable
     */
    public static void main(String[] args) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("START Batch");
        }
        JobStarter jobStarter = new JobStarter();
        int exitCode = jobStarter.execute(args);

        if (log.isDebugEnabled()) {
            log.debug("END Batch");
        }
        System.exit(exitCode);
    }

    /**
     * Ŏw肳ꂽp[^ɃWusB
     * IR[h'1'ꍇAVXevpeB̒lɒuB<br>
     * VXevpeBݒ肳ĂȂꍇ͒uȂB<br>
     * 
     * @param args 
     *            N̈<BR>
     *            PFWuID<BR>
     *            QFWuBean`t@C̑΃pX<BR>
     *            Rȍ~FWuReLXgi[p<BR>
     *            -pȍ~̈̓WuvZXID<BR>
     * @return WuIR[h
     * @throws Throwable Throwable
     */
    protected int execute(String[] args) throws Throwable {
        int exitCode = 0;

        JobExecutor jobExecutor = null;

        JobStatus jobStatus = null;
        try {
            jobExecutor = new JobExecutor();
            
            JobRequestInfo jobInfo = new JobRequestInfo(args);
            jobInfo.init();
            
            // IR[hu邩ۂ
            boolean isReplaceFlag = false;
            // IR[hVXevpeB擾
            String propExitCode = System.getProperty(EXITCODE_KEY);
            // uWuIR[h
            int replaceExitCode = 1;
            // IR[hu鏀
            if (propExitCode != null) {
                try {
                    replaceExitCode = Integer.parseInt(propExitCode);
                    isReplaceFlag = true;    
                } catch (NumberFormatException e) {
                    printIlligalChangeExitCodeLog(jobInfo, propExitCode, e);
                    // VMُI𖾎Iɍs
                    return replaceExitCode;
                }
            }
            // Wus
            jobStatus = jobExecutor.execute(jobInfo);
            // WuIR[h擾
            exitCode = jobStatus.getJobExitCode();
            // IvVŎw肳ꂽIR[h֒u
            if (isReplaceFlag && exitCode == REPLACEMENT_EXIT_CODE ) {
                printChangeExitCodeLog(jobInfo, replaceExitCode);
                exitCode = replaceExitCode;
            }
        } catch (Throwable throwable) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Critical Error!! ");
            logStr.append(throwable.getMessage());
            log.error(logStr.toString(), throwable);
            throw throwable;
        } finally {
            try {
                if (jobExecutor != null) {
                    jobExecutor.destroy();
                }
            } catch (Throwable throwable) {
                StringBuilder logStr = new StringBuilder();
                logStr.append("Critical Error!! ");
                logStr.append(throwable.getMessage());
                log.error(logStr.toString(), throwable);
                throw throwable;
            }
        }
        return exitCode;
    }

    /**
     * IR[hũOo͂B
     * @param jobInfo Wu˗
     * @param replaceExitCode uIR[h
     */
    protected void printChangeExitCodeLog(JobRequestInfo jobInfo,
            int replaceExitCode) {
        if (log.isInfoEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("The job's exitCode is replaced from 1 with ");
            logStr.append(replaceExitCode);
            logStr.append(" : [jobId=");
            logStr.append(jobInfo.getJobId());
            logStr.append("] [jobDiscriptPath=");
            logStr.append(jobInfo.getJobDiscriptorPath());
            logStr.append("]");
            log.info(logStr.toString());
        }
    }
    
    /**
     * IR[hũG[Oo͂B
     * @param jobInfo Wȕ
     * @param propExitCode uIR[h
     * @param e O
     */
    protected void printIlligalChangeExitCodeLog(JobRequestInfo jobInfo,
            String propExitCode, NumberFormatException e) {
        StringBuilder logStr = new StringBuilder();
        logStr.append("The job's exitCode could not be replaced from 1 with ");
        logStr.append(propExitCode);
        logStr.append(" because replacementExitCode wasn't set by a number : [jobId=");
        logStr.append(jobInfo.getJobId());
        logStr.append("] [jobDiscriptPath=");
        logStr.append(jobInfo.getJobDiscriptorPath());
        logStr.append("]");
        log.error(logStr.toString(), e);
    }
}
