/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.commonj;

import java.util.LinkedHashMap;

import org.springframework.scheduling.commonj.DelegatingWork;

import jp.terasoluna.fw.batch.commonj.listener.WorkMapListener;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobExceptionHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;
import jp.terasoluna.fw.batch.standard.QueueProcessor;
import jp.terasoluna.fw.batch.standard.RunnableQueueProcessor;

import commonj.work.WorkException;
import commonj.work.WorkItem;
import commonj.work.WorkManager;
import commonj.work.WorkRejectedException;

/**
 * <code>WorkerExecutorService</code> C^tF[XCommonjpNXB
 * 
 * <p>
 * <code>WorkManager</code> Ń[JsB
 * </p>
 * 
 * @deprecated
 */
public class WorkManagerExecutorService implements WorkerExecutorService {

    /**
     * [N}l[WB
     */
    private WorkManager workManager = null;
    
    /**
     * [NXi[B
     */
    private WorkMapListener workMapListener = null;
    
    /**
     * Onhi[}bvB
     */
    private LinkedHashMap<JobException, JobExceptionHandler> 
        exceptionHandlerMap = null;

    /**
     * ftHgOnhB
     */
    private JobExceptionHandler defaultJobExceptionHandler = null;

    /**
     * ThrowablenhB
     */
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler(); 

    /**
     * Worker̎so^B
     * 
     * @param queueProcessor L[vZbT
     * @param workQueue L[
     * @param jobStatus WuXe[^X
     * @return [J̏ʂɔ񓯊ŃANZX邽߂̃[NACe
     */
    public WorkItem submit(QueueProcessor queueProcessor, WorkQueue workQueue,
            JobStatus jobStatus) {
        try {
            DelegatingWork work = new DelegatingWork(
                    new RunnableQueueProcessor(queueProcessor, workQueue,
                            jobStatus, exceptionHandlerMap,
                            defaultJobExceptionHandler, throwableHandler));
            if (workMapListener == null) {
                return workManager.schedule(work);
            } else {
                WorkItem workItem = workManager.schedule(work, workMapListener);
                workMapListener.addWork(workItem, work);
                return workItem;
            }
        } catch (IllegalArgumentException e) {
            throw new JobException(e);
        } catch (WorkRejectedException e) {
            throw new JobException(e);
        } catch (WorkException e) {
            throw new JobException(e);
        }
    }

    /**
     * ftHgOnh̎擾B
     * 
     * @return ftHgOnh
     */
    public JobExceptionHandler getDefaultJobExceptionHandler() {
        return defaultJobExceptionHandler;
    }
    
    /**
     * ftHgOnh̐ݒB
     * 
     * @param defaultJobExceptionHandler ftHgOnh
     */
    public void setDefaultJobExceptionHandler(
            JobExceptionHandler defaultJobExceptionHandler) {
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }

    /**
     * Onhi[}bv̎擾B
     * 
     * @return Onhi[}bv
     */
    public LinkedHashMap<JobException, JobExceptionHandler> 
        getExceptionHandlerMap() {
        return exceptionHandlerMap;
    }

    /**
     * Onhi[}bv̐ݒB
     * 
     * @param exceptionHandlerMap Onhi[}bv
     */
    public void setExceptionHandlerMap(
            LinkedHashMap<JobException, JobExceptionHandler> 
                exceptionHandlerMap) {
        this.exceptionHandlerMap = exceptionHandlerMap;
    }

    /**
     * [N}l[W̎擾B
     * 
     * @return [N}l[W
     */
    public WorkManager getWorkManager() {
        return workManager;
    }

    /**
     * [N}l[W̐ݒB
     * 
     * @param workManager [N}l[W
     */
    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    /**
     * [NXi[̎擾B
     * 
     * @return [NXi[
     */
    public WorkMapListener getWorkMapListener() {
        return workMapListener;
    }

    /**
     * [NXi[̐ݒB
     * 
     * @param workMapListener [NXi[
     */
    public void setWorkMapListener(WorkMapListener workMapListener) {
        this.workMapListener = workMapListener;
    }

    /**
    * Throwablenhݒ肷B
    * 
    * @param throwableHandler
    *            Throwablenh
    */
   public void setThrowableHandler(ThrowableHandler throwableHandler) {
       this.throwableHandler = throwableHandler;
   }

}
