/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.functionsample.sample002;

import java.util.Date;

import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.annotation.InputFileColumn;
import jp.terasoluna.fw.file.annotation.OutputFileColumn;

/**
 * gf[^t@Chpt@CsIuWFNgBiŒ蒷t@Cisjj
 */
@FileFormat(overWriteFlg = true)
public class Sample002NyukinData03 {

    /**
     * ID
     */
    @InputFileColumn(columnIndex = 0, bytes = 2)
    private int id;

    /**
     * xX
     */
    @InputFileColumn(columnIndex = 1, bytes = 4)
    private String siten;

    /**
     * ڋqR[h
     */
    @InputFileColumn(columnIndex = 2, bytes = 3)
    @OutputFileColumn(columnIndex = 0, bytes = 3)
    private String kokyakucd;

    /**
     * z
     */
    @InputFileColumn(columnIndex = 3, bytes = 5)
    @OutputFileColumn(columnIndex = 1, bytes = 5)
    private int nyukin;

    /**
     * 
     */
    @InputFileColumn(columnIndex = 4, bytes = 10, columnFormat = "yyyy-MM-dd")
    @OutputFileColumn(columnIndex = 2, bytes = 10, columnFormat = "yyyy/MM/dd")
    private Date torihikibi;

    /**
     * IDԋpB
     * @return ID
     */
    public int getId() {
        return id;
    }

    /**
     * IDݒ肷B
     * @param id ID
     */
    public void setId(int id) {
        this.id = id;
    }

    /**
     * xXԋpB
     * @return xX
     */
    public String getSiten() {
        return siten;
    }

    /**
     * xXݒ肷B
     * @param siten xX
     */
    public void setSiten(String siten) {
        this.siten = siten;
    }

    /**
     * ڋqIDԋpB
     * @return ڋqID
     */
    public String getKokyakucd() {
        return kokyakucd;
    }

    /**
     * ڋqIDݒ肷B
     * @param kokyakucd ڋqID
     */
    public void setKokyakucd(String kokyakucd) {
        this.kokyakucd = kokyakucd;
    }

    /**
     * zԋpB
     * @return z
     */
    public int getNyukin() {
        return nyukin;
    }

    /**
     * zݒ肷B
     * @param nyukin z
     */
    public void setNyukin(int nyukin) {
        this.nyukin = nyukin;
    }

    /**
     * ԋpB
     * @return 
     */
    public Date getTorihikibi() {
        return torihikibi;
    }

    /**
     * ݒ肷B
     * @param torihikibi 
     */
    public void setTorihikibi(Date torihikibi) {
        this.torihikibi = torihikibi;
    }
}
