/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.functionsample.sample005;

import jp.terasoluna.fw.batch.core.AbstractCollector;
import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.dao.FileQueryDAO;
import jp.terasoluna.batch.functionsample.common.ZandakaData;

/**
 * t@CRN^[NXB
 * Q̓̓t@CuڋqR[hvŃ}[WB
 */
public class Sample005FileCollector extends AbstractCollector {

    /**
     * t@CANZXpDAOB
     * SpringɂCX^Xݒ肳B
     */
    private FileQueryDAO fileDao = null;

    /**
     * ʃNXB
     * SpringɂCX^Xݒ肳B
     */
    private Object resultClass = null;

    /**
     * t@C1B
     * SpringɂCX^Xݒ肳B
     */
    private String fileName1 = null;
    
    /**
     * t@C2B
     * SpringɂCX^Xݒ肳B
     */
    private String fileName2 = null;
    
         
    @Override
    protected CollectorResult doCollect(JobContext jobContext,
        CollectedDataHandler handler, JobStatus jobStatus) {
    
        // ύs̃JEg
        int collected = 0;

        //t@CsIuWFNgێCe[^擾
        FileLineIterator fileLineIterator = fileDao.execute(fileName1,
            resultClass.getClass());

        FileLineIterator fileLineIterator2 = fileDao.execute(fileName2,
            resultClass.getClass());
       
        
        try {
            
            ZandakaData zandaka1 = new ZandakaData();
            ZandakaData zandaka2 = new ZandakaData();

            if(fileLineIterator.hasNext()){
        	zandaka1 = (ZandakaData)fileLineIterator.next();
            }
            
            if(fileLineIterator2.hasNext()){
        	zandaka2 = (ZandakaData)fileLineIterator2.next();
            }
            
            //}[W    
            while (fileLineIterator.hasNext() 
        	    && fileLineIterator2.hasNext()) {
     
                ZandakaData mergeZandaka = new ZandakaData();
                
        	//ڋqR[hIɔr
        	int compareTo = zandaka1.getKokyakucd().compareTo(
        		zandaka2.getKokyakucd());
        	
        	//ڋqR[h
        	if(compareTo == 0){

        	    //c𑫂
        	    mergeZandaka.setKokyakucd(zandaka1.getKokyakucd());
        	    mergeZandaka.setZandaka(zandaka1.getZandaka() 
        		    + zandaka2.getZandaka());
        	    zandaka1 = (ZandakaData)fileLineIterator.next();
        	    zandaka2 = (ZandakaData)fileLineIterator2.next();

        	//1߂̌ڋqR[h2߂菬
        	}else if(compareTo < 0){
        	    mergeZandaka = zandaka1;
        	    zandaka1 = (ZandakaData)fileLineIterator.next();

        	//1߂̌ڋqR[h2߂傫
        	}else{
        	    mergeZandaka = zandaka2;
        	    zandaka2 = (ZandakaData)fileLineIterator2.next();
        	}
        	
        	handler.handle(mergeZandaka, collected++);
        	jobStatus.incrementCollected();

            }

            //cf[^̏
            while(fileLineIterator.hasNext()){
        	zandaka1 = (ZandakaData)fileLineIterator.next();
        	handler.handle(zandaka1, collected++);
        	jobStatus.incrementCollected();
            }
            while(fileLineIterator2.hasNext()){
        	zandaka2 = (ZandakaData)fileLineIterator2.next();
        	handler.handle(zandaka2, collected++);
        	jobStatus.incrementCollected();
            }
            
            //RN^[ʃIuWFNgԋp
            CollectorResult result 
            	= new CollectorResult(ReturnCode.NORMAL_END, collected);
            return result;
            
        } catch (FileException e) {
            throw e;
        } finally {
            fileLineIterator.closeFile();
            fileLineIterator2.closeFile();
        }
    }

    /**
     * FileQueryDAOݒ肷B
     * @param fileDao FileQueryDAO
     */
    public void setFileDao(FileQueryDAO fileDao) {
        this.fileDao = fileDao;
    }

    /**
     * t@C1ݒ肷B
     * @param fileName1 t@C
     */
    public void setFileName1(String fileName1) {
        this.fileName1 = fileName1;
    }

    /**
     * t@C2ݒ肷B
     * @param fileName2 t@C
     */
    public void setFileName2(String fileName2) {
        this.fileName2 = fileName2;
    }

    /**
     * ʃNXݒ肷B
     * @param resultClass ʃNX
     */
    public void setResultClass(Object resultClass) {
        this.resultClass = resultClass;
    }

}
