/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.controller;

import java.lang.reflect.Type;
import java.util.Date;

import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.web.rich.context.support.DefaultRequestContextSupportImpl;
import jp.terasoluna.fw.web.rich.context.support.RequestContextSupport;
import jp.terasoluna.fw.web.rich.springmvc.Constants;
import jp.terasoluna.fw.web.rich.springmvc.bind.creator.ServletRequestDataBinderCreator;
import jp.terasoluna.fw.web.rich.springmvc.bind.creator.XMLServletRequestDataBinderCreator;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.validation.AbstractBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.DefaultBindingErrorProcessor;
import org.springframework.validation.DefaultMessageCodesResolver;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.controller.
 * TerasolunaController} 
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * T[rXw̃NXs郊NGXgRg[ۃNXB<br>
 * OFHTTPNGXgAHTTPX|XAR}hIuWFNg
 * NulllɂȂȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.controller.
 * TerasolunaController
 */
public class TerasolunaControllerTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(TerasolunaControllerTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public TerasolunaControllerTest(String name) {
        super(name);
    }

    /**
     * testSetCtxSupport01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ctxSupport:not null<br>
     *         () this.ctxSupport:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.ctxSupport:Őݒ肵lB<br>
     *         
     * <br>
     * ctxSupportSetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetCtxSupport01() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl01();
        UTUtil.setPrivateField(controller, "ctxSupport", null);
        RequestContextSupport ctxSupport = 
            new DefaultRequestContextSupportImpl();

        // eXg{
        controller.setCtxSupport(ctxSupport);

        // 
        Object result = UTUtil.getPrivateField(controller, "ctxSupport");
        assertSame(ctxSupport, result);
    }

    /**
     * testSetDataBinderCreator01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() dataBindExecuter:not null<br>
     *         () this.dataBinderCreator:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.dataBinderCreator:Őݒ肵lB<br>
     *         
     * <br>
     * dataBinderCreatorSetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetDataBinderCreator01() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl01();
        UTUtil.setPrivateField(controller, "dataBinderCreator", null);
        ServletRequestDataBinderCreator creator = 
            new XMLServletRequestDataBinderCreator();

        // eXg{
        controller.setDataBinderCreator(creator);

        // 
        Object result = UTUtil.getPrivateField(controller, "dataBinderCreator");
        assertSame(creator, result);
    }

    /**
     * testSetViewName01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() viewName:"sampleView"<br>
     *         () this.viewName:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.viewName:Őݒ肵lB<br>
     *         
     * <br>
     * viewNameSetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetViewName01() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl01();
        UTUtil.setPrivateField(controller, "viewName", null);
        String argString = "sampleView";

        // eXg{
        controller.setViewName(argString);

        // 
        Object result = UTUtil.getPrivateField(controller, "viewName");
        assertEquals(argString, result);
    }

    /**
     * testSetUseVelocityView01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() useVelocityView:true<br>
     *         () this.useVelocityView:false<br>
     *         
     * <br>
     * ҒlF(ԕω) this.useVelocityView:true<br>
     *         
     * <br>
     * useVelocityViewSetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetUseVelocityView01() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl01();
        UTUtil.setPrivateField(controller, "useRequestNameView", false);

        // eXg{
        controller.setUseRequestNameView(true);

        // 
        Boolean result = (Boolean)UTUtil.getPrivateField(
                controller, "useRequestNameView");
        assertTrue(result);
    }
    
    /**
     * testAfterPropertiesSet01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.dataBinderCreator:null<br>
     *         () this.ctxSupport:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException(
     *          "DataBinderCreator is Null.")<br>
     *         (ԕω) O:OxFG[DataBinderCreator is Null.<br>
     *         
     * <br>
     * CX^XDIReiĂ΂郁\bhB
     * f[^oC_NXݒ肳ĂȂꍇ̃eXgB
     * O𔭐B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testAfterPropertiesSet01() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl01();
        UTUtil.setPrivateField(controller, "dataBinderCreator", null);
        UTUtil.setPrivateField(controller, "ctxSupport", 
                new DefaultRequestContextSupportImpl());

        // eXg{
        try {
            controller.afterPropertiesSet();
            fail();
        } catch (IllegalStateException e) {
            // OK
            assertEquals("DataBinderCreator is Null.", e.getMessage());
            assertTrue(LogUTUtil.checkError("DataBinderCreator is Null."));
        }
    }

    /**
     * testAfterPropertiesSet02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.dataBinderCreator:not null<br>
     *         () this.ctxSupport:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException(
     *           "ContextSupport is Null.")<br>
     *         (ԕω) O:OxFG[<br>
     *                    ContextSupport is Null.<br>
     *         
     * <br>
     * CX^XDIReiĂ΂郁\bhB
     * ctxSupportNullł邽߁AOp^[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testAfterPropertiesSet02() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl01();
        UTUtil.setPrivateField(controller, "ctxSupport", null);
        UTUtil.setPrivateField(controller, "dataBinderCreator", 
                new XMLServletRequestDataBinderCreator());

        // eXg{
        try {
            controller.afterPropertiesSet();
            fail();
        } catch (IllegalStateException e) {
            // OK
            assertEquals("ContextSupport is Null.", e.getMessage());
            assertTrue(LogUTUtil.checkError("ContextSupport is Null."));
        }
    }

    /**
     * testAfterPropertiesSet03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.dataBinderCreator:not null<br>
     *         () this.ctxSupport:not null<br>
     *         
     * <br>
     * ҒlF
     * <br>
     * CX^XDIReiĂ΂郁\bhB
     * ɑݒ肳Ă邽߁AȂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testAfterPropertiesSet03() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl01();
        UTUtil.setPrivateField(controller, "dataBinderCreator", 
                new XMLServletRequestDataBinderCreator());
        UTUtil.setPrivateField(controller, "ctxSupport", 
                new DefaultRequestContextSupportImpl());

        // eXg{
        controller.afterPropertiesSet();

        // ʊmFiOȂOK)
    }

    /**
     * testGetCommand01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () getCommandType:NX<br>
     *         
     * <br>
     * ҒlF(߂l) Object:getCommand()̖߂l̃NX
     * CX^XꂽƂmFB<br>
     *         
     * <br>
     * ^p[^NX̃p^[̃eXgBɃCX^XsB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetCommand01() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl08();
        MockHttpServletRequest request = new MockHttpServletRequest();

        // eXg{
        Object result = controller.getCommand(request);

        // 
        assertEquals(Date.class, result.getClass());
    }

    /**
     * testGetCommand02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () getCommandType:ۃNX<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException("Invalid Command type.")<br>
     *         (ԕω) O:OxFG[
     *                         "Invalid Command type.", ClassLoadException<br>
     *         
     * <br>
     * ^p[^ۃNX̃p^[̃eXgB
     * CX^XɎsAO𓊂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetCommand02() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl01();
        UTUtil.setPrivateField(controller, "commandType", TerasolunaController.class);
        MockHttpServletRequest request = new MockHttpServletRequest();

        // eXg{
        try {
            controller.getCommand(request);
            fail();
        } catch (IllegalStateException e) {
            // OK
            assertEquals("Invalid Command type.", e.getMessage());
            assertTrue(LogUTUtil.checkError("Invalid Command type.", 
                new ClassLoadException(new InstantiationException())));
        }
    }

    /**
     * testGetCommand03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () getCommandType:NX<br>
     *                iRXgN^private錾Ăj<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException("Invalid Command type.")<br>
     *         (ԕω) O:OxFG[
     *                         "Invalid Command type.", ClassLoadException<br>
     *         
     * <br>
     * ^p[^NX̃p^[̃eXgB
     * RXgN^ĂׂACX^XɎsAO𓊂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetCommand03() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl01();
        UTUtil.setPrivateField(controller, "commandType", Math.class);
        MockHttpServletRequest request = new MockHttpServletRequest();

        // eXg{
        try {
            controller.getCommand(request);
            fail();
        } catch (IllegalStateException e) {
            // OK
            assertEquals("Invalid Command type.", e.getMessage());
            assertTrue(LogUTUtil.checkError("Invalid Command type.", 
                new ClassLoadException(new IllegalAccessException())));
        }
    }
    
    /**
     * testGetCommand04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () getCommandType:Object.class<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException("Cannot get Command type. Controller cannot specify the Object type for parameterized type P.")<br>
     *         (ԕω) O:OxFG[@Cannot get Command type. Controller cannot specify the Object type for parameterized type P.<br>
     *         
     * <br>
     * ^p[^NX̃p^[̃eXgB
     * RXgN^ĂׂACX^XɎsAO𓊂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetCommand04() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl07();
        MockHttpServletRequest request = new MockHttpServletRequest();

        // eXg{
        try {
            controller.getCommand(request);
            fail();
        } catch (IllegalStateException e) {
            // OK
            String expect = "Cannot get Command type. " +
                    "Controller cannot specify the Object type for parameterized type P.";
            assertEquals(expect, e.getMessage());
            assertTrue(LogUTUtil.checkError(expect));
        }
    }

    /**
     * testGetCommandType01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() thisiRg[NXj:
     *                 eNX`FTerasolunaController<P,R><br>
     *                 this`FMyController extends TerasolunaController
     *                  <Integer,Boolean><br>
     *         
     * <br>
     * ҒlF(߂l) Type:Integer<br>
     *         
     * <br>
     * TerasolunaRg[pA^p[^P̌^w肷p^[B
     * P[XB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetCommandType01() throws Exception {
        // O
        TerasolunaController controller =
            new TerasolunaControllerImpl03();

        // eXg{
        Type type = controller.getCommandType();

        // 
        assertSame(Integer.class, type);
    }

    /**
     * testGetCommandType02()
     * <br><br>
     * 
     *  (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () getCommandType:ۃNX<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException("Invalid Command type.")<br>
     *         (ԕω) O:OxFG[Invalid Command type.<br>
     *         
     * <br>
     * ^p[^ۃNX̃p^[̃eXgB
     * CX^XɎsAO𓊂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetCommandType02() throws Exception {
        // O
        TerasolunaController controller =
            new TerasolunaControllerImpl02();

        // eXg{
        try {
            controller.getCommandType();
            fail();
        } catch (IllegalStateException e) {
            // eXgʊmF
            String expect = "Controller class must be set ParameterizedType"; 
            assertEquals(expect, e.getMessage());
            assertTrue(LogUTUtil.checkError(expect));
        }
    }

    /**
     * testGetCommandType03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() thisiRg[NXj:e̐e̐eNX`F
     *                TerasolunaController<P, R><br>
     *                e̐eNX`FTerasolunaControllerImpl04<P,R> 
     *                extends TerasolunaController<Date,Long><br>
     *                eNX`FTerasolunaControllerImpl05<P,R> 
     *                extends TerasolunaControllerImpl04<Double, String><br>
     *                this`FTerasolunaControllerImpl06
     *                extends TerasolunaControllerImpl05<Float,Short><br>
     *         
     * <br>
     * ҒlF(߂l) Type:Date<br>
     *         
     * <br>
     * Rg[RpĂp^[B
     * TerasolunaControllerNX̌^p[^gpB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetCommandType03() throws Exception {
        // O
        TerasolunaController controller =
            new TerasolunaControllerImpl06();

        // eXg{
        Type type = controller.getCommandType();

        // 
        assertSame(Date.class, type);
    }

    /**
     * testCreateBinder01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () command:not null<br>
     *         () this.dataBinderCreator:not null<br>
     *         () this.dataBinderCreator.create():null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException("DataBinder is Null.")<br>
     *         (ԕω) O:OxFG[DataBinder is Null.<br>
     *         
     * <br>
     * f[^oC_̐NullԂp^[BO𔭐B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateBinder01() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl01();
        UTUtil.setPrivateField(controller, "dataBinderCreator", 
                new TerasolunaController_ServletRequestDataBinderCreatorStub01());
        UTUtil.setPrivateField(controller, "ctxSupport", 
                new TerasolunaController_DefaultRequestContextSupportImplStub01());
        MockHttpServletRequest request = new MockHttpServletRequest();
        Object command = new Object();
        
        // eXg{
        try {
            controller.createBinder(request, command);
            fail();
        } catch (IllegalStateException e) {
            assertEquals("DataBinder is Null.", e.getMessage());
            assertTrue(LogUTUtil.checkError("DataBinder is Null."));
        }
    }

    /**
     * testCreateBinder02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () command:not null<br>
     *         () this.dataBinderCreator:not null<br>
     *         () this.dataBinderCreator.create():not null<br>
     *         () this.getMessageCodesResolver():not null<br>
     *         
     * <br>
     * ҒlF(߂l) ServletRequestDataBinder:
     *                  ServletRequestDataBinderIuWFNgB<br>
     *                  This.messageCodeResolverݒ肳ĂB<br>
     *         (ԕω) initBinder():\bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * Ƀf[^oC_𐶐p^[BmessageCodeResolverZbgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateBinder02() throws Exception {
        // O -----------------------------------------------------
        TerasolunaControllerImpl01 controller = 
            new TerasolunaControllerImpl01();
        
        // f[^oC_
        ServletRequestDataBinder binder = 
            new TerasolunaController_ServletRequestDataBinderStub01();
        
        // f[^oC_NX
        TerasolunaController_ServletRequestDataBinderCreatorStub02 creator = 
            new TerasolunaController_ServletRequestDataBinderCreatorStub02();
        creator.setBinder(binder);
        UTUtil.setPrivateField(controller, "dataBinderCreator", creator);
        
        // ReLXgT|[gNX
        UTUtil.setPrivateField(controller, "ctxSupport", 
                new TerasolunaController_DefaultRequestContextSupportImplStub01());

        // bZ[WR[h]o
        MessageCodesResolver msgCodesResolver = 
            new TerasolunaController_MessageCodesResolverStub01(); 
        UTUtil.setPrivateField(controller, "messageCodesResolver", 
                msgCodesResolver);
        
        // oChG[vZbT
        BindingErrorProcessor errorProcessor = new DefaultBindingErrorProcessor();
        controller.setBindingErrorProcessor(errorProcessor);
        
        // vpeBGfB^
        PropertyEditorRegistrar[] editorRegistrars 
            = new PropertyEditorRegistrar[3];
        TerasolunaController_PropertyEditorRegistrarStab01 registrar1 = new TerasolunaController_PropertyEditorRegistrarStab01();
        TerasolunaController_PropertyEditorRegistrarStab01 registrar2 = new TerasolunaController_PropertyEditorRegistrarStab01();
        TerasolunaController_PropertyEditorRegistrarStab01 registrar3 = new TerasolunaController_PropertyEditorRegistrarStab01();
        editorRegistrars[0] = registrar1;
        editorRegistrars[1] = registrar2;
        editorRegistrars[2] = registrar3;
        controller.setPropertyEditorRegistrars(editorRegistrars);
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        Object command = new Object();
        
        // eXg{ --------------------------------------------------
        ServletRequestDataBinder result = 
            controller.createBinder(request, command);

        //  --------------------------------------------------------
        assertSame(binder, result);

        assertSame(msgCodesResolver,((AbstractBindingResult) binder.getBindingResult()).getMessageCodesResolver());
        Object resultInitBinderRequest = 
            UTUtil.getPrivateField(controller, "initBinderRequest");
        assertSame(request, resultInitBinderRequest);
        Object resultBinder = UTUtil.getPrivateField(controller, "binder");
        assertSame(result, resultBinder);
        assertSame(errorProcessor, result.getBindingErrorProcessor());
        assertSame(result, registrar1.editorRegistry);
        assertSame(result, registrar2.editorRegistry);
        assertSame(result, registrar3.editorRegistry);
    }

    /**
     * testCreateBinder03()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () command:not null<br>
     *         () this.dataBinderCreator:not null<br>
     *         () this.dataBinderCreator.create():not null<br>
     *         () this.getMessageCodesResolver():null<br>
     *         
     * <br>
     * ҒlF(߂l) ServletRequestDataBinder:
     *          ServletRequestDataBinderIuWFNgB
     *          ftHgmessageCodeResolveriDefaultMessageCodesResolverj
     *          ݒ肳ĂB<br>
     *         (ԕω) initBinder():\bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * Ƀf[^oC_𐶐p^[B
     * messageCodeResolverZbgȂ߁A
     * Nullݒ肳ĂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateBinder03() throws Exception {
        // O -----------------------------------------------------
        TerasolunaControllerImpl01 controller = new TerasolunaControllerImpl01();
        
        // f[^oC_
        ServletRequestDataBinder binder = 
            new TerasolunaController_ServletRequestDataBinderStub01();
        
        // f[^oC_NX
        TerasolunaController_ServletRequestDataBinderCreatorStub02 creator = 
            new TerasolunaController_ServletRequestDataBinderCreatorStub02();
        creator.setBinder(binder);
        UTUtil.setPrivateField(controller, "dataBinderCreator", creator);
        
        // ReLXgT|[gNX
        UTUtil.setPrivateField(controller, "ctxSupport", 
                new TerasolunaController_DefaultRequestContextSupportImplStub01());

        // bZ[WR[h]o͐ݒ肵Ȃ
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        Object command = new Object();
        
        // eXg{ --------------------------------------------------
        ServletRequestDataBinder result = 
            controller.createBinder(request, command);

        //  --------------------------------------------------------
        assertSame(binder, result);
        
        assertSame(DefaultMessageCodesResolver.class,
                ((AbstractBindingResult) binder.getBindingResult())
                        .getMessageCodesResolver().getClass());
        
        Object resultInitBinderRequest = 
            UTUtil.getPrivateField(controller, "initBinderRequest");
        assertSame(request, resultInitBinderRequest);
        Object resultBinder = UTUtil.getPrivateField(controller, "binder");
        assertSame(result, resultBinder);
    }

    /**
     * testOnBind01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () command:gpȂ<br>
     *         () errors:G[<br>
     *         
     * <br>
     * ҒlF(ԕω) O:errors𓊂B<br>
     *         
     * <br>
     * oChŃG[p^[̃eXgBO𓊂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testOnBind01() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl01();
        BindException errors = new TerasolunaController_BindExceptionStub01();
        MockHttpServletRequest request = new MockHttpServletRequest();
        Object command = new Object();

        // eXg{
        try {
            controller.onBind(request, command, errors);
            fail();
        } catch (BindException e) {
            // OK
            assertSame(errors, e);
        }
    }

    /**
     * testOnBind02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () command:gpȂ<br>
     *         () errors:G[Ȃ<br>
     *         
     * <br>
     * ҒlF
     * <br>
     * oChŃG[Ȃp^[̃eXgBȂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testOnBind02() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl01();
        BindException errors = new TerasolunaController_BindExceptionStub02();
        MockHttpServletRequest request = new MockHttpServletRequest();
        Object command = new Object();

        // eXg{
        controller.onBind(request, command, errors);
        
        // ʊmF(OȂOKj
    }

    /**
     * testOnBindAndValidate01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () command:gpȂ<br>
     *         () errors:G[<br>
     *         
     * <br>
     * ҒlF(ԕω) O:errors𓊂B<br>
     *         
     * <br>
     * ̓`FbNŃG[p^[̃eXgBO𓊂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testOnBindAndValidate01() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl01();
        BindException errors = new TerasolunaController_BindExceptionStub01();
        MockHttpServletRequest request = new MockHttpServletRequest();
        Object command = new Object();

        // eXg{
        try {
            controller.onBindAndValidate(request, command, errors);
            fail();
        } catch (BindException e) {
            // OK
            assertSame(errors, e);
        }
    }

    /**
     * testOnBindAndValidate02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () command:gpȂ<br>
     *         () errors:G[Ȃ<br>
     *         
     * <br>
     * ҒlF
     * <br>
     * ̓`FbNŃG[Ȃp^[̃eXgBȂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testOnBindAndValidate02() throws Exception {
        // O
        TerasolunaController controller = new TerasolunaControllerImpl01();
        BindException errors = new TerasolunaController_BindExceptionStub02();
        MockHttpServletRequest request = new MockHttpServletRequest();
        Object command = new Object();

        // eXg{
        controller.onBindAndValidate(request, command, errors);
        
        // ʊmF(OȂOKj
    }

    /**
     * testHandle01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () command:not null<br>
     *         () errors:gpȂ<br>
     *         () this.viewName:hsampleh<br>
     *         () this.useRequestNameView:false<br>
     *         () ctxSupport.getRequestName():hcommandh<br>
     *         
     * <br>
     * ҒlF(߂l) ModelAndView:ModelAndViewԂB<br>
     *                  r[Fsample<br>
     *         (ԕω) executeServiceij:\bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * r[𒼐ړ͂p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testHandle01() throws Exception {
        // O --------------------------------------------------------------
        TerasolunaControllerImpl01 controller = new TerasolunaControllerImpl01();
        
        // r[
        String viewName = "sample";
        UTUtil.setPrivateField(controller, "viewName", viewName);
        
        // ReLXgT|[gNX
        UTUtil.setPrivateField(controller, "ctxSupport", 
                new TerasolunaController_DefaultRequestContextSupportImplStub01());

        // VelocitygptO
        UTUtil.setPrivateField(controller, "useRequestNameView", false);
        
        // ƖʃIuWFNg
        Object model = new Object();
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        BindException errors = new BindException(new Object(), "");
        
        // eXg{ ----------------------------------------------------------
        ModelAndView mv = controller.handle(request, response, model, errors);

        //  ----------------------------------------------------------------
        assertEquals(viewName, mv.getViewName());
        assertTrue(controller.isExecuteService);
        assertSame(model, mv.getModel().get(Constants.RESULT_KEY));
    }

    /**
     * testHandle02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () command:not null<br>
     *         () errors:gpȂ<br>
     *         () this.viewName:null<br>
     *         () this.useRequestNameView:true<br>
     *         () ctxSupport.getRequestName():hcommandh<br>
     *         
     * <br>
     * ҒlF(߂l) ModelAndView:ModelAndViewԂB<br>
     *                  r[F/sum<br>
     *         (ԕω) executeServiceij:
     *         \bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * Velocityr[gpp^[̃eXgB
     * r["/"{NGXggpB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testHandle02() throws Exception {
        // O --------------------------------------------------------------
        TerasolunaControllerImpl01 controller = 
            new TerasolunaControllerImpl01();
        
        // r[
        UTUtil.setPrivateField(controller, "viewName", null);
        
        // ReLXgT|[gNX
        UTUtil.setPrivateField(controller, "ctxSupport", 
                new TerasolunaController_DefaultRequestContextSupportImplStub01());
        
        // VelocitygptO
        UTUtil.setPrivateField(controller, "useRequestNameView", true);

        // ƖʃIuWFNg
        Object model = new Object();
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        BindException errors = new BindException(new Object(), "");
        
        
        // eXg{ ----------------------------------------------------------
        ModelAndView mv = controller.handle(request, response, model, errors);

        //  ----------------------------------------------------------------
        assertEquals("/command", mv.getViewName());
        assertTrue(controller.isExecuteService);
        assertEquals(model, mv.getModel().get(Constants.RESULT_KEY));
    }

    /**
     * testHandle03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () command:not null<br>
     *         () errors:gpȂ<br>
     *         () this.viewName:hsampleh<br>
     *         () this.useRequestNameView:true<br>
     *         () ctxSupport.getRequestName():hcommandh<br>
     *         
     * <br>
     * ҒlF(߂l) ModelAndView:ModelAndViewԂB<br>
     *                  r[Fsample<br>
     *         (ԕω) executeServiceij:
     *         \bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * r[𒼐ړ͂AVelocityr[gpݒ肪
     * p^[̃eXgB
     * ړ͂ꂽr[D悳B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testHandle03() throws Exception {
        // O --------------------------------------------------------------
        TerasolunaControllerImpl01 controller = new TerasolunaControllerImpl01();
        
        // r[
        String viewName = "sample";
        UTUtil.setPrivateField(controller, "viewName", viewName);
        
        // ReLXgT|[gNX
        UTUtil.setPrivateField(controller, "ctxSupport", 
                new TerasolunaController_DefaultRequestContextSupportImplStub01());

        // VelocitygptO
        UTUtil.setPrivateField(controller, "useRequestNameView", true);
        
        // ƖʃIuWFNg
        Object model = new Object();
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        BindException errors = new BindException(new Object(), "");
        
        // eXg{ ----------------------------------------------------------
        ModelAndView mv = controller.handle(request, response, model, errors);

        //  ----------------------------------------------------------------
        assertEquals(viewName, mv.getViewName());
        assertTrue(controller.isExecuteService);
        assertSame(model, mv.getModel().get(Constants.RESULT_KEY));
    }

    /**
     * testHandle04()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () command:not null<br>
     *         () errors:gpȂ<br>
     *         () this.viewName:null<br>
     *         () this.useRequestNameView:false<br>
     *         () ctxSupport.getRequestName():hcommandh<br>
     *         
     * <br>
     * ҒlF(߂l) ModelAndView:ModelAndViewԂB<br>
     *                  r[Fi󕶎j<br>
     *         (ԕω) executeServiceij:
     *         \bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * r[̎wAVelocityr[gpݒĂȂꍇ̃eXgB
     * 󕶎̃r[ݒ肳BCastorr[gpꍇ̐ݒƂȂB
     * TERASOLUNÃr[@\ł̓ftHgdlƂȂĂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testHandle04() throws Exception {
        // O --------------------------------------------------------------
        TerasolunaControllerImpl01 controller = new TerasolunaControllerImpl01();
        
        // r[
        UTUtil.setPrivateField(controller, "viewName", null);
        
        // ReLXgT|[gNX
        UTUtil.setPrivateField(controller, "ctxSupport", 
                new TerasolunaController_DefaultRequestContextSupportImplStub01());
        
        // VelocitygptO
        UTUtil.setPrivateField(controller, "useRequestNameView", false);

        // ƖʃIuWFNg
        Object model = new Object();
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        BindException errors = new BindException(new Object(), "");
        
        // eXg{ ----------------------------------------------------------
        ModelAndView mv = controller.handle(request, response, model, errors);

        //  ----------------------------------------------------------------
        assertEquals("", mv.getViewName());
        assertTrue(controller.isExecuteService);
        assertSame(model, mv.getModel().get(Constants.RESULT_KEY));
    }

    /**
     * testExecuteService01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () response:gpȂ<br>
     *         () command:not null<br>
     *         
     * <br>
     * ҒlF(߂l) R:executeServiceij
     *          \bh̖߂lƓƂmFB<br>
     *         (ԕω) preServiceij:
     *         \bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         (ԕω) executeServiceij:
     *         \bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         (ԕω) postServiceij:
     *         \bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * T[rXWbÑeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testExecuteService01() throws Exception {
        // O
        TerasolunaControllerImpl01 controller = 
            new TerasolunaControllerImpl01();
        String model = "aaa";
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        
        // eXg{
        Object result = controller.executeService(request, response, model);

        // 
        assertEquals(model, result);
        assertTrue(controller.isPreService);
        assertTrue(controller.isExecuteService);
        assertTrue(controller.isPostService);
    }
}
