/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.context.support;

import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.web.rich.context.RequestContext;
import jp.terasoluna.fw.web.rich.context.RequestContextManager;
import jp.terasoluna.fw.web.rich.context.exception.IllegalContextPropertyClassTypeException;

/**
 * ߂̕⏕WbNC^tF[XpۃNXB
 * 
 * <p>
 * ƖReLXg}l[WƖReLXg擾AKvȏԋpB
 * </p>
 * 
 * <p>
 * RequestContext, RequestContextManager𗘗p
 * 񋟂ĂB
 * ڍׂ́ARequestContext, RequestContextManagerQƂ邱ƁB
 * </P>
 * 
 * <p>
 * ɐݒ肷lHTTPNGXg擾B
 * HTTPNGXg擾鍀ڂ́AVXe̗vɂĕω邽߁A
 * NGXgNGXgwb_ȊỎӏ擾ꍇA
 * ƖvpeBێꍇ́A
 * KvɉăVXeƂɖ{NX̎NX쐬A
 * 񏉊̒ۃ\bh邱ƁB
 * </p>
 * 
 * <p>
 * VXeƂēɏL̂悤ȗvȂꍇ́AftHgłA
 * DefaultRequestContextSupportImpl𗘗p邱ƁB
 * </p>
 * 
 * <p>
 * {NX𗘗pꍇANXBean`邱ƁB
 * `́ANXQƂ邱ƁB
 * ܂Aȉ̃vpeBKݒ肷邱ƁB
 * </p>
 * 
 * @see jp.terasoluna.fw.web.rich.context.RequestContext
 * @see jp.terasoluna.fw.web.rich.context.RequestContextManager
 * 
 */
public abstract class AbstractRequestContextSupport
        implements RequestContextSupport {

    /**
     * sƖWbNʂ郊NGXg擾B
     *
     * @return NGXg
     */
    public String getRequestName() {
        return getRequestContext().getRequestName();
    }

    /**
     * ƖvpeB擾B
     * ƖƂɓƎɕێ́Ã\bhŎ擾B
     *
     * @param key L[
     * @return ƖvpeB
     */
    public Object getProperty(String key) {
        return getRequestContext().getProperty(key);
    }
    
    /**
     * ԋpľ^w肵āAƖvpeB擾B
     * ƖƂɓƎɕێ́Ã\bhŎ擾B
     * 擾ƖvpeB̌^Ǝw肳ꂽ^ꍇ́A
     * sO𔭐B
     *
     * @param key L[
     * @param <E> ԋpľ^
     * @return ƖvpeB
     */
    public <E> E getProperty(String key, Class<E> clazz) {
        E propertyObject = null;
        
        if (clazz == null) {            
        	// ^p[^w肳ĂȂ
            String message = "Must not use null for clazz of an argument.";
        	throw new IllegalArgumentException(message);
        }
        
        try {
        	propertyObject = clazz.cast(getProperty(key));
        } catch (ClassCastException e) {
            throw new IllegalContextPropertyClassTypeException(e);
        }
    	
        return propertyObject;
    }
    
    /**
     * String^̋ƖvpeB擾B
     * ƖƂɓƎɕێ́Ã\bhŎ擾B
     *
     * @param key L[
     * @return ƖvpeB
     */
    public String getPropertyString(String key) {
        return getProperty(key,String.class);
    }
    
    /**
     * ƖReLXg𐶐B
     * @param request HTTPNGXg
     */
    public void generateContext(HttpServletRequest request) {
        RequestContext ctx = doGenerateContext(request);
        RequestContextManager.bindRequestContext(ctx);
    }
    
    /**
     * 𐶐EĕԋpB
     * @param request HTTPNGXg
     * @return ̐B
     */
    protected abstract RequestContext doGenerateContext(
                                    HttpServletRequest request);
    
    /**
     * jB
     *
     */
    public void destroyContext() {
        if (RequestContextManager.hasRequestContext()) {
            RequestContextManager.unbindRequestContext();
        }
    }
    
    /**
     * }l[W擾B
     * @return 
     */
    protected RequestContext getRequestContext() {
        return RequestContextManager.getRequestContext();
    }
}
