/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.util.Map;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;

/**
 * {@link jp.terasoluna.fw.web.struts.action.MessageResourcesDAOImpl}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * MessageResourcesDAO̎NXB
 * ̃NX̃eXgsۂɂMessageResourcesDAOImpl.sqlp
 * DBɃe[u쐬ĂKvB
 * eXgɍۂāAUTUtilpăf[^x[X𑀍삷邽߁A
 * JDBChCoNXpXɒǉA
 * utlib.confDBڑpɃAJEgƃpX[hIPAhX̐ݒ邱ƁB
 * lɁAf[^\[X̐ݒƎɍsKv邽߁A
 * jp/terasoluna/fw/web/struts/action
 * /MessageResourcesDAOImpl_dbMessageResources04.xml
 * ɑ΂ĂAJEgƃpX[hAIPAhX̐ݒsƁB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.action.MessageResourcesDAOImpl
 */
public class MessageResourcesDAOImplTest extends TestCase {




    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(MessageResourcesDAOImplTest.class);
    }

    /**
     * sB
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        UTUtil.deleteAll("MESSAGE");
    }

    /**
     * ㏈sB
     * f[^x[XB
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        UTUtil.deleteAll("MESSAGE");
    }

    /**
     * testQueryMessageMap01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() sql:"SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE"<br>
     *         () dbMessageResources.xml:"aaaaa"<br>
     *                i݂Ȃt@Cj<br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.message.resources.dao.impl"<br>
     *                    bvOFBeansException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "aaaaa not found or not -//SPRING//DTD BEAN//EN or invalid or anything else."<br>
     *                    O<br>
     *                    BeansException<br>
     *
     * <br>
     * Bean`t@CȂꍇAOX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testQueryMessageMap01() throws Exception {
        // O
        MessageResourcesDAOImpl_MessageResourcesDAOImplStub01 dao
            = new MessageResourcesDAOImpl_MessageResourcesDAOImplStub01();
        dao.setTestBeansXmlName("aaaaa");

        // eXg{
        try {
            dao.queryMessageMap("SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE");
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.message.resources.dao.impl",
                         e.getErrorCode());
            assertTrue(e.getCause() instanceof BeansException);
            assertTrue(LogUTUtil.checkError(
                       "jp/terasoluna/fw/web/struts/action/aaaaa not found or not -//SPRING//DTD BEAN//EN or invalid or anything else.",
                       e.getCause()));
        }

    }

    /**
     * testQueryMessageMap02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() sql:"SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE"<br>
     *         () dbMessageResources.xml:"MessageResourcesDAOImple_dbMessageResources01.xml"<br>
     *                iid"dataSource"<bean>vfȂj<br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.message.resources.dao.impl"<br>
     *                    bvOFNoSuchBeanDefinitionException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    ""dataSource" not defined."<br>
     *                    O<br>
     *                    NoSuchBeanDefinitionException<br>
     *
     * <br>
     * Bean`t@CiddataSourcebeanvfȂꍇAOX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testQueryMessageMap02() throws Exception {
        // O
        MessageResourcesDAOImpl_MessageResourcesDAOImplStub01 dao
            = new MessageResourcesDAOImpl_MessageResourcesDAOImplStub01();
        dao.setTestBeansXmlName("MessageResourcesDAOImpl_dbMessageResources01.xml");

        // eXg{
        try {
            dao.queryMessageMap(
                    "SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE");
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.message.resources.dao.impl", e.getErrorCode());
            assertEquals(NoSuchBeanDefinitionException.class.getName(),
                         e.getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError(
                       "\"dataSource\" not defined.",
                       e.getCause()));
        }
    }

    /**
     * testQueryMessageMap03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() sql:"SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE"<br>
     *         () dbMessageResources.xml:"MessageResourcesDAOImple_dbMessageResources02.xml"<br>
     *                yt@Cɒ`ꂽdataSourcez<br>
     *                <bean id="dataSource"<br>
     *                        class="java.lang.Object"><br>
     *                  c<br>
     *                </bean><br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.message.resources.dao.impl"<br>
     *                    bvOFClassCastException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    ""dataSource" not implemented DataSource."<br>
     *                    O<br>
     *                    ClassCastException<br>
     *
     * <br>
     * Bean`t@CiddataSourceAclassDataSource
     * NXłȂꍇAOX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testQueryMessageMap03() throws Exception {
        // O
        MessageResourcesDAOImpl_MessageResourcesDAOImplStub01 dao
            = new MessageResourcesDAOImpl_MessageResourcesDAOImplStub01();
        dao.setTestBeansXmlName("MessageResourcesDAOImpl_dbMessageResources02.xml");

        // eXg{
        try {
            dao.queryMessageMap("SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE");
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.message.resources.dao.impl", e.getErrorCode());
            assertEquals(ClassCastException.class.getName(),
                         e.getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError(
                       "\"dataSource\" not implemented DataSource.",
                       e.getCause()));
        }
    }

    /**
     * testQueryMessageMap04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() sql:"SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE"<br>
     *         () dbMessageResources.xml:"MessageResourcesDAOImple_dbMessageResources03.xml"<br>
     *                yt@Cɒ`ꂽdataSourcez<br>
     *                <bean id="dataSource"<br>
     *                        class="org.springframework.jdbc.datasource.DriverManagerDataSource"
     *                        abstract="true"><br>
     *                  c<br>
     *                </bean><br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.message.resources.dao.impl"<br>
     *                    bvOFBeansException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "getBean() failed"<br>
     *                    O<br>
     *                    BeansException<br>
     *
     * <br>
     * Bean`t@CiddataSourceAabstracttruȅꍇA
     * OX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testQueryMessageMap04() throws Exception {
        // O
        MessageResourcesDAOImpl_MessageResourcesDAOImplStub01 dao
            = new MessageResourcesDAOImpl_MessageResourcesDAOImplStub01();
        dao.setTestBeansXmlName("MessageResourcesDAOImpl_dbMessageResources03.xml");

        // eXg{
        try {
            dao.queryMessageMap("SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE");
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.message.resources.dao.impl", e.getErrorCode());
            assertTrue(e.getCause() instanceof BeansException);
            assertTrue(LogUTUtil.checkError(
                       "getBean() failed",
                       e.getCause()));
        }
    }

    /**
     * testQueryMessageMap05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() sql:null<br>
     *         () dbMessageResources.xml:"MessageResourcesDAOImple_dbMessageResources04.xml"<br>
     *                yt@Cɒ`ꂽdataSourcez<br>
     *                <bean id="dataSource"<br>
     *                        class="org.springframework.jdbc.datasource.DriverManagerDataSource"><br>
     *                  c<br>
     *                </bean><br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.message.resources.dao.impl"<br>
     *                    bvOFInvalidDataAccessApiUsageException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "SQL is null or something wrong."<br>
     *                    O<br>
     *                    InvalidDataAccessApiUsageException<br>
     *
     * <br>
     * sqlnull̏ꍇAOX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testQueryMessageMap05() throws Exception {
        // O
        MessageResourcesDAOImpl_MessageResourcesDAOImplStub01 dao
            = new MessageResourcesDAOImpl_MessageResourcesDAOImplStub01();
        dao.setTestBeansXmlName("MessageResourcesDAOImpl_dbMessageResources04.xml");

        // eXg{
        try {
            dao.queryMessageMap(null);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.message.resources.dao.impl", e.getErrorCode());
            assertEquals(InvalidDataAccessApiUsageException.class.getName(),
                         e.getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError(
                       "SQL is null or something wrong.",
                       e.getCause()));
        }
    }

    /**
     * testQueryMessageMap06()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() sql:""<br>
     *         () dbMessageResources.xml:"MessageResourcesDAOImple_dbMessageResources04.xml"<br>
     *                yt@Cɒ`ꂽdataSourcez<br>
     *                <bean id="dataSource"<br>
     *                        class="org.springframework.jdbc.datasource.DriverManagerDataSource"><br>
     *                  c<br>
     *                </bean><br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.message.resources.dao.impl"<br>
     *                    bvOFDataAccessException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "Data access exception."<br>
     *                    O<br>
     *                    DataAccessException<br>
     *
     * <br>
     * sql󕶎̏ꍇAOX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testQueryMessageMap06() throws Exception {
        // O
        MessageResourcesDAOImpl_MessageResourcesDAOImplStub01 dao
            = new MessageResourcesDAOImpl_MessageResourcesDAOImplStub01();
        dao.setTestBeansXmlName("MessageResourcesDAOImpl_dbMessageResources04.xml");

        // eXg{
        try {
            dao.queryMessageMap("");
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.message.resources.dao.impl", e.getErrorCode());
            assertTrue(e.getCause() instanceof DataAccessException);
            assertTrue(LogUTUtil.checkError(
                       "Data access exception.",
                       e.getCause()));
        }
    }

    /**
     * testQueryMessageMap07()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() sql:"aaaaa"<br>
     *         () dbMessageResources.xml:"MessageResourcesDAOImple_dbMessageResources04.xml"<br>
     *                yt@Cɒ`ꂽdataSourcez<br>
     *                <bean id="dataSource"<br>
     *                        class="org.springframework.jdbc.datasource.DriverManagerDataSource"><br>
     *                  c<br>
     *                </bean><br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.message.resources.dao.impl"<br>
     *                    bvOFDataAccessException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "Data access exception."<br>
     *                    O<br>
     *                    DataAccessException<br>
     *
     * <br>
     * sql̏ꍇAOX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testQueryMessageMap07() throws Exception {
        // O
        MessageResourcesDAOImpl_MessageResourcesDAOImplStub01 dao
            = new MessageResourcesDAOImpl_MessageResourcesDAOImplStub01();
        dao.setTestBeansXmlName("MessageResourcesDAOImpl_dbMessageResources04.xml");

        // eXg{
        try {
            dao.queryMessageMap("aaaaa");
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.message.resources.dao.impl", e.getErrorCode());
            assertTrue(e.getCause() instanceof DataAccessException);
            assertTrue(LogUTUtil.checkError(
                       "Data access exception.",
                       e.getCause()));
        }
    }

    /**
     * testQueryMessageMap08()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() sql:"SELECT MESSAGE_KEY, MESSAGE_VALUE FROM AAAAA"<br>
     *         () dbMessageResources.xml:"MessageResourcesDAOImple_dbMessageResources04.xml"<br>
     *                yt@Cɒ`ꂽdataSourcez<br>
     *                <bean id="dataSource"<br>
     *                        class="org.springframework.jdbc.datasource.DriverManagerDataSource"><br>
     *                  c<br>
     *                </bean><br>
     *         () MESSAGE_KEY:MESSAGEe[u݂Ȃ<br>
     *         () MESSAGE_VALUE:MESSAGEe[u݂Ȃ<br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.message.resources.dao.impl"<br>
     *                    bvOFDataAccessException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "Data access exception."<br>
     *                    O<br>
     *                    DataAccessException<br>
     *
     * <br>
     * Ώۂ̃e[u݂ȂꍇAOX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testQueryMessageMap08() throws Exception {
        // O
        MessageResourcesDAOImpl_MessageResourcesDAOImplStub01 dao
            = new MessageResourcesDAOImpl_MessageResourcesDAOImplStub01();
        dao.setTestBeansXmlName("MessageResourcesDAOImpl_dbMessageResources04.xml");

        // eXg{
        try {
            dao.queryMessageMap("SELECT MESSAGE_KEY, MESSAGE_VALUE FROM AAAAA");
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.message.resources.dao.impl", e.getErrorCode());
            assertTrue(e.getCause() instanceof DataAccessException);
            assertTrue(LogUTUtil.checkError(
                       "Data access exception.",
                       e.getCause()));
        }
    }

    /**
     * testQueryMessageMap09()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() sql:"UPDATE MESSAGE SET MESSAGE_VALUE = 'XVꂽbZ[W'"<br>
     *         () dbMessageResources.xml:"MessageResourcesDAOImple_dbMessageResources04.xml"<br>
     *                yt@Cɒ`ꂽdataSourcez<br>
     *                <bean id="dataSource"<br>
     *                        class="org.springframework.jdbc.datasource.DriverManagerDataSource"><br>
     *                  c<br>
     *                </bean><br>
     *         () MESSAGE_KEY:"TEST01"<br>
     *         () MESSAGE_VALUE:"eXg߂[OP"<br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.message.resources.dao.impl"<br>
     *                    bvOFDataAccessException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "Data access exception."<br>
     *                    O<br>
     *                    DataAccessException<br>
     *
     * <br>
     * sqlXVn̏ꍇAOX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testQueryMessageMap09() throws Exception {
        // O
        MessageResourcesDAOImpl_MessageResourcesDAOImplStub01 dao
            = new MessageResourcesDAOImpl_MessageResourcesDAOImplStub01();
        dao.setTestBeansXmlName("MessageResourcesDAOImpl_dbMessageResources04.xml");

        String[][] data = {
            {"MESSAGE_KEY", "MESSAGE_VALUE"},
            {"TEST01", "eXg߂[OP"}
        };
        UTUtil.setData("MESSAGE", data);
        // eXg{
        try {
            dao.queryMessageMap(
                    "UPDATE MESSAGE SET MESSAGE_VALUE = 'XVꂽbZ[W'");
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.message.resources.dao.impl", e.getErrorCode());
            assertTrue(e.getCause() instanceof DataAccessException);
            assertTrue(LogUTUtil.checkError(
                       "Data access exception.",
                       e.getCause()));
        }
    }

    /**
     * testQueryMessageMap10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() sql:"SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE"<br>
     *         () dbMessageResources.xml:"MessageResourcesDAOImple_dbMessageResources04.xml"<br>
     *                yt@Cɒ`ꂽdataSourcez<br>
     *                <bean id="dataSource"<br>
     *                        class="org.springframework.jdbc.datasource.DriverManagerDataSource"><br>
     *                  c<br>
     *                </bean><br>
     *         () MESSAGE_KEY:Ȃ<br>
     *         () MESSAGE_VALUE:Ȃ<br>
     *         () count:0<br>
     *
     * <br>
     * ҒlF(߂l) Map<String, String>:Map<br>
     *
     * <br>
     * DB̃bZ[W\[X0̏ꍇAMapԂ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testQueryMessageMap10() throws Exception {
        // O
        MessageResourcesDAOImpl_MessageResourcesDAOImplStub01 dao
            = new MessageResourcesDAOImpl_MessageResourcesDAOImplStub01();
        dao.setTestBeansXmlName("MessageResourcesDAOImpl_dbMessageResources04.xml");

        // eXg{
        Map<String, String> map = dao.queryMessageMap(
                "SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE");

        // 
        assertTrue(map.isEmpty());

    }

    /**
     * testQueryMessageMap11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() sql:"SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE"<br>
     *         () dbMessageResources.xml:"MessageResourcesDAOImple_dbMessageResources04.xml"<br>
     *                yt@Cɒ`ꂽdataSourcez<br>
     *                <bean id="dataSource"<br>
     *                        class="org.springframework.jdbc.datasource.DriverManagerDataSource"><br>
     *                  c<br>
     *                </bean><br>
     *         () MESSAGE_KEY:"TEST01"<br>
     *         () MESSAGE_VALUE:"eXg߂[OP"<br>
     *         () count:1<br>
     *
     * <br>
     * ҒlF(߂l) Map<String, String>:["TEST01"->"eXg߂[OP"]<br>
     *
     * <br>
     * DB̃bZ[W\[X1̏ꍇA1ĂMapԂ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testQueryMessageMap11() throws Exception {
        // O
        MessageResourcesDAOImpl_MessageResourcesDAOImplStub01 dao
            = new MessageResourcesDAOImpl_MessageResourcesDAOImplStub01();
        dao.setTestBeansXmlName("MessageResourcesDAOImpl_dbMessageResources04.xml");
        String[][] data = {
            {"MESSAGE_KEY", "MESSAGE_VALUE"},
            {"TEST01", "eXg߂[OP"}
        };
        UTUtil.setData("MESSAGE", data);
        // eXg{
        Map<String, String> map = dao.queryMessageMap(
                "SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE");

        // 
        assertEquals(1, map.size());
        assertEquals("eXg߂[OP", map.get("TEST01"));
    }

    /**
     * testQueryMessageMap12()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() sql:"SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE"<br>
     *         () dbMessageResources.xml:"MessageResourcesDAOImple_dbMessageResources04.xml"<br>
     *                yt@Cɒ`ꂽdataSourcez<br>
     *                <bean id="dataSource"<br>
     *                        class="org.springframework.jdbc.datasource.DriverManagerDataSource"><br>
     *                  c<br>
     *                </bean><br>
     *         () MESSAGE_KEY:"TEST01"<br>
     *                "TEST02"<br>
     *                "TEST03"<br>
     *         () MESSAGE_VALUE:"eXg߂[OP"<br>
     *                "testMESSAGE02"<br>
     *                "IO"<br>
     *         () count:3<br>
     *
     * <br>
     * ҒlF(߂l) Map<String, String>:["TEST01"->"eXg߂[OP"]<br>
     *                  ["TEST02"->"testMessage02"]<br>
     *                  ["TEST03"->"IO"]<br>
     *
     * <br>
     * DB̃bZ[W\[X3̏ꍇA3ĂMapԂ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testQueryMessageMap12() throws Exception {
        // O
        MessageResourcesDAOImpl_MessageResourcesDAOImplStub01 dao
            = new MessageResourcesDAOImpl_MessageResourcesDAOImplStub01();
        dao.setTestBeansXmlName("MessageResourcesDAOImpl_dbMessageResources04.xml");
        String[][] data = {
            {"MESSAGE_KEY", "MESSAGE_VALUE"},
            {"TEST01", "eXg߂[OP"},
            {"TEST02", "testMessage02"},
            {"TEST03", "IO"},
        };
        UTUtil.setData("MESSAGE", data);
        // eXg{
        Map<String, String> map = dao.queryMessageMap(
                "SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGE");

        // 
        assertEquals(3, map.size());
        assertEquals("eXg߂[OP", map.get("TEST01"));
        assertEquals("testMessage02", map.get("TEST02"));
        assertEquals("IO", map.get("TEST03"));
    }

    /**
     * testGetBeanXml01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() BEANS_XML:"dbMessageResources.xml"<br>
     *
     * <br>
     * ҒlF(߂l) String:"dbMessageResources.xml"<br>
     *
     * <br>
     * nP̂݃eXg
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanXml01() throws Exception {
        // O
        MessageResourcesDAOImpl dao = new MessageResourcesDAOImpl();

        // eXg{
        String actual = dao.getBeansXml();

        // 
        assertEquals("dbMessageResources.xml", actual);
    }



}
