/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.codelist;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.codelist.CodeBean} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * R[hƃR[hl(\)ێBeanNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.codelist.CodeBean
 * 
 */
public class CodeBeanTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CodeBeanTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name
     *            ̃eXgP[X̖OB
     */
    public CodeBeanTest(String name) {
        super(name);
    }

    /**
     * testSetId01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() id:"id"<br>
     * () id:null<br>
     * 
     * <br>
     * ҒlF(ԕω) id:"id"<br>
     * 
     * <br>
     * Ɏw肳ꂽ񂪃CX^Xϐidɐݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetId01() throws Exception {
        // O
        CodeBean codeBean = new CodeBean();

        // eXg{
        codeBean.setId("id");
        // 
        assertEquals("id", UTUtil.getPrivateField(codeBean, "id"));
    }

    /**
     * testSetId02() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() id:null<br>
     * () id:null<br>
     * 
     * <br>
     * ҒlF(ԕω) id:""<br>
     * 
     * <br>
     * idnull̏ꍇA󕶎ݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetId02() throws Exception {
        // O
        CodeBean codeBean = new CodeBean();
        // eXg{
        codeBean.setId(null);
        // 
        assertEquals("", UTUtil.getPrivateField(codeBean, "id"));
    }

    /**
     * testGetId01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() id:"id"<br>
     * 
     * <br>
     * ҒlF(߂l) String:"id"<br>
     * 
     * <br>
     * CX^Xϐid̒l擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetId01() throws Exception {
        // O
        CodeBean codeBean = new CodeBean();
        UTUtil.setPrivateField(codeBean, "id", "id");
        
        // eXg{E
        assertEquals("id", codeBean.getId());
    }

    /**
     * testSetName01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() name:"name"<br>
     * () name:null<br>
     * 
     * <br>
     * ҒlF(ԕω) name:"name"<br>
     * 
     * <br>
     * Ɏw肳ꂽ񂪃CX^Xϐnameɐݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetName01() throws Exception {
        // O
        CodeBean codeBean = new CodeBean();
        // eXg{
        codeBean.setName("name");
        // 
        assertEquals("name", UTUtil.getPrivateField(codeBean, "name"));
    }

    /**
     * testSetName02() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() name:null<br>
     * () name:null<br>
     * 
     * <br>
     * ҒlF(ԕω) name:""<br>
     * 
     * <br>
     * namenull̏ꍇA󕶎ݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetName02() throws Exception {
        // O
        CodeBean codeBean = new CodeBean();
        // eXg{
        codeBean.setName(null);
        // 
        assertEquals("", UTUtil.getPrivateField(codeBean, "name"));
    }

    /**
     * testGetName01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() name:"name"<br>
     * 
     * <br>
     * ҒlF(߂l) String:"name"<br>
     * 
     * <br>
     * CX^Xϐname̒l擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetName01() throws Exception {
        // O
        CodeBean codeBean = new CodeBean();
        UTUtil.setPrivateField(codeBean, "name", "name");
        
        // eXg{E
        assertEquals("name", codeBean.getName());
    }

    /**
     * testGetLabel01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() id:null<br>
     * () name:null<br>
     * 
     * <br>
     * ҒlF(߂l) String:"null null"<br>
     * 
     * <br>
     * ϐidnamenull̏ꍇAunull nullv擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetLabel01() throws Exception {
        // O
        CodeBean codeBean = new CodeBean();
        UTUtil.setPrivateField(codeBean, "id", null);
        UTUtil.setPrivateField(codeBean, "name", null);
        
        // eXg{E
        assertEquals("null null", codeBean.getLabel());
    }

    /**
     * testGetLabel02() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() id:""<br>
     * () name:""<br>
     * 
     * <br>
     * ҒlF(߂l) String:" "<br>
     * 
     * <br>
     * ϐidname󕶎̏ꍇAu vipXy[Xj擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetLabel02() throws Exception {
        // O
        CodeBean codeBean = new CodeBean();
        UTUtil.setPrivateField(codeBean, "id", "");
        UTUtil.setPrivateField(codeBean, "name", "");
        
        // eXg{E
        assertEquals(" ", codeBean.getLabel());
    }

    /**
     * testGetLabel03() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() id:"id"<br>
     * () name:"name"<br>
     * 
     * <br>
     * ҒlF(߂l) String:"id name"<br>
     * 
     * <br>
     * ϐidnameɕ񂪐ݒ肳ĂꍇA
     * id̕name̕𔼊pXy[XŘA񂪎擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetLabel03() throws Exception {
        // O
        CodeBean codeBean = new CodeBean();
        UTUtil.setPrivateField(codeBean, "id", "id");
        UTUtil.setPrivateField(codeBean, "name", "name");
        
        // eXg{E
        assertEquals("id name", codeBean.getLabel());
    }

    /**
     * testGetCodeCommaName01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() id:null<br>
     * () name:null<br>
     * 
     * <br>
     * ҒlF(߂l) String:"null,null"<br>
     * 
     * <br>
     * ϐidnamenull̏ꍇAunull,nullv擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetCodeCommaName01() throws Exception {
        // O
        CodeBean codeBean = new CodeBean();
        UTUtil.setPrivateField(codeBean, "id", null);
        UTUtil.setPrivateField(codeBean, "name", null);
        
        // eXg{E
        assertEquals("null,null", codeBean.getCodeCommaName());
    }

    /**
     * testGetCodeCommaName02() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() id:""<br>
     * () name:""<br>
     * 
     * <br>
     * ҒlF(߂l) String:","<br>
     * 
     * <br>
     * ϐidname󕶎̏ꍇAu,v擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetCodeCommaName02() throws Exception {
        // O
        CodeBean codeBean = new CodeBean();
        UTUtil.setPrivateField(codeBean, "id", "");
        UTUtil.setPrivateField(codeBean, "name", "");
        
        // eXg{E
        assertEquals(",", codeBean.getCodeCommaName());

    }

    /**
     * testGetCodeCommaName03() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() id:"id"<br>
     * () name:"name"<br>
     * 
     * <br>
     * ҒlF(߂l) String:"id,name"<br>
     * 
     * <br>
     * ϐidnameɕ񂪐ݒ肳ĂꍇA
     * id̕name̕J}ŘA񂪎擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetCodeCommaName03() throws Exception {
        // O
        CodeBean codeBean = new CodeBean();
        UTUtil.setPrivateField(codeBean, "id", "id");
        UTUtil.setPrivateField(codeBean, "name", "name");
        
        // eXg{E
        assertEquals("id,name", codeBean.getCodeCommaName());
    }

}
