/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.service.thin.BLogicMessage} NX
 * ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * bZ[WNXB<br>
 * rWlXWbN̎sʂ󂯂āAbZ[Wݒ肷ۂɐB
 * <p>
 * 
 * @see jp.terasoluna.fw.service.thin.BLogicMessage
 */
public class BLogicMessageTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BLogicMessageTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public BLogicMessageTest(String name) {
        super(name);
    }

    /**
     * testGetKey01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () key:"key"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"key"<br>
     *         
     * <br>
     * BLogicMessageɊi[Ăkey𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetKey01() throws Exception {
        // BLogico͏
        BLogicMessage blogicMessage = new BLogicMessage(null);

        // eXglݒ
        String str = "key";
        
        // keyݒ
        UTUtil.setPrivateField(blogicMessage, "key", str);

        // eXg{E
        assertEquals("key", blogicMessage.getKey());
    }

    /**
     * testGetValues01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () values:{"value1", "value2", "value3"}<br>
     *         
     * <br>
     * ҒlF(߂l) Object[]:{"value1", "value2", "value3"}<br>
     *         
     * <br>
     * BLogicMessageɊi[Ăvalues𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetValues01() throws Exception {
        // BLogico͏
        BLogicMessage blogicMessage = new BLogicMessage(null);

        // eXglݒ
        Object[] values = {"value1", "value2", "value3"};
        
        // valuesݒ
        UTUtil.setPrivateField(blogicMessage, "values", values);

        // eXg{
        Object[] results = blogicMessage.getValues();
        
        // 
        for (int i = 0; i < values.length; i++) {
            assertEquals(values[i], results[i]);
        }
        assertEquals(values.length, results.length);
    }

    /**
     * testIsResource01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () resource:true<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         
     * <br>
     * BLogicMessageɊi[Ăresource𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsResource01() throws Exception {
        // eXglݒ
        BLogicMessage blogicMessage = new BLogicMessage(null);
        
        // eXglݒ
        // resourceݒ
        UTUtil.setPrivateField(blogicMessage, "resource", true);

        // eXg{E
        assertTrue(blogicMessage.isResource());
    }

    /**
     * testBLogicMessageString01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key"<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ:|<br>
     *         (ԕω) key:"key"<br>
     *         (ԕω) values:null<br>
     *         (ԕω) resource:true<br>
     *         
     * <br>
     * key"key"̏ꍇAꂽBLogicMessagekey"key"i[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBLogicMessageString01() throws Exception {
        // eXg{
        BLogicMessage blogicMessage = new BLogicMessage("key");

        // 
        assertEquals("key", UTUtil.getPrivateField(blogicMessage, "key"));
        assertNull(UTUtil.getPrivateField(blogicMessage, "values"));
        assertTrue((Boolean) UTUtil.getPrivateField(blogicMessage, "resource"));
    }

    /**
     * testBLogicMessageString02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() key:""<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ:|<br>
     *         (ԕω) key:""<br>
     *         (ԕω) values:null<br>
     *         (ԕω) resource:true<br>
     *         
     * <br>
     * key󕶎̏ꍇAꂽBLogicMessagekeyɋ󕶎i[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBLogicMessageString02() throws Exception {
        // eXg{
        BLogicMessage blogicMessage = new BLogicMessage("");

        // 
        assertEquals("", UTUtil.getPrivateField(blogicMessage, "key"));
        assertNull(UTUtil.getPrivateField(blogicMessage, "values"));
        assertTrue((Boolean) UTUtil.getPrivateField(blogicMessage, "resource"));
    }

    /**
     * testBLogicMessageString03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() key:null<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ:|<br>
     *         (ԕω) key:null<br>
     *         (ԕω) values:null<br>
     *         (ԕω) resource:true<br>
     *         
     * <br>
     * keynull̏ꍇAꂽBLogicMessagekeynulli[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBLogicMessageString03() throws Exception {
        // eXg{
        BLogicMessage blogicMessage = new BLogicMessage(null);

        // 
        assertNull(UTUtil.getPrivateField(blogicMessage, "key"));
        assertNull(UTUtil.getPrivateField(blogicMessage, "values"));
        assertTrue((Boolean) UTUtil.getPrivateField(blogicMessage, "resource"));
    }

    /**
     * testBLogicMessageStringObject01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key"<br>
     *         () values:{"value1", "value2", "value3"}<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ:|<br>
     *         (ԕω) key:"key"<br>
     *         (ԕω) values:{"value1", "value2", "value3"}<br>
     *         (ԕω) resource:true<br>
     *         
     * <br>
     * key"key"AvaluesIuWFNg̏ꍇAꂽBLogicMessagekey"key"AvaluesɎw̃IuWFNgi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBLogicMessageStringObject01() throws Exception {
        // eXglݒ
        Object[] values = {"value1", "value2", "value3"};
        
        // eXg{
        BLogicMessage blogicMessage = new BLogicMessage("key", values);

        // 
        assertEquals("key", UTUtil.getPrivateField(blogicMessage, "key"));
        Object[] results = (Object[]) UTUtil.getPrivateField(blogicMessage,
                "values");
        for (int i = 0; i < values.length; i++) {
            assertEquals(values[i], results[i]);
        }
        assertEquals(values.length, results.length);
        assertTrue((Boolean) UTUtil.getPrivateField(blogicMessage, "resource"));
        
    }

    /**
     * testBLogicMessageStringObject02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:""<br>
     *         () values:{"value1"}<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ:|<br>
     *         (ԕω) key:""<br>
     *         (ԕω) values:{"value1"}<br>
     *         (ԕω) resource:true<br>
     *         
     * <br>
     * key󕶎AvaluesP̃IuWFNg̏ꍇAꂽBLogicMessagekeyɋ󕶎AvaluesɎw̃IuWFNgi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBLogicMessageStringObject02() throws Exception {
        // eXglݒ
        Object[] values = {"value1"};
        
        // eXg{
        BLogicMessage blogicMessage = new BLogicMessage("", values);

        // 
        assertEquals("", UTUtil.getPrivateField(blogicMessage, "key"));
        Object[] results = ((Object[]) UTUtil.getPrivateField(blogicMessage,
                "values"));
        assertEquals(1, results.length);
        assertEquals("value1", results[0]);
        assertTrue((Boolean) UTUtil.getPrivateField(blogicMessage, "resource"));
    }

    /**
     * testBLogicMessageStringObject03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() key:null<br>
     *         () values:null<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ:|<br>
     *         (ԕω) key:null<br>
     *         (ԕω) values:null<br>
     *         (ԕω) resource:true<br>
     *         
     * <br>
     * keynullAvaluesnull̏ꍇAꂽBLogicMessagekeynullAvaluesnulli[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBLogicMessageStringObject03() throws Exception {        
        // eXg{
        BLogicMessage blogicMessage = new BLogicMessage(null, (Object[]) null);

        // 
        assertNull(UTUtil.getPrivateField(blogicMessage, "key"));
        assertNull(UTUtil.getPrivateField(blogicMessage, "values"));
        assertTrue((Boolean) UTUtil.getPrivateField(blogicMessage, "resource"));
    }

    /**
     * testBLogicMessageStringObject04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() key:"key"<br>
     *         () values:{ }i̔zj<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ:|<br>
     *         (ԕω) key:"key"<br>
     *         (ԕω) values:{ }<br>
     *         (ԕω) resource:true<br>
     *         
     * <br>
     * values̔z̏ꍇAꂽBLogicMessagevaluesɋ̔z񂪊i[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBLogicMessageStringObject04() throws Exception {
        // eXglݒ
        Object[] values = new Object[] {};
        
        // eXg{
        BLogicMessage blogicMessage = new BLogicMessage("key", values);

        // 
        assertEquals("key", UTUtil.getPrivateField(blogicMessage, "key"));
        assertEquals(0, ((Object[]) UTUtil.getPrivateField(blogicMessage,
                "values")).length);
        assertTrue((Boolean) UTUtil.getPrivateField(blogicMessage, "resource"));
    }

    /**
     * testBLogicMessageStringboolean01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key"<br>
     *         () resource:true<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ:|<br>
     *         (ԕω) key:"key"<br>
     *         (ԕω) resource:true<br>
     *         
     * <br>
     * key"key"AresourcetruȅꍇAꂽBLogicMessagekey"key"Aresourcetruei[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBLogicMessageStringboolean01() throws Exception {
        // eXg{
        BLogicMessage blogicMessage = new BLogicMessage("key", true);

        // 
        assertEquals("key", UTUtil.getPrivateField(blogicMessage, "key"));
        assertTrue((Boolean) UTUtil.getPrivateField(blogicMessage, "resource"));
    }

    /**
     * testBLogicMessageStringboolean02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FAAC
     * <br><br>
     * ͒lF() key:""<br>
     *         () resource:false<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ:|<br>
     *         (ԕω) key:""<br>
     *         (ԕω) resource:false<br>
     *         
     * <br>
     * key󕶎AresourcefalsȅꍇAꂽBLogicMessagekeyɋ󕶎A"Aresourcefalsei[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBLogicMessageStringboolean02() throws Exception {
        // eXg{
        BLogicMessage blogicMessage = new BLogicMessage("", false);

        // 
        assertEquals("", UTUtil.getPrivateField(blogicMessage, "key"));
        assertFalse((Boolean) UTUtil.getPrivateField(blogicMessage, "resource"));
    }

    /**
     * testBLogicMessageStringboolean03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() key:null<br>
     *         () resource:true<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ:|<br>
     *         (ԕω) key:null<br>
     *         (ԕω) resource:true<br>
     *         
     * <br>
     * keynull̏ꍇAꂽBLogicMessagekeynulli[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBLogicMessageStringboolean03() throws Exception {
        // eXg{
        BLogicMessage blogicMessage = new BLogicMessage(null, true);

        // 
        assertNull(UTUtil.getPrivateField(blogicMessage, "key"));
        assertTrue((Boolean) UTUtil.getPrivateField(blogicMessage, "resource"));
    }

}
