/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.PropertyUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * PtH[hANVB
 *
 * <p>
 *  ActionEx̋@\iJڃOóEgUNVg[N`FbNjpA
 *  JSPȂǂփtH[hANVłB
 *  Struts񋟂ĂForwardActionƓl
 *  struts-config.xml&lt;action&gt;vf
 *  parameterɎw肵ɃtH[hB
 *  parameterݒ肳ĂȂꍇA
 *  Œ̘_tH[husuccessvŃANVtH[h擾B
 *  tH[h悪ݒ肳ĂȂꍇA
 *  SC_NOT_FOUNDi404jG[ԂB
 *  *.jspt@Cւ̒ڃANZX֎~ĂꍇɁA
 *  JSPƖoPɕ\ɂ
 *  ̃ANVpstruts-config.xml
 *  ɃGg쐬KvB
 *  ActionEx#execute()ōsĂ鏈́A
 *  łpB
 * </p>
 * 
 *<br>
 *
 * <p>Bean`t@Cystruts-config.xml̋LqȉɎB</p>
 *
 * :<br>
 * <p>
 *  <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *   <legend><strong>Bean`t@C̐ݒ</strong></legend>
 *   <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *  <code><pre>
 *  &lt;bean name="/foo" scope="prototype"
 *      <strong>class="jp.terasoluna.fw.web.struts.actions.ForwardAction"</strong>&gt
 *  &lt;/bean&gt
 *  </pre></code>
 *   </fieldset>
 *  </fieldset>
 * </p>
 * 
 * <p>
 *  <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *   <legend><strong>struts-config.xml̐ݒ</strong></legend>
 *   <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *    <code><pre>
 *  &lt;action path="/foo"
 *          parameter="/foo.jsp"&gt;
 *  &lt;/action&gt;
 *    </pre></code>
 *   </fieldset>
 *   ܂
 *   <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *    <code><pre>
 *  &lt;action path="/foo"
 *          parameter="/foo.jsp"&gt;
 *    &lt;forward name="success" path="/foo.jsp" module="/sub1" redirect="true"&gt;
 *  &lt;/action&gt;
 *    </pre></code>
 *   </fieldset>
 *  </fieldset>
 * </p>
 *
 *<br>
 *
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *  <legend><strong>contextRelativetB[h</strong></legend>
 * <strong>parameter</strong>̃pX̎w@ύXB
 * 
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *  <legend><strong>contextRelative̐ݒlɂpX̎w@̈Ⴂ</strong></legend>
 *  <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *   <legend><strong>true</strong>̏ꍇ</legend>
 *   parameterł́AReLXg[g̐΃pX̎wƂȂB<br>
 *   {IɓꃂW[̑JڂɎgpB
 *   <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *    <code><pre>
 *  &lt;action path="/pagelinkForward"
 *          parameter="<strong>/pagelink/</strong>sc2401.jsp"/&gt;
 *    </pre></code>
 *   </fieldset> 
 *  </fieldset> 
 *  <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *   <legend><strong>false</strong>̏ꍇ</legend>
 *   parameterł́AW[΃pX̎w肵sȂȂB<br>
 *  W[ׂJڂ⃊_CNgsȂꍇ́A
 *  Ƃ&lt;forward&gt;vfgp邱ƁB
 *   <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *    <code><pre>
 *  &lt;action path="/pagelinkForward"
 *          parameter="<strong>/</strong>sc2401.jsp"/&gt;
 *    </pre></code>
 *   </fieldset> 
 *  </fieldset> 
 * </fieldset> 
 * 
 * 
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *  <legend><strong>contextRelative̐ݒ@</strong></legend>
 *  system.propertiesɐݒLqB<br>
 *  ݒ莩̂ȗꍇ <strong>false</strong> ƂĈB<br>
 *  <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *   <legend><strong>system.properties</strong></legend>
 *    <code><pre>
 * forwardAction.contextRelative=true
 *    </pre></code>
 *  </fieldset> 
 * </fieldset> 
 * </fieldset> 
 *
 *<br>
 *
 */
public class ForwardAction extends ActionEx {

    /**
     * ONXB
     */
    private static Log log
              = LogFactory.getLog(ForwardAction.class);

    /**
     * G[y[Wi404jJڎsG[R[hB
     */
    private static final String FORWARD_ERRORPAGE_ERROR =
        "error.forward.errorpage";

    /**
     * Œ̘_tH[hB
     */
    private static final String FORWARD_SUCCESS = "success";

    /**
     * contextRelativeݒl̃vpeBL[
     */
    private static final String FORWARD_ACTION_CONTEXT_RELATIVE_KEY = "forwardAction.contextRelative";
       
    /**
     * parameterɐݒ肳ꂽJڐ
     * ANVtH[hɃZbgĕԂB
     * parameterݒ肳ĂȂꍇA
     * Jڐ_tH[h"success"
     * ANVtH[h擾ĕԂB
     * ǂݒ肳ĂȂꍇ́Ai404jG[ԂB
     *
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @return Jڐ̃ANVtH[h
     */
    @SuppressWarnings("deprecation")
    @Override
    public ActionForward doExecute(ActionMapping mapping,
                                ActionForm form,
                                HttpServletRequest req,
                                HttpServletResponse res) {
        if (log.isDebugEnabled()) {
            log.debug("doExecute() called.");
        }

        // parameteritH[hj擾
        String path = mapping.getParameter();

        // ANVtH[h𐶐
        ActionForward retVal = null;

        if (path == null) {

            // ActionMappingActionForward擾
            retVal = mapping.findForward(FORWARD_SUCCESS);

            // ActionFowardݒ肳ĂȂꍇ
            if (retVal == null) {
                // parameterAforwardvfƂɐݒ肳ĂȂꍇA
                // i404jG[ԋp
                try {
                    res.sendError(HttpServletResponse.SC_NOT_FOUND);
                } catch (IOException e) {
                    log.error("Error page(404) forwarding failed.");

                    throw new SystemException(e, FORWARD_ERRORPAGE_ERROR);
                }
                return null;
            }
            return retVal;
        }

        retVal = new ActionForward(path);

        // contextRelativeݒl擾
        String contextRelativeStr = PropertyUtil.getProperty(
                FORWARD_ACTION_CONTEXT_RELATIVE_KEY, Boolean.FALSE.toString());
        Boolean contextRelative = new Boolean(contextRelativeStr);

        // ActionForwardcontextRelative̒lݒ肷
        retVal.setContextRelative(contextRelative);
        if (log.isDebugEnabled()) {
            StringBuilder debugLog = new StringBuilder();
            debugLog.append("contextRelative:");
            debugLog.append(contextRelative);
            log.debug(debugLog.toString());
        }

        return retVal;
    }

}
