/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.message;

import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockDataSource;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.message.DBMessageResourceDAOImpl}
 * NX̃ubN{bNXeXgB
 * <p>
 * <h4>yNX̊Tvz</h4>
 * DB烁bZ[W\[X擾DBMessageResourceDAO̎NX
 * <p>
 * 
 * @see jp.terasoluna.fw.message.DBMessageResourceDAOImpl
 */
public class DBMessageResourceDAOImplTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DBMessageResourceDAOImplTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DBMessageResourceDAOImplTest(String name) {
        super(name);
    }

    /**
     * testSetTableName01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() tableName:"test01"<br>
     *         () this.tableName:"MESSAGES"<br>
     *         
     * <br>
     * ҒlF(ԕω) this.tableName:Őݒ肵l<br>
     *         
     * <br>
     * tableNamesetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetTableName01() throws Exception {
        // O
        DBMessageResourceDAOImpl daoImpl = new DBMessageResourceDAOImpl();
        daoImpl.tableName = "MESSAGES";

        // eXg{
        daoImpl.setTableName("test01");

        // 
        assertEquals("test01", UTUtil.getPrivateField(daoImpl, "tableName"));
    }

    /**
     * testSetCodeColumn01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() codeColumn:"test01"<br>
     *         () this.codeColumn:"CODE"<br>
     *         
     * <br>
     * ҒlF(ԕω) this.codeColumn:Őݒ肵l<br>
     *         
     * <br>
     * codeColumnsetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetCodeColumn01() throws Exception {
        // O
        DBMessageResourceDAOImpl daoImpl = new DBMessageResourceDAOImpl();
        daoImpl.codeColumn = "CODE";

        // eXg{
        daoImpl.setCodeColumn("test01");

        // 
        assertEquals("test01", UTUtil.getPrivateField(daoImpl, "codeColumn"));
    }

    /**
     * testSetLaunguageColumn01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() languageColumn:"test01"<br>
     *         () this.languageColumn:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.languageColumn:Őݒ肵l<br>
     *         
     * <br>
     * languageColumnsetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetLaunguageColumn01() throws Exception {
        // O
        DBMessageResourceDAOImpl daoImpl = new DBMessageResourceDAOImpl();
        daoImpl.languageColumn = null;

        // eXg{
        daoImpl.setLanguageColumn("test01");

        // 
        assertEquals("test01", UTUtil
                .getPrivateField(daoImpl, "languageColumn"));
    }

    /**
     * testSetCountryColumn01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() countryColumn:"test01"<br>
     *         () this.countryColumn:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.countryColumn:Őݒ肵l<br>
     *         
     * <br>
     * countryColumnsetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetCountryColumn01() throws Exception {
        // O
        DBMessageResourceDAOImpl daoImpl = new DBMessageResourceDAOImpl();
        daoImpl.countryColumn = null;

        // eXg{
        daoImpl.setCountryColumn("test01");

        // 
        assertEquals("test01", UTUtil
                .getPrivateField(daoImpl, "countryColumn"));
    }

    /**
     * testSetVariantColumn01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() variantColumn:"test01"<br>
     *         () this.variantColumn:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.variantColumn:Őݒ肵l<br>
     *         
     * <br>
     * variantColumnsetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetVariantColumn01() throws Exception {
        // O
        DBMessageResourceDAOImpl daoImpl = new DBMessageResourceDAOImpl();
        daoImpl.variantColumn = null;

        // eXg{
        daoImpl.setVariantColumn("test01");

        // 
        assertEquals("test01", UTUtil
                .getPrivateField(daoImpl, "variantColumn"));
    }

    /**
     * testSetMessageColumn01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() messageColumn:"test01"<br>
     *         () this.messageColumn:"MESSAGE"<br>
     *         
     * <br>
     * ҒlF(ԕω) this.messageColumn:Őݒ肵l<br>
     *         
     * <br>
     * messageColumnsetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetMessageColumn01() throws Exception {
        // O
        DBMessageResourceDAOImpl daoImpl = new DBMessageResourceDAOImpl();
        daoImpl.messageColumn = "MESSAGE";

        // eXg{
        daoImpl.setMessageColumn("test01");

        // 
        assertEquals("test01", UTUtil
                .getPrivateField(daoImpl, "messageColumn"));
    }

    /**
     * testSetFindMessageSql01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() findMessageSql:"test01"<br>
     *         () this.findMessageSql:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.findMessageSql:Őݒ肵l<br>
     *         
     * <br>
     * findMessageSqlsetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetFindMessageSql01() throws Exception {
        // O
        DBMessageResourceDAOImpl daoImpl = new DBMessageResourceDAOImpl();
        daoImpl.findMessageSql = null;

        // eXg{
        daoImpl.setFindMessageSql("test01");

        // 
        assertEquals("test01", UTUtil
                .getPrivateField(daoImpl, "findMessageSql"));
    }

    /**
     * testInitDao01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() getDataSource():not null<br>
     *         () makeSql():"SELECT FOO FROM BAR"<br>
     *         () dBMessageQuery:null<br>
     *         () codeColumn:"CODE"<br>
     *         () languageColumn:"LANGUAGE"<br>
     *         () countryColumn:"COUNTRY"<br>
     *         () variantColumn:"VARIANT"<br>
     *         () messageColumn:"MESSAGE"<br>
     *         
     * <br>
     * ҒlF(ԕω) DBMessageQuery:DBMessageQueryIuWFNgB
     * <br>
     *         
     * <br>
     * DBMessageQueryĂяoAthis.dBMessageQueryɊi[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitDao01() throws Exception {
        // O
        DataSource dataSource = new MockDataSource();
        DBMessageResourceDAOImpl_JdbcTemplateStub01 jdbc
            = new DBMessageResourceDAOImpl_JdbcTemplateStub01();
        DBMessageResourceDAOImpl_DBMessageResourceDAOImplStub01 dbmr
                = new DBMessageResourceDAOImpl_DBMessageResourceDAOImplStub01();
        jdbc.ds = dataSource;
        UTUtil.setPrivateField(dbmr, "jdbcTemplate", jdbc);
        
        dbmr.dBMessageQuery = null;
        dbmr.codeColumn = "CODE";
        dbmr.languageColumn = "LANGUAGE";
        dbmr.countryColumn = "COUNTRY";
        dbmr.variantColumn = "VARIANT";
        dbmr.messageColumn = "MESSAGE";
        
        // eXg{
        dbmr.initDao();

        // 
        DBMessageQuery query = dbmr.dBMessageQuery;
        
        assertEquals("CODE", query.rsCodeColumn);
        assertEquals("LANGUAGE", query.rsLanguageColumn);
        assertEquals("COUNTRY", query.rsCountryColumn);
        assertEquals("VARIANT", query.rsVariantColumn);
        assertEquals("MESSAGE", query.rsMessageColumn);
        assertTrue(dbmr.isRead);
    }

    /**
     * testInitDao02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() getDataSource():null<br>
     *         () makeSql():"SELECT FOO FROM BAR"<br>
     *         () dBMessageQuery:null<br>
     *         () codeColumn:"CODE"<br>
     *         () languageColumn:null<br>
     *         () countryColumn:null<br>
     *         () variantColumn:null<br>
     *         () messageColumn:"MESSAGE"<br>
     *         
     * <br>
     * ҒlF(ԕω) DBMessageQuery:[<br>
     *         (ԕω) O:illgalArgumentException邱ƂmFB
     *         <br>
     *                    bZ[W<br>
     *                    Missing dataSource in spring configuration file.<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    Missing dataSource in spring configuration file.<br>
     *         
     * <br>
     * DBMessageQueryĂяoꂸAO邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitDao02() throws Exception {
        // O
        DBMessageResourceDAOImpl_JdbcTemplateStub01 jdbc
            = new DBMessageResourceDAOImpl_JdbcTemplateStub01();
        DBMessageResourceDAOImpl_DBMessageResourceDAOImplStub01 dbmr
                = new DBMessageResourceDAOImpl_DBMessageResourceDAOImplStub01();
        jdbc.ds = null;
        
        dbmr.dBMessageQuery = null;
       
        dbmr.codeColumn = "CODE";
        dbmr.languageColumn = "LANGUAGE";
        dbmr.countryColumn = "COUNTRY";
        dbmr.variantColumn = "VARIANT";
        dbmr.messageColumn = "MESSAGE";
        
        // eXg{
        try {
            dbmr.initDao();
            fail();
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(
                    "Missing dataSource in spring configuration file.",
                    e.getMessage());
            assertTrue(LogUTUtil.checkError(
                    "Missing dataSource in spring configuration file."));
        }
    }

    /**
     * testInitDao03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() getDataSource():not null<br>
     *         () makeSql():"SELECT FOO FROM BAR"<br>
     *         () dBMessageQuery:null<br>
     *         () codeColumn:"CODE"<br>
     *         () languageColumn:null<br>
     *         () countryColumn:null<br>
     *         () variantColumn:null<br>
     *         () messageColumn:"MESSAGE"<br>
     *         
     * <br>
     * ҒlF(ԕω) DBMessageQuery:DBMessageQueryIuWFNgB
     * <br>       
     * <br>
     * DBMessageQueryĂяoAthis.dBMessageQueryɊi[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitDao03() throws Exception {
        // O
        DataSource dataSource = new MockDataSource();
        DBMessageResourceDAOImpl_JdbcTemplateStub01 jdbc
            = new DBMessageResourceDAOImpl_JdbcTemplateStub01();
        DBMessageResourceDAOImpl_DBMessageResourceDAOImplStub01 dbmr
                = new DBMessageResourceDAOImpl_DBMessageResourceDAOImplStub01();
        jdbc.ds = dataSource;
        UTUtil.setPrivateField(dbmr, "jdbcTemplate", jdbc);
        
        dbmr.dBMessageQuery = null;
        dbmr.codeColumn = "CODE";
        dbmr.languageColumn = null;
        dbmr.countryColumn = null;
        dbmr.variantColumn = null;
        dbmr.messageColumn = "MESSAGE";
        
        // eXg{
        dbmr.initDao();

        // 
        // 
        DBMessageQuery query = dbmr.dBMessageQuery;
        
        assertEquals("CODE", query.rsCodeColumn);
        assertNull(query.rsLanguageColumn);
        assertNull(query.rsCountryColumn);
        assertNull(query.rsVariantColumn);
        assertEquals("MESSAGE", query.rsMessageColumn);
        assertTrue(dbmr.isRead);
    }

    /**
     * testMakeSql01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() codeColumn:"CODE"<br>
     * () languageColumn:"LANGUAGE"<br>
     * () countryColumn:"COUNTRY"<br>
     * () variantColumn:"VARIANT"<br>
     * () messageColumn:"MESSAGE"<br>
     * () tableName:"MESSAGES"<br>
     * () findMessageSql:null<br>
     * <br>
     * ҒlF(߂l) sql:"SELECT CODE,LANGUAGE,COUNTRY,VARIANT,MESSAGE FROM
     * MESSAGES"<br>
     * <br>
     * ƂĂꂽ񂩂rpk쐬AStringŕԋpB<br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testMakeSql01() throws Exception {
        // O
        DBMessageResourceDAOImpl dbmr = new DBMessageResourceDAOImpl();
        dbmr.codeColumn = "CODE";
        dbmr.languageColumn = "LANGUAGE";
        dbmr.countryColumn = "COUNTRY";
        dbmr.variantColumn = "VARIANT";
        dbmr.messageColumn = "MESSAGE";
        dbmr.tableName = "MESSAGES";
        dbmr.findMessageSql = null;
        
        // eXg{
        String sql = dbmr.makeSql();

        // 
        assertEquals(
            "SELECT CODE,LANGUAGE,COUNTRY,VARIANT,MESSAGE FROM MESSAGES", sql);
    }

    /**
     * testMakeSql02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG<br>
     * <br>
     * ͒lF() codeColumn:""<br>
     * () languageColumn:"LANGUAGE"<br>
     * () countryColumn:"COUNTRY"<br>
     * () variantColumn:"VARIANT"<br>
     * () messageColumn:"MESSAGE"<br>
     * () tableName:"MESSAGES"<br>
     * () findMessageSql:null<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentExceptionF<br>
     * bZ[W<br>
     * "codeColumn is illegalAurgument"<br>
     * (ԕω) O:yG[Oz<br>
     * bZ[W<br>
     * "codeColumn is illegalAurgument"<br>
     * <br>
     * R[hJ󕶎̂߁AĂяo惁\bhɂĒ~B <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testMakeSql02() throws Exception {
        // O
        DBMessageResourceDAOImpl dbmr 
                = new DBMessageResourceDAOImpl();
        dbmr.codeColumn = "";
        dbmr.languageColumn = "LANGUAGE";
        dbmr.countryColumn = "COUNTRY";
        dbmr.variantColumn = "VARIANT";
        dbmr.messageColumn = "MESSAGE";
        dbmr.tableName = "MESSAGES";
        dbmr.findMessageSql = null;
        
        // eXg{
        try {
            dbmr.makeSql();
            fail();
        } catch (IllegalArgumentException e) {

            // 
            assertEquals(
                    "illegalArgument: codeColumn is null or empty.", e.getMessage());
            assertTrue(LogUTUtil
                    .checkError("illegalArgument: codeColumn is null or empty."));
        }
    }

    /**
     * testMakeSql03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() codeColumn:null<br>
     * () languageColumn:"LANGUAGE"<br>
     * () countryColumn:"COUNTRY"<br>
     * () variantColumn:"VARIANT"<br>
     * () messageColumn:"MESSAGE"<br>
     * () tableName:"MESSAGES"<br>
     * () findMessageSql:null<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentExceptionF<br>
     * bZ[W<br>
     * "codeColumn is illegalArgument"<br>
     * (ԕω) O:yG[Oz<br>
     * bZ[W<br>
     * "codeColumn is illegalArgument"<br>
     * <br>
     * R[hJnull̂߁AĂяo惁\bhɂĒ~B <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testMakeSql03() throws Exception {
        // O
        DBMessageResourceDAOImpl dbmr 
                = new DBMessageResourceDAOImpl();
        dbmr.codeColumn = null;
        dbmr.languageColumn = "LANGUAGE";
        dbmr.countryColumn = "COUNTRY";
        dbmr.variantColumn = "VARIANT";
        dbmr.messageColumn = "MESSAGE";
        dbmr.tableName = "MESSAGES";
        dbmr.findMessageSql = null;
        
        // eXg{
        try {
            dbmr.makeSql();
            fail();
        } catch (IllegalArgumentException e) {

            // 
            assertEquals(
                    "illegalArgument: codeColumn is null or empty.", e.getMessage());
            assertTrue(LogUTUtil
                    .checkError("illegalArgument: codeColumn is null or empty."));
        }
    }

    /**
     * testMakeSql04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() codeColumn:"CODE"<br>
     * () languageColumn:""<br>
     * () countryColumn:null<br>
     * () variantColumn:null<br>
     * () messageColumn:null<br>
     * () tableName:"MESSAGES"<br>
     * () findMessageSql:null<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentExceptionF<br>
     * bZ[W<br>
     * "languageColumn is illegalArgument"<br>
     * (ԕω) O:yG[Oz<br>
     * bZ[W<br>
     * "languageColumn is illegalArgument"<br>
     * <br>
     * J󕶎̂߁AĂяo惁\bhɂĒ~B <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testMakeSql04() throws Exception {
        // O
        DBMessageResourceDAOImpl dbmr 
                = new DBMessageResourceDAOImpl();
        dbmr.codeColumn = "CODE";
        dbmr.languageColumn = "";
        dbmr.countryColumn = null;
        dbmr.variantColumn = null;
        dbmr.messageColumn = null;
        dbmr.tableName = "MESSAGES";
        dbmr.findMessageSql = null;
        
        // eXg{
        try {
            dbmr.makeSql();
            fail();
        } catch (IllegalArgumentException e) {

            // 
            assertEquals(
                    "illegalArgument: languageColumn is empty.", e.getMessage());
            assertTrue(LogUTUtil
                    .checkError("illegalArgument: languageColumn is empty."));
        }
    }

    /**
     * testMakeSql05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() codeColumn:"CODE"<br>
     * () languageColumn:null<br>
     * () countryColumn:""<br>
     * () variantColumn:null<br>
     * () messageColumn:null<br>
     * () tableName:"MESSAGES"<br>
     * () findMessageSql:null<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentExceptionF<br>
     * bZ[W<br>
     * "countryColumn is illegalArgument"<br>
     * (ԕω) O:yG[Oz<br>
     * bZ[W<br>
     * "countryColumn is illegalArgument"<br>
     * <br>
     * J󕶎̂߁AĂяo惁\bhɂĒ~B <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testMakeSql05() throws Exception {
        // O
        DBMessageResourceDAOImpl dbmr 
                = new DBMessageResourceDAOImpl();
        dbmr.codeColumn = "CODE";
        dbmr.languageColumn = null;
        dbmr.countryColumn = "";
        dbmr.variantColumn = null;
        dbmr.messageColumn = null;
        dbmr.tableName = "MESSAGES";
        dbmr.findMessageSql = null;
        
        // eXg{
        try {
            dbmr.makeSql();
            fail();
        } catch (IllegalArgumentException e) {

            // 
            assertEquals(
                    "illegalArgument: countryColumn is empty.", e.getMessage());
            assertTrue(LogUTUtil
                    .checkError("illegalArgument: countryColumn is empty."));
        }
    }

    /**
     * testMakeSql06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() codeColumn:"CODE"<br>
     * () languageColumn:null<br>
     * () countryColumn:null<br>
     * () variantColumn:""<br>
     * () messageColumn:null<br>
     * () tableName:"MESSAGES"<br>
     * () findMessageSql:null<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentExceptionF<br>
     * bZ[W<br>
     * "variantColumn is illegalArgument"<br>
     * (ԕω) O:yG[Oz<br>
     * bZ[W<br>
     * "variantColumn is illegalArgument"<br>
     * <br>
     * oAgJ󕶎̂߁AĂяo惁\bhɂĒ~B <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testMakeSql06() throws Exception {
        // O
        DBMessageResourceDAOImpl dbmr 
                = new DBMessageResourceDAOImpl();
        dbmr.codeColumn = "CODE";
        dbmr.languageColumn = null;
        dbmr.countryColumn = null;
        dbmr.variantColumn = "";
        dbmr.messageColumn = null;
        dbmr.tableName = "MESSAGES";
        dbmr.findMessageSql = null;
        
        // eXg{
        try {
            dbmr.makeSql();
            fail();
        } catch (IllegalArgumentException e) {

            // 
            assertEquals(
                    "illegalArgument: variantColumn is empty.", e.getMessage());
            assertTrue(LogUTUtil
                    .checkError("illegalArgument: variantColumn is empty."));
        }
    }

    /**
     * testMakeSql07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() codeColumn:"CODE"<br>
     * () languageColumn:null<br>
     * () countryColumn:null<br>
     * () variantColumn:null<br>
     * () messageColumn:""<br>
     * () tableName:"MESSAGES"<br>
     * () findMessageSql:null<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentExceptionF<br>
     * bZ[W<br>
     * "messageColumn is illegalArgument"<br>
     * (ԕω) O:yG[Oz<br>
     * bZ[W<br>
     * "messageColumn is illegalArgument"<br>
     * <br>
     * bZ[WJ󕶎̂߁AĂяo惁\bhɂĒ~B <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testMakeSql07() throws Exception {
        // O
        DBMessageResourceDAOImpl dbmr 
                = new DBMessageResourceDAOImpl();
        dbmr.codeColumn = "CODE";
        dbmr.languageColumn = null;
        dbmr.countryColumn = null;
        dbmr.variantColumn = null;
        dbmr.messageColumn = "";
        dbmr.tableName = "MESSAGES";
        dbmr.findMessageSql = null;
        
        // eXg{
        try {
            dbmr.makeSql();
            fail();
        } catch (IllegalArgumentException e) {

            // 
            assertEquals(
                    "illegalArgument: messageColumn is null or empty.", e.getMessage());
            assertTrue(LogUTUtil
                    .checkError("illegalArgument: messageColumn is null or empty."));
        }
    }

    /**
     * testMakeSql08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() codeColumn:"CODE"<br>
     * () languageColumn:null<br>
     * () countryColumn:null<br>
     * () variantColumn:null<br>
     * () messageColumn:null<br>
     * () tableName:"MESSAGES"<br>
     * () findMessageSql:null<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentExceptionF<br>
     * bZ[W<br>
     * "MessageColumn is illegalArgument"<br>
     * (ԕω) O:yG[Oz<br>
     * bZ[W<br>
     * "MessageColumn is illegalArgument"<br>
     * <br>
     * bZ[WJnull̂߁AĂяo惁\bhɂĒ~B <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testMakeSql08() throws Exception {
        // O
        DBMessageResourceDAOImpl dbmr 
                = new DBMessageResourceDAOImpl();
        dbmr.codeColumn = "CODE";
        dbmr.languageColumn = null;
        dbmr.countryColumn = null;
        dbmr.variantColumn = null;
        dbmr.messageColumn = null;
        dbmr.tableName = "MESSAGES";
        dbmr.findMessageSql = null;
        
        // eXg{
        try {
            dbmr.makeSql();
            fail();
        } catch (IllegalArgumentException e) {

            // 
            assertEquals(
                    "illegalArgument: messageColumn is null or empty.", e.getMessage());
            assertTrue(LogUTUtil
                    .checkError("illegalArgument: messageColumn is null or empty."));
        }
    }
    
    /**
     * testMakeSql09() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() codeColumn:"CODE"<br>
     * () languageColumn:null<br>
     * () countryColumn:null<br>
     * () variantColumn:null<br>
     * () messageColumn:"MESSAGE"<br>
     * () tableName:""<br>
     * () findMessageSql:null<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentExceptionF<br>
     * bZ[W<br>
     * "tableName is illegalArgument"<br>
     * (ԕω) O:yG[Oz<br>
     * bZ[W<br>
     * "tableName is illegalArgument"<br>
     * <br>
     * e[u󕶎̂߁AĂяo惁\bhɂĒ~B <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testMakeSql09() throws Exception {
        // O
        DBMessageResourceDAOImpl dbmr 
                = new DBMessageResourceDAOImpl();
        dbmr.codeColumn = "CODE";
        dbmr.languageColumn = null;
        dbmr.countryColumn = null;
        dbmr.variantColumn = null;
        dbmr.messageColumn = "MESSAGE";
        dbmr.tableName = "";
        dbmr.findMessageSql = null;
        
        // eXg{
        try {
            dbmr.makeSql();
            fail();
        } catch (IllegalArgumentException e) {

            // 
            assertEquals(
                    "illegalArgument: tableName is null or empty.", e.getMessage());
            assertTrue(LogUTUtil
                    .checkError("illegalArgument: tableName is null or empty."));
        }
    }

    /**
     * testMakeSql10() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() codeColumn:"CODE"<br>
     * () languageColumn:null<br>
     * () countryColumn:null<br>
     * () variantColumn:null<br>
     * () messageColumn:"MESSAGE"<br>
     * () tableName:null<br>
     * () findMessageSql:null<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentExceptionF<br>
     * bZ[W<br>
     * "tableName is illegalArgument"<br>
     * (ԕω) O:yG[Oz<br>
     * bZ[W<br>
     * "tableName is illegalArgument"<br>
     * <br>
     * e[unull̂߁AĂяo惁\bhɂĒ~B <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testMakeSql10() throws Exception {
        // O
        DBMessageResourceDAOImpl dbmr 
                = new DBMessageResourceDAOImpl();
        dbmr.codeColumn = "CODE";
        dbmr.languageColumn = null;
        dbmr.countryColumn = null;
        dbmr.variantColumn = null;
        dbmr.messageColumn = "MESSAGE";
        dbmr.tableName = null;
        dbmr.findMessageSql = null;
        
        // eXg{
        try {
            dbmr.makeSql();
            fail();
        } catch (IllegalArgumentException e) {

            // 
            assertEquals(
                    "illegalArgument: tableName is null or empty.", e.getMessage());
            assertTrue(LogUTUtil
                    .checkError("illegalArgument: tableName is null or empty."));
        }
    }

    /**
     * testMakeSql11() <br>
     * <br>
     * (n) <br>
     * ϓ_FA,F <br>
     * <br>
     * ͒lF() codeColumn:"CODE"<br>
     * () languageColumn:null<br>
     * () countryColumn:null<br>
     * () variantColumn:null<br>
     * () messageColumn:"MESSAGE"<br>
     * () tableName:"MESSAGES"<br>
     * () findMessageSql:"SELECT CODE,LANGUAGE,COUNTRY,VARIANT,MESSAGE FROM
     * MESSAGES"<br>
     * <br>
     * ҒlF(߂l) sql:"SELECT CODE,LANGUAGE,COUNTRY,VARIANT,MESSAGE FROM
     * MESSAGES"<br>
     * <br>
     * ƂĂꂽSQLAStringŕԋpB<br>
     * SQLWbN͎gpȂB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testMakeSql11() throws Exception {
        // O
        DBMessageResourceDAOImpl dbmr 
                = new DBMessageResourceDAOImpl();
        String sql ="SELECT CODE,LANGUAGE,COUNTRY,VARIANT,MESSAGE FROM MESSAGES";
        dbmr.codeColumn = "CODE";
        dbmr.languageColumn = null;
        dbmr.countryColumn = null;
        dbmr.variantColumn = null;
        dbmr.messageColumn = "MESSAGE";
        dbmr.tableName = "MESSAGES";
        dbmr.findMessageSql = sql;
        
        // eXg{
        String sqlReturn = dbmr.makeSql();
        
        // 
        assertEquals(sql, sqlReturn);
    }

    /**
     * testFindDBMessages01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() dBmessageQuery:not null<br>
     *         
     * <br>
     * ҒlF(߂l) dBMessageQuery.execute()̌<br>
     *         
     * <br>
     * execute\bhĂяoA߂lԂĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFindDBMessages01() throws Exception {
        // O
        DataSource ds = new MockDataSource();
        DBMessageResourceDAOImpl_DBMessageQueryStub01 query
                = new DBMessageResourceDAOImpl_DBMessageQueryStub01(ds,
                "SELECT CODE,MESSAGE FROM MESSAGES", "CODE", "LANGUAGE",
                "COUNTRY", "VARIANT", "MESSAGE");
        DBMessageResourceDAOImpl dbmr = new DBMessageResourceDAOImpl();
        dbmr.dBMessageQuery = query;
        
        List list = new ArrayList();
        list.add("success");
        query.list = list;
        
        // eXg{
        List listReturn = dbmr.findDBMessages();
        
        // 
        assertSame(list, listReturn);
    }
}
