/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.exception;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * SystemException ubN{bNXeXgB<br>
 *
 *
 * @version 2004/04/21
 */

public class SystemExceptionTest extends TestCase {

    /**
      * eXgpSystemExceptiontB[hB
      */
    private SystemException se1 = null;

    /**
     * SystemExceptioneXgۂɍsB
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testSystemExceptionThrowable01()<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFcause = not null<br>
     * ҒlFcause = not null, errorCode = ""ݒ肳B<br>
     * 
     * TvFcauseNotNullŁAbZ[W̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowable01() throws Exception {

        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        assertEquals("testException", throwWord);
        assertEquals("", errorCode);

    }

    /**
     * testSystemExceptionThrowable02()<br>
     *
     * (n)<br>
     * ϓ_FC<br>
     *
     * ͒lFcause = ""<br>
     * ҒlFcause = "", errorCode = ""ݒ肳B<br>
     * 
     * TvFcauseNotNullŁAbZ[W󔒂̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowable02() throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("");

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        assertEquals("", throwWord);
        assertEquals("", errorCode);
    }

    /**
     * testSystemExceptionThrowable03()<br>
     *
     * (n)<br>
     * ϓ_FC<br>
     *
     * ͒lFcause = null<br>
     * ҒlFcause = null, errorCode = ""ݒ肳B<br>
     * 
     * TvFcausenull̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowable03() throws Exception {

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(null);

        // o͒l̊mFB
        Throwable throWord = (Throwable) UTUtil.getPrivateField(se1, "cause");
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        assertNull(throWord);
        assertEquals("", errorCode);
    }

    /**
     * testSystemExceptionThrowableString01()<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFcause = not null, errorCode = not null<br>
     * ҒlFcause = not null, errorCode = not nullݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableString01() throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String errorCode = "test01";

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, errorCode);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        assertEquals("testException", throwWord);
        assertEquals("test01", errorCode);
    }

    /**
     * testSystemExceptionThrowableString02()<br>
     *
     * (n)<br>
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = ""<br>
     * ҒlFcause = not null, errorCode = ""ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode󔒂̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableString02() throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, "");

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        assertEquals("testException", throwWord);
        assertEquals("", errorCode);
    }
    /**
     * testSystemExceptionThrowableString03<br>
     *
     * (n)<br>
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = null<br>
     * ҒlFcause = not null, errorCode = nullݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCodenull̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableString03() throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, null);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        assertEquals("testException", throwWord);
        assertNull(errorCode);
    }

    /**
     * testSystemExceptionThrowableStringStringArray01<br>
     *
     * (n)<br>
     *
     * ϓ_FA<br>
     *
     * ͒lFcause = not null, errorCode = not null, <br>
     *        optionStrings = not null<br>
     * ҒlFcause = not null, errorCode = not null, <br>
     *        options = not nullݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"Aoptionsu{ "a" }v̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringArray01()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String errorCode = "test01";
        String[] optionStrings = { "a" };

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, errorCode, optionStrings);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("test01", errorCode);
        assertEquals("a", options[0]);
    }

    /**
     * testSystemExceptionThrowableStringStringArray02()<br>
     *
     * (n)<br>
     *
     * ϓ_FA<br>
     *
     * ͒lFcause = not null, errorCode = "", <br>
     *        optionStrings = not null<br>
     * ҒlFcause = not null, errorCode = "", <br>
     *        options = not nullݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"Aoptionsu{ "a", "b" }v̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringArray02()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String[] optionStrings = { "a", "b" };

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, "", optionStrings);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("", errorCode);
        assertEquals("a", options[0]);
        assertEquals("b", options[1]);
    }

    /**
     * testSystemExceptionThrowableStringStringArray03()<br>
     *
     * (n)<br>
     *
     * ϓ_FA<br>
     *
     * ͒lFcause = not null, errorCode = null, <br>
     *        optionStrings = not null<br>
     * ҒlFcause = not null, errorCode = null, <br>
     *        options = not nullݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"Aoptionsu{ "a", "b", "c" }v̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringArray03()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String[] optionStrings = { "a", "b", "c" };

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, null, optionStrings);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertNull(errorCode);
        assertEquals("a", options[0]);
        assertEquals("b", options[1]);
        assertEquals("c", options[2]);
    }

    /**
     * testSystemExceptionThrowableStringStringArray04<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = "", <br>
     *        optionStrings = null<br>
     * ҒlFcause = not null, errorCode = "", <br>
     *        options = nullݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"Aoptionsnull̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringArray04()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String[] optionStrings = null;

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, "", optionStrings);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("", errorCode);
        assertNull(options);

    }

    /**
     * testSystemExceptionThrowableStringStringArray05<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = null, <br>
     *        optionStrings = not null(zvfɋ󔒂)<br>
     * ҒlFcause = not null, errorCode = null, <br>
     *        options = not null(zvfɋ󔒂)ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"Aoptionsu{ "", "", "" }v̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringArray05()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String[] optionStrings = { "", "", "" };

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, null, optionStrings);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals(null, errorCode);
        assertEquals("", options[0]);
        assertEquals("", options[1]);
        assertEquals("", options[2]);

    }

    /**
     * testSystemExceptionThrowableStringStringArray06<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = not null, <br>
     *        optionStrings = not null(zvfnull)<br>
     * ҒlFcause = not null, errorCode = not null, <br>
     *        options = not null(zvfnull)ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"Aoptionsu{ null, null, null }v̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringArray06()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String errorCode = "test01";
        String[] optionStrings = { null, null, null };

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, errorCode, optionStrings);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("test01", errorCode);
        assertNull(options[0]);
        assertNull(options[1]);
        assertNull(options[2]);

    }

    /**
     * testSystemExceptionThrowableStringStringArray07<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = not null, <br>
     *        optionStrings = not null(zvfɋ󔒁Anull)<br>
     * ҒlFcause = not null, errorCode = not null, <br>
     *        options = not null(zvfɋ󔒁Anull)ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"Aoptionsu{ "a", "", null }v̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringArray07()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String errorCode = "test01";
        String[] optionStrings = { "a", "", null };

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, errorCode, optionStrings);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("test01", errorCode);
        assertEquals("a", options[0]);
        assertEquals("", options[1]);
        assertNull(options[2]);

    }

    /**
     * testSystemExceptionThrowableStringString01()<br>
     *
     * (n)<br>
     *
     * ϓ_FA<br>
     *
     * ͒lFcause = not null, errorCode = not null, s0 = not null<br>
     * ҒlFcause = not null, errorCode = not null, <br>
     *        options = not nullݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"As0"a"̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringString01() throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String errorCode = "test01";
        String s0 = "a";

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, errorCode, s0);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("test01", errorCode);
        assertEquals("a", options[0]);
    }

    /**
     * testSystemExceptionThrowableStringString02()<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = "", s0 = ""<br>
     * ҒlFcause = not null, errorCode = "", <br>
     *        options = not null(zvfɋ󔒂)ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode""As0󔒂̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringString02() throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, "", "");

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("", errorCode);
        assertEquals("", options[0]);
    }

    /**
     * testSystemExceptionThrowableStringString03()<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = null, s0 = null<br>
     * ҒlFcause = not null, errorCode = null, <br>
     *        options = not null(zvfnull)ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCodenullAs0null̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringString03() throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String s0 = null;

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, null, s0);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertNull(errorCode);
        assertNull(options[0]);
    }

    /**
     * testSystemExceptionThrowableStringStringString01()<br>
     *
     * (n)<br>
     *
     * ϓ_FA<br>
     *
     * ͒lFcause = not null, errorCode = not null,<br>
     *        s0 = not null, s1 = not null<br>
     * ҒlFcause = not null, errorCode = not null, <br>
     *        options = not nullݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"As0"a"As1"b"̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringString01()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String errorCode = "test01";
        String s0 = "a";
        String s1 = "b";

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, errorCode, s0, s1);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("test01", errorCode);
        assertEquals("a", options[0]);
        assertEquals("b", options[1]);
    }

    /**
     * testSystemExceptionThrowableStringStringString02()<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = not null, s0 = "", s1 = ""<br>
     * ҒlFcause = not null, errorCode = not null, <br>
     *        options = not null(zvf"")ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"As0󔒁As1󔒂̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringString02()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String errorCode = "test01";

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, errorCode, "", "");

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("test01", errorCode);
        assertEquals("", options[0]);
        assertEquals("", options[1]);
    }

    /**
     * testSystemExceptionThrowableStringStringString03()<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = "", s0 = null, s1 = null<br>
     * ҒlFcause = not null, errorCode = "", <br>
     *        options = not null(zvfnull)ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode󔒁As0nullAs1null̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringString03()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, "", null, null);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("", errorCode);
        assertNull(options[0]);
        assertNull(options[1]);
    }

    /**
     * testSystemExceptionThrowableStringStringString04()<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = null, s0 = "", s1 = not null<br>
     * ҒlFcause = not null, errorCode = null, <br>
     *        options = not null(zvfɋ󔒂)ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCodenullAs0󔒁As1"a"̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringString04()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String s1 = "a";

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, null, "", s1);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertNull(errorCode);
        assertEquals("", options[0]);
        assertEquals("a", options[1]);
    }

    /**
     * testSystemExceptionThrowableStringStringString05()<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = not null, s0 = null, s1 = not null<br>
     * ҒlFcause = not null, errorCode = not null, <br>
     *        options = not null(zvfnull)ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"As0nullAs1"a"̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringString05()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String errorCode = "test01";
        String s1 = "a";

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, errorCode, null, s1);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("test01", errorCode);
        assertNull(options[0]);
        assertEquals("a", options[1]);
    }

    /**
     * testSystemExceptionThrowableStringStringStringString01()<br>
     *
     * (n)<br>
     *
     * ϓ_FA<br>
     *
     * ͒lFcause = not null, errorCode = not null, <br>
     *        s0 = not null, s1 = not null, s2 = not null<br>
     * ҒlFcause = not null, errorCode = not null, <br>
     *        options = not nullݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"As0"a"As1"b"As2"c"̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringStringString01()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String errorCode = "test01";
        String s0 = "a";
        String s1 = "b";
        String s2 = "c";

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, errorCode, s0, s1, s2);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("test01", errorCode);
        assertEquals("a", options[0]);
        assertEquals("b", options[1]);
        assertEquals("c", options[2]);
    }

    /**
     * testSystemExceptionThrowableStringStringStringString02()<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = "", <br>
     *        s0 = "", s1 = "", s2 = ""<br>
     * ҒlFcause = not null, errorCode = "", <br>
     *        options = not null(zvfɋ󔒂)ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode󔒁As0󔒁As1󔒁As2󔒂̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringStringString02()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, "", "", "", "");

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("", errorCode);
        assertEquals("", options[0]);
        assertEquals("", options[1]);
        assertEquals("", options[2]);
    }

    /**
     * testSystemExceptionThrowableStringStringStringString03()<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = null, <br>
     *        s0 = null, s1 = null, s2 = null<br>
     * ҒlFcause = not null, errorCode = null, <br>
     *        options = not null(zvfɋ󔒂)ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCodenullAs0nullAs1nullAs2null̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringStringString03()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, null, null, null, null);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertNull(errorCode);
        assertNull(options[0]);
        assertNull(options[1]);
        assertNull(options[2]);
    }

    /**
     * testSystemExceptionThrowableStringStringStringString04()<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = not null,<br>
     *        s0 = not null, s1 = "", s2 = null<br>
     * ҒlFcause = not null, errorCode = not null,<br>
     *        options = not nullݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"As0"a"As1󔒁As2null̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringStringString04()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String errorCode = "test01";
        String s0 = "a";

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, errorCode, s0, "", null);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("test01", errorCode);
        assertEquals("a", options[0]);
        assertEquals("", options[1]);
        assertNull(options[2]);
    }

    /**
     * testSystemExceptionThrowableStringStringStringStringString01()<br>
     *
     * (n)<br>
     *
     * ϓ_FA<br>
     *
     * ͒lFcause = not null, errorCode = null,<br>
     *        s0 = not null, s1 = not null, s2 = not null, s3 = not null<br>
     * ҒlFcause = not null, errorCode = null, <br>
     *        options = not nullݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCodenullAs0"a"As1"b"As2"c"As3"d"̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringStringStringString01()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String s0 = "a";
        String s1 = "b";
        String s2 = "c";
        String s3 = "d";

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, null, s0, s1, s2, s3);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertNull(errorCode);
        assertEquals("a", options[0]);
        assertEquals("b", options[1]);
        assertEquals("c", options[2]);
        assertEquals("d", options[3]);
    }

    /**
     * testSystemExceptionThrowableStringStringStringStringString02()<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = not null,<br>
     *        s0 = "", s1 = "", s2 = "", s3 = ""<br>
     * ҒlFcause = not null, errorCode = not null, <br>
     *        options = not null(zvfɋ󔒂)ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode"test01"As0󔒁As1󔒁As2󔒁As3󔒂̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringStringStringString02()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String errorCode = "test01";

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, errorCode, "", "", "", "");

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("test01", errorCode);
        assertEquals("", options[0]);
        assertEquals("", options[1]);
        assertEquals("", options[2]);
        assertEquals("", options[3]);
    }

    /**
     * testSystemExceptionThrowableStringStringStringStringString03()<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = "", <br>
     *        s0 = null, s1 = null, s2 = null, s3 = null<br>
     * ҒlFcause = not null, errorCode = "", <br>
     *        options = not null(zvfnull)ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCode󔒁As0nullAs1nullAs2nullAs3null̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringStringStringString03()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, "", null, null, null, null);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertEquals("", errorCode);
        assertNull(options[0]);
        assertNull(options[1]);
        assertNull(options[2]);
        assertNull(options[3]);
    }

    /**
     * testSystemExceptionThrowableStringStringStringStringString04()<br>
     *
     * (n)<br>
     *
     * ϓ_FC<br>
     *
     * ͒lFcause = not null, errorCode = null,<br>
     *        s0 = not null, s1 = not null, s2 = "", s3 = null<br>
     * ҒlFcause = not null, errorCode = null, <br>
     *        options = not null(zvfɋ󔒁Anull)ݒ肳B<br>
     * 
     * TvFcauseNotNullŃbZ[WAerrorCodenullAs0"a"As1"b"As2󔒁As3null̏ꍇ
     * @throws Exception O
     */
    public void testSystemExceptionThrowableStringStringStringStringString04()
        throws Exception {
        // ͒l̐ݒB
        Throwable cause = new Throwable("testException");
        String s0 = "a";
        String s1 = "b";

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause, null, s0, s1, "", null);

        // o͒l̊mFB
        String throwWord =
            ((Throwable) UTUtil.getPrivateField(se1, "cause")).getMessage();
        String errorCode = (String) UTUtil.getPrivateField(se1, "errorCode");
        String[] options = (String[]) UTUtil.getPrivateField(se1, "options");
        assertEquals("testException", throwWord);
        assertNull(errorCode);
        assertEquals("a", options[0]);
        assertEquals("b", options[1]);
        assertEquals("", options[2]);
        assertNull(options[3]);
    }

    /**
     * testGetErrorCode01()<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFcause = not null, errorCode = not null<br>
     * ҒlFSystemExceptionerrorCode擾łĂ邩mFB
     * 
     * TvFnꌏ̂݃eXg
     * @throws Exception O
     */
    public void testGetErrorCode01() throws Exception {
        // SystemException̐ݒB
        Throwable cause = new Throwable("testException");

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause);
        UTUtil.setPrivateField(se1, "errorCode", "abc");

        // eXgΏۃ\bh̎sƏo͒l̊mFB
        assertEquals("abc", se1.getErrorCode());
    }

    /**
     * testGetOptions01()<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFoptions = not null<br>
     * ҒlFSystemExceptionoptions擾łĂ邩mFB
     * 
     * TvFnꌏ̂݃eXg
     * @throws Exception O
     */
    public void testGetOptions01() throws Exception {
        // SystemException̐ݒB
        Throwable cause = new Throwable("testException");
        String[] options = { "a", "b" };
        se1 = new SystemException(cause);
        UTUtil.setPrivateField(se1, "options", options);

        // eXgΏۃ\bh̎sƏo͒l̊mFB
        assertEquals("a", se1.getOptions()[0]);
        assertEquals("b", se1.getOptions()[1]);
        assertEquals(2, se1.getOptions().length);
    }

    /**
     * testSetMessage01()<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFcause = not null, message = not null<br>
     * ҒlFSystemExceptionmessage͂łĂ邩mFB
     * 
     * TvFnꌏ̂݃eXg
     * @throws Exception O
     */
    public void testSetMessage01() throws Exception {
        // SystemException̐ݒB
        Throwable cause = new Throwable("testException");
        se1 = new SystemException(cause);
        String message = "abc";

        // eXgΏۃ\bh̎sB
        se1.setMessage(message);

        // o͒l̊mFB
        assertEquals("abc", UTUtil.getPrivateField(se1, "message"));
    }

    /**
     * testGetMessage01()<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFcause = not null, message = not null<br>
     * ҒlFSystemExceptionmessage擾łĂ邩mFB
     * 
     * TvFmessage̒lnot null̏ꍇAmessage̒l擾ł邱ƂmFB
     * @throws Exception O
     */
    public void testGetMessage01() throws Exception {
        // SystemException̐ݒB
        Throwable cause = new Throwable("testException");

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause);
        UTUtil.setPrivateField(se1, "message", "abc");

        // eXgΏۃ\bh̎sƏo͒l̊mFB
        assertEquals("abc", se1.getMessage());
    }

    /**
     * testGetMessage02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() message:null<br>
     *         () errorCode:"def"<br>
     *
     * <br>
     * ҒlF(߂l) message:"def"<br>
     *
     * <br>
     * message̒lnull̏ꍇAerrorCode̒l擾ł邱ƂmFB
     * <br>
     * 
     * TvFmessage̒lnull̏ꍇAerrorCode̒l擾ł邱ƂmFB
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage02() throws Exception {
        // SystemException̐ݒB
        Throwable cause = new Throwable("testException");

        // eXgΏۃRXgN^̎sB
        se1 = new SystemException(cause);
        UTUtil.setPrivateField(se1, "message", null);
        UTUtil.setPrivateField(se1, "errorCode", "def");

        // eXgΏۃ\bh̎sƏo͒l̊mFB
        assertEquals("def", se1.getMessage());
    }
}