package jp.terasoluna.fw.web.thin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.thin.LimitedLock} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * bN҂XbhۂɁAÂbN҂Xbh𒆒f@\bNNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.thin.LimitedLock
 */
public class LimitedLockTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(LimitedLockTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public LimitedLockTest(String name) {
        super(name);
    }

    /**
     * testLimitedLock01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FB
     * <br><br>
     * ͒lF() threshold:1<br>
     *         
     * <br>
     * ҒlF(߂l) LimitedLock:not Null<br>
     *         (ԕω) threshold:1<br>
     * <br>
     * RXgN^̈1ȏłꍇAŗ^lthresholdɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLimitedLock01() throws Exception {
        // eXg{
        LimitedLock lock = new LimitedLock(1);
        
        // 
        int thresholdField = (Integer) UTUtil.getPrivateField(lock, "threshold");
        assertEquals(1, thresholdField);
    }

    /**
     * testLimitedLock02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FB
     * <br><br>
     * ͒lF() threshold:0<br>
     *         
     * <br>
     * ҒlF(߂l) LimitedLock:not Null<br>
     *         (ԕω) threshold:0<br>
     * <br>
     * RXgN^̈0ȉ(0)łꍇA0thresholdɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLimitedLock02() throws Exception {
        // eXg{
        LimitedLock lock = new LimitedLock(0);
        
        // 
        int thresholdField = (Integer) UTUtil.getPrivateField(lock, "threshold");
        assertEquals(0, thresholdField);
    }

    /**
     * testLimitedLock03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FB
     * <br><br>
     * ͒lF() threshold:-1<br>
     *         
     * <br>
     * ҒlF(߂l) LimitedLock:not Null<br>
     *         (ԕω) threshold:0<br>
     * <br>
     * RXgN^̈0ȉ(-1)łꍇA0thresholdɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLimitedLock03() throws Exception {
        // eXg{
        LimitedLock lock = new LimitedLock(-1);
        
        // 
        int thresholdField = (Integer) UTUtil.getPrivateField(lock, "threshold");
        assertEquals(0, thresholdField);
    }

    /**
     * testLockInterruptibly01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() threshold:1<br>
     *         () bN<br>
     *         () ݂̃XbhɊ荞݃Xe[^Xݒ肳Ă<br>
     * <br>
     * ҒlF(ԕω) O:InterruptedExceptionF<br>
     * <br>
     * bN擾OɁAɌ݂̃XbhɊ荞݃Xe[^Xݒ肳ĂꍇA
     * bNԂɊւ炸AbN̎擾f邱ƂmFB<br>
     * 
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLockInterruptibly01() throws Exception {
        // O
        LimitedLock lock = new LimitedLock(1);
        Thread.currentThread().interrupt();
        
        // eXg{
        try {
            lock.lockInterruptibly();
            fail();
        } catch (InterruptedException e) {
            // Ғʂ
        }
        
        // 
        assertNull(UTUtil.invokePrivate(lock, "getOwner"));
    }

    /**
     * testLockInterruptibly02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() threshold:1<br>
     *         () ʂ̃XbhbNĂ<br>
     *         () ݂̃XbhbN҂ĂԂɁAXbh̊荞݃Xe[^Xݒ肳<br>
     * <br>
     * ҒlF(ԕω) O:InterruptedExceptionF<br>
     * <br>
     * bN҂ĂԂɁÃ݂XbhɊ荞݃Xe[^Xݒ肳ꂽꍇA
     * bN҂f邱ƂmFB<br>
     * 
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLockInterruptibly02() throws Exception {
        final LimitedLock lock = new LimitedLock(1);
        final Thread testThread = Thread.currentThread();
        ErrorFeedBackThread interruptorThread = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    lock.lockInterruptibly();
                    // eXgXbhueXg{v̂ƂɐiޑO
                    // 荞݃Xe[^Xݒ肵Ȃ悤A
                    // ҂B
                    Thread.sleep(100);
                    testThread.interrupt();
                } finally {
                    lock.unlock();
                }
            }
        };
        interruptorThread.start();
        Thread.sleep(50);
        // interruptorThreadbN擾܂܁A50~bɌ݂̃XbhɊ荞݂B
        
        // eXg{
        try {
            lock.lockInterruptibly();
            fail();
        } catch (InterruptedException e) {
            // Ғʂ
        }
        
        // 
        assertNotSame(testThread, UTUtil.invokePrivate(lock, "getOwner"));
        
        // ʃXbh̃G[tB[hobN
        interruptorThread.throwErrorOrExceptionIfThrown();
    }

    /**
     * testLockInterruptibly03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() threshold:1<br>
     *         () bN<br>
     * <br>
     * ҒlF(ԕω) ݂̃XbhŃbNꂽ<br>
     * <br>
     * bNԂłꍇAɃbN擾ł邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLockInterruptibly03() throws Exception {
        // O
        final LimitedLock lock = new LimitedLock(1);
        final Thread testThread = Thread.currentThread();
        ErrorFeedBackThread interruptorThread = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    // 1bȓɃbN擾łȂ΁AfB
                    // fƁAueXg{v̂Ƃ납InterruptedExceptionA̓G[ƂȂB
                    Thread.sleep(1000);
                    testThread.interrupt();
                } catch (InterruptedException e) {
                    // ɃeXgIAXbh𑬂₩ɒ~邽߂̌㏈sꂽƂɁA
                    // ɓBB
                }
            }
        };
        interruptorThread.start();
        
        // eXg{
        lock.lockInterruptibly();
        
        // 
        assertSame(testThread, UTUtil.invokePrivate(lock, "getOwner"));
        
        // ㏈
        interruptorThread.interrupt();
        
        // ʃXbh̃G[tB[hobN
        interruptorThread.throwErrorOrExceptionIfThrown();
    }

    /**
     * testLockInterruptibly04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FB
     * <br><br>
     * ͒lF() threshold:1<br>
     *         () ʂ̃XbhbNێĂȂA1̃XbhbN҂Ă<br>
     * <br>
     * ҒlF(ԕω) ݂̃XbhŃbNꂽ<br>
     * <br>
     * ʂ̃XbhbNێĂꍇA<br>
     * thresholdȓ̃Xbh(1)bN҂ĂĂAbN҂̒fȂƂmFB<br>
     * ɁÃ݂XbhbN擾ł邱ƂmFB<br>
     * bN擾łƂɂ́ÃXbhbNłȂƂmFB<br>
     * (ɕ̃XbhbNlȂ̂́AX[p[NX̋@\Ȃ̂ŁÃeXg\bĥ݂ŊmFB)<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLockInterruptibly04() throws Exception {
        // O
        final LimitedLock lock = new LimitedLock(1);
        final Thread testThread = Thread.currentThread();
        final HashSet<Thread> lockThreadSet = new HashSet<Thread>();
        ErrorFeedBackThread lockThread = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    lock.lockInterruptibly();
                    lockThreadSet.add(Thread.currentThread());
                    Thread.sleep(500);
                } finally {
                    lockThreadSet.remove(Thread.currentThread());
                    lock.unlock();
                }
            }
        };
        lockThread.start();
        Thread.sleep(50);
        ErrorFeedBackThread waitThread = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    lock.lockInterruptibly();
                    lockThreadSet.add(Thread.currentThread());
                } finally {
                    lockThreadSet.remove(Thread.currentThread());
                    lock.unlock();
                }
            }
        };
        waitThread.start();
        Thread.sleep(50);
        // lockThreadbN擾āAƖ400~bbNĂԁB
        // waitThread̓bN҂ĂԁB
        
        // eXg{
        lock.lockInterruptibly();
        
        // 
        assertEquals(0, lockThreadSet.size());
        assertSame(testThread, UTUtil.invokePrivate(lock, "getOwner"));

        // ʃXbh̃G[tB[hobN
        lockThread.throwErrorOrExceptionIfThrown();
        waitThread.throwErrorOrExceptionIfThrown();
    }

    /**
     * testLockInterruptibly05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FBD
     * <br><br>
     * ͒lF() threshold:1<br>
     *         () ʂ̃XbhbNێĂȂA2̃Xbh(݂̃Xbh܂܂Ȃ)bN҂Ă<br>
     * <br>
     * ҒlF(ԕω) ݂̃XbhŃbNꂽ<br>
     *         (ԕω) ŏɃbN҂ɂȂXbh1݂̂AbN҂𒆒fB
     * <br>
     * ʂ̃XbhbNێĂꍇA<br>
     * threshold𒴂Xbh(2)bN҂ĂꍇAbN҂̒f邱ƂmFB<br>
     * ÂbN҂Xbh(bN҂Xbh2̂AŏɃbN҂ԂɂȂXbh)̃bN҂f邱ƂmFB
     * ɁÃ݂XbhbN擾ł邱ƂmFB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLockInterruptibly05() throws Exception {
        // O
        final LimitedLock lock = new LimitedLock(1);
        final Thread testThread = Thread.currentThread();
        ErrorFeedBackThread lockThread = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    lock.lockInterruptibly();
                    Thread.sleep(500);
                } finally {
                    lock.unlock();
                }
            }
        };
        lockThread.start();
        Thread.sleep(50);
        ErrorFeedBackThread waitThread1 = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    lock.lockInterruptibly();
                    fail();
                } catch (InterruptedException e) {
                    // Ғʂ
                } finally {
                    lock.unlock();
                }
            }
        };
        waitThread1.start();
        Thread.sleep(50);
        ErrorFeedBackThread waitThread2 = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    lock.lockInterruptibly();
                } finally {
                    lock.unlock();
                }
            }
        };
        waitThread2.start();
        Thread.sleep(50);
        // lockThreadbN擾āAƖ350~bbNĂԁB
        // waitThread1̓bN҂ĂԁB
        // waitThread2̓bN҂ĂԁB
        
        // eXg{
        lock.lockInterruptibly();
        
        // 
        assertSame(testThread, UTUtil.invokePrivate(lock, "getOwner"));

        // ʃXbh̃G[tB[hobN
        lockThread.throwErrorOrExceptionIfThrown();
        waitThread1.throwErrorOrExceptionIfThrown();
        waitThread2.throwErrorOrExceptionIfThrown();
    }

    /**
     * testLockInterruptibly06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() threshold:1<br>
     *         () ʂ̃XbhbNێĂȂA5̃Xbh(Ō1݂͌̃Xbh)bN҂Ă<br>
     * <br>
     * ҒlF(ԕω) ݂̃XbhŃbNꂽ<br>
     *         (ԕω) 1, 2, 3ԖڂɃbN҂ɂȂXbh3݂̂AbN҂𒆒fB
     * <br>
     * ʂ̃XbhbNێĂꍇA<br>
     * threshold𒴂XbhbN҂ĂꍇAbN҂̒f邱ƂmFB<br>
     * ÂbN҂Xbh烍bN҂f邱ƂmFB
     * ɁÃ݂XbhbN擾ł邱ƂmFB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLockInterruptibly06() throws Exception {
        // O
        final LimitedLock lock = new LimitedLock(1);
        final Thread testThread = Thread.currentThread();
        final List<String> interruptedList = Collections.synchronizedList(new ArrayList<String>());
        ErrorFeedBackThread lockThread = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    lock.lockInterruptibly();
                    Thread.sleep(500);
                } finally {
                    lock.unlock();
                }
            }
        };
        lockThread.start();
        Thread.sleep(50);
        
        // eXg{
        ErrorFeedBackThread waitThread1 = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    lock.lockInterruptibly();
                    fail();
                } catch (InterruptedException e) {
                    // Ғʂ
                    interruptedList.add("1");
                } finally {
                    lock.unlock();
                }
            }
        };
        waitThread1.start();
        Thread.sleep(50);
        ErrorFeedBackThread waitThread2 = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    lock.lockInterruptibly();
                    fail();
                } catch (InterruptedException e) {
                    // Ғʂ
                    interruptedList.add("2");
                } finally {
                    lock.unlock();
                }
            }
        };
        waitThread2.start();
        Thread.sleep(50);
        ErrorFeedBackThread waitThread3 = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    lock.lockInterruptibly();
                    fail();
                } catch (InterruptedException e) {
                    // Ғʂ
                    interruptedList.add("3");
                } finally {
                    lock.unlock();
                }
            }
        };
        waitThread3.start();
        Thread.sleep(50);
        ErrorFeedBackThread waitThread4 = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    lock.lockInterruptibly();
                } finally {
                    lock.unlock();
                }
            }
        };
        waitThread4.start();
        Thread.sleep(50);
        // lockThreadbN擾āAƖ250~bbNĂԁB
        
        lock.lockInterruptibly();
        
        // 
        assertSame(testThread, UTUtil.invokePrivate(lock, "getOwner"));
        assertEquals(3, interruptedList.size());
        assertEquals("1", interruptedList.get(0));
        assertEquals("2", interruptedList.get(1));
        assertEquals("3", interruptedList.get(2));

        // ʃXbh̃G[tB[hobN
        lockThread.throwErrorOrExceptionIfThrown();
        waitThread1.throwErrorOrExceptionIfThrown();
        waitThread2.throwErrorOrExceptionIfThrown();
        waitThread3.throwErrorOrExceptionIfThrown();
        waitThread4.throwErrorOrExceptionIfThrown();
    }

    /**
     * testLockInterruptibly07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() threshold:1<br>
     *         () ݂̃XbhbNێĂȂA2̃XbhbN҂Ă<br>
     * <br>
     * ҒlF(ԕω) ݂̃XbhŃbNꂽ<br>
     * <br>
     * ݂̃XbhɃbNێĂꍇ(ēbN)A<br>
     * threshold𒴂Xbh(2)bN҂ĂĂAbN҂̒f͔ȂƂmFB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLockInterruptibly07() throws Exception {
        // O
        final LimitedLock lock = new LimitedLock(1);
        final Thread testThread = Thread.currentThread();
        lock.lockInterruptibly();
        ErrorFeedBackThread waitThread1 = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    lock.lockInterruptibly();
                } finally {
                    lock.unlock();
                }
            }
        };
        waitThread1.start();
        Thread.sleep(50);
        ErrorFeedBackThread waitThread2 = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    lock.lockInterruptibly();
                } finally {
                    lock.unlock();
                }
            }
        };
        waitThread2.start();
        Thread.sleep(50);
        
        // eXg{
        lock.lockInterruptibly();
        
        // 
        assertSame(testThread, UTUtil.invokePrivate(lock, "getOwner"));
        
        // ㏈
        lock.unlock();
        lock.unlock();

        // ʃXbh̃G[tB[hobN
        waitThread1.throwErrorOrExceptionIfThrown();
        waitThread2.throwErrorOrExceptionIfThrown();
    }

    /**
     * testUnlock01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() threshold:1<br>
     *         () ݂̃XbhbNێĂ<br>
     *         () bNJEg:1<br>
     * <br>
     * ҒlF(ԕω) bNꂽ<br>
     * <br>
     * bNێĂXbhunlocksꍇAbN邱ƂmFB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testUnlock01() throws Exception {
        // O
        LimitedLock lock = new LimitedLock(1);
        lock.lockInterruptibly();
        
        // eXg{
        lock.unlock();
        
        // 
        assertNull(UTUtil.invokePrivate(lock, "getOwner"));
    }

    /**
     * testUnlock02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() threshold:1<br>
     *         () ݂̃XbhbNێĂ<br>
     *         () bNJEg:2<br>
     * <br>
     * ҒlF(ԕω) ݂̃XbhbNێĂ<br>
     *         (ԕω) bNJEg:1<br>
     * <br>
     * bN2擾Xbhunlock1sꍇAbNɃbNJEgfNg邱ƂmFB<br>
     * (X[p[NX̍ē\bNƂĂ̋@\)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testUnlock02() throws Exception {
        // O
        LimitedLock lock = new LimitedLock(1);
        Thread testThread = Thread.currentThread();
        lock.lockInterruptibly();
        lock.lockInterruptibly();
        
        // eXg{
        lock.unlock();
        
        // 
        assertSame(testThread, UTUtil.invokePrivate(lock, "getOwner"));
        assertEquals(1, lock.getHoldCount());
    }

    /**
     * testUnlock03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() threshold:1<br>
     *         () ʂ̃XbhbNێĂ<br>
     * <br>
     * ҒlF(ԕω) ʂ̃XbhbNێĂ<br>
     * <br>
     * ݂̃XbhbNێĂȂꍇAȂƂmFB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testUnlock03() throws Exception {
        // O
        final LimitedLock lock = new LimitedLock(1);
        ErrorFeedBackThread lockThread = new ErrorFeedBackThread() {
            @Override
            public void doRun() throws Exception {
                try {
                    lock.lockInterruptibly();
                    Thread.sleep(500);
                } finally {
                    lock.unlock();
                }
            }
        };
        lockThread.start();
        Thread.sleep(50);
        
        // eXg{
        lock.unlock();
        
        // 
        assertSame(lockThread, UTUtil.invokePrivate(lock, "getOwner"));

        // ʃXbh̃G[tB[hobN
        lockThread.throwErrorOrExceptionIfThrown();
    }

    /**
     * testReadObject01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() threshold:1<br>
     *         () lock:Not Null<br>
     *         () waitingThreadList:Not Null<br>
     * <br>
     * ҒlF(ԕω) threshold:1<br>
     *         (ԕω) lock:Object(͒lƂ͈قȂ)<br>
     *         (ԕω) waitingThreadList:LinkedList(͒lƂ͈قȂ)<br>
     * <br>
     * VACYAfVACYꍇAthreshold̒l͈pAlockwaitingThreadListɂ͐VIuWFNgݒ肳邱ƂmFB<br>
     * (fVACY邱ƂɂAreadObject\bh𓮍삳B)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testReadObject01() throws Exception {
        // O
        LimitedLock lock = new LimitedLock(1);
        Object oldLockField = UTUtil.getPrivateField(lock, "lock");
        LinkedList oldWaitingThreadListField = (LinkedList) UTUtil.getPrivateField(lock, "waitingThreadList");
        
        // eXg{
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(lock);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object deserialObject = ois.readObject();
        
        // 
        assertEquals(1, UTUtil.getPrivateField(deserialObject, "threshold"));
        Object newLockField = UTUtil.getPrivateField(deserialObject, "lock");
        assertNotNull(newLockField);
        assertNotSame(oldLockField, newLockField);
        LinkedList newWaitingThreadListField = (LinkedList) UTUtil.getPrivateField(deserialObject, "waitingThreadList");
        assertNotNull(newWaitingThreadListField);
        assertNotSame(oldWaitingThreadListField, newWaitingThreadListField);
    }

    /**
     * G[tB[hobNłXbhB
     * ʃXbhŎ{e doRun() throws Exception ɎB
     * IAthrowErrorOrExceptionIfThrown\bhsƁA
     * doRun\bhɂđzÕG[ꍇɁÃG[X[B
     */
    abstract class ErrorFeedBackThread extends Thread {
        private Exception exception;
        private Error error;
        @Override
        public void run() {
            try {
                doRun();
            } catch (Exception e) {
                exception = e;
            } catch (Error e) {
                error = e;
            }
        }
        
        public void throwErrorOrExceptionIfThrown() throws Exception {
            join();
            if (error != null) {
                throw error;
            } else if (exception != null) {
                throw exception;
            }
        }
        
        abstract void doRun() throws Exception;
    }

}
